/* common-actions.c generated by valac 0.48.13, the Vala compiler
 * generated from common-actions.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT,
	SYNAPSE_MATCH_TYPE_INTERNET
} SynapseMatchType;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_BASE_ACTION (synapse_base_action_get_type ())
#define SYNAPSE_BASE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction))
#define SYNAPSE_BASE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionClass))
#define SYNAPSE_IS_BASE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_BASE_ACTION))
#define SYNAPSE_IS_BASE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_BASE_ACTION))
#define SYNAPSE_BASE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionClass))

typedef struct _SynapseBaseAction SynapseBaseAction;
typedef struct _SynapseBaseActionClass SynapseBaseActionClass;
typedef struct _SynapseBaseActionPrivate SynapseBaseActionPrivate;
enum  {
	SYNAPSE_BASE_ACTION_0_PROPERTY,
	SYNAPSE_BASE_ACTION_TITLE_PROPERTY,
	SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY,
	SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY,
	SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY,
	SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY,
	SYNAPSE_BASE_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_base_action_properties[SYNAPSE_BASE_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER (synapse_common_actions_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunner))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))

typedef struct _SynapseCommonActionsRunner SynapseCommonActionsRunner;
typedef struct _SynapseCommonActionsRunnerClass SynapseCommonActionsRunnerClass;
typedef struct _SynapseCommonActionsRunnerPrivate SynapseCommonActionsRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_runner_properties[SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES];
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER (synapse_common_actions_terminal_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunner))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))

typedef struct _SynapseCommonActionsTerminalRunner SynapseCommonActionsTerminalRunner;
typedef struct _SynapseCommonActionsTerminalRunnerClass SynapseCommonActionsTerminalRunnerClass;
typedef struct _SynapseCommonActionsTerminalRunnerPrivate SynapseCommonActionsTerminalRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_terminal_runner_properties[SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES];

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPENER (synapse_common_actions_opener_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener))
#define SYNAPSE_COMMON_ACTIONS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))

typedef struct _SynapseCommonActionsOpener SynapseCommonActionsOpener;
typedef struct _SynapseCommonActionsOpenerClass SynapseCommonActionsOpenerClass;
typedef struct _SynapseCommonActionsOpenerPrivate SynapseCommonActionsOpenerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPENER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_opener_properties[SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER (synapse_common_actions_open_folder_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolder))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))

typedef struct _SynapseCommonActionsOpenFolder SynapseCommonActionsOpenFolder;
typedef struct _SynapseCommonActionsOpenFolderClass SynapseCommonActionsOpenFolderClass;
typedef struct _SynapseCommonActionsOpenFolderPrivate SynapseCommonActionsOpenFolderPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_open_folder_properties[SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES];

#define SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY (synapse_common_actions_clipboard_copy_get_type ())
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopy))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))

typedef struct _SynapseCommonActionsClipboardCopy SynapseCommonActionsClipboardCopy;
typedef struct _SynapseCommonActionsClipboardCopyClass SynapseCommonActionsClipboardCopyClass;
typedef struct _SynapseCommonActionsClipboardCopyPrivate SynapseCommonActionsClipboardCopyPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_clipboard_copy_properties[SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES];

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchIface))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchIface SynapseTextMatchIface;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseBaseAction {
	GObject parent_instance;
	SynapseBaseActionPrivate * priv;
};

struct _SynapseBaseActionClass {
	GObjectClass parent_class;
	gboolean (*valid_for_match) (SynapseBaseAction* self, SynapseMatch* match);
	gint (*get_relevancy_for_match) (SynapseBaseAction* self, SynapseMatch* match);
	void (*do_execute) (SynapseBaseAction* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseBaseAction* self);
	SynapseQueryFlags (*target_flags) (SynapseBaseAction* self);
};

struct _SynapseBaseActionPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	gboolean _notify_match;
};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseCommonActions {
	GObject parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	GObjectClass parent_class;
};

struct _SynapseCommonActionsPrivate {
	gboolean _enabled;
	GeeList* actions;
};

struct _SynapseCommonActionsRunner {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsRunnerPrivate * priv;
};

struct _SynapseCommonActionsRunnerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseCommonActionsTerminalRunner {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsTerminalRunnerPrivate * priv;
};

struct _SynapseCommonActionsTerminalRunnerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsOpener {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsOpenerPrivate * priv;
};

struct _SynapseCommonActionsOpenerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsOpenerPrivate {
	GRegex* web_uri;
	GRegex* file_path;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseCommonActionsOpenFolder {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsOpenFolderPrivate * priv;
};

struct _SynapseCommonActionsOpenFolderClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsClipboardCopy {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsClipboardCopyPrivate * priv;
};

struct _SynapseCommonActionsClipboardCopyClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseTextMatchIface {
	GTypeInterface parent_iface;
	gchar* (*get_text) (SynapseTextMatch* self);
	SynapseTextOrigin (*get_text_origin) (SynapseTextMatch* self);
	void (*set_text_origin) (SynapseTextMatch* self, SynapseTextOrigin value);
};

static gint SynapseBaseAction_private_offset;
static gpointer synapse_base_action_parent_class = NULL;
static SynapseMatchIface * synapse_base_action_synapse_match_parent_iface = NULL;
static gint SynapseCommonActions_private_offset;
static gpointer synapse_common_actions_parent_class = NULL;
static gpointer synapse_common_actions_runner_parent_class = NULL;
static gpointer synapse_common_actions_terminal_runner_parent_class = NULL;
static gint SynapseCommonActionsOpener_private_offset;
static gpointer synapse_common_actions_opener_parent_class = NULL;
static gpointer synapse_common_actions_open_folder_parent_class = NULL;
static gpointer synapse_common_actions_clipboard_copy_parent_class = NULL;
static SynapseActivatableIface * synapse_common_actions_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_common_actions_synapse_action_provider_parent_iface = NULL;

GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_base_action_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseBaseAction, g_object_unref)
gboolean synapse_base_action_valid_for_match (SynapseBaseAction* self,
                                              SynapseMatch* match);
gint synapse_base_action_get_relevancy_for_match (SynapseBaseAction* self,
                                                  SynapseMatch* match);
void synapse_base_action_do_execute (SynapseBaseAction* self,
                                     SynapseMatch* source,
                                     SynapseMatch* target);
gboolean synapse_base_action_needs_target (SynapseBaseAction* self);
SynapseQueryFlags synapse_base_action_target_flags (SynapseBaseAction* self);
static gboolean synapse_base_action_real_valid_for_match (SynapseBaseAction* self,
                                                   SynapseMatch* match);
static gint synapse_base_action_real_get_relevancy_for_match (SynapseBaseAction* self,
                                                       SynapseMatch* match);
gint synapse_base_action_get_default_relevancy (SynapseBaseAction* self);
static void synapse_base_action_real_do_execute (SynapseBaseAction* self,
                                          SynapseMatch* source,
                                          SynapseMatch* target);
static void synapse_base_action_real_execute_with_target (SynapseMatch* base,
                                                   SynapseMatch* source,
                                                   SynapseMatch* target);
gboolean synapse_base_action_get_notify_match (SynapseBaseAction* self);
static gboolean synapse_base_action_real_needs_target (SynapseBaseAction* self);
static SynapseQueryFlags synapse_base_action_real_target_flags (SynapseBaseAction* self);
SynapseBaseAction* synapse_base_action_construct (GType object_type);
void synapse_base_action_set_default_relevancy (SynapseBaseAction* self,
                                                gint value);
void synapse_base_action_set_notify_match (SynapseBaseAction* self,
                                           gboolean value);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
gboolean synapse_match_needs_target (SynapseMatch* self);
SynapseQueryFlags synapse_match_target_flags (SynapseMatch* self);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
static void synapse_base_action_finalize (GObject * obj);
static GType synapse_base_action_get_type_once (void);
static void _vala_synapse_base_action_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_synapse_base_action_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActions, g_object_unref)
static void synapse_common_actions_real_activate (SynapseActivatable* base);
static void synapse_common_actions_real_deactivate (SynapseActivatable* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
void synapse_common_actions_open_uri (const gchar* uri);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void synapse_utils_logger_warning (GObject* obj,
                                   const gchar* format,
                                   ...);
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
static GType synapse_common_actions_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsRunner, g_object_unref)
static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void);
static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void synapse_common_actions_runner_real_do_execute (SynapseBaseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseRelevancyService, g_object_unref)
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self,
                                                     GAppInfo* app_info);
void synapse_match_execute (SynapseMatch* self,
                            SynapseMatch* match);
static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseBaseAction* base,
                                                             SynapseMatch* match);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
static GType synapse_common_actions_runner_get_type_once (void);
static GType synapse_common_actions_terminal_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsTerminalRunner, g_object_unref)
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void);
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type);
static void synapse_common_actions_terminal_runner_real_do_execute (SynapseBaseAction* base,
                                                             SynapseMatch* match,
                                                             SynapseMatch* target);
static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseBaseAction* base,
                                                                      SynapseMatch* match);
static GType synapse_common_actions_terminal_runner_get_type_once (void);
static GType synapse_common_actions_opener_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsOpener, g_object_unref)
static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void);
static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type);
static void synapse_common_actions_opener_real_do_execute (SynapseBaseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseBaseAction* base,
                                                             SynapseMatch* match);
static GObject * synapse_common_actions_opener_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void synapse_common_actions_opener_finalize (GObject * obj);
static GType synapse_common_actions_opener_get_type_once (void);
static GType synapse_common_actions_open_folder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsOpenFolder, g_object_unref)
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void);
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type);
static void synapse_common_actions_open_folder_real_do_execute (SynapseBaseAction* base,
                                                         SynapseMatch* match,
                                                         SynapseMatch* target);
static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseBaseAction* base,
                                                                  SynapseMatch* match);
static GType synapse_common_actions_open_folder_get_type_once (void);
static GType synapse_common_actions_clipboard_copy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsClipboardCopy, g_object_unref)
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_new (void);
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_construct (GType object_type);
static void synapse_common_actions_clipboard_copy_real_do_execute (SynapseBaseAction* base,
                                                            SynapseMatch* match,
                                                            SynapseMatch* target);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
static gboolean synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseBaseAction* base,
                                                                     SynapseMatch* match);
static gint synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseBaseAction* base,
                                                                         SynapseMatch* match);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
static GType synapse_common_actions_clipboard_copy_get_type_once (void);
static GObject * synapse_common_actions_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
void synapse_activatable_activate (SynapseActivatable* self);
void synapse_activatable_deactivate (SynapseActivatable* self);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
SynapseResultSet* synapse_action_provider_find_for_match (SynapseActionProvider* self,
                                                          SynapseQuery* query,
                                                          SynapseMatch* match);
static void synapse_common_actions_finalize (GObject * obj);
static GType synapse_common_actions_get_type_once (void);
static void _vala_synapse_common_actions_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_common_actions_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
synapse_base_action_get_instance_private (SynapseBaseAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseBaseAction_private_offset);
}

static gboolean
synapse_base_action_real_valid_for_match (SynapseBaseAction* self,
                                          SynapseMatch* match)
{
	gboolean _tmp0_ = FALSE;
#line 36 "../lib/synapse-core/common-actions.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_base_action_valid_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 36 "../lib/synapse-core/common-actions.vala"
	return _tmp0_;
#line 680 "common-actions.c"
}

gboolean
synapse_base_action_valid_for_match (SynapseBaseAction* self,
                                     SynapseMatch* match)
{
#line 36 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 36 "../lib/synapse-core/common-actions.vala"
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->valid_for_match (self, match);
#line 691 "common-actions.c"
}

static gint
synapse_base_action_real_get_relevancy_for_match (SynapseBaseAction* self,
                                                  SynapseMatch* match)
{
	gint _tmp0_;
	gint result = 0;
#line 37 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, 0);
#line 38 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_default_relevancy;
#line 38 "../lib/synapse-core/common-actions.vala"
	result = _tmp0_;
#line 38 "../lib/synapse-core/common-actions.vala"
	return result;
#line 708 "common-actions.c"
}

gint
synapse_base_action_get_relevancy_for_match (SynapseBaseAction* self,
                                             SynapseMatch* match)
{
#line 37 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 37 "../lib/synapse-core/common-actions.vala"
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->get_relevancy_for_match (self, match);
#line 719 "common-actions.c"
}

static void
synapse_base_action_real_do_execute (SynapseBaseAction* self,
                                     SynapseMatch* source,
                                     SynapseMatch* target)
{
#line 41 "../lib/synapse-core/common-actions.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_base_action_do_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 41 "../lib/synapse-core/common-actions.vala"
	return;
#line 731 "common-actions.c"
}

void
synapse_base_action_do_execute (SynapseBaseAction* self,
                                SynapseMatch* source,
                                SynapseMatch* target)
{
#line 41 "../lib/synapse-core/common-actions.vala"
	g_return_if_fail (self != NULL);
#line 41 "../lib/synapse-core/common-actions.vala"
	SYNAPSE_BASE_ACTION_GET_CLASS (self)->do_execute (self, source, target);
#line 743 "common-actions.c"
}

static void
synapse_base_action_real_execute_with_target (SynapseMatch* base,
                                              SynapseMatch* source,
                                              SynapseMatch* target)
{
	SynapseBaseAction * self;
	gboolean _tmp0_;
#line 42 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 43 "../lib/synapse-core/common-actions.vala"
	synapse_base_action_do_execute (self, source, target);
#line 44 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_notify_match;
#line 44 "../lib/synapse-core/common-actions.vala"
	if (_tmp0_) {
#line 44 "../lib/synapse-core/common-actions.vala"
		g_signal_emit_by_name (source, "executed");
#line 763 "common-actions.c"
	}
}

static gboolean
synapse_base_action_real_needs_target (SynapseBaseAction* self)
{
	gboolean result = FALSE;
#line 48 "../lib/synapse-core/common-actions.vala"
	result = FALSE;
#line 48 "../lib/synapse-core/common-actions.vala"
	return result;
#line 775 "common-actions.c"
}

gboolean
synapse_base_action_needs_target (SynapseBaseAction* self)
{
#line 47 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 47 "../lib/synapse-core/common-actions.vala"
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->needs_target (self);
#line 785 "common-actions.c"
}

static SynapseQueryFlags
synapse_base_action_real_target_flags (SynapseBaseAction* self)
{
	SynapseQueryFlags result = 0U;
#line 52 "../lib/synapse-core/common-actions.vala"
	result = SYNAPSE_QUERY_FLAGS_ALL;
#line 52 "../lib/synapse-core/common-actions.vala"
	return result;
#line 796 "common-actions.c"
}

SynapseQueryFlags
synapse_base_action_target_flags (SynapseBaseAction* self)
{
#line 51 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 51 "../lib/synapse-core/common-actions.vala"
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->target_flags (self);
#line 806 "common-actions.c"
}

SynapseBaseAction*
synapse_base_action_construct (GType object_type)
{
	SynapseBaseAction * self = NULL;
#line 24 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) g_object_new (object_type, NULL);
#line 24 "../lib/synapse-core/common-actions.vala"
	return self;
#line 817 "common-actions.c"
}

static const gchar*
synapse_base_action_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
#line 26 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 26 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_title;
#line 26 "../lib/synapse-core/common-actions.vala"
	result = _tmp0_;
#line 26 "../lib/synapse-core/common-actions.vala"
	return result;
#line 834 "common-actions.c"
}

static void
synapse_base_action_real_set_title (SynapseMatch* base,
                                    const gchar* value)
{
	SynapseBaseAction* self;
	gchar* old_value;
#line 26 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 26 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_real_get_title (base);
#line 26 "../lib/synapse-core/common-actions.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 849 "common-actions.c"
		gchar* _tmp0_;
#line 26 "../lib/synapse-core/common-actions.vala"
		_tmp0_ = g_strdup (value);
#line 26 "../lib/synapse-core/common-actions.vala"
		_g_free0 (self->priv->_title);
#line 26 "../lib/synapse-core/common-actions.vala"
		self->priv->_title = _tmp0_;
#line 26 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_TITLE_PROPERTY]);
#line 859 "common-actions.c"
	}
}

static const gchar*
synapse_base_action_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
#line 27 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 27 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_description;
#line 27 "../lib/synapse-core/common-actions.vala"
	result = _tmp0_;
#line 27 "../lib/synapse-core/common-actions.vala"
	return result;
#line 877 "common-actions.c"
}

static void
synapse_base_action_real_set_description (SynapseMatch* base,
                                          const gchar* value)
{
	SynapseBaseAction* self;
	gchar* old_value;
#line 27 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 27 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_real_get_description (base);
#line 27 "../lib/synapse-core/common-actions.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 892 "common-actions.c"
		gchar* _tmp0_;
#line 27 "../lib/synapse-core/common-actions.vala"
		_tmp0_ = g_strdup (value);
#line 27 "../lib/synapse-core/common-actions.vala"
		_g_free0 (self->priv->_description);
#line 27 "../lib/synapse-core/common-actions.vala"
		self->priv->_description = _tmp0_;
#line 27 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY]);
#line 902 "common-actions.c"
	}
}

static const gchar*
synapse_base_action_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
#line 28 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 28 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_icon_name;
#line 28 "../lib/synapse-core/common-actions.vala"
	result = _tmp0_;
#line 28 "../lib/synapse-core/common-actions.vala"
	return result;
#line 920 "common-actions.c"
}

static void
synapse_base_action_real_set_icon_name (SynapseMatch* base,
                                        const gchar* value)
{
	SynapseBaseAction* self;
	gchar* old_value;
#line 28 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 28 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_real_get_icon_name (base);
#line 28 "../lib/synapse-core/common-actions.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 935 "common-actions.c"
		gchar* _tmp0_;
#line 28 "../lib/synapse-core/common-actions.vala"
		_tmp0_ = g_strdup (value);
#line 28 "../lib/synapse-core/common-actions.vala"
		_g_free0 (self->priv->_icon_name);
#line 28 "../lib/synapse-core/common-actions.vala"
		self->priv->_icon_name = _tmp0_;
#line 28 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY]);
#line 945 "common-actions.c"
	}
}

static gboolean
synapse_base_action_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseBaseAction* self;
#line 29 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 29 "../lib/synapse-core/common-actions.vala"
	result = self->priv->_has_thumbnail;
#line 29 "../lib/synapse-core/common-actions.vala"
	return result;
#line 960 "common-actions.c"
}

static void
synapse_base_action_real_set_has_thumbnail (SynapseMatch* base,
                                            gboolean value)
{
	SynapseBaseAction* self;
	gboolean old_value;
#line 29 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 29 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_real_get_has_thumbnail (base);
#line 29 "../lib/synapse-core/common-actions.vala"
	if (old_value != value) {
#line 29 "../lib/synapse-core/common-actions.vala"
		self->priv->_has_thumbnail = value;
#line 29 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY]);
#line 979 "common-actions.c"
	}
}

static const gchar*
synapse_base_action_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
#line 30 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 30 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 30 "../lib/synapse-core/common-actions.vala"
	result = _tmp0_;
#line 30 "../lib/synapse-core/common-actions.vala"
	return result;
#line 997 "common-actions.c"
}

static void
synapse_base_action_real_set_thumbnail_path (SynapseMatch* base,
                                             const gchar* value)
{
	SynapseBaseAction* self;
	gchar* old_value;
#line 30 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 30 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_real_get_thumbnail_path (base);
#line 30 "../lib/synapse-core/common-actions.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1012 "common-actions.c"
		gchar* _tmp0_;
#line 30 "../lib/synapse-core/common-actions.vala"
		_tmp0_ = g_strdup (value);
#line 30 "../lib/synapse-core/common-actions.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 30 "../lib/synapse-core/common-actions.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 30 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY]);
#line 1022 "common-actions.c"
	}
}

static SynapseMatchType
synapse_base_action_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseBaseAction* self;
	SynapseMatchType _tmp0_;
#line 31 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 31 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = self->priv->_match_type;
#line 31 "../lib/synapse-core/common-actions.vala"
	result = _tmp0_;
#line 31 "../lib/synapse-core/common-actions.vala"
	return result;
#line 1040 "common-actions.c"
}

static void
synapse_base_action_real_set_match_type (SynapseMatch* base,
                                         SynapseMatchType value)
{
	SynapseBaseAction* self;
	SynapseMatchType old_value;
#line 31 "../lib/synapse-core/common-actions.vala"
	self = (SynapseBaseAction*) base;
#line 31 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_real_get_match_type (base);
#line 31 "../lib/synapse-core/common-actions.vala"
	if (old_value != value) {
#line 31 "../lib/synapse-core/common-actions.vala"
		self->priv->_match_type = value;
#line 31 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY]);
#line 1059 "common-actions.c"
	}
}

gint
synapse_base_action_get_default_relevancy (SynapseBaseAction* self)
{
	gint result;
#line 33 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 33 "../lib/synapse-core/common-actions.vala"
	result = self->priv->_default_relevancy;
#line 33 "../lib/synapse-core/common-actions.vala"
	return result;
#line 1073 "common-actions.c"
}

void
synapse_base_action_set_default_relevancy (SynapseBaseAction* self,
                                           gint value)
{
	gint old_value;
#line 33 "../lib/synapse-core/common-actions.vala"
	g_return_if_fail (self != NULL);
#line 33 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_get_default_relevancy (self);
#line 33 "../lib/synapse-core/common-actions.vala"
	if (old_value != value) {
#line 33 "../lib/synapse-core/common-actions.vala"
		self->priv->_default_relevancy = value;
#line 33 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY]);
#line 1091 "common-actions.c"
	}
}

gboolean
synapse_base_action_get_notify_match (SynapseBaseAction* self)
{
	gboolean result;
#line 34 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 34 "../lib/synapse-core/common-actions.vala"
	result = self->priv->_notify_match;
#line 34 "../lib/synapse-core/common-actions.vala"
	return result;
#line 1105 "common-actions.c"
}

void
synapse_base_action_set_notify_match (SynapseBaseAction* self,
                                      gboolean value)
{
	gboolean old_value;
#line 34 "../lib/synapse-core/common-actions.vala"
	g_return_if_fail (self != NULL);
#line 34 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_base_action_get_notify_match (self);
#line 34 "../lib/synapse-core/common-actions.vala"
	if (old_value != value) {
#line 34 "../lib/synapse-core/common-actions.vala"
		self->priv->_notify_match = value;
#line 34 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY]);
#line 1123 "common-actions.c"
	}
}

static void
synapse_base_action_class_init (SynapseBaseActionClass * klass,
                                gpointer klass_data)
{
#line 24 "../lib/synapse-core/common-actions.vala"
	synapse_base_action_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-core/common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseBaseAction_private_offset);
#line 24 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_base_action_real_valid_for_match;
#line 24 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseBaseAction*, SynapseMatch*)) synapse_base_action_real_get_relevancy_for_match;
#line 24 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_base_action_real_do_execute;
#line 24 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->needs_target = (gboolean (*) (SynapseBaseAction*)) synapse_base_action_real_needs_target;
#line 24 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->target_flags = (SynapseQueryFlags (*) (SynapseBaseAction*)) synapse_base_action_real_target_flags;
#line 24 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_base_action_get_property;
#line 24 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_base_action_set_property;
#line 24 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_base_action_finalize;
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_TITLE_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY] = g_param_spec_boolean ("notify-match", "notify-match", "notify-match", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1167 "common-actions.c"
}

static void
synapse_base_action_synapse_match_interface_init (SynapseMatchIface * iface,
                                                  gpointer iface_data)
{
#line 24 "../lib/synapse-core/common-actions.vala"
	synapse_base_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->execute_with_target = (void (*) (SynapseMatch*, SynapseMatch*, SynapseMatch*)) synapse_base_action_real_execute_with_target;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->needs_target = (gboolean (*) (SynapseMatch*)) synapse_base_action_needs_target;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->target_flags = (SynapseQueryFlags (*) (SynapseMatch*)) synapse_base_action_target_flags;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->get_title = synapse_base_action_real_get_title;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->set_title = synapse_base_action_real_set_title;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->get_description = synapse_base_action_real_get_description;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->set_description = synapse_base_action_real_set_description;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->get_icon_name = synapse_base_action_real_get_icon_name;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->set_icon_name = synapse_base_action_real_set_icon_name;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->get_has_thumbnail = synapse_base_action_real_get_has_thumbnail;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->set_has_thumbnail = synapse_base_action_real_set_has_thumbnail;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->get_thumbnail_path = synapse_base_action_real_get_thumbnail_path;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->set_thumbnail_path = synapse_base_action_real_set_thumbnail_path;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->get_match_type = synapse_base_action_real_get_match_type;
#line 24 "../lib/synapse-core/common-actions.vala"
	iface->set_match_type = synapse_base_action_real_set_match_type;
#line 1206 "common-actions.c"
}

static void
synapse_base_action_instance_init (SynapseBaseAction * self,
                                   gpointer klass)
{
#line 24 "../lib/synapse-core/common-actions.vala"
	self->priv = synapse_base_action_get_instance_private (self);
#line 34 "../lib/synapse-core/common-actions.vala"
	self->priv->_notify_match = TRUE;
#line 1217 "common-actions.c"
}

static void
synapse_base_action_finalize (GObject * obj)
{
	SynapseBaseAction * self;
#line 24 "../lib/synapse-core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction);
#line 26 "../lib/synapse-core/common-actions.vala"
	_g_free0 (self->priv->_title);
#line 27 "../lib/synapse-core/common-actions.vala"
	_g_free0 (self->priv->_description);
#line 28 "../lib/synapse-core/common-actions.vala"
	_g_free0 (self->priv->_icon_name);
#line 30 "../lib/synapse-core/common-actions.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 24 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (synapse_base_action_parent_class)->finalize (obj);
#line 1236 "common-actions.c"
}

static GType
synapse_base_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseBaseActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_base_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseBaseAction), 0, (GInstanceInitFunc) synapse_base_action_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_base_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_base_action_type_id;
	synapse_base_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseBaseAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (synapse_base_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	SynapseBaseAction_private_offset = g_type_add_instance_private (synapse_base_action_type_id, sizeof (SynapseBaseActionPrivate));
	return synapse_base_action_type_id;
}

GType
synapse_base_action_get_type (void)
{
	static volatile gsize synapse_base_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_base_action_type_id__volatile)) {
		GType synapse_base_action_type_id;
		synapse_base_action_type_id = synapse_base_action_get_type_once ();
		g_once_init_leave (&synapse_base_action_type_id__volatile, synapse_base_action_type_id);
	}
	return synapse_base_action_type_id__volatile;
}

static void
_vala_synapse_base_action_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapseBaseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction);
#line 24 "../lib/synapse-core/common-actions.vala"
	switch (property_id) {
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_TITLE_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_int (value, synapse_base_action_get_default_relevancy (self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		g_value_set_boolean (value, synapse_base_action_get_notify_match (self));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 1321 "common-actions.c"
		default:
#line 24 "../lib/synapse-core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 1327 "common-actions.c"
	}
}

static void
_vala_synapse_base_action_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapseBaseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction);
#line 24 "../lib/synapse-core/common-actions.vala"
	switch (property_id) {
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_TITLE_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_base_action_set_default_relevancy (self, g_value_get_int (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 24 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY:
#line 24 "../lib/synapse-core/common-actions.vala"
		synapse_base_action_set_notify_match (self, g_value_get_boolean (value));
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 1389 "common-actions.c"
		default:
#line 24 "../lib/synapse-core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-core/common-actions.vala"
		break;
#line 1395 "common-actions.c"
	}
}

static inline gpointer
synapse_common_actions_get_instance_private (SynapseCommonActions* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActions_private_offset);
}

static void
synapse_common_actions_real_activate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
#line 59 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 1411 "common-actions.c"
}

static void
synapse_common_actions_real_deactivate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
#line 61 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 1420 "common-actions.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 306 "../lib/synapse-core/common-actions.vala"
	return self ? g_object_ref (self) : NULL;
#line 1428 "common-actions.c"
}

static SynapseResultSet*
synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseCommonActions * self;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp2_;
	SynapseResultSet* result = NULL;
#line 301 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 301 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 301 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 302 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = *query;
#line 302 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_.query_string;
#line 302 "../lib/synapse-core/common-actions.vala"
	query_empty = g_strcmp0 (_tmp1_, "") == 0;
#line 303 "../lib/synapse-core/common-actions.vala"
	_tmp2_ = synapse_result_set_new ();
#line 303 "../lib/synapse-core/common-actions.vala"
	results = _tmp2_;
#line 305 "../lib/synapse-core/common-actions.vala"
	if (query_empty) {
#line 1461 "common-actions.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp3_;
			GeeList* _tmp4_;
			gint _action_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _action_index = 0;
#line 306 "../lib/synapse-core/common-actions.vala"
			_tmp3_ = self->priv->actions;
#line 306 "../lib/synapse-core/common-actions.vala"
			_tmp4_ = _g_object_ref0 (_tmp3_);
#line 306 "../lib/synapse-core/common-actions.vala"
			_action_list = _tmp4_;
#line 306 "../lib/synapse-core/common-actions.vala"
			_tmp5_ = _action_list;
#line 306 "../lib/synapse-core/common-actions.vala"
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 306 "../lib/synapse-core/common-actions.vala"
			_tmp7_ = _tmp6_;
#line 306 "../lib/synapse-core/common-actions.vala"
			_action_size = _tmp7_;
#line 306 "../lib/synapse-core/common-actions.vala"
			_action_index = -1;
#line 306 "../lib/synapse-core/common-actions.vala"
			while (TRUE) {
#line 1489 "common-actions.c"
				gint _tmp8_;
				gint _tmp9_;
				SynapseBaseAction* action = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				SynapseBaseAction* _tmp12_;
#line 306 "../lib/synapse-core/common-actions.vala"
				_action_index = _action_index + 1;
#line 306 "../lib/synapse-core/common-actions.vala"
				_tmp8_ = _action_index;
#line 306 "../lib/synapse-core/common-actions.vala"
				_tmp9_ = _action_size;
#line 306 "../lib/synapse-core/common-actions.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 306 "../lib/synapse-core/common-actions.vala"
					break;
#line 1506 "common-actions.c"
				}
#line 306 "../lib/synapse-core/common-actions.vala"
				_tmp10_ = _action_list;
#line 306 "../lib/synapse-core/common-actions.vala"
				_tmp11_ = gee_list_get (_tmp10_, _action_index);
#line 306 "../lib/synapse-core/common-actions.vala"
				action = (SynapseBaseAction*) _tmp11_;
#line 307 "../lib/synapse-core/common-actions.vala"
				_tmp12_ = action;
#line 307 "../lib/synapse-core/common-actions.vala"
				if (synapse_base_action_valid_for_match (_tmp12_, match)) {
#line 1518 "common-actions.c"
					SynapseResultSet* _tmp13_;
					SynapseBaseAction* _tmp14_;
					SynapseBaseAction* _tmp15_;
#line 308 "../lib/synapse-core/common-actions.vala"
					_tmp13_ = results;
#line 308 "../lib/synapse-core/common-actions.vala"
					_tmp14_ = action;
#line 308 "../lib/synapse-core/common-actions.vala"
					_tmp15_ = action;
#line 308 "../lib/synapse-core/common-actions.vala"
					synapse_result_set_add (_tmp13_, (SynapseMatch*) _tmp14_, synapse_base_action_get_relevancy_for_match (_tmp15_, match));
#line 1530 "common-actions.c"
				}
#line 306 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (action);
#line 1534 "common-actions.c"
			}
#line 306 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_action_list);
#line 1538 "common-actions.c"
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp16_;
		const gchar* _tmp17_;
		GeeList* _tmp18_;
#line 312 "../lib/synapse-core/common-actions.vala"
		_tmp16_ = *query;
#line 312 "../lib/synapse-core/common-actions.vala"
		_tmp17_ = _tmp16_.query_string;
#line 312 "../lib/synapse-core/common-actions.vala"
		_tmp18_ = synapse_query_get_matchers_for_query (_tmp17_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 312 "../lib/synapse-core/common-actions.vala"
		matchers = _tmp18_;
#line 1553 "common-actions.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp19_;
			GeeList* _tmp20_;
			gint _action_size = 0;
			GeeList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _action_index = 0;
#line 313 "../lib/synapse-core/common-actions.vala"
			_tmp19_ = self->priv->actions;
#line 313 "../lib/synapse-core/common-actions.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 313 "../lib/synapse-core/common-actions.vala"
			_action_list = _tmp20_;
#line 313 "../lib/synapse-core/common-actions.vala"
			_tmp21_ = _action_list;
#line 313 "../lib/synapse-core/common-actions.vala"
			_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
#line 313 "../lib/synapse-core/common-actions.vala"
			_tmp23_ = _tmp22_;
#line 313 "../lib/synapse-core/common-actions.vala"
			_action_size = _tmp23_;
#line 313 "../lib/synapse-core/common-actions.vala"
			_action_index = -1;
#line 313 "../lib/synapse-core/common-actions.vala"
			while (TRUE) {
#line 1581 "common-actions.c"
				gint _tmp24_;
				gint _tmp25_;
				SynapseBaseAction* action = NULL;
				GeeList* _tmp26_;
				gpointer _tmp27_;
				SynapseBaseAction* _tmp28_;
#line 313 "../lib/synapse-core/common-actions.vala"
				_action_index = _action_index + 1;
#line 313 "../lib/synapse-core/common-actions.vala"
				_tmp24_ = _action_index;
#line 313 "../lib/synapse-core/common-actions.vala"
				_tmp25_ = _action_size;
#line 313 "../lib/synapse-core/common-actions.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 313 "../lib/synapse-core/common-actions.vala"
					break;
#line 1598 "common-actions.c"
				}
#line 313 "../lib/synapse-core/common-actions.vala"
				_tmp26_ = _action_list;
#line 313 "../lib/synapse-core/common-actions.vala"
				_tmp27_ = gee_list_get (_tmp26_, _action_index);
#line 313 "../lib/synapse-core/common-actions.vala"
				action = (SynapseBaseAction*) _tmp27_;
#line 314 "../lib/synapse-core/common-actions.vala"
				_tmp28_ = action;
#line 314 "../lib/synapse-core/common-actions.vala"
				if (!synapse_base_action_valid_for_match (_tmp28_, match)) {
#line 315 "../lib/synapse-core/common-actions.vala"
					_g_object_unref0 (action);
#line 315 "../lib/synapse-core/common-actions.vala"
					continue;
#line 1614 "common-actions.c"
				}
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp29_;
					GeeList* _tmp30_;
					gint _matcher_size = 0;
					GeeList* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gint _matcher_index = 0;
#line 318 "../lib/synapse-core/common-actions.vala"
					_tmp29_ = matchers;
#line 318 "../lib/synapse-core/common-actions.vala"
					_tmp30_ = _g_object_ref0 (_tmp29_);
#line 318 "../lib/synapse-core/common-actions.vala"
					_matcher_list = _tmp30_;
#line 318 "../lib/synapse-core/common-actions.vala"
					_tmp31_ = _matcher_list;
#line 318 "../lib/synapse-core/common-actions.vala"
					_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
#line 318 "../lib/synapse-core/common-actions.vala"
					_tmp33_ = _tmp32_;
#line 318 "../lib/synapse-core/common-actions.vala"
					_matcher_size = _tmp33_;
#line 318 "../lib/synapse-core/common-actions.vala"
					_matcher_index = -1;
#line 318 "../lib/synapse-core/common-actions.vala"
					while (TRUE) {
#line 1643 "common-actions.c"
						gint _tmp34_;
						gint _tmp35_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp36_;
						gpointer _tmp37_;
						GeeMapEntry* _tmp38_;
						gconstpointer _tmp39_;
						gconstpointer _tmp40_;
						SynapseBaseAction* _tmp41_;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
#line 318 "../lib/synapse-core/common-actions.vala"
						_matcher_index = _matcher_index + 1;
#line 318 "../lib/synapse-core/common-actions.vala"
						_tmp34_ = _matcher_index;
#line 318 "../lib/synapse-core/common-actions.vala"
						_tmp35_ = _matcher_size;
#line 318 "../lib/synapse-core/common-actions.vala"
						if (!(_tmp34_ < _tmp35_)) {
#line 318 "../lib/synapse-core/common-actions.vala"
							break;
#line 1665 "common-actions.c"
						}
#line 318 "../lib/synapse-core/common-actions.vala"
						_tmp36_ = _matcher_list;
#line 318 "../lib/synapse-core/common-actions.vala"
						_tmp37_ = gee_list_get (_tmp36_, _matcher_index);
#line 318 "../lib/synapse-core/common-actions.vala"
						matcher = (GeeMapEntry*) _tmp37_;
#line 319 "../lib/synapse-core/common-actions.vala"
						_tmp38_ = matcher;
#line 319 "../lib/synapse-core/common-actions.vala"
						_tmp39_ = gee_map_entry_get_key (_tmp38_);
#line 319 "../lib/synapse-core/common-actions.vala"
						_tmp40_ = _tmp39_;
#line 319 "../lib/synapse-core/common-actions.vala"
						_tmp41_ = action;
#line 319 "../lib/synapse-core/common-actions.vala"
						_tmp42_ = synapse_match_get_title ((SynapseMatch*) _tmp41_);
#line 319 "../lib/synapse-core/common-actions.vala"
						_tmp43_ = _tmp42_;
#line 319 "../lib/synapse-core/common-actions.vala"
						if (g_regex_match ((GRegex*) _tmp40_, _tmp43_, 0, NULL)) {
#line 1687 "common-actions.c"
							SynapseResultSet* _tmp44_;
							SynapseBaseAction* _tmp45_;
							GeeMapEntry* _tmp46_;
							gconstpointer _tmp47_;
							gconstpointer _tmp48_;
#line 320 "../lib/synapse-core/common-actions.vala"
							_tmp44_ = results;
#line 320 "../lib/synapse-core/common-actions.vala"
							_tmp45_ = action;
#line 320 "../lib/synapse-core/common-actions.vala"
							_tmp46_ = matcher;
#line 320 "../lib/synapse-core/common-actions.vala"
							_tmp47_ = gee_map_entry_get_value (_tmp46_);
#line 320 "../lib/synapse-core/common-actions.vala"
							_tmp48_ = _tmp47_;
#line 320 "../lib/synapse-core/common-actions.vala"
							synapse_result_set_add (_tmp44_, (SynapseMatch*) _tmp45_, (gint) ((gintptr) _tmp48_));
#line 321 "../lib/synapse-core/common-actions.vala"
							_g_object_unref0 (matcher);
#line 321 "../lib/synapse-core/common-actions.vala"
							break;
#line 1709 "common-actions.c"
						}
#line 318 "../lib/synapse-core/common-actions.vala"
						_g_object_unref0 (matcher);
#line 1713 "common-actions.c"
					}
#line 318 "../lib/synapse-core/common-actions.vala"
					_g_object_unref0 (_matcher_list);
#line 1717 "common-actions.c"
				}
#line 313 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (action);
#line 1721 "common-actions.c"
			}
#line 313 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_action_list);
#line 1725 "common-actions.c"
		}
#line 305 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (matchers);
#line 1729 "common-actions.c"
	}
#line 327 "../lib/synapse-core/common-actions.vala"
	result = results;
#line 327 "../lib/synapse-core/common-actions.vala"
	return result;
#line 1735 "common-actions.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 337 "../lib/synapse-core/common-actions.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1743 "common-actions.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 337 "../lib/synapse-core/common-actions.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1751 "common-actions.c"
}

void
synapse_common_actions_open_uri (const gchar* uri)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 330 "../lib/synapse-core/common-actions.vala"
	g_return_if_fail (uri != NULL);
#line 331 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = g_file_new_for_uri (uri);
#line 331 "../lib/synapse-core/common-actions.vala"
	f = _tmp0_;
#line 1766 "common-actions.c"
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp1_;
		GAppInfo* _tmp2_;
		GList* files = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp5_;
		GdkDisplay* _tmp6_;
		GAppInfo* _tmp7_;
		GList* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
		GdkAppLaunchContext* _tmp11_;
#line 333 "../lib/synapse-core/common-actions.vala"
		_tmp1_ = f;
#line 333 "../lib/synapse-core/common-actions.vala"
		_tmp2_ = g_file_query_default_handler (_tmp1_, NULL, &_inner_error0_);
#line 333 "../lib/synapse-core/common-actions.vala"
		app_info = _tmp2_;
#line 333 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1790 "common-actions.c"
			goto __catch0_g_error;
		}
#line 334 "../lib/synapse-core/common-actions.vala"
		files = NULL;
#line 335 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = f;
#line 335 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 335 "../lib/synapse-core/common-actions.vala"
		files = g_list_prepend (files, _tmp4_);
#line 336 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = gdk_display_get_default ();
#line 336 "../lib/synapse-core/common-actions.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 336 "../lib/synapse-core/common-actions.vala"
		display = _tmp6_;
#line 337 "../lib/synapse-core/common-actions.vala"
		_tmp7_ = app_info;
#line 337 "../lib/synapse-core/common-actions.vala"
		_tmp8_ = files;
#line 337 "../lib/synapse-core/common-actions.vala"
		_tmp9_ = display;
#line 337 "../lib/synapse-core/common-actions.vala"
		_tmp10_ = gdk_display_get_app_launch_context (_tmp9_);
#line 337 "../lib/synapse-core/common-actions.vala"
		_tmp11_ = _tmp10_;
#line 337 "../lib/synapse-core/common-actions.vala"
		g_app_info_launch (_tmp7_, _tmp8_, (GAppLaunchContext*) _tmp11_, &_inner_error0_);
#line 337 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (_tmp11_);
#line 337 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 337 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (display);
#line 337 "../lib/synapse-core/common-actions.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 337 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (app_info);
#line 1829 "common-actions.c"
			goto __catch0_g_error;
		}
#line 332 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (display);
#line 332 "../lib/synapse-core/common-actions.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 332 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (app_info);
#line 1838 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 332 "../lib/synapse-core/common-actions.vala"
		err = _inner_error0_;
#line 332 "../lib/synapse-core/common-actions.vala"
		_inner_error0_ = NULL;
#line 339 "../lib/synapse-core/common-actions.vala"
		_tmp12_ = err;
#line 339 "../lib/synapse-core/common-actions.vala"
		_tmp13_ = _tmp12_->message;
#line 339 "../lib/synapse-core/common-actions.vala"
		synapse_utils_logger_warning (NULL, "%s", _tmp13_, NULL);
#line 332 "../lib/synapse-core/common-actions.vala"
		_g_error_free0 (err);
#line 1858 "common-actions.c"
	}
	__finally0:
#line 332 "../lib/synapse-core/common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 332 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (f);
#line 332 "../lib/synapse-core/common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 332 "../lib/synapse-core/common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 332 "../lib/synapse-core/common-actions.vala"
		return;
#line 1871 "common-actions.c"
	}
#line 330 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (f);
#line 1875 "common-actions.c"
}

SynapseCommonActions*
synapse_common_actions_construct (GType object_type)
{
	SynapseCommonActions * self = NULL;
#line 56 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActions*) g_object_new (object_type, NULL);
#line 56 "../lib/synapse-core/common-actions.vala"
	return self;
#line 1886 "common-actions.c"
}

SynapseCommonActions*
synapse_common_actions_new (void)
{
#line 56 "../lib/synapse-core/common-actions.vala"
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
#line 1894 "common-actions.c"
}

static gboolean
synapse_common_actions_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommonActions* self;
#line 57 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 57 "../lib/synapse-core/common-actions.vala"
	result = self->priv->_enabled;
#line 57 "../lib/synapse-core/common-actions.vala"
	return result;
#line 1908 "common-actions.c"
}

static void
synapse_common_actions_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommonActions* self;
	gboolean old_value;
#line 57 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 57 "../lib/synapse-core/common-actions.vala"
	old_value = synapse_common_actions_real_get_enabled (base);
#line 57 "../lib/synapse-core/common-actions.vala"
	if (old_value != value) {
#line 57 "../lib/synapse-core/common-actions.vala"
		self->priv->_enabled = value;
#line 57 "../lib/synapse-core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY]);
#line 1927 "common-actions.c"
	}
}

static SynapseCommonActionsRunner*
synapse_common_actions_runner_construct (GType object_type)
{
	SynapseCommonActionsRunner * self = NULL;
#line 65 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsRunner*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
#line 64 "../lib/synapse-core/common-actions.vala"
	return self;
#line 1939 "common-actions.c"
}

static SynapseCommonActionsRunner*
synapse_common_actions_runner_new (void)
{
#line 64 "../lib/synapse-core/common-actions.vala"
	return synapse_common_actions_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER);
#line 1947 "common-actions.c"
}

static void
synapse_common_actions_runner_real_do_execute (SynapseBaseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsRunner * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	GError* _inner_error0_ = NULL;
#line 72 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsRunner*) base;
#line 73 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 73 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 73 "../lib/synapse-core/common-actions.vala"
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
#line 1967 "common-actions.c"
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp2_;
		SynapseApplicationMatch* _tmp3_;
		GAppInfo* _tmp4_ = NULL;
		SynapseApplicationMatch* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		GAppInfo* _tmp8_;
		GAppInfo* app = NULL;
		GAppInfo* _tmp13_;
#line 74 "../lib/synapse-core/common-actions.vala"
		_tmp2_ = _g_object_ref0 (SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL);
#line 74 "../lib/synapse-core/common-actions.vala"
		app_match = _tmp2_;
#line 75 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = app_match;
#line 75 "../lib/synapse-core/common-actions.vala"
		g_return_if_fail (_tmp3_ != NULL);
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = app_match;
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp6_ = synapse_application_match_get_app_info (_tmp5_);
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp7_ = _tmp6_;
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = _tmp8_;
#line 77 "../lib/synapse-core/common-actions.vala"
		if (_tmp4_ == NULL) {
#line 1998 "common-actions.c"
			SynapseApplicationMatch* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GDesktopAppInfo* _tmp12_;
#line 78 "../lib/synapse-core/common-actions.vala"
			_tmp9_ = app_match;
#line 78 "../lib/synapse-core/common-actions.vala"
			_tmp10_ = synapse_application_match_get_filename (_tmp9_);
#line 78 "../lib/synapse-core/common-actions.vala"
			_tmp11_ = _tmp10_;
#line 78 "../lib/synapse-core/common-actions.vala"
			_tmp12_ = g_desktop_app_info_new_from_filename (_tmp11_);
#line 78 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp4_);
#line 78 "../lib/synapse-core/common-actions.vala"
			_tmp4_ = (GAppInfo*) _tmp12_;
#line 2015 "common-actions.c"
		}
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp13_ = _tmp4_;
#line 77 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = NULL;
#line 77 "../lib/synapse-core/common-actions.vala"
		app = _tmp13_;
#line 2023 "common-actions.c"
		{
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp14_;
			GdkDisplay* _tmp15_;
			GAppInfo* _tmp16_;
			GdkDisplay* _tmp17_;
			GdkAppLaunchContext* _tmp18_;
			GdkAppLaunchContext* _tmp19_;
			SynapseRelevancyService* _tmp20_;
			SynapseRelevancyService* _tmp21_;
			GAppInfo* _tmp22_;
#line 81 "../lib/synapse-core/common-actions.vala"
			_tmp14_ = gdk_display_get_default ();
#line 81 "../lib/synapse-core/common-actions.vala"
			_tmp15_ = _g_object_ref0 (_tmp14_);
#line 81 "../lib/synapse-core/common-actions.vala"
			display = _tmp15_;
#line 82 "../lib/synapse-core/common-actions.vala"
			_tmp16_ = app;
#line 82 "../lib/synapse-core/common-actions.vala"
			_tmp17_ = display;
#line 82 "../lib/synapse-core/common-actions.vala"
			_tmp18_ = gdk_display_get_app_launch_context (_tmp17_);
#line 82 "../lib/synapse-core/common-actions.vala"
			_tmp19_ = _tmp18_;
#line 82 "../lib/synapse-core/common-actions.vala"
			g_app_info_launch (_tmp16_, NULL, (GAppLaunchContext*) _tmp19_, &_inner_error0_);
#line 82 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp19_);
#line 82 "../lib/synapse-core/common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 82 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (display);
#line 2057 "common-actions.c"
				goto __catch0_g_error;
			}
#line 84 "../lib/synapse-core/common-actions.vala"
			_tmp20_ = synapse_relevancy_service_get_default ();
#line 84 "../lib/synapse-core/common-actions.vala"
			_tmp21_ = _tmp20_;
#line 84 "../lib/synapse-core/common-actions.vala"
			_tmp22_ = app;
#line 84 "../lib/synapse-core/common-actions.vala"
			synapse_relevancy_service_application_launched (_tmp21_, _tmp22_);
#line 84 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp21_);
#line 80 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (display);
#line 2072 "common-actions.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
#line 80 "../lib/synapse-core/common-actions.vala"
			err = _inner_error0_;
#line 80 "../lib/synapse-core/common-actions.vala"
			_inner_error0_ = NULL;
#line 86 "../lib/synapse-core/common-actions.vala"
			_tmp23_ = err;
#line 86 "../lib/synapse-core/common-actions.vala"
			_tmp24_ = _tmp23_->message;
#line 86 "../lib/synapse-core/common-actions.vala"
			synapse_utils_logger_warning ((GObject*) self, "%s", _tmp24_, NULL);
#line 80 "../lib/synapse-core/common-actions.vala"
			_g_error_free0 (err);
#line 2092 "common-actions.c"
		}
		__finally0:
#line 80 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (app);
#line 80 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp4_);
#line 80 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (app_match);
#line 80 "../lib/synapse-core/common-actions.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 80 "../lib/synapse-core/common-actions.vala"
			g_clear_error (&_inner_error0_);
#line 80 "../lib/synapse-core/common-actions.vala"
			return;
#line 2109 "common-actions.c"
		}
#line 73 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (app);
#line 73 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (_tmp4_);
#line 73 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (app_match);
#line 2117 "common-actions.c"
	} else {
#line 89 "../lib/synapse-core/common-actions.vala"
		synapse_match_execute (match, NULL);
#line 2121 "common-actions.c"
	}
}

static gboolean
synapse_common_actions_runner_real_valid_for_match (SynapseBaseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsRunner * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	gboolean result = FALSE;
#line 93 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsRunner*) base;
#line 93 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 94 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 94 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 94 "../lib/synapse-core/common-actions.vala"
	switch (_tmp1_) {
#line 94 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_SEARCH:
#line 2145 "common-actions.c"
		{
#line 96 "../lib/synapse-core/common-actions.vala"
			result = TRUE;
#line 96 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2151 "common-actions.c"
		}
#line 94 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_ACTION:
#line 2155 "common-actions.c"
		{
#line 98 "../lib/synapse-core/common-actions.vala"
			result = TRUE;
#line 98 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2161 "common-actions.c"
		}
#line 94 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_APPLICATION:
#line 2165 "common-actions.c"
		{
			SynapseApplicationMatch* am = NULL;
			SynapseApplicationMatch* _tmp2_;
			gboolean _tmp3_ = FALSE;
			SynapseApplicationMatch* _tmp4_;
#line 100 "../lib/synapse-core/common-actions.vala"
			_tmp2_ = _g_object_ref0 (SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL);
#line 100 "../lib/synapse-core/common-actions.vala"
			am = _tmp2_;
#line 101 "../lib/synapse-core/common-actions.vala"
			_tmp4_ = am;
#line 101 "../lib/synapse-core/common-actions.vala"
			if (_tmp4_ == NULL) {
#line 101 "../lib/synapse-core/common-actions.vala"
				_tmp3_ = TRUE;
#line 2181 "common-actions.c"
			} else {
				SynapseApplicationMatch* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
#line 101 "../lib/synapse-core/common-actions.vala"
				_tmp5_ = am;
#line 101 "../lib/synapse-core/common-actions.vala"
				_tmp6_ = synapse_application_match_get_needs_terminal (_tmp5_);
#line 101 "../lib/synapse-core/common-actions.vala"
				_tmp7_ = _tmp6_;
#line 101 "../lib/synapse-core/common-actions.vala"
				_tmp3_ = !_tmp7_;
#line 2194 "common-actions.c"
			}
#line 101 "../lib/synapse-core/common-actions.vala"
			result = _tmp3_;
#line 101 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (am);
#line 101 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2202 "common-actions.c"
		}
		default:
		{
#line 103 "../lib/synapse-core/common-actions.vala"
			result = FALSE;
#line 103 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2210 "common-actions.c"
		}
	}
}

static void
synapse_common_actions_runner_class_init (SynapseCommonActionsRunnerClass * klass,
                                          gpointer klass_data)
{
#line 63 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_runner_parent_class = g_type_class_peek_parent (klass);
#line 63 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_runner_real_do_execute;
#line 63 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_runner_real_valid_for_match;
#line 2225 "common-actions.c"
}

static void
synapse_common_actions_runner_instance_init (SynapseCommonActionsRunner * self,
                                             gpointer klass)
{
}

static GType
synapse_common_actions_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsRunner), 0, (GInstanceInitFunc) synapse_common_actions_runner_instance_init, NULL };
	GType synapse_common_actions_runner_type_id;
	synapse_common_actions_runner_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsRunner", &g_define_type_info, 0);
	return synapse_common_actions_runner_type_id;
}

static GType
synapse_common_actions_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_runner_type_id__volatile)) {
		GType synapse_common_actions_runner_type_id;
		synapse_common_actions_runner_type_id = synapse_common_actions_runner_get_type_once ();
		g_once_init_leave (&synapse_common_actions_runner_type_id__volatile, synapse_common_actions_runner_type_id);
	}
	return synapse_common_actions_runner_type_id__volatile;
}

static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_construct (GType object_type)
{
	SynapseCommonActionsTerminalRunner * self = NULL;
#line 110 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) g_object_new (object_type, "title", _ ("Run in Terminal"), "description", _ ("Run application or command in terminal"), "icon-name", "terminal", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, NULL);
#line 109 "../lib/synapse-core/common-actions.vala"
	return self;
#line 2263 "common-actions.c"
}

static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_new (void)
{
#line 109 "../lib/synapse-core/common-actions.vala"
	return synapse_common_actions_terminal_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER);
#line 2271 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_real_do_execute (SynapseBaseAction* base,
                                                        SynapseMatch* match,
                                                        SynapseMatch* target)
{
	SynapseCommonActionsTerminalRunner * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	GError* _inner_error0_ = NULL;
#line 117 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) base;
#line 118 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 118 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 118 "../lib/synapse-core/common-actions.vala"
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
#line 2291 "common-actions.c"
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp2_;
		SynapseApplicationMatch* _tmp3_;
		GAppInfo* _tmp4_ = NULL;
		SynapseApplicationMatch* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		GAppInfo* _tmp8_;
		GAppInfo* original = NULL;
		GAppInfo* _tmp13_;
#line 119 "../lib/synapse-core/common-actions.vala"
		_tmp2_ = _g_object_ref0 (SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL);
#line 119 "../lib/synapse-core/common-actions.vala"
		app_match = _tmp2_;
#line 120 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = app_match;
#line 120 "../lib/synapse-core/common-actions.vala"
		g_return_if_fail (_tmp3_ != NULL);
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = app_match;
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp6_ = synapse_application_match_get_app_info (_tmp5_);
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp7_ = _tmp6_;
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = _tmp8_;
#line 122 "../lib/synapse-core/common-actions.vala"
		if (_tmp4_ == NULL) {
#line 2322 "common-actions.c"
			SynapseApplicationMatch* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GDesktopAppInfo* _tmp12_;
#line 123 "../lib/synapse-core/common-actions.vala"
			_tmp9_ = app_match;
#line 123 "../lib/synapse-core/common-actions.vala"
			_tmp10_ = synapse_application_match_get_filename (_tmp9_);
#line 123 "../lib/synapse-core/common-actions.vala"
			_tmp11_ = _tmp10_;
#line 123 "../lib/synapse-core/common-actions.vala"
			_tmp12_ = g_desktop_app_info_new_from_filename (_tmp11_);
#line 123 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp4_);
#line 123 "../lib/synapse-core/common-actions.vala"
			_tmp4_ = (GAppInfo*) _tmp12_;
#line 2339 "common-actions.c"
		}
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp13_ = _tmp4_;
#line 122 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = NULL;
#line 122 "../lib/synapse-core/common-actions.vala"
		original = _tmp13_;
#line 2347 "common-actions.c"
		{
			GAppInfo* app = NULL;
			GAppInfo* _tmp14_;
			const gchar* _tmp15_;
			GAppInfo* _tmp16_;
			const gchar* _tmp17_;
			GAppInfo* _tmp18_;
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp19_;
			GdkDisplay* _tmp20_;
			GAppInfo* _tmp21_;
			GdkDisplay* _tmp22_;
			GdkAppLaunchContext* _tmp23_;
			GdkAppLaunchContext* _tmp24_;
#line 126 "../lib/synapse-core/common-actions.vala"
			_tmp14_ = original;
#line 126 "../lib/synapse-core/common-actions.vala"
			_tmp15_ = g_app_info_get_commandline (_tmp14_);
#line 126 "../lib/synapse-core/common-actions.vala"
			_tmp16_ = original;
#line 126 "../lib/synapse-core/common-actions.vala"
			_tmp17_ = g_app_info_get_name (_tmp16_);
#line 126 "../lib/synapse-core/common-actions.vala"
			_tmp18_ = g_app_info_create_from_commandline (_tmp15_, _tmp17_, G_APP_INFO_CREATE_NEEDS_TERMINAL, &_inner_error0_);
#line 126 "../lib/synapse-core/common-actions.vala"
			app = _tmp18_;
#line 126 "../lib/synapse-core/common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2376 "common-actions.c"
				goto __catch0_g_error;
			}
#line 129 "../lib/synapse-core/common-actions.vala"
			_tmp19_ = gdk_display_get_default ();
#line 129 "../lib/synapse-core/common-actions.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 129 "../lib/synapse-core/common-actions.vala"
			display = _tmp20_;
#line 130 "../lib/synapse-core/common-actions.vala"
			_tmp21_ = app;
#line 130 "../lib/synapse-core/common-actions.vala"
			_tmp22_ = display;
#line 130 "../lib/synapse-core/common-actions.vala"
			_tmp23_ = gdk_display_get_app_launch_context (_tmp22_);
#line 130 "../lib/synapse-core/common-actions.vala"
			_tmp24_ = _tmp23_;
#line 130 "../lib/synapse-core/common-actions.vala"
			g_app_info_launch (_tmp21_, NULL, (GAppLaunchContext*) _tmp24_, &_inner_error0_);
#line 130 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp24_);
#line 130 "../lib/synapse-core/common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 130 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (display);
#line 130 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (app);
#line 2403 "common-actions.c"
				goto __catch0_g_error;
			}
#line 125 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (display);
#line 125 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (app);
#line 2410 "common-actions.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
#line 125 "../lib/synapse-core/common-actions.vala"
			err = _inner_error0_;
#line 125 "../lib/synapse-core/common-actions.vala"
			_inner_error0_ = NULL;
#line 132 "../lib/synapse-core/common-actions.vala"
			_tmp25_ = err;
#line 132 "../lib/synapse-core/common-actions.vala"
			_tmp26_ = _tmp25_->message;
#line 132 "../lib/synapse-core/common-actions.vala"
			synapse_utils_logger_warning ((GObject*) self, "%s", _tmp26_, NULL);
#line 125 "../lib/synapse-core/common-actions.vala"
			_g_error_free0 (err);
#line 2430 "common-actions.c"
		}
		__finally0:
#line 125 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 125 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (original);
#line 125 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (_tmp4_);
#line 125 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (app_match);
#line 125 "../lib/synapse-core/common-actions.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 125 "../lib/synapse-core/common-actions.vala"
			g_clear_error (&_inner_error0_);
#line 125 "../lib/synapse-core/common-actions.vala"
			return;
#line 2447 "common-actions.c"
		}
#line 118 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (original);
#line 118 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (_tmp4_);
#line 118 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (app_match);
#line 2455 "common-actions.c"
	}
}

static gboolean
synapse_common_actions_terminal_runner_real_valid_for_match (SynapseBaseAction* base,
                                                             SynapseMatch* match)
{
	SynapseCommonActionsTerminalRunner * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	gboolean result = FALSE;
#line 137 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) base;
#line 137 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 138 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 138 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 138 "../lib/synapse-core/common-actions.vala"
	switch (_tmp1_) {
#line 138 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_APPLICATION:
#line 2479 "common-actions.c"
		{
			SynapseApplicationMatch* am = NULL;
			SynapseApplicationMatch* _tmp2_;
			SynapseApplicationMatch* _tmp3_;
#line 140 "../lib/synapse-core/common-actions.vala"
			_tmp2_ = _g_object_ref0 (SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL);
#line 140 "../lib/synapse-core/common-actions.vala"
			am = _tmp2_;
#line 141 "../lib/synapse-core/common-actions.vala"
			_tmp3_ = am;
#line 141 "../lib/synapse-core/common-actions.vala"
			result = _tmp3_ != NULL;
#line 141 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (am);
#line 141 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2496 "common-actions.c"
		}
		default:
		{
#line 143 "../lib/synapse-core/common-actions.vala"
			result = FALSE;
#line 143 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2504 "common-actions.c"
		}
	}
}

static void
synapse_common_actions_terminal_runner_class_init (SynapseCommonActionsTerminalRunnerClass * klass,
                                                   gpointer klass_data)
{
#line 108 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_terminal_runner_parent_class = g_type_class_peek_parent (klass);
#line 108 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_do_execute;
#line 108 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_valid_for_match;
#line 2519 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_instance_init (SynapseCommonActionsTerminalRunner * self,
                                                      gpointer klass)
{
}

static GType
synapse_common_actions_terminal_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsTerminalRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_terminal_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsTerminalRunner), 0, (GInstanceInitFunc) synapse_common_actions_terminal_runner_instance_init, NULL };
	GType synapse_common_actions_terminal_runner_type_id;
	synapse_common_actions_terminal_runner_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsTerminalRunner", &g_define_type_info, 0);
	return synapse_common_actions_terminal_runner_type_id;
}

static GType
synapse_common_actions_terminal_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_terminal_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_terminal_runner_type_id__volatile)) {
		GType synapse_common_actions_terminal_runner_type_id;
		synapse_common_actions_terminal_runner_type_id = synapse_common_actions_terminal_runner_get_type_once ();
		g_once_init_leave (&synapse_common_actions_terminal_runner_type_id__volatile, synapse_common_actions_terminal_runner_type_id);
	}
	return synapse_common_actions_terminal_runner_type_id__volatile;
}

static inline gpointer
synapse_common_actions_opener_get_instance_private (SynapseCommonActionsOpener* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActionsOpener_private_offset);
}

static SynapseCommonActionsOpener*
synapse_common_actions_opener_construct (GType object_type)
{
	SynapseCommonActionsOpener * self = NULL;
#line 150 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsOpener*) g_object_new (object_type, "title", _ ("Open"), "description", _ ("Open using default application"), "icon-name", "fileopen", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_GOOD, NULL);
#line 149 "../lib/synapse-core/common-actions.vala"
	return self;
#line 2563 "common-actions.c"
}

static SynapseCommonActionsOpener*
synapse_common_actions_opener_new (void)
{
#line 149 "../lib/synapse-core/common-actions.vala"
	return synapse_common_actions_opener_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPENER);
#line 2571 "common-actions.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 2594 "common-actions.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 2603 "common-actions.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 2622 "common-actions.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2626 "common-actions.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 2632 "common-actions.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 2642 "common-actions.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 2650 "common-actions.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 2654 "common-actions.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 2660 "common-actions.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 2670 "common-actions.c"
}

static void
synapse_common_actions_opener_real_do_execute (SynapseBaseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsOpener * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
#line 157 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsOpener*) base;
#line 158 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = _g_object_ref0 (SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL);
#line 158 "../lib/synapse-core/common-actions.vala"
	uri_match = _tmp0_;
#line 160 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = uri_match;
#line 160 "../lib/synapse-core/common-actions.vala"
	if (_tmp1_ != NULL) {
#line 2692 "common-actions.c"
		SynapseUriMatch* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 161 "../lib/synapse-core/common-actions.vala"
		_tmp2_ = uri_match;
#line 161 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = synapse_uri_match_get_uri (_tmp2_);
#line 161 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = _tmp3_;
#line 161 "../lib/synapse-core/common-actions.vala"
		synapse_common_actions_open_uri (_tmp4_);
#line 2704 "common-actions.c"
	} else {
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 162 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = self->priv->file_path;
#line 162 "../lib/synapse-core/common-actions.vala"
		_tmp6_ = synapse_match_get_title (match);
#line 162 "../lib/synapse-core/common-actions.vala"
		_tmp7_ = _tmp6_;
#line 162 "../lib/synapse-core/common-actions.vala"
		if (g_regex_match (_tmp5_, _tmp7_, 0, NULL)) {
#line 2717 "common-actions.c"
			GFile* f = NULL;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
#line 164 "../lib/synapse-core/common-actions.vala"
			_tmp8_ = synapse_match_get_title (match);
#line 164 "../lib/synapse-core/common-actions.vala"
			_tmp9_ = _tmp8_;
#line 164 "../lib/synapse-core/common-actions.vala"
			if (g_str_has_prefix (_tmp9_, "~")) {
#line 2730 "common-actions.c"
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GFile* _tmp17_;
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp10_ = g_get_home_dir ();
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp11_ = synapse_match_get_title (match);
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp12_ = _tmp11_;
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp13_ = string_substring (_tmp12_, (glong) 1, (glong) -1);
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp14_ = _tmp13_;
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp15_ = g_build_filename (_tmp10_, _tmp14_, NULL, NULL);
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp16_ = _tmp15_;
#line 165 "../lib/synapse-core/common-actions.vala"
				_tmp17_ = g_file_new_for_path (_tmp16_);
#line 165 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (f);
#line 165 "../lib/synapse-core/common-actions.vala"
				f = _tmp17_;
#line 165 "../lib/synapse-core/common-actions.vala"
				_g_free0 (_tmp16_);
#line 165 "../lib/synapse-core/common-actions.vala"
				_g_free0 (_tmp14_);
#line 2763 "common-actions.c"
			} else {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GFile* _tmp20_;
#line 167 "../lib/synapse-core/common-actions.vala"
				_tmp18_ = synapse_match_get_title (match);
#line 167 "../lib/synapse-core/common-actions.vala"
				_tmp19_ = _tmp18_;
#line 167 "../lib/synapse-core/common-actions.vala"
				_tmp20_ = g_file_new_for_path (_tmp19_);
#line 167 "../lib/synapse-core/common-actions.vala"
				_g_object_unref0 (f);
#line 167 "../lib/synapse-core/common-actions.vala"
				f = _tmp20_;
#line 2778 "common-actions.c"
			}
#line 169 "../lib/synapse-core/common-actions.vala"
			_tmp21_ = f;
#line 169 "../lib/synapse-core/common-actions.vala"
			_tmp22_ = g_file_get_uri (_tmp21_);
#line 169 "../lib/synapse-core/common-actions.vala"
			_tmp23_ = _tmp22_;
#line 169 "../lib/synapse-core/common-actions.vala"
			synapse_common_actions_open_uri (_tmp23_);
#line 169 "../lib/synapse-core/common-actions.vala"
			_g_free0 (_tmp23_);
#line 162 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (f);
#line 2792 "common-actions.c"
		} else {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
#line 171 "../lib/synapse-core/common-actions.vala"
			_tmp24_ = synapse_match_get_title (match);
#line 171 "../lib/synapse-core/common-actions.vala"
			_tmp25_ = _tmp24_;
#line 171 "../lib/synapse-core/common-actions.vala"
			synapse_common_actions_open_uri (_tmp25_);
#line 2802 "common-actions.c"
		}
	}
#line 157 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (uri_match);
#line 2807 "common-actions.c"
}

static gboolean
synapse_common_actions_opener_real_valid_for_match (SynapseBaseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsOpener * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	gboolean result = FALSE;
#line 175 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsOpener*) base;
#line 175 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 176 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 176 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 176 "../lib/synapse-core/common-actions.vala"
	switch (_tmp1_) {
#line 176 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
#line 2830 "common-actions.c"
		{
#line 178 "../lib/synapse-core/common-actions.vala"
			result = TRUE;
#line 178 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2836 "common-actions.c"
		}
#line 176 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_UNKNOWN:
#line 2840 "common-actions.c"
		{
			gboolean _tmp2_ = FALSE;
			GRegex* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
#line 180 "../lib/synapse-core/common-actions.vala"
			_tmp3_ = self->priv->web_uri;
#line 180 "../lib/synapse-core/common-actions.vala"
			_tmp4_ = synapse_match_get_title (match);
#line 180 "../lib/synapse-core/common-actions.vala"
			_tmp5_ = _tmp4_;
#line 180 "../lib/synapse-core/common-actions.vala"
			if (g_regex_match (_tmp3_, _tmp5_, 0, NULL)) {
#line 180 "../lib/synapse-core/common-actions.vala"
				_tmp2_ = TRUE;
#line 2856 "common-actions.c"
			} else {
				GRegex* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
#line 180 "../lib/synapse-core/common-actions.vala"
				_tmp6_ = self->priv->file_path;
#line 180 "../lib/synapse-core/common-actions.vala"
				_tmp7_ = synapse_match_get_title (match);
#line 180 "../lib/synapse-core/common-actions.vala"
				_tmp8_ = _tmp7_;
#line 180 "../lib/synapse-core/common-actions.vala"
				_tmp2_ = g_regex_match (_tmp6_, _tmp8_, 0, NULL);
#line 2869 "common-actions.c"
			}
#line 180 "../lib/synapse-core/common-actions.vala"
			result = _tmp2_;
#line 180 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2875 "common-actions.c"
		}
		default:
		{
#line 182 "../lib/synapse-core/common-actions.vala"
			result = FALSE;
#line 182 "../lib/synapse-core/common-actions.vala"
			return result;
#line 2883 "common-actions.c"
		}
	}
}

static GObject *
synapse_common_actions_opener_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActionsOpener * self;
	GError* _inner_error0_ = NULL;
#line 189 "../lib/synapse-core/common-actions.vala"
	parent_class = G_OBJECT_CLASS (synapse_common_actions_opener_parent_class);
#line 189 "../lib/synapse-core/common-actions.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 189 "../lib/synapse-core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
#line 2903 "common-actions.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 191 "../lib/synapse-core/common-actions.vala"
		_tmp1_ = g_regex_new ("^(ftp|http(s)?)://[^.]+\\.[^.]+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 191 "../lib/synapse-core/common-actions.vala"
		_tmp0_ = _tmp1_;
#line 191 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2917 "common-actions.c"
			goto __catch0_g_error;
		}
#line 191 "../lib/synapse-core/common-actions.vala"
		_tmp2_ = _tmp0_;
#line 191 "../lib/synapse-core/common-actions.vala"
		_tmp0_ = NULL;
#line 191 "../lib/synapse-core/common-actions.vala"
		_g_regex_unref0 (self->priv->web_uri);
#line 191 "../lib/synapse-core/common-actions.vala"
		self->priv->web_uri = _tmp2_;
#line 192 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = g_regex_new ("^(/|~/)[^/]+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 192 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = _tmp4_;
#line 192 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 192 "../lib/synapse-core/common-actions.vala"
			_g_regex_unref0 (_tmp0_);
#line 2936 "common-actions.c"
			goto __catch0_g_error;
		}
#line 192 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = _tmp3_;
#line 192 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = NULL;
#line 192 "../lib/synapse-core/common-actions.vala"
		_g_regex_unref0 (self->priv->file_path);
#line 192 "../lib/synapse-core/common-actions.vala"
		self->priv->file_path = _tmp5_;
#line 190 "../lib/synapse-core/common-actions.vala"
		_g_regex_unref0 (_tmp3_);
#line 190 "../lib/synapse-core/common-actions.vala"
		_g_regex_unref0 (_tmp0_);
#line 2951 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 190 "../lib/synapse-core/common-actions.vala"
		err = _inner_error0_;
#line 190 "../lib/synapse-core/common-actions.vala"
		_inner_error0_ = NULL;
#line 194 "../lib/synapse-core/common-actions.vala"
		_tmp6_ = err;
#line 194 "../lib/synapse-core/common-actions.vala"
		_tmp7_ = _tmp6_->message;
#line 194 "../lib/synapse-core/common-actions.vala"
		synapse_utils_logger_warning ((GObject*) self, "%s", _tmp7_, NULL);
#line 190 "../lib/synapse-core/common-actions.vala"
		_g_error_free0 (err);
#line 2971 "common-actions.c"
	}
	__finally0:
#line 190 "../lib/synapse-core/common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 190 "../lib/synapse-core/common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 190 "../lib/synapse-core/common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 2980 "common-actions.c"
	}
#line 189 "../lib/synapse-core/common-actions.vala"
	return obj;
#line 2984 "common-actions.c"
}

static void
synapse_common_actions_opener_class_init (SynapseCommonActionsOpenerClass * klass,
                                          gpointer klass_data)
{
#line 148 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_opener_parent_class = g_type_class_peek_parent (klass);
#line 148 "../lib/synapse-core/common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommonActionsOpener_private_offset);
#line 148 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_opener_real_do_execute;
#line 148 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_opener_real_valid_for_match;
#line 148 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_opener_constructor;
#line 148 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_opener_finalize;
#line 3003 "common-actions.c"
}

static void
synapse_common_actions_opener_instance_init (SynapseCommonActionsOpener * self,
                                             gpointer klass)
{
#line 148 "../lib/synapse-core/common-actions.vala"
	self->priv = synapse_common_actions_opener_get_instance_private (self);
#line 3012 "common-actions.c"
}

static void
synapse_common_actions_opener_finalize (GObject * obj)
{
	SynapseCommonActionsOpener * self;
#line 148 "../lib/synapse-core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
#line 186 "../lib/synapse-core/common-actions.vala"
	_g_regex_unref0 (self->priv->web_uri);
#line 187 "../lib/synapse-core/common-actions.vala"
	_g_regex_unref0 (self->priv->file_path);
#line 148 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (synapse_common_actions_opener_parent_class)->finalize (obj);
#line 3027 "common-actions.c"
}

static GType
synapse_common_actions_opener_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_opener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpener), 0, (GInstanceInitFunc) synapse_common_actions_opener_instance_init, NULL };
	GType synapse_common_actions_opener_type_id;
	synapse_common_actions_opener_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsOpener", &g_define_type_info, 0);
	SynapseCommonActionsOpener_private_offset = g_type_add_instance_private (synapse_common_actions_opener_type_id, sizeof (SynapseCommonActionsOpenerPrivate));
	return synapse_common_actions_opener_type_id;
}

static GType
synapse_common_actions_opener_get_type (void)
{
	static volatile gsize synapse_common_actions_opener_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_opener_type_id__volatile)) {
		GType synapse_common_actions_opener_type_id;
		synapse_common_actions_opener_type_id = synapse_common_actions_opener_get_type_once ();
		g_once_init_leave (&synapse_common_actions_opener_type_id__volatile, synapse_common_actions_opener_type_id);
	}
	return synapse_common_actions_opener_type_id__volatile;
}

static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_construct (GType object_type)
{
	SynapseCommonActionsOpenFolder * self = NULL;
#line 201 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) g_object_new (object_type, "title", _ ("Open folder"), "description", _ ("Open folder containing this file"), "icon-name", "folder-open", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
#line 200 "../lib/synapse-core/common-actions.vala"
	return self;
#line 3060 "common-actions.c"
}

static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_new (void)
{
#line 200 "../lib/synapse-core/common-actions.vala"
	return synapse_common_actions_open_folder_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER);
#line 3068 "common-actions.c"
}

static void
synapse_common_actions_open_folder_real_do_execute (SynapseBaseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GError* _inner_error0_ = NULL;
#line 208 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) base;
#line 209 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = _g_object_ref0 (SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL);
#line 209 "../lib/synapse-core/common-actions.vala"
	uri_match = _tmp0_;
#line 210 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = uri_match;
#line 210 "../lib/synapse-core/common-actions.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 211 "../lib/synapse-core/common-actions.vala"
	_tmp2_ = uri_match;
#line 211 "../lib/synapse-core/common-actions.vala"
	_tmp3_ = synapse_uri_match_get_uri (_tmp2_);
#line 211 "../lib/synapse-core/common-actions.vala"
	_tmp4_ = _tmp3_;
#line 211 "../lib/synapse-core/common-actions.vala"
	_tmp5_ = g_file_new_for_uri (_tmp4_);
#line 211 "../lib/synapse-core/common-actions.vala"
	f = _tmp5_;
#line 212 "../lib/synapse-core/common-actions.vala"
	_tmp6_ = f;
#line 212 "../lib/synapse-core/common-actions.vala"
	_tmp7_ = g_file_get_parent (_tmp6_);
#line 212 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (f);
#line 212 "../lib/synapse-core/common-actions.vala"
	f = _tmp7_;
#line 3116 "common-actions.c"
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp8_;
		GAppInfo* _tmp9_;
		GList* files = NULL;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp12_;
		GdkDisplay* _tmp13_;
		GAppInfo* _tmp14_;
		GList* _tmp15_;
		GdkDisplay* _tmp16_;
		GdkAppLaunchContext* _tmp17_;
		GdkAppLaunchContext* _tmp18_;
#line 214 "../lib/synapse-core/common-actions.vala"
		_tmp8_ = f;
#line 214 "../lib/synapse-core/common-actions.vala"
		_tmp9_ = g_file_query_default_handler (_tmp8_, NULL, &_inner_error0_);
#line 214 "../lib/synapse-core/common-actions.vala"
		app_info = _tmp9_;
#line 214 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3140 "common-actions.c"
			goto __catch0_g_error;
		}
#line 215 "../lib/synapse-core/common-actions.vala"
		files = NULL;
#line 216 "../lib/synapse-core/common-actions.vala"
		_tmp10_ = f;
#line 216 "../lib/synapse-core/common-actions.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 216 "../lib/synapse-core/common-actions.vala"
		files = g_list_prepend (files, _tmp11_);
#line 217 "../lib/synapse-core/common-actions.vala"
		_tmp12_ = gdk_display_get_default ();
#line 217 "../lib/synapse-core/common-actions.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 217 "../lib/synapse-core/common-actions.vala"
		display = _tmp13_;
#line 218 "../lib/synapse-core/common-actions.vala"
		_tmp14_ = app_info;
#line 218 "../lib/synapse-core/common-actions.vala"
		_tmp15_ = files;
#line 218 "../lib/synapse-core/common-actions.vala"
		_tmp16_ = display;
#line 218 "../lib/synapse-core/common-actions.vala"
		_tmp17_ = gdk_display_get_app_launch_context (_tmp16_);
#line 218 "../lib/synapse-core/common-actions.vala"
		_tmp18_ = _tmp17_;
#line 218 "../lib/synapse-core/common-actions.vala"
		g_app_info_launch (_tmp14_, _tmp15_, (GAppLaunchContext*) _tmp18_, &_inner_error0_);
#line 218 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (_tmp18_);
#line 218 "../lib/synapse-core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 218 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (display);
#line 218 "../lib/synapse-core/common-actions.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 218 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (app_info);
#line 3179 "common-actions.c"
			goto __catch0_g_error;
		}
#line 213 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (display);
#line 213 "../lib/synapse-core/common-actions.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 213 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (app_info);
#line 3188 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
#line 213 "../lib/synapse-core/common-actions.vala"
		err = _inner_error0_;
#line 213 "../lib/synapse-core/common-actions.vala"
		_inner_error0_ = NULL;
#line 220 "../lib/synapse-core/common-actions.vala"
		_tmp19_ = err;
#line 220 "../lib/synapse-core/common-actions.vala"
		_tmp20_ = _tmp19_->message;
#line 220 "../lib/synapse-core/common-actions.vala"
		synapse_utils_logger_warning ((GObject*) self, "%s", _tmp20_, NULL);
#line 213 "../lib/synapse-core/common-actions.vala"
		_g_error_free0 (err);
#line 3208 "common-actions.c"
	}
	__finally0:
#line 213 "../lib/synapse-core/common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 213 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (f);
#line 213 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (uri_match);
#line 213 "../lib/synapse-core/common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 213 "../lib/synapse-core/common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 213 "../lib/synapse-core/common-actions.vala"
		return;
#line 3223 "common-actions.c"
	}
#line 208 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (f);
#line 208 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (uri_match);
#line 3229 "common-actions.c"
}

static gboolean
synapse_common_actions_open_folder_real_valid_for_match (SynapseBaseAction* base,
                                                         SynapseMatch* match)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp2_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* parent = NULL;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GFile* _tmp10_;
	gboolean result = FALSE;
#line 224 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) base;
#line 224 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 225 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 225 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 225 "../lib/synapse-core/common-actions.vala"
	if (_tmp1_ != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
#line 226 "../lib/synapse-core/common-actions.vala"
		result = FALSE;
#line 226 "../lib/synapse-core/common-actions.vala"
		return result;
#line 3266 "common-actions.c"
	}
#line 228 "../lib/synapse-core/common-actions.vala"
	_tmp2_ = _g_object_ref0 (SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL);
#line 228 "../lib/synapse-core/common-actions.vala"
	uri_match = _tmp2_;
#line 229 "../lib/synapse-core/common-actions.vala"
	_tmp3_ = uri_match;
#line 229 "../lib/synapse-core/common-actions.vala"
	_tmp4_ = synapse_uri_match_get_uri (_tmp3_);
#line 229 "../lib/synapse-core/common-actions.vala"
	_tmp5_ = _tmp4_;
#line 229 "../lib/synapse-core/common-actions.vala"
	_tmp6_ = g_file_new_for_uri (_tmp5_);
#line 229 "../lib/synapse-core/common-actions.vala"
	f = _tmp6_;
#line 230 "../lib/synapse-core/common-actions.vala"
	_tmp7_ = f;
#line 230 "../lib/synapse-core/common-actions.vala"
	_tmp8_ = g_file_get_parent (_tmp7_);
#line 230 "../lib/synapse-core/common-actions.vala"
	parent = _tmp8_;
#line 232 "../lib/synapse-core/common-actions.vala"
	_tmp10_ = parent;
#line 232 "../lib/synapse-core/common-actions.vala"
	if (_tmp10_ != NULL) {
#line 3292 "common-actions.c"
		GFile* _tmp11_;
#line 232 "../lib/synapse-core/common-actions.vala"
		_tmp11_ = f;
#line 232 "../lib/synapse-core/common-actions.vala"
		_tmp9_ = g_file_is_native (_tmp11_);
#line 3298 "common-actions.c"
	} else {
#line 232 "../lib/synapse-core/common-actions.vala"
		_tmp9_ = FALSE;
#line 3302 "common-actions.c"
	}
#line 232 "../lib/synapse-core/common-actions.vala"
	result = _tmp9_;
#line 232 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (parent);
#line 232 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (f);
#line 232 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (uri_match);
#line 232 "../lib/synapse-core/common-actions.vala"
	return result;
#line 3314 "common-actions.c"
}

static void
synapse_common_actions_open_folder_class_init (SynapseCommonActionsOpenFolderClass * klass,
                                               gpointer klass_data)
{
#line 199 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_open_folder_parent_class = g_type_class_peek_parent (klass);
#line 199 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_open_folder_real_do_execute;
#line 199 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_open_folder_real_valid_for_match;
#line 3327 "common-actions.c"
}

static void
synapse_common_actions_open_folder_instance_init (SynapseCommonActionsOpenFolder * self,
                                                  gpointer klass)
{
}

static GType
synapse_common_actions_open_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_open_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpenFolder), 0, (GInstanceInitFunc) synapse_common_actions_open_folder_instance_init, NULL };
	GType synapse_common_actions_open_folder_type_id;
	synapse_common_actions_open_folder_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsOpenFolder", &g_define_type_info, 0);
	return synapse_common_actions_open_folder_type_id;
}

static GType
synapse_common_actions_open_folder_get_type (void)
{
	static volatile gsize synapse_common_actions_open_folder_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_open_folder_type_id__volatile)) {
		GType synapse_common_actions_open_folder_type_id;
		synapse_common_actions_open_folder_type_id = synapse_common_actions_open_folder_get_type_once ();
		g_once_init_leave (&synapse_common_actions_open_folder_type_id__volatile, synapse_common_actions_open_folder_type_id);
	}
	return synapse_common_actions_open_folder_type_id__volatile;
}

static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_construct (GType object_type)
{
	SynapseCommonActionsClipboardCopy * self = NULL;
#line 238 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) g_object_new (object_type, "title", _ ("Copy to Clipboard"), "description", _ ("Copy selection to clipboard"), "icon-name", "gtk-copy", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
#line 237 "../lib/synapse-core/common-actions.vala"
	return self;
#line 3365 "common-actions.c"
}

static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_new (void)
{
#line 237 "../lib/synapse-core/common-actions.vala"
	return synapse_common_actions_clipboard_copy_construct (SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY);
#line 3373 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_real_do_execute (SynapseBaseAction* base,
                                                       SynapseMatch* match,
                                                       SynapseMatch* target)
{
	SynapseCommonActionsClipboardCopy * self;
	GtkClipboard* cb = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	SynapseMatchType _tmp2_;
	SynapseMatchType _tmp3_;
#line 245 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 246 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = gtk_clipboard_get (GDK_NONE);
#line 246 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 246 "../lib/synapse-core/common-actions.vala"
	cb = _tmp1_;
#line 247 "../lib/synapse-core/common-actions.vala"
	_tmp2_ = synapse_match_get_match_type (match);
#line 247 "../lib/synapse-core/common-actions.vala"
	_tmp3_ = _tmp2_;
#line 247 "../lib/synapse-core/common-actions.vala"
	if (_tmp3_ == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
#line 3401 "common-actions.c"
		SynapseUriMatch* uri_match = NULL;
		SynapseUriMatch* _tmp4_;
		SynapseUriMatch* _tmp5_;
		GtkClipboard* _tmp6_;
		SynapseUriMatch* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 248 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = _g_object_ref0 (SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL);
#line 248 "../lib/synapse-core/common-actions.vala"
		uri_match = _tmp4_;
#line 249 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = uri_match;
#line 249 "../lib/synapse-core/common-actions.vala"
		g_return_if_fail (_tmp5_ != NULL);
#line 259 "../lib/synapse-core/common-actions.vala"
		_tmp6_ = cb;
#line 259 "../lib/synapse-core/common-actions.vala"
		_tmp7_ = uri_match;
#line 259 "../lib/synapse-core/common-actions.vala"
		_tmp8_ = synapse_uri_match_get_uri (_tmp7_);
#line 259 "../lib/synapse-core/common-actions.vala"
		_tmp9_ = _tmp8_;
#line 259 "../lib/synapse-core/common-actions.vala"
		gtk_clipboard_set_text (_tmp6_, _tmp9_, -1);
#line 247 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (uri_match);
#line 3429 "common-actions.c"
	} else {
		SynapseMatchType _tmp10_;
		SynapseMatchType _tmp11_;
#line 260 "../lib/synapse-core/common-actions.vala"
		_tmp10_ = synapse_match_get_match_type (match);
#line 260 "../lib/synapse-core/common-actions.vala"
		_tmp11_ = _tmp10_;
#line 260 "../lib/synapse-core/common-actions.vala"
		if (_tmp11_ == SYNAPSE_MATCH_TYPE_TEXT) {
#line 3439 "common-actions.c"
			SynapseTextMatch* text_match = NULL;
			SynapseTextMatch* _tmp12_;
			gchar* _tmp13_ = NULL;
			SynapseTextMatch* _tmp14_;
			gchar* content = NULL;
			gchar* _tmp20_;
			GtkClipboard* _tmp21_;
			const gchar* _tmp22_;
#line 261 "../lib/synapse-core/common-actions.vala"
			_tmp12_ = _g_object_ref0 (SYNAPSE_IS_TEXT_MATCH (match) ? ((SynapseTextMatch*) match) : NULL);
#line 261 "../lib/synapse-core/common-actions.vala"
			text_match = _tmp12_;
#line 262 "../lib/synapse-core/common-actions.vala"
			_tmp14_ = text_match;
#line 262 "../lib/synapse-core/common-actions.vala"
			if (_tmp14_ != NULL) {
#line 3456 "common-actions.c"
				SynapseTextMatch* _tmp15_;
				gchar* _tmp16_;
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp15_ = text_match;
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp16_ = synapse_text_match_get_text (_tmp15_);
#line 262 "../lib/synapse-core/common-actions.vala"
				_g_free0 (_tmp13_);
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp13_ = _tmp16_;
#line 3467 "common-actions.c"
			} else {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp17_ = synapse_match_get_title (match);
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp18_ = _tmp17_;
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp19_ = g_strdup (_tmp18_);
#line 262 "../lib/synapse-core/common-actions.vala"
				_g_free0 (_tmp13_);
#line 262 "../lib/synapse-core/common-actions.vala"
				_tmp13_ = _tmp19_;
#line 3482 "common-actions.c"
			}
#line 262 "../lib/synapse-core/common-actions.vala"
			_tmp20_ = g_strdup (_tmp13_);
#line 262 "../lib/synapse-core/common-actions.vala"
			content = _tmp20_;
#line 264 "../lib/synapse-core/common-actions.vala"
			_tmp21_ = cb;
#line 264 "../lib/synapse-core/common-actions.vala"
			_tmp22_ = content;
#line 264 "../lib/synapse-core/common-actions.vala"
			gtk_clipboard_set_text (_tmp21_, _tmp22_, -1);
#line 260 "../lib/synapse-core/common-actions.vala"
			_g_free0 (content);
#line 260 "../lib/synapse-core/common-actions.vala"
			_g_free0 (_tmp13_);
#line 260 "../lib/synapse-core/common-actions.vala"
			_g_object_unref0 (text_match);
#line 3500 "common-actions.c"
		}
	}
#line 245 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (cb);
#line 3505 "common-actions.c"
}

static gboolean
synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseBaseAction* base,
                                                            SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	gboolean result = FALSE;
#line 268 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 268 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 269 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 269 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = _tmp0_;
#line 269 "../lib/synapse-core/common-actions.vala"
	switch (_tmp1_) {
#line 269 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
#line 3528 "common-actions.c"
		{
#line 271 "../lib/synapse-core/common-actions.vala"
			result = TRUE;
#line 271 "../lib/synapse-core/common-actions.vala"
			return result;
#line 3534 "common-actions.c"
		}
#line 269 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_MATCH_TYPE_TEXT:
#line 3538 "common-actions.c"
		{
#line 273 "../lib/synapse-core/common-actions.vala"
			result = TRUE;
#line 273 "../lib/synapse-core/common-actions.vala"
			return result;
#line 3544 "common-actions.c"
		}
		default:
		{
#line 275 "../lib/synapse-core/common-actions.vala"
			result = FALSE;
#line 275 "../lib/synapse-core/common-actions.vala"
			return result;
#line 3552 "common-actions.c"
		}
	}
}

static gint
synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseBaseAction* base,
                                                                    SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	SynapseTextMatch* text_match = NULL;
	SynapseTextMatch* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SynapseTextMatch* _tmp2_;
	gint _tmp6_;
	gint _tmp7_;
	gint result = 0;
#line 279 "../lib/synapse-core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 279 "../lib/synapse-core/common-actions.vala"
	g_return_val_if_fail (match != NULL, 0);
#line 280 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = _g_object_ref0 (SYNAPSE_IS_TEXT_MATCH (match) ? ((SynapseTextMatch*) match) : NULL);
#line 280 "../lib/synapse-core/common-actions.vala"
	text_match = _tmp0_;
#line 281 "../lib/synapse-core/common-actions.vala"
	_tmp2_ = text_match;
#line 281 "../lib/synapse-core/common-actions.vala"
	if (_tmp2_ != NULL) {
#line 3581 "common-actions.c"
		SynapseTextMatch* _tmp3_;
		SynapseTextOrigin _tmp4_;
		SynapseTextOrigin _tmp5_;
#line 281 "../lib/synapse-core/common-actions.vala"
		_tmp3_ = text_match;
#line 281 "../lib/synapse-core/common-actions.vala"
		_tmp4_ = synapse_text_match_get_text_origin (_tmp3_);
#line 281 "../lib/synapse-core/common-actions.vala"
		_tmp5_ = _tmp4_;
#line 281 "../lib/synapse-core/common-actions.vala"
		_tmp1_ = _tmp5_ == SYNAPSE_TEXT_ORIGIN_CLIPBOARD;
#line 3593 "common-actions.c"
	} else {
#line 281 "../lib/synapse-core/common-actions.vala"
		_tmp1_ = FALSE;
#line 3597 "common-actions.c"
	}
#line 281 "../lib/synapse-core/common-actions.vala"
	if (_tmp1_) {
#line 282 "../lib/synapse-core/common-actions.vala"
		result = 0;
#line 282 "../lib/synapse-core/common-actions.vala"
		_g_object_unref0 (text_match);
#line 282 "../lib/synapse-core/common-actions.vala"
		return result;
#line 3607 "common-actions.c"
	}
#line 285 "../lib/synapse-core/common-actions.vala"
	_tmp6_ = synapse_base_action_get_default_relevancy ((SynapseBaseAction*) self);
#line 285 "../lib/synapse-core/common-actions.vala"
	_tmp7_ = _tmp6_;
#line 285 "../lib/synapse-core/common-actions.vala"
	result = _tmp7_;
#line 285 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (text_match);
#line 285 "../lib/synapse-core/common-actions.vala"
	return result;
#line 3619 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_class_init (SynapseCommonActionsClipboardCopyClass * klass,
                                                  gpointer klass_data)
{
#line 236 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_clipboard_copy_parent_class = g_type_class_peek_parent (klass);
#line 236 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_do_execute;
#line 236 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_valid_for_match;
#line 236 "../lib/synapse-core/common-actions.vala"
	((SynapseBaseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_get_relevancy_for_match;
#line 3634 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_instance_init (SynapseCommonActionsClipboardCopy * self,
                                                     gpointer klass)
{
}

static GType
synapse_common_actions_clipboard_copy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClipboardCopyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_clipboard_copy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsClipboardCopy), 0, (GInstanceInitFunc) synapse_common_actions_clipboard_copy_instance_init, NULL };
	GType synapse_common_actions_clipboard_copy_type_id;
	synapse_common_actions_clipboard_copy_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsClipboardCopy", &g_define_type_info, 0);
	return synapse_common_actions_clipboard_copy_type_id;
}

static GType
synapse_common_actions_clipboard_copy_get_type (void)
{
	static volatile gsize synapse_common_actions_clipboard_copy_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_clipboard_copy_type_id__volatile)) {
		GType synapse_common_actions_clipboard_copy_type_id;
		synapse_common_actions_clipboard_copy_type_id = synapse_common_actions_clipboard_copy_get_type_once ();
		g_once_init_leave (&synapse_common_actions_clipboard_copy_type_id__volatile, synapse_common_actions_clipboard_copy_type_id);
	}
	return synapse_common_actions_clipboard_copy_type_id__volatile;
}

static GObject *
synapse_common_actions_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	SynapseCommonActionsRunner* _tmp2_;
	SynapseCommonActionsRunner* _tmp3_;
	GeeList* _tmp4_;
	SynapseCommonActionsTerminalRunner* _tmp5_;
	SynapseCommonActionsTerminalRunner* _tmp6_;
	GeeList* _tmp7_;
	SynapseCommonActionsOpener* _tmp8_;
	SynapseCommonActionsOpener* _tmp9_;
	GeeList* _tmp10_;
	SynapseCommonActionsOpenFolder* _tmp11_;
	SynapseCommonActionsOpenFolder* _tmp12_;
	GeeList* _tmp13_;
	SynapseCommonActionsClipboardCopy* _tmp14_;
	SynapseCommonActionsClipboardCopy* _tmp15_;
#line 291 "../lib/synapse-core/common-actions.vala"
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
#line 291 "../lib/synapse-core/common-actions.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 291 "../lib/synapse-core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 292 "../lib/synapse-core/common-actions.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_BASE_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 292 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (self->priv->actions);
#line 292 "../lib/synapse-core/common-actions.vala"
	self->priv->actions = (GeeList*) _tmp0_;
#line 294 "../lib/synapse-core/common-actions.vala"
	_tmp1_ = self->priv->actions;
#line 294 "../lib/synapse-core/common-actions.vala"
	_tmp2_ = synapse_common_actions_runner_new ();
#line 294 "../lib/synapse-core/common-actions.vala"
	_tmp3_ = _tmp2_;
#line 294 "../lib/synapse-core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp1_, (SynapseBaseAction*) _tmp3_);
#line 294 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (_tmp3_);
#line 295 "../lib/synapse-core/common-actions.vala"
	_tmp4_ = self->priv->actions;
#line 295 "../lib/synapse-core/common-actions.vala"
	_tmp5_ = synapse_common_actions_terminal_runner_new ();
#line 295 "../lib/synapse-core/common-actions.vala"
	_tmp6_ = _tmp5_;
#line 295 "../lib/synapse-core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp4_, (SynapseBaseAction*) _tmp6_);
#line 295 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (_tmp6_);
#line 296 "../lib/synapse-core/common-actions.vala"
	_tmp7_ = self->priv->actions;
#line 296 "../lib/synapse-core/common-actions.vala"
	_tmp8_ = synapse_common_actions_opener_new ();
#line 296 "../lib/synapse-core/common-actions.vala"
	_tmp9_ = _tmp8_;
#line 296 "../lib/synapse-core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp7_, (SynapseBaseAction*) _tmp9_);
#line 296 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (_tmp9_);
#line 297 "../lib/synapse-core/common-actions.vala"
	_tmp10_ = self->priv->actions;
#line 297 "../lib/synapse-core/common-actions.vala"
	_tmp11_ = synapse_common_actions_open_folder_new ();
#line 297 "../lib/synapse-core/common-actions.vala"
	_tmp12_ = _tmp11_;
#line 297 "../lib/synapse-core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp10_, (SynapseBaseAction*) _tmp12_);
#line 297 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (_tmp12_);
#line 298 "../lib/synapse-core/common-actions.vala"
	_tmp13_ = self->priv->actions;
#line 298 "../lib/synapse-core/common-actions.vala"
	_tmp14_ = synapse_common_actions_clipboard_copy_new ();
#line 298 "../lib/synapse-core/common-actions.vala"
	_tmp15_ = _tmp14_;
#line 298 "../lib/synapse-core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp13_, (SynapseBaseAction*) _tmp15_);
#line 298 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (_tmp15_);
#line 291 "../lib/synapse-core/common-actions.vala"
	return obj;
#line 3752 "common-actions.c"
}

static void
synapse_common_actions_class_init (SynapseCommonActionsClass * klass,
                                   gpointer klass_data)
{
#line 56 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
#line 56 "../lib/synapse-core/common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommonActions_private_offset);
#line 56 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_common_actions_get_property;
#line 56 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_common_actions_set_property;
#line 56 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
#line 56 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
#line 56 "../lib/synapse-core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3773 "common-actions.c"
}

static void
synapse_common_actions_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 56 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 56 "../lib/synapse-core/common-actions.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_activate;
#line 56 "../lib/synapse-core/common-actions.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_deactivate;
#line 56 "../lib/synapse-core/common-actions.vala"
	iface->get_enabled = synapse_common_actions_real_get_enabled;
#line 56 "../lib/synapse-core/common-actions.vala"
	iface->set_enabled = synapse_common_actions_real_set_enabled;
#line 3790 "common-actions.c"
}

static void
synapse_common_actions_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                               gpointer iface_data)
{
#line 56 "../lib/synapse-core/common-actions.vala"
	synapse_common_actions_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 56 "../lib/synapse-core/common-actions.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_common_actions_real_find_for_match;
#line 3801 "common-actions.c"
}

static void
synapse_common_actions_instance_init (SynapseCommonActions * self,
                                      gpointer klass)
{
#line 56 "../lib/synapse-core/common-actions.vala"
	self->priv = synapse_common_actions_get_instance_private (self);
#line 57 "../lib/synapse-core/common-actions.vala"
	self->priv->_enabled = TRUE;
#line 3812 "common-actions.c"
}

static void
synapse_common_actions_finalize (GObject * obj)
{
	SynapseCommonActions * self;
#line 56 "../lib/synapse-core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 289 "../lib/synapse-core/common-actions.vala"
	_g_object_unref0 (self->priv->actions);
#line 56 "../lib/synapse-core/common-actions.vala"
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
#line 3825 "common-actions.c"
}

static GType
synapse_common_actions_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_common_actions_type_id;
	synapse_common_actions_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommonActions", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseCommonActions_private_offset = g_type_add_instance_private (synapse_common_actions_type_id, sizeof (SynapseCommonActionsPrivate));
	return synapse_common_actions_type_id;
}

GType
synapse_common_actions_get_type (void)
{
	static volatile gsize synapse_common_actions_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_type_id__volatile)) {
		GType synapse_common_actions_type_id;
		synapse_common_actions_type_id = synapse_common_actions_get_type_once ();
		g_once_init_leave (&synapse_common_actions_type_id__volatile, synapse_common_actions_type_id);
	}
	return synapse_common_actions_type_id__volatile;
}

static void
_vala_synapse_common_actions_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 56 "../lib/synapse-core/common-actions.vala"
	switch (property_id) {
#line 56 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
#line 56 "../lib/synapse-core/common-actions.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 56 "../lib/synapse-core/common-actions.vala"
		break;
#line 3870 "common-actions.c"
		default:
#line 56 "../lib/synapse-core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 56 "../lib/synapse-core/common-actions.vala"
		break;
#line 3876 "common-actions.c"
	}
}

static void
_vala_synapse_common_actions_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 56 "../lib/synapse-core/common-actions.vala"
	switch (property_id) {
#line 56 "../lib/synapse-core/common-actions.vala"
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
#line 56 "../lib/synapse-core/common-actions.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 56 "../lib/synapse-core/common-actions.vala"
		break;
#line 3896 "common-actions.c"
		default:
#line 56 "../lib/synapse-core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 56 "../lib/synapse-core/common-actions.vala"
		break;
#line 3902 "common-actions.c"
	}
}

