/* desktop-file-service.c generated by valac 0.48.13, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gee.h>

#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;
typedef enum  {
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE = 1 << 3,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR = 1 << 4,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX = 1 << 5,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE = 1 << 6,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY = 1 << 7,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE = 1 << 8,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON = 1 << 9,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD = 1 << 10,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL = 0x3FF
} SynapseDesktopFileInfoEnvironmentType;

#define SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE (synapse_desktop_file_info_environment_type_get_type ())
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_service_properties[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
typedef struct _SynapseDesktopFileServiceProcessDirectoryData SynapseDesktopFileServiceProcessDirectoryData;
typedef struct _SynapseDesktopFileServiceLoadAllDesktopFilesData SynapseDesktopFileServiceLoadAllDesktopFilesData;
typedef struct _SynapseDesktopFileServiceReloadDesktopFilesData SynapseDesktopFileServiceReloadDesktopFilesData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadDesktopFileData SynapseDesktopFileServiceLoadDesktopFileData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData SynapseDesktopFileServiceLoadMimeParentsFromFileData;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS
};
static guint synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS] = {0};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()
struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	gchar** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileInfoPrivate {
	gchar* _desktop_id;
	gchar* _name;
	gchar* _generic_name;
	gchar* _comment;
	gchar* _icon_name;
	gchar* _gettext_domain;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	gchar* name_folded;
	SynapseDesktopFileInfoEnvironmentType _show_in;
};

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileServicePrivate {
	SynapseUtilsAsyncOnce* init_once;
	GeeList* directory_monitors;
	GeeList* all_desktop_files;
	GeeList* non_hidden_desktop_files;
	GeeMap* mimetype_map;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	GeeMultiMap* mimetype_parent_map;
	SynapseDesktopFileInfoEnvironmentType session_type;
	gchar* session_type_str;
	guint timer_id;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	const gchar* _tmp2_;
	SynapseUtilsAsyncOnce* _tmp3_;
};

struct _SynapseDesktopFileServiceProcessDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GFile* directory;
	gchar* id_prefix;
	GeeSet* monitored_dirs;
	gchar* path;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean exists;
	GeeIterator* _scanned_dir_it;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GFile* scanned_dir;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp17_;
	GList* files;
	GFileEnumerator* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	GList* f_collection;
	GList* f_it;
	GFileInfo* _tmp21_;
	GFileInfo* f;
	const gchar* name;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	GFileInfo* _tmp24_;
	GFile* subdir;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	gchar* new_prefix;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GError* err;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	gchar** data_dirs;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** dir_collection;
	gint dir_collection_length1;
	gint _dir_collection_size_;
	gint dir_it;
	const gchar* dir;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GeeSet* desktop_file_dirs;
	GeeHashSet* _tmp7_;
	GeeMultiMap* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** data_dir_collection;
	gint data_dir_collection_length1;
	gint _data_dir_collection_size_;
	gint data_dir_it;
	const gchar* data_dir;
	gchar* dir_path;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* directory;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GeeSet* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeIterator* _d_it;
	GeeSet* _tmp20_;
	GeeIterator* _tmp21_;
	GeeIterator* _tmp22_;
	GFile* d;
	GeeIterator* _tmp23_;
	gpointer _tmp24_;
	GFileMonitor* monitor;
	GFile* _tmp25_;
	GFileMonitor* _tmp26_;
	GFileMonitor* _tmp27_;
	GeeList* _tmp28_;
	GFileMonitor* _tmp29_;
	GError* err;
	GError* _tmp30_;
	const gchar* _tmp31_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceReloadDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
};

struct _SynapseDesktopFileServiceLoadDesktopFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GFile* file;
	gchar* id_prefix;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	gboolean success;
	guint8* _tmp0_;
	gsize _tmp1_;
	gboolean _tmp2_;
	GKeyFile* keyfile;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* desktop_id;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	SynapseDesktopFileInfo* dfi;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GKeyFile* _tmp14_;
	const gchar* _tmp15_;
	SynapseDesktopFileInfo* _tmp16_;
	SynapseDesktopFileInfo* _tmp17_;
	SynapseDesktopFileInfo* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GeeList* _tmp21_;
	SynapseDesktopFileInfo* _tmp22_;
	gboolean _tmp23_;
	SynapseDesktopFileInfo* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	SynapseDesktopFileInfoEnvironmentType _tmp27_;
	SynapseDesktopFileInfo* _tmp28_;
	SynapseDesktopFileInfoEnvironmentType _tmp29_;
	SynapseDesktopFileInfoEnvironmentType _tmp30_;
	GeeList* _tmp31_;
	SynapseDesktopFileInfo* _tmp32_;
	GError* err;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	gchar* fi;
	GFile* file;
	GFile* _tmp0_;
	gboolean exists;
	GFile* _tmp1_;
	GFileInputStream* fis;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis;
	GFileInputStream* _tmp4_;
	GDataInputStream* _tmp5_;
	gchar* line;
	gchar** mimes;
	gint mimes_length1;
	gint _mimes_size_;
	gint len;
	gchar* _tmp6_;
	GDataInputStream* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	GeeMultiMap* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	GError* _inner_error0_;
};

static gint SynapseDesktopFileInfo_private_offset;
static gpointer synapse_desktop_file_info_parent_class = NULL;
static gint SynapseDesktopFileService_private_offset;
static gpointer synapse_desktop_file_service_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;

GQuark synapse_desktop_file_error_quark (void);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileInfo, g_object_unref)
GType synapse_desktop_file_info_environment_type_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DESKTOP_FILE_INFO_GROUP "Desktop Entry"
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                                                   GKeyFile* keyfile,
                                                                   const gchar* desktop_id);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                                         const gchar* path,
                                                                         GKeyFile* keyfile,
                                                                         const gchar* desktop_id);
static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                                  GKeyFile* keyfile);
static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self,
                                                                                    gchar** environments,
                                                                                    gint environments_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gint stack_length,
                                      const gchar* needle);
void synapse_desktop_file_info_set_gettext_domain (SynapseDesktopFileInfo* self,
                                                   const gchar* value);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                         const gchar* value);
void synapse_desktop_file_info_set_generic_name (SynapseDesktopFileInfo* self,
                                                 const gchar* value);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                         const gchar* value);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                              gboolean value);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                            const gchar* value);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                              const gchar* value);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                                   gboolean value);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                            SynapseDesktopFileInfoEnvironmentType value);
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_utils_logger_warning (GObject* obj,
                                   const gchar* format,
                                   ...);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                             gboolean value);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const gchar* synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                               const gchar* value);
const gchar* synapse_desktop_file_info_get_generic_name (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_gettext_domain (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                             const gchar* value);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_finalize (GObject * obj);
static GType synapse_desktop_file_info_get_type_once (void);
static void _vala_synapse_desktop_file_info_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_desktop_file_info_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileService, g_object_unref)
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsAsyncOnce, synapse_utils_async_once_unref)
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                     GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self);
static gboolean _synapse_desktop_file_service_initialize_co_gsource_func (gpointer self);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self);
static gboolean synapse_desktop_file_service_get_list_has_desktop_id (SynapseDesktopFileService* self,
                                                               const gchar* desktop_id);
static void synapse_desktop_file_service_process_directory_data_free (gpointer _data);
static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                     GFile* directory,
                                                     const gchar* id_prefix,
                                                     GeeSet* monitored_dirs,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
void synapse_utils_query_exists_async (GFile* f,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static void synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                     GFile* file,
                                                     const gchar* id_prefix,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                               const gchar* fi,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                      GAsyncResult* _res_);
static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                          GFile* file,
                                                                                          GFile* other_file,
                                                                                          GFileMonitorEvent event_type,
                                                                                          gpointer self);
static gboolean __lambda7_ (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                               GAsyncResult* _res_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_);
static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_);
static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                                    const gchar* mime,
                                                    GeeSet* ret);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                                  const gchar* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                                  const gchar* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                                              const gchar* desktop_id);
static GObject * synapse_desktop_file_service_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
static void synapse_desktop_file_service_finalize (GObject * obj);
static GType synapse_desktop_file_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* SYNAPSE_DESKTOP_FILE_INFO_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

GQuark
synapse_desktop_file_error_quark (void)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	return g_quark_from_static_string ("synapse-desktop-file-error-quark");
#line 673 "desktop-file-service.c"
}

static inline gpointer
synapse_desktop_file_info_get_instance_private (SynapseDesktopFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileInfo_private_offset);
}

static GType
synapse_desktop_file_info_environment_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE", "mate"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR", "razor"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE", "tde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY", "unity"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON", "pantheon"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
	GType synapse_desktop_file_info_environment_type_type_id;
	synapse_desktop_file_info_environment_type_type_id = g_flags_register_static ("SynapseDesktopFileInfoEnvironmentType", values);
	return synapse_desktop_file_info_environment_type_type_id;
}

GType
synapse_desktop_file_info_environment_type_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_environment_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_environment_type_type_id__volatile)) {
		GType synapse_desktop_file_info_environment_type_type_id;
		synapse_desktop_file_info_environment_type_type_id = synapse_desktop_file_info_environment_type_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_info_environment_type_type_id__volatile, synapse_desktop_file_info_environment_type_type_id);
	}
	return synapse_desktop_file_info_environment_type_type_id__volatile;
}

const gchar*
synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	const gchar* result = NULL;
#line 66 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 67 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->name_folded;
#line 67 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 715 "desktop-file-service.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 68 "../lib/synapse-core/desktop-file-service.vala"
		_tmp1_ = self->priv->_name;
#line 68 "../lib/synapse-core/desktop-file-service.vala"
		_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
#line 68 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->name_folded);
#line 68 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->name_folded = _tmp2_;
#line 726 "desktop-file-service.c"
	}
#line 71 "../lib/synapse-core/desktop-file-service.vala"
	_tmp3_ = self->priv->name_folded;
#line 71 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp3_;
#line 71 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 734 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                 const gchar* path,
                                                 GKeyFile* keyfile,
                                                 const gchar* desktop_id)
{
	SynapseDesktopFileInfo * self = NULL;
#line 79 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 79 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (keyfile != NULL, NULL);
#line 79 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 80 "../lib/synapse-core/desktop-file-service.vala"
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "filename", path, "desktop-id", desktop_id, NULL);
#line 82 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_info_init_from_keyfile (self, keyfile);
#line 79 "../lib/synapse-core/desktop-file-service.vala"
	return self;
#line 756 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                           GKeyFile* keyfile,
                                           const gchar* desktop_id)
{
#line 79 "../lib/synapse-core/desktop-file-service.vala"
	return synapse_desktop_file_info_construct_for_keyfile (SYNAPSE_TYPE_DESKTOP_FILE_INFO, path, keyfile, desktop_id);
#line 766 "desktop-file-service.c"
}

static SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self,
                                              gchar** environments,
                                              gint environments_length1)
{
	SynapseDesktopFileInfoEnvironmentType _result_ = 0U;
	SynapseDesktopFileInfoEnvironmentType result = 0U;
#line 85 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 86 "../lib/synapse-core/desktop-file-service.vala"
	_result_ = 0;
#line 780 "desktop-file-service.c"
	{
		gchar** env_collection = NULL;
		gint env_collection_length1 = 0;
		gint _env_collection_size_ = 0;
		gint env_it = 0;
#line 87 "../lib/synapse-core/desktop-file-service.vala"
		env_collection = environments;
#line 87 "../lib/synapse-core/desktop-file-service.vala"
		env_collection_length1 = environments_length1;
#line 87 "../lib/synapse-core/desktop-file-service.vala"
		for (env_it = 0; env_it < env_collection_length1; env_it = env_it + 1) {
#line 792 "desktop-file-service.c"
			const gchar* env = NULL;
#line 87 "../lib/synapse-core/desktop-file-service.vala"
			env = env_collection[env_it];
#line 796 "desktop-file-service.c"
			{
				gchar* env_up = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label0 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label1 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label2 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label3 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label4 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label5 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label6 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label7 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label8 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label9 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label10 = 0;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				static GQuark _tmp4_label11 = 0;
#line 88 "../lib/synapse-core/desktop-file-service.vala"
				_tmp0_ = env;
#line 88 "../lib/synapse-core/desktop-file-service.vala"
				_tmp1_ = g_utf8_strup (_tmp0_, (gssize) -1);
#line 88 "../lib/synapse-core/desktop-file-service.vala"
				env_up = _tmp1_;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				_tmp2_ = env_up;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				_tmp3_ = _tmp2_;
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 89 "../lib/synapse-core/desktop-file-service.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("GNOME")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 844 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp6_;
#line 91 "../lib/synapse-core/desktop-file-service.vala"
							_tmp6_ = _result_;
#line 91 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp6_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
#line 92 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 854 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("PANTHEON")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 860 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp7_;
#line 94 "../lib/synapse-core/desktop-file-service.vala"
							_tmp7_ = _result_;
#line 94 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp7_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON;
#line 95 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 870 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("KDE")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 876 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp8_;
#line 97 "../lib/synapse-core/desktop-file-service.vala"
							_tmp8_ = _result_;
#line 97 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp8_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
#line 98 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 886 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("LXDE")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 892 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp9_;
#line 100 "../lib/synapse-core/desktop-file-service.vala"
							_tmp9_ = _result_;
#line 100 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp9_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
#line 101 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 902 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("MATE")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 908 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp10_;
#line 103 "../lib/synapse-core/desktop-file-service.vala"
							_tmp10_ = _result_;
#line 103 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp10_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE;
#line 104 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 918 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("RAZOR")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 924 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp11_;
#line 106 "../lib/synapse-core/desktop-file-service.vala"
							_tmp11_ = _result_;
#line 106 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp11_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR;
#line 107 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 934 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("ROX")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 940 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp12_;
#line 108 "../lib/synapse-core/desktop-file-service.vala"
							_tmp12_ = _result_;
#line 108 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp12_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
#line 108 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 950 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label7) ? _tmp4_label7 : (_tmp4_label7 = g_quark_from_static_string ("TDE")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 956 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp13_;
#line 109 "../lib/synapse-core/desktop-file-service.vala"
							_tmp13_ = _result_;
#line 109 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp13_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE;
#line 109 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 966 "desktop-file-service.c"
						}
					}
				} else if ((_tmp5_ == ((0 != _tmp4_label8) ? _tmp4_label8 : (_tmp4_label8 = g_quark_from_static_string ("UNITY")))) || (_tmp5_ == ((0 != _tmp4_label9) ? _tmp4_label9 : (_tmp4_label9 = g_quark_from_static_string ("UNITY7"))))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 972 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp14_;
#line 112 "../lib/synapse-core/desktop-file-service.vala"
							_tmp14_ = _result_;
#line 112 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp14_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY;
#line 113 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 982 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label10) ? _tmp4_label10 : (_tmp4_label10 = g_quark_from_static_string ("XFCE")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 988 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp15_;
#line 114 "../lib/synapse-core/desktop-file-service.vala"
							_tmp15_ = _result_;
#line 114 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp15_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
#line 114 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 998 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label11) ? _tmp4_label11 : (_tmp4_label11 = g_quark_from_static_string ("OLD")))) {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 1004 "desktop-file-service.c"
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp16_;
#line 115 "../lib/synapse-core/desktop-file-service.vala"
							_tmp16_ = _result_;
#line 115 "../lib/synapse-core/desktop-file-service.vala"
							_result_ = _tmp16_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD;
#line 115 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 1014 "desktop-file-service.c"
						}
					}
				} else {
#line 89 "../lib/synapse-core/desktop-file-service.vala"
					switch (0) {
#line 1020 "desktop-file-service.c"
						default:
						{
							const gchar* _tmp17_;
#line 116 "../lib/synapse-core/desktop-file-service.vala"
							_tmp17_ = env;
#line 116 "../lib/synapse-core/desktop-file-service.vala"
							g_warning ("desktop-file-service.vala:116: %s is not understood", _tmp17_);
#line 116 "../lib/synapse-core/desktop-file-service.vala"
							break;
#line 1030 "desktop-file-service.c"
						}
					}
				}
#line 87 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (env_up);
#line 1036 "desktop-file-service.c"
			}
		}
	}
#line 119 "../lib/synapse-core/desktop-file-service.vala"
	result = _result_;
#line 119 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1044 "desktop-file-service.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gint stack_length,
                             const gchar* needle)
{
	gint i;
#line 130 "../lib/synapse-core/desktop-file-service.vala"
	for (i = 0; i < stack_length; i++) {
#line 130 "../lib/synapse-core/desktop-file-service.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 130 "../lib/synapse-core/desktop-file-service.vala"
			return TRUE;
#line 1059 "desktop-file-service.c"
		}
	}
#line 130 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 1064 "desktop-file-service.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 165 "../lib/synapse-core/desktop-file-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 1072 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                             GKeyFile* keyfile)
{
	GError* _inner_error0_ = NULL;
#line 122 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 122 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (keyfile != NULL);
#line 1084 "desktop-file-service.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gboolean _tmp3_ = FALSE;
		GDesktopAppInfo* app_info = NULL;
		GDesktopAppInfo* _tmp13_;
		GDesktopAppInfo* _tmp14_;
		GDesktopAppInfo* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		GDesktopAppInfo* _tmp19_;
		const gchar* _tmp20_;
		GDesktopAppInfo* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		const gchar* _tmp35_ = NULL;
		GDesktopAppInfo* _tmp36_;
		const gchar* _tmp37_;
		GIcon* _tmp38_ = NULL;
		GDesktopAppInfo* _tmp39_;
		GIcon* _tmp40_;
		GIcon* _tmp41_;
		GIcon* icon = NULL;
		GIcon* _tmp43_;
		GIcon* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gboolean _tmp47_ = FALSE;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp63_ = FALSE;
		const gchar* _tmp64_;
#line 124 "../lib/synapse-core/desktop-file-service.vala"
		_tmp1_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Type", &_inner_error0_);
#line 124 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = _tmp1_;
#line 124 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1127 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 124 "../lib/synapse-core/desktop-file-service.vala"
		if (g_strcmp0 (_tmp0_, "Application") != 0) {
#line 1132 "desktop-file-service.c"
			GError* _tmp2_;
#line 125 "../lib/synapse-core/desktop-file-service.vala"
			_tmp2_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
#line 125 "../lib/synapse-core/desktop-file-service.vala"
			_inner_error0_ = _tmp2_;
#line 125 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1140 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 128 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_inner_error0_);
#line 128 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 128 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1149 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 128 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp3_) {
#line 1154 "desktop-file-service.c"
			gchar** categories = NULL;
			gsize _tmp4_ = 0;
			gchar** _tmp5_;
			gint categories_length1;
			gint _categories_size_;
			gchar** _tmp6_;
			gint _tmp6__length1;
#line 129 "../lib/synapse-core/desktop-file-service.vala"
			_tmp5_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_tmp4_, &_inner_error0_);
#line 129 "../lib/synapse-core/desktop-file-service.vala"
			categories = _tmp5_;
#line 129 "../lib/synapse-core/desktop-file-service.vala"
			categories_length1 = _tmp4_;
#line 129 "../lib/synapse-core/desktop-file-service.vala"
			_categories_size_ = categories_length1;
#line 129 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 129 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1174 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 130 "../lib/synapse-core/desktop-file-service.vala"
			_tmp6_ = categories;
#line 130 "../lib/synapse-core/desktop-file-service.vala"
			_tmp6__length1 = categories_length1;
#line 130 "../lib/synapse-core/desktop-file-service.vala"
			if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "Screensaver")) {
#line 1183 "desktop-file-service.c"
				GError* _tmp7_;
#line 131 "../lib/synapse-core/desktop-file-service.vala"
				_tmp7_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
#line 131 "../lib/synapse-core/desktop-file-service.vala"
				_inner_error0_ = _tmp7_;
#line 131 "../lib/synapse-core/desktop-file-service.vala"
				categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
#line 131 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1193 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 128 "../lib/synapse-core/desktop-file-service.vala"
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
#line 1198 "desktop-file-service.c"
		}
		{
			const gchar** domain_key_collection = NULL;
			gint domain_key_collection_length1 = 0;
			gint _domain_key_collection_size_ = 0;
			gint domain_key_it = 0;
#line 134 "../lib/synapse-core/desktop-file-service.vala"
			domain_key_collection = SYNAPSE_DESKTOP_FILE_INFO_SUPPORTED_GETTEXT_DOMAINS_KEYS;
#line 134 "../lib/synapse-core/desktop-file-service.vala"
			domain_key_collection_length1 = G_N_ELEMENTS (SYNAPSE_DESKTOP_FILE_INFO_SUPPORTED_GETTEXT_DOMAINS_KEYS);
#line 134 "../lib/synapse-core/desktop-file-service.vala"
			for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
#line 1211 "desktop-file-service.c"
				const gchar* domain_key = NULL;
#line 134 "../lib/synapse-core/desktop-file-service.vala"
				domain_key = domain_key_collection[domain_key_it];
#line 1215 "desktop-file-service.c"
				{
					gboolean _tmp8_ = FALSE;
					const gchar* _tmp9_;
#line 135 "../lib/synapse-core/desktop-file-service.vala"
					_tmp9_ = domain_key;
#line 135 "../lib/synapse-core/desktop-file-service.vala"
					_tmp8_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, _tmp9_, &_inner_error0_);
#line 135 "../lib/synapse-core/desktop-file-service.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 135 "../lib/synapse-core/desktop-file-service.vala"
						_g_free0 (_tmp0_);
#line 1227 "desktop-file-service.c"
						goto __catch0_g_error;
					}
#line 135 "../lib/synapse-core/desktop-file-service.vala"
					if (_tmp8_) {
#line 1232 "desktop-file-service.c"
						gchar* _tmp10_ = NULL;
						const gchar* _tmp11_;
						gchar* _tmp12_;
#line 136 "../lib/synapse-core/desktop-file-service.vala"
						_tmp11_ = domain_key;
#line 136 "../lib/synapse-core/desktop-file-service.vala"
						_tmp12_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, _tmp11_, &_inner_error0_);
#line 136 "../lib/synapse-core/desktop-file-service.vala"
						_tmp10_ = _tmp12_;
#line 136 "../lib/synapse-core/desktop-file-service.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 136 "../lib/synapse-core/desktop-file-service.vala"
							_g_free0 (_tmp0_);
#line 1246 "desktop-file-service.c"
							goto __catch0_g_error;
						}
#line 136 "../lib/synapse-core/desktop-file-service.vala"
						synapse_desktop_file_info_set_gettext_domain (self, _tmp10_);
#line 137 "../lib/synapse-core/desktop-file-service.vala"
						_g_free0 (_tmp10_);
#line 137 "../lib/synapse-core/desktop-file-service.vala"
						break;
#line 1255 "desktop-file-service.c"
					}
				}
			}
		}
#line 142 "../lib/synapse-core/desktop-file-service.vala"
		_tmp13_ = g_desktop_app_info_new_from_keyfile (keyfile);
#line 142 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (app_info);
#line 142 "../lib/synapse-core/desktop-file-service.vala"
		app_info = _tmp13_;
#line 144 "../lib/synapse-core/desktop-file-service.vala"
		_tmp14_ = app_info;
#line 144 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp14_ == NULL) {
#line 1270 "desktop-file-service.c"
			GError* _tmp15_;
#line 145 "../lib/synapse-core/desktop-file-service.vala"
			_tmp15_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Unable to create AppInfo");
#line 145 "../lib/synapse-core/desktop-file-service.vala"
			_inner_error0_ = _tmp15_;
#line 145 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 145 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1280 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 148 "../lib/synapse-core/desktop-file-service.vala"
		_tmp16_ = app_info;
#line 148 "../lib/synapse-core/desktop-file-service.vala"
		_tmp17_ = g_app_info_get_name ((GAppInfo*) _tmp16_);
#line 148 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_name (self, _tmp17_);
#line 149 "../lib/synapse-core/desktop-file-service.vala"
		_tmp19_ = app_info;
#line 149 "../lib/synapse-core/desktop-file-service.vala"
		_tmp20_ = g_desktop_app_info_get_generic_name (_tmp19_);
#line 149 "../lib/synapse-core/desktop-file-service.vala"
		_tmp18_ = _tmp20_;
#line 149 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp18_ == NULL) {
#line 149 "../lib/synapse-core/desktop-file-service.vala"
			_tmp18_ = "";
#line 1299 "desktop-file-service.c"
		}
#line 149 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_generic_name (self, _tmp18_);
#line 150 "../lib/synapse-core/desktop-file-service.vala"
		_tmp21_ = app_info;
#line 150 "../lib/synapse-core/desktop-file-service.vala"
		_tmp22_ = g_app_info_get_commandline ((GAppInfo*) _tmp21_);
#line 150 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_exec (self, _tmp22_);
#line 151 "../lib/synapse-core/desktop-file-service.vala"
		_tmp23_ = self->priv->_exec;
#line 151 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp23_ == NULL) {
#line 1313 "desktop-file-service.c"
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GError* _tmp27_;
			GError* _tmp28_;
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_tmp24_ = self->priv->_name;
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_tmp25_ = g_strdup_printf ("Unable to get exec for %s", _tmp24_);
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_tmp26_ = _tmp25_;
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_tmp27_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp26_);
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_tmp28_ = _tmp27_;
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp26_);
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_inner_error0_ = _tmp28_;
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 152 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1337 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 156 "../lib/synapse-core/desktop-file-service.vala"
		_tmp30_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error0_);
#line 156 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 156 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 156 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1348 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 156 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp30_) {
#line 1353 "desktop-file-service.c"
			gboolean _tmp31_ = FALSE;
#line 156 "../lib/synapse-core/desktop-file-service.vala"
			_tmp31_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error0_);
#line 156 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 156 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 156 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1363 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 156 "../lib/synapse-core/desktop-file-service.vala"
			_tmp29_ = _tmp31_;
#line 1368 "desktop-file-service.c"
		} else {
#line 156 "../lib/synapse-core/desktop-file-service.vala"
			_tmp29_ = FALSE;
#line 1372 "desktop-file-service.c"
		}
#line 156 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp29_) {
#line 157 "../lib/synapse-core/desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
#line 1378 "desktop-file-service.c"
		}
#line 159 "../lib/synapse-core/desktop-file-service.vala"
		_tmp33_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error0_);
#line 159 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 159 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 159 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1388 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 159 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp33_) {
#line 1393 "desktop-file-service.c"
			gboolean _tmp34_ = FALSE;
#line 159 "../lib/synapse-core/desktop-file-service.vala"
			_tmp34_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error0_);
#line 159 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 159 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 159 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1403 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 159 "../lib/synapse-core/desktop-file-service.vala"
			_tmp32_ = _tmp34_;
#line 1408 "desktop-file-service.c"
		} else {
#line 159 "../lib/synapse-core/desktop-file-service.vala"
			_tmp32_ = FALSE;
#line 1412 "desktop-file-service.c"
		}
#line 159 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp32_) {
#line 160 "../lib/synapse-core/desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
#line 1418 "desktop-file-service.c"
		}
#line 163 "../lib/synapse-core/desktop-file-service.vala"
		_tmp36_ = app_info;
#line 163 "../lib/synapse-core/desktop-file-service.vala"
		_tmp37_ = g_app_info_get_description ((GAppInfo*) _tmp36_);
#line 163 "../lib/synapse-core/desktop-file-service.vala"
		_tmp35_ = _tmp37_;
#line 163 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp35_ == NULL) {
#line 163 "../lib/synapse-core/desktop-file-service.vala"
			_tmp35_ = "";
#line 1430 "desktop-file-service.c"
		}
#line 163 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_comment (self, _tmp35_);
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		_tmp39_ = app_info;
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		_tmp40_ = g_app_info_get_icon ((GAppInfo*) _tmp39_);
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		_tmp41_ = _g_object_ref0 (_tmp40_);
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		_tmp38_ = _tmp41_;
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp38_ == NULL) {
#line 1444 "desktop-file-service.c"
			GThemedIcon* _tmp42_;
#line 166 "../lib/synapse-core/desktop-file-service.vala"
			_tmp42_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
#line 166 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_tmp38_);
#line 166 "../lib/synapse-core/desktop-file-service.vala"
			_tmp38_ = (GIcon*) _tmp42_;
#line 1452 "desktop-file-service.c"
		}
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		_tmp43_ = _tmp38_;
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		_tmp38_ = NULL;
#line 165 "../lib/synapse-core/desktop-file-service.vala"
		icon = _tmp43_;
#line 167 "../lib/synapse-core/desktop-file-service.vala"
		_tmp44_ = icon;
#line 167 "../lib/synapse-core/desktop-file-service.vala"
		_tmp45_ = g_icon_to_string (_tmp44_);
#line 167 "../lib/synapse-core/desktop-file-service.vala"
		_tmp46_ = _tmp45_;
#line 167 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_icon_name (self, _tmp46_);
#line 167 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (_tmp46_);
#line 169 "../lib/synapse-core/desktop-file-service.vala"
		_tmp47_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_inner_error0_);
#line 169 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 169 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 169 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_tmp38_);
#line 169 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 169 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1482 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 169 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp47_) {
#line 1487 "desktop-file-service.c"
			gchar** _tmp48_ = NULL;
			gsize _tmp49_ = 0;
			gchar** _tmp50_;
			gint _tmp48__length1;
			gint __tmp48__size_;
			gchar** _tmp51_;
			gint _tmp51__length1;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp50_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_tmp49_, &_inner_error0_);
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp48_ = _tmp50_;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp48__length1 = _tmp49_;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			__tmp48__size_ = _tmp48__length1;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 170 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 170 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_tmp38_);
#line 170 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 170 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1513 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp51_ = _tmp48_;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp51__length1 = _tmp48__length1;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp48_ = NULL;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			_tmp48__length1 = 0;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			self->mime_types = _tmp51_;
#line 170 "../lib/synapse-core/desktop-file-service.vala"
			self->mime_types_length1 = _tmp51__length1;
#line 169 "../lib/synapse-core/desktop-file-service.vala"
			_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
#line 1532 "desktop-file-service.c"
		}
#line 172 "../lib/synapse-core/desktop-file-service.vala"
		_tmp52_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error0_);
#line 172 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 172 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 172 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_tmp38_);
#line 172 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 172 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1546 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 172 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp52_) {
#line 1551 "desktop-file-service.c"
			gboolean _tmp53_ = FALSE;
#line 173 "../lib/synapse-core/desktop-file-service.vala"
			_tmp53_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error0_);
#line 173 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 173 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 173 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_tmp38_);
#line 173 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 173 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1565 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 173 "../lib/synapse-core/desktop-file-service.vala"
			synapse_desktop_file_info_set_needs_terminal (self, _tmp53_);
#line 1570 "desktop-file-service.c"
		}
#line 175 "../lib/synapse-core/desktop-file-service.vala"
		_tmp54_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_inner_error0_);
#line 175 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 175 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 175 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_tmp38_);
#line 175 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 175 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1584 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 175 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp54_) {
#line 1589 "desktop-file-service.c"
			gchar** _tmp55_ = NULL;
			gsize _tmp56_ = 0;
			gchar** _tmp57_;
			gint _tmp55__length1;
			gint __tmp55__size_;
#line 176 "../lib/synapse-core/desktop-file-service.vala"
			_tmp57_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_tmp56_, &_inner_error0_);
#line 176 "../lib/synapse-core/desktop-file-service.vala"
			_tmp55_ = _tmp57_;
#line 176 "../lib/synapse-core/desktop-file-service.vala"
			_tmp55__length1 = _tmp56_;
#line 176 "../lib/synapse-core/desktop-file-service.vala"
			__tmp55__size_ = _tmp55__length1;
#line 176 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 176 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 176 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_tmp38_);
#line 176 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 176 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1613 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 176 "../lib/synapse-core/desktop-file-service.vala"
			synapse_desktop_file_info_set_show_in (self, synapse_desktop_file_info_parse_environments (self, _tmp55_, (gint) _tmp55__length1));
#line 175 "../lib/synapse-core/desktop-file-service.vala"
			_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 1620 "desktop-file-service.c"
		} else {
			gboolean _tmp58_ = FALSE;
#line 177 "../lib/synapse-core/desktop-file-service.vala"
			_tmp58_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_inner_error0_);
#line 177 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 177 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 177 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_tmp38_);
#line 177 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 177 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1635 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 177 "../lib/synapse-core/desktop-file-service.vala"
			if (_tmp58_) {
#line 1640 "desktop-file-service.c"
				gchar** _tmp59_ = NULL;
				gsize _tmp60_ = 0;
				gchar** _tmp61_;
				gint _tmp59__length1;
				gint __tmp59__size_;
				SynapseDesktopFileInfoEnvironmentType not_show = 0U;
				SynapseDesktopFileInfoEnvironmentType _tmp62_;
#line 178 "../lib/synapse-core/desktop-file-service.vala"
				_tmp61_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_tmp60_, &_inner_error0_);
#line 178 "../lib/synapse-core/desktop-file-service.vala"
				_tmp59_ = _tmp61_;
#line 178 "../lib/synapse-core/desktop-file-service.vala"
				_tmp59__length1 = _tmp60_;
#line 178 "../lib/synapse-core/desktop-file-service.vala"
				__tmp59__size_ = _tmp59__length1;
#line 178 "../lib/synapse-core/desktop-file-service.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (icon);
#line 178 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (_tmp38_);
#line 178 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (app_info);
#line 178 "../lib/synapse-core/desktop-file-service.vala"
					_g_free0 (_tmp0_);
#line 1666 "desktop-file-service.c"
					goto __catch0_g_error;
				}
#line 178 "../lib/synapse-core/desktop-file-service.vala"
				not_show = synapse_desktop_file_info_parse_environments (self, _tmp59_, (gint) _tmp59__length1);
#line 179 "../lib/synapse-core/desktop-file-service.vala"
				_tmp62_ = not_show;
#line 179 "../lib/synapse-core/desktop-file-service.vala"
				synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL ^ _tmp62_);
#line 177 "../lib/synapse-core/desktop-file-service.vala"
				_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
#line 1677 "desktop-file-service.c"
			}
		}
#line 184 "../lib/synapse-core/desktop-file-service.vala"
		_tmp64_ = self->priv->_filename;
#line 184 "../lib/synapse-core/desktop-file-service.vala"
		if (g_str_has_suffix (_tmp64_, "gconf-editor.desktop")) {
#line 184 "../lib/synapse-core/desktop-file-service.vala"
			_tmp63_ = TRUE;
#line 1686 "desktop-file-service.c"
		} else {
			const gchar* _tmp65_;
#line 184 "../lib/synapse-core/desktop-file-service.vala"
			_tmp65_ = self->priv->_filename;
#line 184 "../lib/synapse-core/desktop-file-service.vala"
			_tmp63_ = g_str_has_suffix (_tmp65_, "dconf-editor.desktop");
#line 1693 "desktop-file-service.c"
		}
#line 184 "../lib/synapse-core/desktop-file-service.vala"
		if (_tmp63_) {
#line 185 "../lib/synapse-core/desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, FALSE);
#line 1699 "desktop-file-service.c"
		}
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (icon);
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_tmp38_);
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (app_info);
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (_tmp0_);
#line 1709 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp66_;
		const gchar* _tmp67_;
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		err = _inner_error0_;
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		_inner_error0_ = NULL;
#line 188 "../lib/synapse-core/desktop-file-service.vala"
		_tmp66_ = err;
#line 188 "../lib/synapse-core/desktop-file-service.vala"
		_tmp67_ = _tmp66_->message;
#line 188 "../lib/synapse-core/desktop-file-service.vala"
		synapse_utils_logger_warning ((GObject*) self, "%s", _tmp67_, NULL);
#line 189 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_is_valid (self, FALSE);
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		_g_error_free0 (err);
#line 1731 "desktop-file-service.c"
	}
	__finally0:
#line 123 "../lib/synapse-core/desktop-file-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		g_clear_error (&_inner_error0_);
#line 123 "../lib/synapse-core/desktop-file-service.vala"
		return;
#line 1742 "desktop-file-service.c"
	}
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct (GType object_type)
{
	SynapseDesktopFileInfo * self = NULL;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	return self;
#line 1754 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new (void)
{
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
#line 1762 "desktop-file-service.c"
}

const gchar*
synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1778 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_desktop_id (self);
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1792 "desktop-file-service.c"
		gchar* _tmp0_;
#line 48 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 48 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_desktop_id);
#line 48 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_desktop_id = _tmp0_;
#line 48 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY]);
#line 1802 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_name;
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1819 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_name (self);
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1833 "desktop-file-service.c"
		gchar* _tmp0_;
#line 49 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 49 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_name);
#line 49 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_name = _tmp0_;
#line 49 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY]);
#line 1843 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_generic_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_generic_name;
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1860 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_generic_name (SynapseDesktopFileInfo* self,
                                            const gchar* value)
{
	gchar* old_value;
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_generic_name (self);
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1874 "desktop-file-service.c"
		gchar* _tmp0_;
#line 50 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 50 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_generic_name);
#line 50 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_generic_name = _tmp0_;
#line 50 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY]);
#line 1884 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_comment;
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1901 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                       const gchar* value)
{
	gchar* old_value;
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_comment (self);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1915 "desktop-file-service.c"
		gchar* _tmp0_;
#line 51 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_comment);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_comment = _tmp0_;
#line 51 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY]);
#line 1925 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_icon_name;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1942 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                         const gchar* value)
{
	gchar* old_value;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_icon_name (self);
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1956 "desktop-file-service.c"
		gchar* _tmp0_;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 52 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_icon_name);
#line 52 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_icon_name = _tmp0_;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY]);
#line 1966 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_gettext_domain (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_gettext_domain;
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 1983 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_gettext_domain (SynapseDesktopFileInfo* self,
                                              const gchar* value)
{
	gchar* old_value;
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_gettext_domain (self);
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1997 "desktop-file-service.c"
		gchar* _tmp0_;
#line 53 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 53 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_gettext_domain);
#line 53 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_gettext_domain = _tmp0_;
#line 53 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY]);
#line 2007 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	result = self->priv->_needs_terminal;
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2021 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                              gboolean value)
{
	gboolean old_value;
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_needs_terminal (self);
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	if (old_value != value) {
#line 55 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_needs_terminal = value;
#line 55 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY]);
#line 2039 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_filename;
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2056 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_filename (self);
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2070 "desktop-file-service.c"
		gchar* _tmp0_;
#line 56 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 56 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_filename);
#line 56 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_filename = _tmp0_;
#line 56 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY]);
#line 2080 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_exec;
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2097 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_exec (self);
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2111 "desktop-file-service.c"
		gchar* _tmp0_;
#line 58 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 58 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->_exec);
#line 58 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_exec = _tmp0_;
#line 58 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY]);
#line 2121 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	result = self->priv->_is_hidden;
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2135 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                         gboolean value)
{
	gboolean old_value;
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_is_hidden (self);
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	if (old_value != value) {
#line 60 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_is_hidden = value;
#line 60 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY]);
#line 2153 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	result = self->priv->_is_valid;
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2167 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                        gboolean value)
{
	gboolean old_value;
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_is_valid (self);
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	if (old_value != value) {
#line 61 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_is_valid = value;
#line 61 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY]);
#line 2185 "desktop-file-service.c"
	}
}

SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self)
{
	SynapseDesktopFileInfoEnvironmentType result;
	SynapseDesktopFileInfoEnvironmentType _tmp0_;
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->_show_in;
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2202 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                       SynapseDesktopFileInfoEnvironmentType value)
{
	SynapseDesktopFileInfoEnvironmentType old_value;
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_show_in (self);
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	if (old_value != value) {
#line 74 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->_show_in = value;
#line 74 "../lib/synapse-core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY]);
#line 2220 "desktop-file-service.c"
	}
}

static void
synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass,
                                      gpointer klass_data)
{
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileInfo_private_offset);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_info_get_property;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_info_set_property;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY] = g_param_spec_string ("gettext-domain", "gettext-domain", "gettext-domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY] = g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY] = g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2262 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	self->priv = synapse_desktop_file_info_get_instance_private (self);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = g_strdup ("");
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->_comment = _tmp0_;
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = g_strdup ("");
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->_icon_name = _tmp1_;
#line 55 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->_needs_terminal = FALSE;
#line 60 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->_is_hidden = FALSE;
#line 61 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->_is_valid = TRUE;
#line 63 "../lib/synapse-core/desktop-file-service.vala"
	self->mime_types = NULL;
#line 63 "../lib/synapse-core/desktop-file-service.vala"
	self->mime_types_length1 = 0;
#line 65 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->name_folded = NULL;
#line 74 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->_show_in = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL;
#line 2295 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_finalize (GObject * obj)
{
	SynapseDesktopFileInfo * self;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 48 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_desktop_id);
#line 49 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_name);
#line 50 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_generic_name);
#line 51 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_comment);
#line 52 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_icon_name);
#line 53 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_gettext_domain);
#line 56 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_filename);
#line 58 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->_exec);
#line 63 "../lib/synapse-core/desktop-file-service.vala"
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 65 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->name_folded);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
#line 2326 "desktop-file-service.c"
}

static GType
synapse_desktop_file_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
	GType synapse_desktop_file_info_type_id;
	synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
	SynapseDesktopFileInfo_private_offset = g_type_add_instance_private (synapse_desktop_file_info_type_id, sizeof (SynapseDesktopFileInfoPrivate));
	return synapse_desktop_file_info_type_id;
}

GType
synapse_desktop_file_info_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__volatile)) {
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = synapse_desktop_file_info_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_info_type_id__volatile, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__volatile;
}

static void
_vala_synapse_desktop_file_info_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	switch (property_id) {
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_desktop_id (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_generic_name (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_gettext_domain (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 2433 "desktop-file-service.c"
		default:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 2439 "desktop-file-service.c"
	}
}

static void
_vala_synapse_desktop_file_info_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
	switch (property_id) {
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_desktop_id (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_generic_name (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_gettext_domain (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 2525 "desktop-file-service.c"
		default:
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "../lib/synapse-core/desktop-file-service.vala"
		break;
#line 2531 "desktop-file-service.c"
	}
}

static inline gpointer
synapse_desktop_file_service_get_instance_private (SynapseDesktopFileService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileService_private_offset);
}

SynapseDesktopFileService*
synapse_desktop_file_service_get_default (void)
{
	SynapseDesktopFileService* _tmp0_ = NULL;
	SynapseDesktopFileService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp4_;
	SynapseDesktopFileService* result = NULL;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = synapse_desktop_file_service_instance;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _tmp2_;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 2557 "desktop-file-service.c"
		SynapseDesktopFileService* _tmp3_;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = synapse_desktop_file_service_new ();
#line 200 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_tmp0_);
#line 200 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = _tmp3_;
#line 2565 "desktop-file-service.c"
	}
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	_tmp4_ = _tmp0_;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = NULL;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp4_;
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_tmp0_);
#line 200 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2577 "desktop-file-service.c"
}

static SynapseDesktopFileService*
synapse_desktop_file_service_construct (GType object_type)
{
	SynapseDesktopFileService * self = NULL;
#line 203 "../lib/synapse-core/desktop-file-service.vala"
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
#line 203 "../lib/synapse-core/desktop-file-service.vala"
	return self;
#line 2588 "desktop-file-service.c"
}

static SynapseDesktopFileService*
synapse_desktop_file_service_new (void)
{
#line 203 "../lib/synapse-core/desktop-file-service.vala"
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
#line 2596 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_initialize_data_free (gpointer _data)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _data;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceInitializeData, _data_);
#line 2608 "desktop-file-service.c"
}

void
synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_initialize_co (_data_);
#line 2630 "desktop-file-service.c"
}

void
synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                GAsyncResult* _res_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2640 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_initialize_co (_data_);
#line 2657 "desktop-file-service.c"
}

static gboolean
_synapse_desktop_file_service_initialize_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_service_initialize_co (self);
#line 241 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2667 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_)
{
#line 229 "../lib/synapse-core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 229 "../lib/synapse-core/desktop-file-service.vala"
		case 0:
#line 2677 "desktop-file-service.c"
		goto _state_0;
#line 229 "../lib/synapse-core/desktop-file-service.vala"
		case 1:
#line 2681 "desktop-file-service.c"
		goto _state_1;
#line 229 "../lib/synapse-core/desktop-file-service.vala"
		case 2:
#line 2685 "desktop-file-service.c"
		goto _state_2;
#line 229 "../lib/synapse-core/desktop-file-service.vala"
		case 3:
#line 2689 "desktop-file-service.c"
		goto _state_3;
		default:
#line 229 "../lib/synapse-core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 2694 "desktop-file-service.c"
	}
	_state_0:
#line 230 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp0_ = _data_->self->priv->init_once;
#line 230 "../lib/synapse-core/desktop-file-service.vala"
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
#line 231 "../lib/synapse-core/desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 231 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 231 "../lib/synapse-core/desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 231 "../lib/synapse-core/desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2709 "desktop-file-service.c"
			}
		}
#line 231 "../lib/synapse-core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 231 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 2716 "desktop-file-service.c"
	}
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->self->priv->init_once;
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_state_ = 1;
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_desktop_file_service_initialize_ready, _data_);
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 2726 "desktop-file-service.c"
	_state_1:
#line 233 "../lib/synapse-core/desktop-file-service.vala"
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
#line 234 "../lib/synapse-core/desktop-file-service.vala"
	if (!_data_->is_locked) {
#line 235 "../lib/synapse-core/desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 235 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 235 "../lib/synapse-core/desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 235 "../lib/synapse-core/desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2740 "desktop-file-service.c"
			}
		}
#line 235 "../lib/synapse-core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 235 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 2747 "desktop-file-service.c"
	}
#line 238 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_get_environment_type (_data_->self);
#line 239 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp2_ = _data_->self->priv->session_type_str;
#line 239 "../lib/synapse-core/desktop-file-service.vala"
	g_desktop_app_info_set_desktop_env (_data_->_tmp2_);
#line 241 "../lib/synapse-core/desktop-file-service.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_service_initialize_co_gsource_func, _data_, NULL);
#line 242 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_state_ = 2;
#line 242 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 2761 "desktop-file-service.c"
	_state_2:
	;
#line 243 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_state_ = 3;
#line 243 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_initialize_ready, _data_);
#line 243 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 2770 "desktop-file-service.c"
	_state_3:
#line 243 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
#line 245 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp3_ = _data_->self->priv->init_once;
#line 245 "../lib/synapse-core/desktop-file-service.vala"
	synapse_utils_async_once_leave (_data_->_tmp3_, (gpointer) ((gintptr) TRUE));
#line 229 "../lib/synapse-core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 229 "../lib/synapse-core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 229 "../lib/synapse-core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 229 "../lib/synapse-core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2786 "desktop-file-service.c"
		}
	}
#line 229 "../lib/synapse-core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 229 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 2793 "desktop-file-service.c"
}

SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self)
{
	SynapseDesktopFileInfoEnvironmentType _tmp0_;
	SynapseDesktopFileInfoEnvironmentType result = 0U;
#line 251 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 252 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->session_type;
#line 252 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp0_;
#line 252 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 2809 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self)
{
	const gchar* session_var = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* session = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
#line 255 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 257 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 257 "../lib/synapse-core/desktop-file-service.vala"
	session_var = _tmp0_;
#line 258 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = session_var;
#line 258 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp1_ == NULL) {
#line 2834 "desktop-file-service.c"
		const gchar* _tmp2_;
#line 259 "../lib/synapse-core/desktop-file-service.vala"
		_tmp2_ = g_getenv ("DESKTOP_SESSION");
#line 259 "../lib/synapse-core/desktop-file-service.vala"
		session_var = _tmp2_;
#line 2840 "desktop-file-service.c"
	}
#line 262 "../lib/synapse-core/desktop-file-service.vala"
	_tmp3_ = session_var;
#line 262 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp3_ == NULL) {
#line 263 "../lib/synapse-core/desktop-file-service.vala"
		return;
#line 2848 "desktop-file-service.c"
	}
#line 266 "../lib/synapse-core/desktop-file-service.vala"
	_tmp4_ = session_var;
#line 266 "../lib/synapse-core/desktop-file-service.vala"
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 266 "../lib/synapse-core/desktop-file-service.vala"
	session = _tmp5_;
#line 268 "../lib/synapse-core/desktop-file-service.vala"
	_tmp7_ = session;
#line 268 "../lib/synapse-core/desktop-file-service.vala"
	if (g_str_has_prefix (_tmp7_, "unity")) {
#line 268 "../lib/synapse-core/desktop-file-service.vala"
		_tmp6_ = TRUE;
#line 2862 "desktop-file-service.c"
	} else {
		const gchar* _tmp8_;
#line 268 "../lib/synapse-core/desktop-file-service.vala"
		_tmp8_ = session;
#line 268 "../lib/synapse-core/desktop-file-service.vala"
		_tmp6_ = g_str_has_prefix (_tmp8_, "ubuntu");
#line 2869 "desktop-file-service.c"
	}
#line 268 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp6_) {
#line 2873 "desktop-file-service.c"
		gchar* _tmp9_;
#line 269 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY;
#line 270 "../lib/synapse-core/desktop-file-service.vala"
		_tmp9_ = g_strdup ("Unity");
#line 270 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (self->priv->session_type_str);
#line 270 "../lib/synapse-core/desktop-file-service.vala"
		self->priv->session_type_str = _tmp9_;
#line 2883 "desktop-file-service.c"
	} else {
		const gchar* _tmp10_;
#line 271 "../lib/synapse-core/desktop-file-service.vala"
		_tmp10_ = session;
#line 271 "../lib/synapse-core/desktop-file-service.vala"
		if (g_str_has_prefix (_tmp10_, "kde")) {
#line 2890 "desktop-file-service.c"
			gchar* _tmp11_;
#line 272 "../lib/synapse-core/desktop-file-service.vala"
			self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
#line 273 "../lib/synapse-core/desktop-file-service.vala"
			_tmp11_ = g_strdup ("KDE");
#line 273 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (self->priv->session_type_str);
#line 273 "../lib/synapse-core/desktop-file-service.vala"
			self->priv->session_type_str = _tmp11_;
#line 2900 "desktop-file-service.c"
		} else {
			const gchar* _tmp12_;
#line 274 "../lib/synapse-core/desktop-file-service.vala"
			_tmp12_ = session;
#line 274 "../lib/synapse-core/desktop-file-service.vala"
			if (g_str_has_prefix (_tmp12_, "gnome")) {
#line 2907 "desktop-file-service.c"
				gchar* _tmp13_;
#line 275 "../lib/synapse-core/desktop-file-service.vala"
				self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
#line 276 "../lib/synapse-core/desktop-file-service.vala"
				_tmp13_ = g_strdup ("GNOME");
#line 276 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (self->priv->session_type_str);
#line 276 "../lib/synapse-core/desktop-file-service.vala"
				self->priv->session_type_str = _tmp13_;
#line 2917 "desktop-file-service.c"
			} else {
				const gchar* _tmp14_;
#line 277 "../lib/synapse-core/desktop-file-service.vala"
				_tmp14_ = session;
#line 277 "../lib/synapse-core/desktop-file-service.vala"
				if (g_str_has_prefix (_tmp14_, "lx")) {
#line 2924 "desktop-file-service.c"
					gchar* _tmp15_;
#line 278 "../lib/synapse-core/desktop-file-service.vala"
					self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
#line 279 "../lib/synapse-core/desktop-file-service.vala"
					_tmp15_ = g_strdup ("LXDE");
#line 279 "../lib/synapse-core/desktop-file-service.vala"
					_g_free0 (self->priv->session_type_str);
#line 279 "../lib/synapse-core/desktop-file-service.vala"
					self->priv->session_type_str = _tmp15_;
#line 2934 "desktop-file-service.c"
				} else {
					const gchar* _tmp16_;
#line 280 "../lib/synapse-core/desktop-file-service.vala"
					_tmp16_ = session;
#line 280 "../lib/synapse-core/desktop-file-service.vala"
					if (g_str_has_prefix (_tmp16_, "xfce")) {
#line 2941 "desktop-file-service.c"
						gchar* _tmp17_;
#line 281 "../lib/synapse-core/desktop-file-service.vala"
						self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
#line 282 "../lib/synapse-core/desktop-file-service.vala"
						_tmp17_ = g_strdup ("XFCE");
#line 282 "../lib/synapse-core/desktop-file-service.vala"
						_g_free0 (self->priv->session_type_str);
#line 282 "../lib/synapse-core/desktop-file-service.vala"
						self->priv->session_type_str = _tmp17_;
#line 2951 "desktop-file-service.c"
					} else {
						const gchar* _tmp18_;
#line 283 "../lib/synapse-core/desktop-file-service.vala"
						_tmp18_ = session;
#line 283 "../lib/synapse-core/desktop-file-service.vala"
						if (g_str_has_prefix (_tmp18_, "mate")) {
#line 2958 "desktop-file-service.c"
							gchar* _tmp19_;
#line 284 "../lib/synapse-core/desktop-file-service.vala"
							self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE;
#line 285 "../lib/synapse-core/desktop-file-service.vala"
							_tmp19_ = g_strdup ("MATE");
#line 285 "../lib/synapse-core/desktop-file-service.vala"
							_g_free0 (self->priv->session_type_str);
#line 285 "../lib/synapse-core/desktop-file-service.vala"
							self->priv->session_type_str = _tmp19_;
#line 2968 "desktop-file-service.c"
						} else {
							const gchar* _tmp20_;
#line 286 "../lib/synapse-core/desktop-file-service.vala"
							_tmp20_ = session;
#line 286 "../lib/synapse-core/desktop-file-service.vala"
							if (g_str_has_prefix (_tmp20_, "razor")) {
#line 2975 "desktop-file-service.c"
								gchar* _tmp21_;
#line 287 "../lib/synapse-core/desktop-file-service.vala"
								self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR;
#line 288 "../lib/synapse-core/desktop-file-service.vala"
								_tmp21_ = g_strdup ("Razor");
#line 288 "../lib/synapse-core/desktop-file-service.vala"
								_g_free0 (self->priv->session_type_str);
#line 288 "../lib/synapse-core/desktop-file-service.vala"
								self->priv->session_type_str = _tmp21_;
#line 2985 "desktop-file-service.c"
							} else {
								const gchar* _tmp22_;
#line 289 "../lib/synapse-core/desktop-file-service.vala"
								_tmp22_ = session;
#line 289 "../lib/synapse-core/desktop-file-service.vala"
								if (g_str_has_prefix (_tmp22_, "tde")) {
#line 2992 "desktop-file-service.c"
									gchar* _tmp23_;
#line 290 "../lib/synapse-core/desktop-file-service.vala"
									self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE;
#line 291 "../lib/synapse-core/desktop-file-service.vala"
									_tmp23_ = g_strdup ("TDE");
#line 291 "../lib/synapse-core/desktop-file-service.vala"
									_g_free0 (self->priv->session_type_str);
#line 291 "../lib/synapse-core/desktop-file-service.vala"
									self->priv->session_type_str = _tmp23_;
#line 3002 "desktop-file-service.c"
								} else {
									const gchar* _tmp24_;
#line 292 "../lib/synapse-core/desktop-file-service.vala"
									_tmp24_ = session;
#line 292 "../lib/synapse-core/desktop-file-service.vala"
									if (g_str_has_prefix (_tmp24_, "rox")) {
#line 3009 "desktop-file-service.c"
										gchar* _tmp25_;
#line 293 "../lib/synapse-core/desktop-file-service.vala"
										self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
#line 294 "../lib/synapse-core/desktop-file-service.vala"
										_tmp25_ = g_strdup ("ROX");
#line 294 "../lib/synapse-core/desktop-file-service.vala"
										_g_free0 (self->priv->session_type_str);
#line 294 "../lib/synapse-core/desktop-file-service.vala"
										self->priv->session_type_str = _tmp25_;
#line 3019 "desktop-file-service.c"
									} else {
										const gchar* _tmp26_;
#line 295 "../lib/synapse-core/desktop-file-service.vala"
										_tmp26_ = session;
#line 295 "../lib/synapse-core/desktop-file-service.vala"
										if (g_str_has_prefix (_tmp26_, "pantheon")) {
#line 3026 "desktop-file-service.c"
											gchar* _tmp27_;
#line 296 "../lib/synapse-core/desktop-file-service.vala"
											self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON;
#line 297 "../lib/synapse-core/desktop-file-service.vala"
											_tmp27_ = g_strdup ("Pantheon");
#line 297 "../lib/synapse-core/desktop-file-service.vala"
											_g_free0 (self->priv->session_type_str);
#line 297 "../lib/synapse-core/desktop-file-service.vala"
											self->priv->session_type_str = _tmp27_;
#line 3036 "desktop-file-service.c"
										} else {
#line 299 "../lib/synapse-core/desktop-file-service.vala"
											g_warning ("desktop-file-service.vala:299: Desktop session type is not recognized," \
" assuming GNOME.");
#line 3040 "desktop-file-service.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 255 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (session);
#line 3053 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_get_list_has_desktop_id (SynapseDesktopFileService* self,
                                                      const gchar* desktop_id)
{
	gboolean result = FALSE;
#line 303 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 303 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, FALSE);
#line 3065 "desktop-file-service.c"
	{
		GeeList* _dfi_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _dfi_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dfi_index = 0;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = self->priv->all_desktop_files;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_dfi_list = _tmp1_;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_tmp2_ = _dfi_list;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_tmp4_ = _tmp3_;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_dfi_size = _tmp4_;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_dfi_index = -1;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		while (TRUE) {
#line 3093 "desktop-file-service.c"
			gint _tmp5_;
			gint _tmp6_;
			SynapseDesktopFileInfo* dfi = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			SynapseDesktopFileInfo* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			_dfi_index = _dfi_index + 1;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			_tmp5_ = _dfi_index;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			_tmp6_ = _dfi_size;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 304 "../lib/synapse-core/desktop-file-service.vala"
				break;
#line 3112 "desktop-file-service.c"
			}
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			_tmp7_ = _dfi_list;
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			_tmp8_ = gee_list_get (_tmp7_, _dfi_index);
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			dfi = (SynapseDesktopFileInfo*) _tmp8_;
#line 305 "../lib/synapse-core/desktop-file-service.vala"
			_tmp9_ = dfi;
#line 305 "../lib/synapse-core/desktop-file-service.vala"
			_tmp10_ = synapse_desktop_file_info_get_desktop_id (_tmp9_);
#line 305 "../lib/synapse-core/desktop-file-service.vala"
			_tmp11_ = _tmp10_;
#line 305 "../lib/synapse-core/desktop-file-service.vala"
			if (g_strcmp0 (_tmp11_, desktop_id) == 0) {
#line 306 "../lib/synapse-core/desktop-file-service.vala"
				result = TRUE;
#line 306 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 306 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_dfi_list);
#line 306 "../lib/synapse-core/desktop-file-service.vala"
				return result;
#line 3136 "desktop-file-service.c"
			}
#line 304 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (dfi);
#line 3140 "desktop-file-service.c"
		}
#line 304 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_dfi_list);
#line 3144 "desktop-file-service.c"
	}
#line 310 "../lib/synapse-core/desktop-file-service.vala"
	result = FALSE;
#line 310 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 3150 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_data_free (gpointer _data)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = _data;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->directory);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->monitored_dirs);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceProcessDirectoryData, _data_);
#line 3168 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                GFile* directory,
                                                const gchar* id_prefix,
                                                GeeSet* monitored_dirs,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GeeSet* _tmp3_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceProcessDirectoryData);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_process_directory_data_free);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = _g_object_ref0 (directory);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->directory);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->directory = _tmp1_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = g_strdup (id_prefix);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->id_prefix = _tmp2_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp3_ = _g_object_ref0 (monitored_dirs);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->monitored_dirs);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->monitored_dirs = _tmp3_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_process_directory_co (_data_);
#line 3214 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3224 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
#line 326 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 326 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 326 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 326 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_process_directory_co (_data_);
#line 3241 "desktop-file-service.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 314 "../lib/synapse-core/desktop-file-service.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3249 "desktop-file-service.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 314 "../lib/synapse-core/desktop-file-service.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 3257 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_)
{
#line 313 "../lib/synapse-core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		case 0:
#line 3267 "desktop-file-service.c"
		goto _state_0;
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		case 1:
#line 3271 "desktop-file-service.c"
		goto _state_1;
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		case 2:
#line 3275 "desktop-file-service.c"
		goto _state_2;
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		case 3:
#line 3279 "desktop-file-service.c"
		goto _state_3;
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		case 4:
#line 3283 "desktop-file-service.c"
		goto _state_4;
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		case 5:
#line 3287 "desktop-file-service.c"
		goto _state_5;
		default:
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 3292 "desktop-file-service.c"
	}
	_state_0:
	{
#line 315 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp0_ = g_file_get_path (_data_->directory);
#line 315 "../lib/synapse-core/desktop-file-service.vala"
		_data_->path = _data_->_tmp0_;
#line 317 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp2_ = _data_->path;
#line 317 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_tmp2_ != NULL) {
#line 317 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp3_ = _data_->path;
#line 317 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp1_ = g_str_has_suffix (_data_->_tmp3_, "menu-xdg");
#line 3308 "desktop-file-service.c"
		} else {
#line 317 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp1_ = FALSE;
#line 3312 "desktop-file-service.c"
		}
#line 317 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_tmp1_) {
#line 318 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 318 "../lib/synapse-core/desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 318 "../lib/synapse-core/desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 318 "../lib/synapse-core/desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 318 "../lib/synapse-core/desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3326 "desktop-file-service.c"
				}
			}
#line 318 "../lib/synapse-core/desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 318 "../lib/synapse-core/desktop-file-service.vala"
			return FALSE;
#line 3333 "desktop-file-service.c"
		}
#line 321 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp5_ = _data_->path;
#line 321 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_tmp5_ != NULL) {
#line 321 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp6_ = _data_->path;
#line 321 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp4_ = g_str_has_suffix (_data_->_tmp6_, "/screensavers");
#line 3343 "desktop-file-service.c"
		} else {
#line 321 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp4_ = FALSE;
#line 3347 "desktop-file-service.c"
		}
#line 321 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_tmp4_) {
#line 322 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 322 "../lib/synapse-core/desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 322 "../lib/synapse-core/desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 322 "../lib/synapse-core/desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 322 "../lib/synapse-core/desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3361 "desktop-file-service.c"
				}
			}
#line 322 "../lib/synapse-core/desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 322 "../lib/synapse-core/desktop-file-service.vala"
			return FALSE;
#line 3368 "desktop-file-service.c"
		}
#line 325 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp7_ = _data_->path;
#line 325 "../lib/synapse-core/desktop-file-service.vala"
		synapse_utils_logger_debug ((GObject*) _data_->self, "desktop-file-service.vala:325: Searching for desktop files in: %s", _data_->_tmp7_, NULL);
#line 326 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_state_ = 1;
#line 326 "../lib/synapse-core/desktop-file-service.vala"
		synapse_utils_query_exists_async (_data_->directory, synapse_desktop_file_service_process_directory_ready, _data_);
#line 326 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 3380 "desktop-file-service.c"
		_state_1:
#line 326 "../lib/synapse-core/desktop-file-service.vala"
		_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 327 "../lib/synapse-core/desktop-file-service.vala"
		if (!_data_->exists) {
#line 328 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 328 "../lib/synapse-core/desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 328 "../lib/synapse-core/desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 328 "../lib/synapse-core/desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 328 "../lib/synapse-core/desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3396 "desktop-file-service.c"
				}
			}
#line 328 "../lib/synapse-core/desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 328 "../lib/synapse-core/desktop-file-service.vala"
			return FALSE;
#line 3403 "desktop-file-service.c"
		}
		{
#line 331 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->monitored_dirs);
#line 331 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_scanned_dir_it = _data_->_tmp8_;
#line 331 "../lib/synapse-core/desktop-file-service.vala"
			while (TRUE) {
#line 331 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp9_ = _data_->_scanned_dir_it;
#line 331 "../lib/synapse-core/desktop-file-service.vala"
				if (!gee_iterator_next (_data_->_tmp9_)) {
#line 331 "../lib/synapse-core/desktop-file-service.vala"
					break;
#line 3418 "desktop-file-service.c"
				}
#line 331 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp10_ = _data_->_scanned_dir_it;
#line 331 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
#line 331 "../lib/synapse-core/desktop-file-service.vala"
				_data_->scanned_dir = (GFile*) _data_->_tmp11_;
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp12_ = _data_->path;
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp13_ = _data_->scanned_dir;
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp16_ = g_strcmp0 (_data_->_tmp12_, _data_->_tmp15_) == 0;
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp15_);
#line 332 "../lib/synapse-core/desktop-file-service.vala"
				if (_data_->_tmp16_) {
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (_data_->scanned_dir);
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (_data_->_scanned_dir_it);
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					_g_free0 (_data_->path);
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					if (_data_->_state_ != 0) {
#line 333 "../lib/synapse-core/desktop-file-service.vala"
						while (!g_task_get_completed (_data_->_async_result)) {
#line 333 "../lib/synapse-core/desktop-file-service.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3454 "desktop-file-service.c"
						}
					}
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					g_object_unref (_data_->_async_result);
#line 333 "../lib/synapse-core/desktop-file-service.vala"
					return FALSE;
#line 3461 "desktop-file-service.c"
				}
#line 331 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->scanned_dir);
#line 3465 "desktop-file-service.c"
			}
#line 331 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_data_->_scanned_dir_it);
#line 3469 "desktop-file-service.c"
		}
#line 336 "../lib/synapse-core/desktop-file-service.vala"
		gee_collection_add ((GeeCollection*) _data_->monitored_dirs, _data_->directory);
#line 337 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_state_ = 2;
#line 337 "../lib/synapse-core/desktop-file-service.vala"
		g_file_enumerate_children_async (_data_->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
#line 337 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 3479 "desktop-file-service.c"
		_state_2:
#line 337 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp17_ = g_file_enumerate_children_finish (_data_->directory, _data_->_res_, &_data_->_inner_error0_);
#line 337 "../lib/synapse-core/desktop-file-service.vala"
		_data_->enumerator = _data_->_tmp17_;
#line 337 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 337 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 3489 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp18_ = _data_->enumerator;
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_state_ = 3;
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		g_file_enumerator_next_files_async (_data_->_tmp18_, 1024, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 3500 "desktop-file-service.c"
		_state_3:
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp19_ = g_file_enumerator_next_files_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		_data_->files = _data_->_tmp19_;
#line 338 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 338 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_data_->enumerator);
#line 338 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 3512 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 339 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp20_ = _data_->files;
#line 3517 "desktop-file-service.c"
		{
#line 339 "../lib/synapse-core/desktop-file-service.vala"
			_data_->f_collection = _data_->_tmp20_;
#line 339 "../lib/synapse-core/desktop-file-service.vala"
			for (_data_->f_it = _data_->f_collection; _data_->f_it != NULL; _data_->f_it = _data_->f_it->next) {
#line 339 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp21_ = _g_object_ref0 ((GFileInfo*) _data_->f_it->data);
#line 339 "../lib/synapse-core/desktop-file-service.vala"
				_data_->f = _data_->_tmp21_;
#line 3527 "desktop-file-service.c"
				{
#line 340 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp22_ = _data_->f;
#line 340 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp23_ = g_file_info_get_name (_data_->_tmp22_);
#line 340 "../lib/synapse-core/desktop-file-service.vala"
					_data_->name = _data_->_tmp23_;
#line 341 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp24_ = _data_->f;
#line 341 "../lib/synapse-core/desktop-file-service.vala"
					if (g_file_info_get_file_type (_data_->_tmp24_) == G_FILE_TYPE_DIRECTORY) {
#line 343 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp25_ = _data_->name;
#line 343 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp26_ = g_file_get_child (_data_->directory, _data_->_tmp25_);
#line 343 "../lib/synapse-core/desktop-file-service.vala"
						_data_->subdir = _data_->_tmp26_;
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp27_ = _data_->subdir;
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp28_ = g_file_get_basename (_data_->_tmp27_);
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp29_ = _data_->_tmp28_;
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp30_ = g_strdup_printf ("%s%s-", _data_->id_prefix, _data_->_tmp29_);
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp31_ = _data_->_tmp30_;
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_g_free0 (_data_->_tmp29_);
#line 344 "../lib/synapse-core/desktop-file-service.vala"
						_data_->new_prefix = _data_->_tmp31_;
#line 345 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp32_ = _data_->subdir;
#line 345 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp33_ = _data_->new_prefix;
#line 345 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_state_ = 4;
#line 345 "../lib/synapse-core/desktop-file-service.vala"
						synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp32_, _data_->_tmp33_, _data_->monitored_dirs, synapse_desktop_file_service_process_directory_ready, _data_);
#line 345 "../lib/synapse-core/desktop-file-service.vala"
						return FALSE;
#line 3569 "desktop-file-service.c"
						_state_4:
#line 345 "../lib/synapse-core/desktop-file-service.vala"
						synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
#line 341 "../lib/synapse-core/desktop-file-service.vala"
						_g_free0 (_data_->new_prefix);
#line 341 "../lib/synapse-core/desktop-file-service.vala"
						_g_object_unref0 (_data_->subdir);
#line 3577 "desktop-file-service.c"
					} else {
#line 348 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp34_ = _data_->name;
#line 348 "../lib/synapse-core/desktop-file-service.vala"
						if (g_str_has_suffix (_data_->_tmp34_, "synapse.desktop")) {
#line 349 "../lib/synapse-core/desktop-file-service.vala"
							_g_object_unref0 (_data_->f);
#line 349 "../lib/synapse-core/desktop-file-service.vala"
							continue;
#line 3587 "desktop-file-service.c"
						}
#line 351 "../lib/synapse-core/desktop-file-service.vala"
						_data_->_tmp35_ = _data_->name;
#line 351 "../lib/synapse-core/desktop-file-service.vala"
						if (g_str_has_suffix (_data_->_tmp35_, ".desktop")) {
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							_data_->_tmp36_ = _data_->name;
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							_data_->_tmp37_ = g_file_get_child (_data_->directory, _data_->_tmp36_);
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							_data_->_tmp38_ = _data_->_tmp37_;
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							_data_->_state_ = 5;
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							synapse_desktop_file_service_load_desktop_file (_data_->self, _data_->_tmp38_, _data_->id_prefix, synapse_desktop_file_service_process_directory_ready, _data_);
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							return FALSE;
#line 3605 "desktop-file-service.c"
							_state_5:
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							synapse_desktop_file_service_load_desktop_file_finish (_data_->self, _data_->_res_);
#line 352 "../lib/synapse-core/desktop-file-service.vala"
							_g_object_unref0 (_data_->_tmp38_);
#line 3611 "desktop-file-service.c"
						}
					}
#line 339 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (_data_->f);
#line 3616 "desktop-file-service.c"
				}
			}
		}
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_data_->enumerator);
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (_data_->path);
#line 3626 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_inner_error0_ = NULL;
#line 357 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp39_ = _data_->err;
#line 357 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp40_ = _data_->_tmp39_->message;
#line 357 "../lib/synapse-core/desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:357: %s", _data_->_tmp40_);
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		_g_error_free0 (_data_->err);
#line 3643 "desktop-file-service.c"
	}
	__finally0:
#line 314 "../lib/synapse-core/desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 314 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 3656 "desktop-file-service.c"
	}
#line 313 "../lib/synapse-core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 313 "../lib/synapse-core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 313 "../lib/synapse-core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 313 "../lib/synapse-core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3666 "desktop-file-service.c"
		}
	}
#line 313 "../lib/synapse-core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 313 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 3673 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = _data;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadAllDesktopFilesData, _data_);
#line 3685 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadAllDesktopFilesData);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_all_desktop_files_data_free);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
#line 3707 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3717 "desktop-file-service.c"
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 364 "../lib/synapse-core/desktop-file-service.vala"
	if ((*length) == (*size)) {
#line 364 "../lib/synapse-core/desktop-file-service.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 364 "../lib/synapse-core/desktop-file-service.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3732 "desktop-file-service.c"
	}
#line 364 "../lib/synapse-core/desktop-file-service.vala"
	(*array)[(*length)++] = value;
#line 364 "../lib/synapse-core/desktop-file-service.vala"
	(*array)[*length] = NULL;
#line 3738 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
#line 3755 "desktop-file-service.c"
}

static void
_synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                     GFile* file,
                                                                                     GFile* other_file,
                                                                                     GFileMonitorEvent event_type,
                                                                                     gpointer self)
{
#line 384 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_desktop_file_directory_changed ((SynapseDesktopFileService*) self);
#line 3767 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_)
{
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 361 "../lib/synapse-core/desktop-file-service.vala"
		case 0:
#line 3777 "desktop-file-service.c"
		goto _state_0;
#line 361 "../lib/synapse-core/desktop-file-service.vala"
		case 1:
#line 3781 "desktop-file-service.c"
		goto _state_1;
#line 361 "../lib/synapse-core/desktop-file-service.vala"
		case 2:
#line 3785 "desktop-file-service.c"
		goto _state_2;
		default:
#line 361 "../lib/synapse-core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 3790 "desktop-file-service.c"
	}
	_state_0:
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp0_ = g_get_user_data_dir ();
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp2_ = g_new0 (gchar*, 1 + 1);
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp2_[0] = _data_->_tmp1_;
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->data_dirs = _data_->_tmp2_;
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->data_dirs_length1 = 1;
#line 362 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_data_dirs_size_ = _data_->data_dirs_length1;
#line 363 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp4_ = _data_->_tmp3_ = g_get_system_data_dirs ();
#line 3809 "desktop-file-service.c"
	{
#line 363 "../lib/synapse-core/desktop-file-service.vala"
		_data_->dir_collection_length1 = 0;
#line 363 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_dir_collection_size_ = 0;
#line 363 "../lib/synapse-core/desktop-file-service.vala"
		_data_->dir_collection = _data_->_tmp4_;
#line 363 "../lib/synapse-core/desktop-file-service.vala"
		_data_->dir_collection_length1 = _vala_array_length (_data_->_tmp3_);
#line 363 "../lib/synapse-core/desktop-file-service.vala"
		for (_data_->dir_it = 0; _data_->dir_it < _data_->dir_collection_length1; _data_->dir_it = _data_->dir_it + 1) {
#line 363 "../lib/synapse-core/desktop-file-service.vala"
			_data_->dir = _data_->dir_collection[_data_->dir_it];
#line 3823 "desktop-file-service.c"
			{
#line 364 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp5_ = _data_->dir;
#line 364 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 364 "../lib/synapse-core/desktop-file-service.vala"
				_vala_array_add5 (&_data_->data_dirs, &_data_->data_dirs_length1, &_data_->_data_dirs_size_, _data_->_tmp6_);
#line 3831 "desktop-file-service.c"
			}
		}
	}
#line 367 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp7_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 367 "../lib/synapse-core/desktop-file-service.vala"
	_data_->desktop_file_dirs = (GeeSet*) _data_->_tmp7_;
#line 368 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp8_ = _data_->self->priv->mimetype_parent_map;
#line 368 "../lib/synapse-core/desktop-file-service.vala"
	gee_multi_map_clear (_data_->_tmp8_);
#line 370 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp9_ = _data_->data_dirs;
#line 370 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp9__length1 = _data_->data_dirs_length1;
#line 3847 "desktop-file-service.c"
	{
#line 370 "../lib/synapse-core/desktop-file-service.vala"
		_data_->data_dir_collection_length1 = 0;
#line 370 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_data_dir_collection_size_ = 0;
#line 370 "../lib/synapse-core/desktop-file-service.vala"
		_data_->data_dir_collection = _data_->_tmp9_;
#line 370 "../lib/synapse-core/desktop-file-service.vala"
		_data_->data_dir_collection_length1 = _data_->_tmp9__length1;
#line 370 "../lib/synapse-core/desktop-file-service.vala"
		for (_data_->data_dir_it = 0; _data_->data_dir_it < _data_->data_dir_collection_length1; _data_->data_dir_it = _data_->data_dir_it + 1) {
#line 370 "../lib/synapse-core/desktop-file-service.vala"
			_data_->data_dir = _data_->data_dir_collection[_data_->data_dir_it];
#line 3861 "desktop-file-service.c"
			{
#line 371 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp10_ = _data_->data_dir;
#line 371 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp11_ = g_build_filename (_data_->_tmp10_, "applications", NULL, NULL);
#line 371 "../lib/synapse-core/desktop-file-service.vala"
				_data_->dir_path = _data_->_tmp11_;
#line 372 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp12_ = _data_->dir_path;
#line 372 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp13_ = g_file_new_for_path (_data_->_tmp12_);
#line 372 "../lib/synapse-core/desktop-file-service.vala"
				_data_->directory = _data_->_tmp13_;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp14_ = _data_->directory;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp15_ = _data_->desktop_file_dirs;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_state_ = 1;
#line 373 "../lib/synapse-core/desktop-file-service.vala"
				synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp14_, "", _data_->_tmp15_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
#line 373 "../lib/synapse-core/desktop-file-service.vala"
				return FALSE;
#line 3885 "desktop-file-service.c"
				_state_1:
#line 373 "../lib/synapse-core/desktop-file-service.vala"
				synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
#line 374 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp16_ = _data_->data_dir;
#line 374 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp17_ = g_build_filename (_data_->_tmp16_, "mime", "subclasses", NULL);
#line 374 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->dir_path);
#line 374 "../lib/synapse-core/desktop-file-service.vala"
				_data_->dir_path = _data_->_tmp17_;
#line 375 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp18_ = _data_->dir_path;
#line 375 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_state_ = 2;
#line 375 "../lib/synapse-core/desktop-file-service.vala"
				synapse_desktop_file_service_load_mime_parents_from_file (_data_->self, _data_->_tmp18_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
#line 375 "../lib/synapse-core/desktop-file-service.vala"
				return FALSE;
#line 3905 "desktop-file-service.c"
				_state_2:
#line 375 "../lib/synapse-core/desktop-file-service.vala"
				synapse_desktop_file_service_load_mime_parents_from_file_finish (_data_->self, _data_->_res_);
#line 370 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->directory);
#line 370 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->dir_path);
#line 3913 "desktop-file-service.c"
			}
		}
	}
#line 378 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_create_indices (_data_->self);
#line 380 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp19_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 380 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self->priv->directory_monitors);
#line 380 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self->priv->directory_monitors = (GeeList*) _data_->_tmp19_;
#line 3925 "desktop-file-service.c"
	{
#line 381 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp20_ = _data_->desktop_file_dirs;
#line 381 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp21_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp20_);
#line 381 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_d_it = _data_->_tmp21_;
#line 381 "../lib/synapse-core/desktop-file-service.vala"
		while (TRUE) {
#line 381 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp22_ = _data_->_d_it;
#line 381 "../lib/synapse-core/desktop-file-service.vala"
			if (!gee_iterator_next (_data_->_tmp22_)) {
#line 381 "../lib/synapse-core/desktop-file-service.vala"
				break;
#line 3941 "desktop-file-service.c"
			}
#line 381 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp23_ = _data_->_d_it;
#line 381 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp24_ = gee_iterator_get (_data_->_tmp23_);
#line 381 "../lib/synapse-core/desktop-file-service.vala"
			_data_->d = (GFile*) _data_->_tmp24_;
#line 3949 "desktop-file-service.c"
			{
#line 383 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp25_ = _data_->d;
#line 383 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp26_ = g_file_monitor_directory (_data_->_tmp25_, 0, NULL, &_data_->_inner_error0_);
#line 383 "../lib/synapse-core/desktop-file-service.vala"
				_data_->monitor = _data_->_tmp26_;
#line 383 "../lib/synapse-core/desktop-file-service.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 3959 "desktop-file-service.c"
					goto __catch0_g_error;
				}
#line 384 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp27_ = _data_->monitor;
#line 384 "../lib/synapse-core/desktop-file-service.vala"
				g_signal_connect_object (_data_->_tmp27_, "changed", (GCallback) _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed, _data_->self, 0);
#line 385 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp28_ = _data_->self->priv->directory_monitors;
#line 385 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp29_ = _data_->monitor;
#line 385 "../lib/synapse-core/desktop-file-service.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp28_, _data_->_tmp29_);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->monitor);
#line 3974 "desktop-file-service.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_data_->err = _data_->_inner_error0_;
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_inner_error0_ = NULL;
#line 387 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp30_ = _data_->err;
#line 387 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp31_ = _data_->_tmp30_->message;
#line 387 "../lib/synapse-core/desktop-file-service.vala"
				g_warning ("desktop-file-service.vala:387: Unable to monitor directory: %s", _data_->_tmp31_);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_g_error_free0 (_data_->err);
#line 3991 "desktop-file-service.c"
			}
			__finally0:
#line 382 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->d);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->_d_it);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->desktop_file_dirs);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				g_object_unref (_data_->_async_result);
#line 382 "../lib/synapse-core/desktop-file-service.vala"
				return FALSE;
#line 4012 "desktop-file-service.c"
			}
#line 381 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_data_->d);
#line 4016 "desktop-file-service.c"
		}
#line 381 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_data_->_d_it);
#line 4020 "desktop-file-service.c"
	}
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->desktop_file_dirs);
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 361 "../lib/synapse-core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 361 "../lib/synapse-core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4034 "desktop-file-service.c"
		}
	}
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 361 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 4041 "desktop-file-service.c"
}

static gboolean
__lambda7_ (SynapseDesktopFileService* self)
{
	gboolean result = FALSE;
#line 404 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->timer_id = (guint) 0;
#line 405 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files (self, NULL, NULL);
#line 406 "../lib/synapse-core/desktop-file-service.vala"
	result = FALSE;
#line 406 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 4056 "desktop-file-service.c"
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((SynapseDesktopFileService*) self);
#line 403 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 4066 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self)
{
#line 397 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 398 "../lib/synapse-core/desktop-file-service.vala"
	g_signal_emit (self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL], 0);
#line 399 "../lib/synapse-core/desktop-file-service.vala"
	if (self->priv->timer_id != ((guint) 0)) {
#line 400 "../lib/synapse-core/desktop-file-service.vala"
		g_source_remove (self->priv->timer_id);
#line 4080 "desktop-file-service.c"
	}
#line 403 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
#line 4084 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = _data;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceReloadDesktopFilesData, _data_);
#line 4096 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceReloadDesktopFilesData);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_reload_desktop_files_data_free);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
#line 4118 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                          GAsyncResult* _res_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4128 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
#line 4145 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_)
{
#line 410 "../lib/synapse-core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 410 "../lib/synapse-core/desktop-file-service.vala"
		case 0:
#line 4155 "desktop-file-service.c"
		goto _state_0;
#line 410 "../lib/synapse-core/desktop-file-service.vala"
		case 1:
#line 4159 "desktop-file-service.c"
		goto _state_1;
		default:
#line 410 "../lib/synapse-core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 4164 "desktop-file-service.c"
	}
	_state_0:
#line 411 "../lib/synapse-core/desktop-file-service.vala"
	g_debug ("desktop-file-service.vala:411: Reloading desktop files...");
#line 412 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp0_ = _data_->self->priv->all_desktop_files;
#line 412 "../lib/synapse-core/desktop-file-service.vala"
	gee_collection_clear ((GeeCollection*) _data_->_tmp0_);
#line 413 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->self->priv->non_hidden_desktop_files;
#line 413 "../lib/synapse-core/desktop-file-service.vala"
	gee_collection_clear ((GeeCollection*) _data_->_tmp1_);
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_state_ = 1;
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_reload_desktop_files_ready, _data_);
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 4183 "desktop-file-service.c"
	_state_1:
#line 414 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
#line 416 "../lib/synapse-core/desktop-file-service.vala"
	g_signal_emit (_data_->self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL], 0);
#line 410 "../lib/synapse-core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 410 "../lib/synapse-core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 410 "../lib/synapse-core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 410 "../lib/synapse-core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4197 "desktop-file-service.c"
		}
	}
#line 410 "../lib/synapse-core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 410 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 4204 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = _data;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadDesktopFileData, _data_);
#line 4220 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                GFile* file,
                                                const gchar* id_prefix,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadDesktopFileData);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_desktop_file_data_free);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->file = _tmp1_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = g_strdup (id_prefix);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->id_prefix = _tmp2_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_desktop_file_co (_data_);
#line 4258 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4268 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_desktop_file_co (_data_);
#line 4285 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_)
{
#line 419 "../lib/synapse-core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 419 "../lib/synapse-core/desktop-file-service.vala"
		case 0:
#line 4295 "desktop-file-service.c"
		goto _state_0;
#line 419 "../lib/synapse-core/desktop-file-service.vala"
		case 1:
#line 4299 "desktop-file-service.c"
		goto _state_1;
		default:
#line 419 "../lib/synapse-core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 4304 "desktop-file-service.c"
	}
	_state_0:
	{
#line 421 "../lib/synapse-core/desktop-file-service.vala"
		_data_->file_contents_length1 = 0;
#line 421 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_file_contents_size_ = 0;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp0_ = NULL;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp1_ = 0;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_state_ = 1;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		g_file_load_contents_async (_data_->file, NULL, synapse_desktop_file_service_load_desktop_file_ready, _data_);
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 4322 "desktop-file-service.c"
		_state_1:
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp2_ = g_file_load_contents_finish (_data_->file, _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_, NULL, &_data_->_inner_error0_);
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->file_contents = _data_->_tmp0_;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->file_contents_length1 = _data_->_tmp1_;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_file_contents_size_ = _data_->file_contents_length1;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		_data_->success = _data_->_tmp2_;
#line 422 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 422 "../lib/synapse-core/desktop-file-service.vala"
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4340 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 423 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->success) {
#line 424 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp3_ = g_key_file_new ();
#line 424 "../lib/synapse-core/desktop-file-service.vala"
			_data_->keyfile = _data_->_tmp3_;
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp4_ = _data_->keyfile;
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp5_ = _data_->file_contents;
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp5__length1 = _data_->file_contents_length1;
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp6_ = _data_->file_contents;
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp6__length1 = _data_->file_contents_length1;
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			g_key_file_load_from_data (_data_->_tmp4_, (const gchar*) _data_->_tmp5_, (gsize) _data_->_tmp6__length1, 0, &_data_->_inner_error0_);
#line 425 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 425 "../lib/synapse-core/desktop-file-service.vala"
				_g_key_file_unref0 (_data_->keyfile);
#line 425 "../lib/synapse-core/desktop-file-service.vala"
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4367 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 428 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp7_ = g_file_get_basename (_data_->file);
#line 428 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp8_ = _data_->_tmp7_;
#line 428 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp9_ = g_strdup_printf ("%s%s", _data_->id_prefix, _data_->_tmp8_);
#line 428 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 428 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->_tmp8_);
#line 428 "../lib/synapse-core/desktop-file-service.vala"
			_data_->desktop_id = _data_->_tmp10_;
#line 429 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp11_ = _data_->desktop_id;
#line 429 "../lib/synapse-core/desktop-file-service.vala"
			if (synapse_desktop_file_service_get_list_has_desktop_id (_data_->self, _data_->_tmp11_)) {
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->desktop_id);
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				_g_key_file_unref0 (_data_->keyfile);
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				if (_data_->_state_ != 0) {
#line 430 "../lib/synapse-core/desktop-file-service.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 430 "../lib/synapse-core/desktop-file-service.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4400 "desktop-file-service.c"
					}
				}
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				g_object_unref (_data_->_async_result);
#line 430 "../lib/synapse-core/desktop-file-service.vala"
				return FALSE;
#line 4407 "desktop-file-service.c"
			}
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp12_ = g_file_get_path (_data_->file);
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp14_ = _data_->keyfile;
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp15_ = _data_->desktop_id;
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp16_ = synapse_desktop_file_info_new_for_keyfile (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_);
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->_tmp13_);
#line 433 "../lib/synapse-core/desktop-file-service.vala"
			_data_->dfi = _data_->_tmp17_;
#line 434 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp18_ = _data_->dfi;
#line 434 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp19_ = synapse_desktop_file_info_get_is_valid (_data_->_tmp18_);
#line 434 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 434 "../lib/synapse-core/desktop-file-service.vala"
			if (_data_->_tmp20_) {
#line 435 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp21_ = _data_->self->priv->all_desktop_files;
#line 435 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp22_ = _data_->dfi;
#line 435 "../lib/synapse-core/desktop-file-service.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp21_, _data_->_tmp22_);
#line 436 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp24_ = _data_->dfi;
#line 436 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp25_ = synapse_desktop_file_info_get_is_hidden (_data_->_tmp24_);
#line 436 "../lib/synapse-core/desktop-file-service.vala"
				_data_->_tmp26_ = _data_->_tmp25_;
#line 436 "../lib/synapse-core/desktop-file-service.vala"
				if (!_data_->_tmp26_) {
#line 436 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp27_ = _data_->self->priv->session_type;
#line 436 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp28_ = _data_->dfi;
#line 436 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp29_ = synapse_desktop_file_info_get_show_in (_data_->_tmp28_);
#line 436 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp30_ = _data_->_tmp29_;
#line 436 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp23_ = (_data_->_tmp30_ & _data_->_tmp27_) == _data_->_tmp27_;
#line 4457 "desktop-file-service.c"
				} else {
#line 436 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp23_ = FALSE;
#line 4461 "desktop-file-service.c"
				}
#line 436 "../lib/synapse-core/desktop-file-service.vala"
				if (_data_->_tmp23_) {
#line 437 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp31_ = _data_->self->priv->non_hidden_desktop_files;
#line 437 "../lib/synapse-core/desktop-file-service.vala"
					_data_->_tmp32_ = _data_->dfi;
#line 437 "../lib/synapse-core/desktop-file-service.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp31_, _data_->_tmp32_);
#line 4471 "desktop-file-service.c"
				}
			}
#line 423 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (_data_->dfi);
#line 423 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->desktop_id);
#line 423 "../lib/synapse-core/desktop-file-service.vala"
			_g_key_file_unref0 (_data_->keyfile);
#line 4480 "desktop-file-service.c"
		}
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4484 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_inner_error0_ = NULL;
#line 442 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp33_ = _data_->err;
#line 442 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp34_ = _data_->_tmp33_->message;
#line 442 "../lib/synapse-core/desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:442: %s", _data_->_tmp34_);
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		_g_error_free0 (_data_->err);
#line 4501 "desktop-file-service.c"
	}
	__finally0:
#line 420 "../lib/synapse-core/desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 420 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 4514 "desktop-file-service.c"
	}
#line 419 "../lib/synapse-core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 419 "../lib/synapse-core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 419 "../lib/synapse-core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 419 "../lib/synapse-core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4524 "desktop-file-service.c"
		}
	}
#line 419 "../lib/synapse-core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 419 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 4531 "desktop-file-service.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 4552 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GRegex* exec_re = NULL;
	GError* _inner_error0_ = NULL;
#line 446 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 448 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 448 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 448 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->mimetype_map = (GeeMap*) _tmp0_;
#line 450 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 450 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->exec_map);
#line 450 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->exec_map = (GeeMap*) _tmp1_;
#line 452 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 452 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->desktop_id_map);
#line 452 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->desktop_id_map = (GeeMap*) _tmp2_;
#line 4583 "desktop-file-service.c"
	{
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		_tmp4_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error0_);
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = _tmp4_;
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4594 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		_tmp5_ = _tmp3_;
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = NULL;
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 456 "../lib/synapse-core/desktop-file-service.vala"
		exec_re = _tmp5_;
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		_g_regex_unref0 (_tmp3_);
#line 4607 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		err = _inner_error0_;
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		_inner_error0_ = NULL;
#line 458 "../lib/synapse-core/desktop-file-service.vala"
		_tmp6_ = err;
#line 458 "../lib/synapse-core/desktop-file-service.vala"
		_tmp7_ = _tmp6_->message;
#line 458 "../lib/synapse-core/desktop-file-service.vala"
		g_critical ("desktop-file-service.vala:458: %s", _tmp7_);
#line 459 "../lib/synapse-core/desktop-file-service.vala"
		_g_error_free0 (err);
#line 459 "../lib/synapse-core/desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 459 "../lib/synapse-core/desktop-file-service.vala"
		return;
#line 4631 "desktop-file-service.c"
	}
	__finally0:
#line 455 "../lib/synapse-core/desktop-file-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		g_clear_error (&_inner_error0_);
#line 455 "../lib/synapse-core/desktop-file-service.vala"
		return;
#line 4644 "desktop-file-service.c"
	}
	{
		GeeList* _dfi_list = NULL;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		gint _dfi_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _dfi_index = 0;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_tmp8_ = self->priv->all_desktop_files;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_dfi_list = _tmp9_;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_tmp10_ = _dfi_list;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_tmp12_ = _tmp11_;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_dfi_size = _tmp12_;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_dfi_index = -1;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		while (TRUE) {
#line 4673 "desktop-file-service.c"
			gint _tmp13_;
			gint _tmp14_;
			SynapseDesktopFileInfo* dfi = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			gchar* exec = NULL;
			gchar* _tmp17_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			GeeList* exec_list = NULL;
			GeeMap* _tmp29_;
			const gchar* _tmp30_;
			gpointer _tmp31_;
			GeeList* _tmp32_;
			GeeList* _tmp37_;
			SynapseDesktopFileInfo* _tmp38_;
			gchar* _tmp39_ = NULL;
			SynapseDesktopFileInfo* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* desktop_id = NULL;
			gchar* _tmp48_;
			GeeMap* _tmp49_;
			const gchar* _tmp50_;
			SynapseDesktopFileInfo* _tmp51_;
			gboolean _tmp52_ = FALSE;
			SynapseDesktopFileInfo* _tmp53_;
			gboolean _tmp54_;
			gboolean _tmp55_;
			SynapseDesktopFileInfo* _tmp58_;
			gchar** _tmp59_;
			gint _tmp59__length1;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_dfi_index = _dfi_index + 1;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_tmp13_ = _dfi_index;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_tmp14_ = _dfi_size;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 462 "../lib/synapse-core/desktop-file-service.vala"
				break;
#line 4717 "desktop-file-service.c"
			}
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_tmp15_ = _dfi_list;
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_tmp16_ = gee_list_get (_tmp15_, _dfi_index);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			dfi = (SynapseDesktopFileInfo*) _tmp16_;
#line 463 "../lib/synapse-core/desktop-file-service.vala"
			_tmp17_ = g_strdup ("");
#line 463 "../lib/synapse-core/desktop-file-service.vala"
			exec = _tmp17_;
#line 4729 "desktop-file-service.c"
			{
				gchar* _tmp18_ = NULL;
				GRegex* _tmp19_;
				SynapseDesktopFileInfo* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp19_ = exec_re;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp20_ = dfi;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp21_ = synapse_desktop_file_info_get_exec (_tmp20_);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp22_ = _tmp21_;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp23_ = g_regex_replace_literal (_tmp19_, _tmp22_, (gssize) -1, 0, "", 0, &_inner_error0_);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp18_ = _tmp23_;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 4754 "desktop-file-service.c"
						goto __catch1_g_regex_error;
					}
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					_g_free0 (exec);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (dfi);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					_g_object_unref0 (_dfi_list);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					_g_regex_unref0 (exec_re);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					g_clear_error (&_inner_error0_);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
					return;
#line 4771 "desktop-file-service.c"
				}
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp24_ = _tmp18_;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_tmp18_ = NULL;
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (exec);
#line 465 "../lib/synapse-core/desktop-file-service.vala"
				exec = _tmp24_;
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp18_);
#line 4783 "desktop-file-service.c"
			}
			goto __finally1;
			__catch1_g_regex_error:
			{
				GError* err = NULL;
				GError* _tmp25_;
				const gchar* _tmp26_;
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				err = _inner_error0_;
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_inner_error0_ = NULL;
#line 467 "../lib/synapse-core/desktop-file-service.vala"
				_tmp25_ = err;
#line 467 "../lib/synapse-core/desktop-file-service.vala"
				_tmp26_ = _tmp25_->message;
#line 467 "../lib/synapse-core/desktop-file-service.vala"
				synapse_utils_logger_error ((GObject*) self, "%s", _tmp26_, NULL);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_g_error_free0 (err);
#line 4803 "desktop-file-service.c"
			}
			__finally1:
#line 464 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (exec);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_dfi_list);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				_g_regex_unref0 (exec_re);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				g_clear_error (&_inner_error0_);
#line 464 "../lib/synapse-core/desktop-file-service.vala"
				return;
#line 4822 "desktop-file-service.c"
			}
#line 469 "../lib/synapse-core/desktop-file-service.vala"
			_tmp27_ = exec;
#line 469 "../lib/synapse-core/desktop-file-service.vala"
			_tmp28_ = string_strip (_tmp27_);
#line 469 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (exec);
#line 469 "../lib/synapse-core/desktop-file-service.vala"
			exec = _tmp28_;
#line 471 "../lib/synapse-core/desktop-file-service.vala"
			_tmp29_ = self->priv->exec_map;
#line 471 "../lib/synapse-core/desktop-file-service.vala"
			_tmp30_ = exec;
#line 471 "../lib/synapse-core/desktop-file-service.vala"
			_tmp31_ = gee_map_get (_tmp29_, _tmp30_);
#line 471 "../lib/synapse-core/desktop-file-service.vala"
			exec_list = (GeeList*) _tmp31_;
#line 472 "../lib/synapse-core/desktop-file-service.vala"
			_tmp32_ = exec_list;
#line 472 "../lib/synapse-core/desktop-file-service.vala"
			if (_tmp32_ == NULL) {
#line 4844 "desktop-file-service.c"
				GeeArrayList* _tmp33_;
				GeeMap* _tmp34_;
				const gchar* _tmp35_;
				GeeList* _tmp36_;
#line 473 "../lib/synapse-core/desktop-file-service.vala"
				_tmp33_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 473 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (exec_list);
#line 473 "../lib/synapse-core/desktop-file-service.vala"
				exec_list = (GeeList*) _tmp33_;
#line 474 "../lib/synapse-core/desktop-file-service.vala"
				_tmp34_ = self->priv->exec_map;
#line 474 "../lib/synapse-core/desktop-file-service.vala"
				_tmp35_ = exec;
#line 474 "../lib/synapse-core/desktop-file-service.vala"
				_tmp36_ = exec_list;
#line 474 "../lib/synapse-core/desktop-file-service.vala"
				gee_map_set (_tmp34_, _tmp35_, _tmp36_);
#line 4863 "desktop-file-service.c"
			}
#line 476 "../lib/synapse-core/desktop-file-service.vala"
			_tmp37_ = exec_list;
#line 476 "../lib/synapse-core/desktop-file-service.vala"
			_tmp38_ = dfi;
#line 476 "../lib/synapse-core/desktop-file-service.vala"
			gee_collection_add ((GeeCollection*) _tmp37_, _tmp38_);
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp40_ = dfi;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp41_ = synapse_desktop_file_info_get_desktop_id (_tmp40_);
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp42_ = _tmp41_;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp43_ = g_strdup (_tmp42_);
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp39_ = _tmp43_;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			if (_tmp39_ == NULL) {
#line 4883 "desktop-file-service.c"
				SynapseDesktopFileInfo* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
				_tmp44_ = dfi;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
				_tmp45_ = synapse_desktop_file_info_get_filename (_tmp44_);
#line 479 "../lib/synapse-core/desktop-file-service.vala"
				_tmp46_ = _tmp45_;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
				_tmp47_ = g_path_get_basename (_tmp46_);
#line 479 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp39_);
#line 479 "../lib/synapse-core/desktop-file-service.vala"
				_tmp39_ = _tmp47_;
#line 4900 "desktop-file-service.c"
			}
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp48_ = _tmp39_;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			_tmp39_ = NULL;
#line 479 "../lib/synapse-core/desktop-file-service.vala"
			desktop_id = _tmp48_;
#line 480 "../lib/synapse-core/desktop-file-service.vala"
			_tmp49_ = self->priv->desktop_id_map;
#line 480 "../lib/synapse-core/desktop-file-service.vala"
			_tmp50_ = desktop_id;
#line 480 "../lib/synapse-core/desktop-file-service.vala"
			_tmp51_ = dfi;
#line 480 "../lib/synapse-core/desktop-file-service.vala"
			gee_map_set (_tmp49_, _tmp50_, _tmp51_);
#line 483 "../lib/synapse-core/desktop-file-service.vala"
			_tmp53_ = dfi;
#line 483 "../lib/synapse-core/desktop-file-service.vala"
			_tmp54_ = synapse_desktop_file_info_get_is_hidden (_tmp53_);
#line 483 "../lib/synapse-core/desktop-file-service.vala"
			_tmp55_ = _tmp54_;
#line 483 "../lib/synapse-core/desktop-file-service.vala"
			if (_tmp55_) {
#line 483 "../lib/synapse-core/desktop-file-service.vala"
				_tmp52_ = TRUE;
#line 4926 "desktop-file-service.c"
			} else {
				SynapseDesktopFileInfo* _tmp56_;
				gchar** _tmp57_;
				gint _tmp57__length1;
#line 483 "../lib/synapse-core/desktop-file-service.vala"
				_tmp56_ = dfi;
#line 483 "../lib/synapse-core/desktop-file-service.vala"
				_tmp57_ = _tmp56_->mime_types;
#line 483 "../lib/synapse-core/desktop-file-service.vala"
				_tmp57__length1 = _tmp56_->mime_types_length1;
#line 483 "../lib/synapse-core/desktop-file-service.vala"
				_tmp52_ = _tmp57_ == NULL;
#line 4939 "desktop-file-service.c"
			}
#line 483 "../lib/synapse-core/desktop-file-service.vala"
			if (_tmp52_) {
#line 484 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (desktop_id);
#line 484 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_tmp39_);
#line 484 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (exec_list);
#line 484 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (exec);
#line 484 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 484 "../lib/synapse-core/desktop-file-service.vala"
				continue;
#line 4955 "desktop-file-service.c"
			}
#line 487 "../lib/synapse-core/desktop-file-service.vala"
			_tmp58_ = dfi;
#line 487 "../lib/synapse-core/desktop-file-service.vala"
			_tmp59_ = _tmp58_->mime_types;
#line 487 "../lib/synapse-core/desktop-file-service.vala"
			_tmp59__length1 = _tmp58_->mime_types_length1;
#line 4963 "desktop-file-service.c"
			{
				gchar** mime_type_collection = NULL;
				gint mime_type_collection_length1 = 0;
				gint _mime_type_collection_size_ = 0;
				gint mime_type_it = 0;
#line 487 "../lib/synapse-core/desktop-file-service.vala"
				mime_type_collection = _tmp59_;
#line 487 "../lib/synapse-core/desktop-file-service.vala"
				mime_type_collection_length1 = _tmp59__length1;
#line 487 "../lib/synapse-core/desktop-file-service.vala"
				for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
#line 4975 "desktop-file-service.c"
					const gchar* mime_type = NULL;
#line 487 "../lib/synapse-core/desktop-file-service.vala"
					mime_type = mime_type_collection[mime_type_it];
#line 4979 "desktop-file-service.c"
					{
						GeeList* list = NULL;
						GeeMap* _tmp60_;
						const gchar* _tmp61_;
						gpointer _tmp62_;
						GeeList* _tmp63_;
						GeeList* _tmp68_;
						SynapseDesktopFileInfo* _tmp69_;
#line 488 "../lib/synapse-core/desktop-file-service.vala"
						_tmp60_ = self->priv->mimetype_map;
#line 488 "../lib/synapse-core/desktop-file-service.vala"
						_tmp61_ = mime_type;
#line 488 "../lib/synapse-core/desktop-file-service.vala"
						_tmp62_ = gee_map_get (_tmp60_, _tmp61_);
#line 488 "../lib/synapse-core/desktop-file-service.vala"
						list = (GeeList*) _tmp62_;
#line 489 "../lib/synapse-core/desktop-file-service.vala"
						_tmp63_ = list;
#line 489 "../lib/synapse-core/desktop-file-service.vala"
						if (_tmp63_ == NULL) {
#line 5000 "desktop-file-service.c"
							GeeArrayList* _tmp64_;
							GeeMap* _tmp65_;
							const gchar* _tmp66_;
							GeeList* _tmp67_;
#line 490 "../lib/synapse-core/desktop-file-service.vala"
							_tmp64_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 490 "../lib/synapse-core/desktop-file-service.vala"
							_g_object_unref0 (list);
#line 490 "../lib/synapse-core/desktop-file-service.vala"
							list = (GeeList*) _tmp64_;
#line 491 "../lib/synapse-core/desktop-file-service.vala"
							_tmp65_ = self->priv->mimetype_map;
#line 491 "../lib/synapse-core/desktop-file-service.vala"
							_tmp66_ = mime_type;
#line 491 "../lib/synapse-core/desktop-file-service.vala"
							_tmp67_ = list;
#line 491 "../lib/synapse-core/desktop-file-service.vala"
							gee_map_set (_tmp65_, _tmp66_, _tmp67_);
#line 5019 "desktop-file-service.c"
						}
#line 493 "../lib/synapse-core/desktop-file-service.vala"
						_tmp68_ = list;
#line 493 "../lib/synapse-core/desktop-file-service.vala"
						_tmp69_ = dfi;
#line 493 "../lib/synapse-core/desktop-file-service.vala"
						gee_collection_add ((GeeCollection*) _tmp68_, _tmp69_);
#line 487 "../lib/synapse-core/desktop-file-service.vala"
						_g_object_unref0 (list);
#line 5029 "desktop-file-service.c"
					}
				}
			}
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (desktop_id);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_tmp39_);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (exec_list);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (exec);
#line 462 "../lib/synapse-core/desktop-file-service.vala"
			_g_object_unref0 (dfi);
#line 5043 "desktop-file-service.c"
		}
#line 462 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_dfi_list);
#line 5047 "desktop-file-service.c"
	}
#line 446 "../lib/synapse-core/desktop-file-service.vala"
	_g_regex_unref0 (exec_re);
#line 5051 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = _data;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (_data_->fi);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadMimeParentsFromFileData, _data_);
#line 5065 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                          const gchar* fi,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	gchar* _tmp1_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadMimeParentsFromFileData);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_mime_parents_from_file_data_free);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = g_strdup (fi);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (_data_->fi);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_->fi = _tmp1_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
#line 5095 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 5105 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
#line 5122 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_)
{
#line 498 "../lib/synapse-core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 498 "../lib/synapse-core/desktop-file-service.vala"
		case 0:
#line 5132 "desktop-file-service.c"
		goto _state_0;
#line 498 "../lib/synapse-core/desktop-file-service.vala"
		case 1:
#line 5136 "desktop-file-service.c"
		goto _state_1;
#line 498 "../lib/synapse-core/desktop-file-service.vala"
		case 2:
#line 5140 "desktop-file-service.c"
		goto _state_2;
#line 498 "../lib/synapse-core/desktop-file-service.vala"
		case 3:
#line 5144 "desktop-file-service.c"
		goto _state_3;
		default:
#line 498 "../lib/synapse-core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 5149 "desktop-file-service.c"
	}
	_state_0:
#line 499 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp0_ = g_file_new_for_path (_data_->fi);
#line 499 "../lib/synapse-core/desktop-file-service.vala"
	_data_->file = _data_->_tmp0_;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->file;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	_data_->_state_ = 1;
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	synapse_utils_query_exists_async (_data_->_tmp1_, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 5164 "desktop-file-service.c"
	_state_1:
#line 500 "../lib/synapse-core/desktop-file-service.vala"
	_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 501 "../lib/synapse-core/desktop-file-service.vala"
	if (!_data_->exists) {
#line 502 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_data_->file);
#line 502 "../lib/synapse-core/desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 502 "../lib/synapse-core/desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 502 "../lib/synapse-core/desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 502 "../lib/synapse-core/desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5180 "desktop-file-service.c"
			}
		}
#line 502 "../lib/synapse-core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 502 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 5187 "desktop-file-service.c"
	}
	{
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp2_ = _data_->file;
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_state_ = 2;
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		g_file_read_async (_data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 5198 "desktop-file-service.c"
		_state_2:
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp3_ = g_file_read_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		_data_->fis = _data_->_tmp3_;
#line 506 "../lib/synapse-core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 5206 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 507 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp4_ = _data_->fis;
#line 507 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_tmp5_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp4_);
#line 507 "../lib/synapse-core/desktop-file-service.vala"
		_data_->dis = _data_->_tmp5_;
#line 508 "../lib/synapse-core/desktop-file-service.vala"
		_data_->line = NULL;
#line 509 "../lib/synapse-core/desktop-file-service.vala"
		_data_->mimes = NULL;
#line 509 "../lib/synapse-core/desktop-file-service.vala"
		_data_->mimes_length1 = 0;
#line 509 "../lib/synapse-core/desktop-file-service.vala"
		_data_->_mimes_size_ = _data_->mimes_length1;
#line 510 "../lib/synapse-core/desktop-file-service.vala"
		_data_->len = 0;
#line 512 "../lib/synapse-core/desktop-file-service.vala"
		while (TRUE) {
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp7_ = _data_->dis;
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_state_ = 3;
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			g_data_input_stream_read_line_async (_data_->_tmp7_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			return FALSE;
#line 5235 "desktop-file-service.c"
			_state_3:
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp8_ = g_data_input_stream_read_line_finish (_data_->_tmp7_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp6_ = _data_->_tmp8_;
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 513 "../lib/synapse-core/desktop-file-service.vala"
				_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 513 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->line);
#line 513 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->dis);
#line 513 "../lib/synapse-core/desktop-file-service.vala"
				_g_object_unref0 (_data_->fis);
#line 5251 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp9_ = _data_->_tmp6_;
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp6_ = NULL;
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->line);
#line 513 "../lib/synapse-core/desktop-file-service.vala"
			_data_->line = _data_->_tmp9_;
#line 514 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp10_ = _data_->line;
#line 514 "../lib/synapse-core/desktop-file-service.vala"
			if (_data_->_tmp10_ == NULL) {
#line 515 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 515 "../lib/synapse-core/desktop-file-service.vala"
				break;
#line 5270 "desktop-file-service.c"
			}
#line 517 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp11_ = _data_->line;
#line 517 "../lib/synapse-core/desktop-file-service.vala"
			if (g_str_has_prefix (_data_->_tmp11_, "#")) {
#line 518 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 518 "../lib/synapse-core/desktop-file-service.vala"
				continue;
#line 5280 "desktop-file-service.c"
			}
#line 520 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp12_ = _data_->line;
#line 520 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp14_ = _data_->_tmp13_ = g_strsplit (_data_->_tmp12_, " ", 0);
#line 520 "../lib/synapse-core/desktop-file-service.vala"
			_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 520 "../lib/synapse-core/desktop-file-service.vala"
			_data_->mimes = _data_->_tmp14_;
#line 520 "../lib/synapse-core/desktop-file-service.vala"
			_data_->mimes_length1 = _vala_array_length (_data_->_tmp13_);
#line 520 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_mimes_size_ = _data_->mimes_length1;
#line 521 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp15_ = _data_->mimes;
#line 521 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp15__length1 = _data_->mimes_length1;
#line 521 "../lib/synapse-core/desktop-file-service.vala"
			_data_->len = (gint) g_strv_length (_data_->_tmp15_);
#line 522 "../lib/synapse-core/desktop-file-service.vala"
			if (_data_->len != 2) {
#line 523 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 523 "../lib/synapse-core/desktop-file-service.vala"
				continue;
#line 5306 "desktop-file-service.c"
			}
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp16_ = _data_->mimes;
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp16__length1 = _data_->mimes_length1;
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp17_ = _data_->_tmp16_[0];
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp18_ = _data_->mimes;
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp18__length1 = _data_->mimes_length1;
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp19_ = _data_->_tmp18_[1];
#line 526 "../lib/synapse-core/desktop-file-service.vala"
			if (g_strcmp0 (_data_->_tmp17_, _data_->_tmp19_) == 0) {
#line 527 "../lib/synapse-core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 527 "../lib/synapse-core/desktop-file-service.vala"
				continue;
#line 5326 "desktop-file-service.c"
			}
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp20_ = _data_->self->priv->mimetype_parent_map;
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp21_ = _data_->mimes;
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp21__length1 = _data_->mimes_length1;
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp22_ = _data_->_tmp21_[0];
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp23_ = _data_->mimes;
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp23__length1 = _data_->mimes_length1;
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			_data_->_tmp24_ = _data_->_tmp23_[1];
#line 530 "../lib/synapse-core/desktop-file-service.vala"
			gee_multi_map_set (_data_->_tmp20_, _data_->_tmp22_, _data_->_tmp24_);
#line 512 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (_data_->_tmp6_);
#line 5346 "desktop-file-service.c"
		}
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		_g_free0 (_data_->line);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_data_->dis);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_data_->fis);
#line 5356 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 533 "../lib/synapse-core/desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:533: Can't read file.");
#line 5365 "desktop-file-service.c"
	}
	__finally0:
#line 505 "../lib/synapse-core/desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_data_->file);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 505 "../lib/synapse-core/desktop-file-service.vala"
		return FALSE;
#line 5380 "desktop-file-service.c"
	}
#line 498 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 498 "../lib/synapse-core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 498 "../lib/synapse-core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 498 "../lib/synapse-core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 498 "../lib/synapse-core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5392 "desktop-file-service.c"
		}
	}
#line 498 "../lib/synapse-core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 498 "../lib/synapse-core/desktop-file-service.vala"
	return FALSE;
#line 5399 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                               const gchar* mime,
                                               GeeSet* ret)
{
	GeeList* dfis = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeCollection* parents = NULL;
	GeeMultiMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
#line 537 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 537 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (mime != NULL);
#line 537 "../lib/synapse-core/desktop-file-service.vala"
	g_return_if_fail (ret != NULL);
#line 538 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->mimetype_map;
#line 538 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_map_get (_tmp0_, mime);
#line 538 "../lib/synapse-core/desktop-file-service.vala"
	dfis = (GeeList*) _tmp1_;
#line 539 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = dfis;
#line 539 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp2_ != NULL) {
#line 5431 "desktop-file-service.c"
		GeeList* _tmp3_;
#line 540 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = dfis;
#line 540 "../lib/synapse-core/desktop-file-service.vala"
		gee_collection_add_all ((GeeCollection*) ret, (GeeCollection*) _tmp3_);
#line 5437 "desktop-file-service.c"
	}
#line 543 "../lib/synapse-core/desktop-file-service.vala"
	_tmp4_ = self->priv->mimetype_parent_map;
#line 543 "../lib/synapse-core/desktop-file-service.vala"
	_tmp5_ = gee_multi_map_get (_tmp4_, mime);
#line 543 "../lib/synapse-core/desktop-file-service.vala"
	parents = _tmp5_;
#line 544 "../lib/synapse-core/desktop-file-service.vala"
	_tmp6_ = parents;
#line 544 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp6_ == NULL) {
#line 545 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (parents);
#line 545 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (dfis);
#line 545 "../lib/synapse-core/desktop-file-service.vala"
		return;
#line 5455 "desktop-file-service.c"
	}
	{
		GeeIterator* _parent_it = NULL;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
#line 547 "../lib/synapse-core/desktop-file-service.vala"
		_tmp7_ = parents;
#line 547 "../lib/synapse-core/desktop-file-service.vala"
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
#line 547 "../lib/synapse-core/desktop-file-service.vala"
		_parent_it = _tmp8_;
#line 547 "../lib/synapse-core/desktop-file-service.vala"
		while (TRUE) {
#line 5469 "desktop-file-service.c"
			GeeIterator* _tmp9_;
			gchar* parent = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
#line 547 "../lib/synapse-core/desktop-file-service.vala"
			_tmp9_ = _parent_it;
#line 547 "../lib/synapse-core/desktop-file-service.vala"
			if (!gee_iterator_next (_tmp9_)) {
#line 547 "../lib/synapse-core/desktop-file-service.vala"
				break;
#line 5481 "desktop-file-service.c"
			}
#line 547 "../lib/synapse-core/desktop-file-service.vala"
			_tmp10_ = _parent_it;
#line 547 "../lib/synapse-core/desktop-file-service.vala"
			_tmp11_ = gee_iterator_get (_tmp10_);
#line 547 "../lib/synapse-core/desktop-file-service.vala"
			parent = (gchar*) _tmp11_;
#line 548 "../lib/synapse-core/desktop-file-service.vala"
			_tmp12_ = parent;
#line 548 "../lib/synapse-core/desktop-file-service.vala"
			synapse_desktop_file_service_add_dfi_for_mime (self, _tmp12_, ret);
#line 547 "../lib/synapse-core/desktop-file-service.vala"
			_g_free0 (parent);
#line 5495 "desktop-file-service.c"
		}
#line 547 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_parent_it);
#line 5499 "desktop-file-service.c"
	}
#line 537 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (parents);
#line 537 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (dfis);
#line 5505 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result = NULL;
#line 553 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 554 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->non_hidden_desktop_files;
#line 554 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 554 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = _tmp1_;
#line 554 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp2_;
#line 554 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 5527 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result = NULL;
#line 559 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 560 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->all_desktop_files;
#line 560 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 560 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = _tmp1_;
#line 560 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp2_;
#line 560 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 5549 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                         const gchar* mime_type)
{
	GeeHashSet* dfi_set = NULL;
	GeeHashSet* _tmp0_;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp1_;
	GeeList* result = NULL;
#line 563 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 563 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 564 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 564 "../lib/synapse-core/desktop-file-service.vala"
	dfi_set = _tmp0_;
#line 565 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_add_dfi_for_mime (self, mime_type, (GeeSet*) dfi_set);
#line 566 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 566 "../lib/synapse-core/desktop-file-service.vala"
	ret = _tmp1_;
#line 567 "../lib/synapse-core/desktop-file-service.vala"
	gee_array_list_add_all (ret, (GeeCollection*) dfi_set);
#line 568 "../lib/synapse-core/desktop-file-service.vala"
	result = (GeeList*) ret;
#line 568 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (dfi_set);
#line 568 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 5583 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                         const gchar* exec)
{
	GeeList* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp4_;
	GeeList* result = NULL;
#line 571 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 571 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = self->priv->exec_map;
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = gee_map_get (_tmp1_, exec);
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = (GeeList*) _tmp2_;
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 5607 "desktop-file-service.c"
		GeeArrayList* _tmp3_;
#line 572 "../lib/synapse-core/desktop-file-service.vala"
		_tmp3_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 572 "../lib/synapse-core/desktop-file-service.vala"
		_g_object_unref0 (_tmp0_);
#line 572 "../lib/synapse-core/desktop-file-service.vala"
		_tmp0_ = (GeeList*) _tmp3_;
#line 5615 "desktop-file-service.c"
	}
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	_tmp4_ = _tmp0_;
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = NULL;
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	result = _tmp4_;
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (_tmp0_);
#line 572 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 5627 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                      const gchar* desktop_id)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	SynapseDesktopFileInfo* result = NULL;
#line 575 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 575 "../lib/synapse-core/desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 576 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = self->priv->desktop_id_map;
#line 576 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_map_get (_tmp0_, desktop_id);
#line 576 "../lib/synapse-core/desktop-file-service.vala"
	result = (SynapseDesktopFileInfo*) _tmp1_;
#line 576 "../lib/synapse-core/desktop-file-service.vala"
	return result;
#line 5649 "desktop-file-service.c"
}

static GObject *
synapse_desktop_file_service_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	SynapseUtilsAsyncOnce* _tmp4_;
#line 213 "../lib/synapse-core/desktop-file-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
#line 213 "../lib/synapse-core/desktop-file-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 213 "../lib/synapse-core/desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
#line 214 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_instance = self;
#line 216 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 216 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->directory_monitors);
#line 216 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->directory_monitors = (GeeList*) _tmp0_;
#line 217 "../lib/synapse-core/desktop-file-service.vala"
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 217 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->all_desktop_files);
#line 217 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->all_desktop_files = (GeeList*) _tmp1_;
#line 218 "../lib/synapse-core/desktop-file-service.vala"
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 218 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
#line 218 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->non_hidden_desktop_files = (GeeList*) _tmp2_;
#line 219 "../lib/synapse-core/desktop-file-service.vala"
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 219 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_parent_map);
#line 219 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->mimetype_parent_map = (GeeMultiMap*) _tmp3_;
#line 220 "../lib/synapse-core/desktop-file-service.vala"
	_tmp4_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
#line 220 "../lib/synapse-core/desktop-file-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 220 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->init_once = _tmp4_;
#line 222 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_initialize (self, NULL, NULL);
#line 213 "../lib/synapse-core/desktop-file-service.vala"
	return obj;
#line 5707 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass,
                                         gpointer klass_data)
{
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileService_private_offset);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL] = g_signal_new ("reload-started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL] = g_signal_new ("reload-done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5726 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self,
                                            gpointer klass)
{
	gchar* _tmp0_;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	self->priv = synapse_desktop_file_service_get_instance_private (self);
#line 248 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
#line 249 "../lib/synapse-core/desktop-file-service.vala"
	_tmp0_ = g_strdup ("GNOME");
#line 249 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->session_type_str = _tmp0_;
#line 392 "../lib/synapse-core/desktop-file-service.vala"
	self->priv->timer_id = (guint) 0;
#line 5744 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_finalize (GObject * obj)
{
	SynapseDesktopFileService * self;
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
#line 226 "../lib/synapse-core/desktop-file-service.vala"
	synapse_desktop_file_service_instance = NULL;
#line 196 "../lib/synapse-core/desktop-file-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 205 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->directory_monitors);
#line 206 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->all_desktop_files);
#line 207 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
#line 208 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 209 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->exec_map);
#line 210 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->desktop_id_map);
#line 211 "../lib/synapse-core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_parent_map);
#line 249 "../lib/synapse-core/desktop-file-service.vala"
	_g_free0 (self->priv->session_type_str);
#line 194 "../lib/synapse-core/desktop-file-service.vala"
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
#line 5775 "desktop-file-service.c"
}

static GType
synapse_desktop_file_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
	GType synapse_desktop_file_service_type_id;
	synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
	SynapseDesktopFileService_private_offset = g_type_add_instance_private (synapse_desktop_file_service_type_id, sizeof (SynapseDesktopFileServicePrivate));
	return synapse_desktop_file_service_type_id;
}

GType
synapse_desktop_file_service_get_type (void)
{
	static volatile gsize synapse_desktop_file_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__volatile)) {
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = synapse_desktop_file_service_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_service_type_id__volatile, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5807 "desktop-file-service.c"
		gint i;
#line 284 "../lib/synapse-core/data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 284 "../lib/synapse-core/data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 284 "../lib/synapse-core/data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5815 "desktop-file-service.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 284 "../lib/synapse-core/data-sink.vala"
	g_free (array);
#line 5830 "desktop-file-service.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 284 "../lib/synapse-core/data-sink.vala"
	if (array) {
#line 284 "../lib/synapse-core/data-sink.vala"
		while (((gpointer*) array)[length]) {
#line 284 "../lib/synapse-core/data-sink.vala"
			length++;
#line 5844 "desktop-file-service.c"
		}
	}
#line 284 "../lib/synapse-core/data-sink.vala"
	return length;
#line 5849 "desktop-file-service.c"
}

