/* result-set.c generated by valac 0.48.13, the Vala compiler
 * generated from result-set.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;
typedef struct _SynapseResultSetPrivate SynapseResultSetPrivate;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT,
	SYNAPSE_MATCH_TYPE_INTERNET
} SynapseMatchType;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
enum  {
	SYNAPSE_RESULT_SET_0_PROPERTY,
	SYNAPSE_RESULT_SET_ELEMENT_TYPE_PROPERTY,
	SYNAPSE_RESULT_SET_SIZE_PROPERTY,
	SYNAPSE_RESULT_SET_KEYS_PROPERTY,
	SYNAPSE_RESULT_SET_ENTRIES_PROPERTY,
	SYNAPSE_RESULT_SET_NUM_PROPERTIES
};
static GParamSpec* synapse_result_set_properties[SYNAPSE_RESULT_SET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseResultSet {
	GObject parent_instance;
	SynapseResultSetPrivate * priv;
	GeeMap* matches;
	GeeSet* uris;
};

struct _SynapseResultSetClass {
	GObjectClass parent_class;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

static gpointer synapse_result_set_parent_class = NULL;
static GeeTraversableIface * synapse_result_set_gee_traversable_parent_iface = NULL;
static GeeIterableIface * synapse_result_set_gee_iterable_parent_iface = NULL;

GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
static GeeIterator* synapse_result_set_real_iterator (GeeIterable* base);
static gboolean synapse_result_set_real_foreach (GeeTraversable* base,
                                          GeeForallFunc func,
                                          gpointer func_target);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_result_set_add_all (SynapseResultSet* self,
                                 SynapseResultSet* rs);
gboolean synapse_result_set_contains_uri (SynapseResultSet* self,
                                          const gchar* uri);
GeeList* synapse_result_set_get_sorted_list (SynapseResultSet* self);
static gint __lambda4_ (SynapseResultSet* self,
                 GeeMapEntry* a,
                 GeeMapEntry* b);
const gchar* synapse_match_get_title (SynapseMatch* self);
static gint ___lambda4__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
gint synapse_result_set_get_size (SynapseResultSet* self);
GeeSet* synapse_result_set_get_keys (SynapseResultSet* self);
GeeSet* synapse_result_set_get_entries (SynapseResultSet* self);
static GObject * synapse_result_set_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void synapse_result_set_finalize (GObject * obj);
static GType synapse_result_set_get_type_once (void);
static void _vala_synapse_result_set_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);

SynapseResultSet*
synapse_result_set_construct (GType object_type)
{
	SynapseResultSet * self = NULL;
#line 29 "../lib/synapse-core/result-set.vala"
	self = (SynapseResultSet*) g_object_new (object_type, NULL);
#line 28 "../lib/synapse-core/result-set.vala"
	return self;
#line 195 "result-set.c"
}

SynapseResultSet*
synapse_result_set_new (void)
{
#line 28 "../lib/synapse-core/result-set.vala"
	return synapse_result_set_construct (SYNAPSE_TYPE_RESULT_SET);
#line 203 "result-set.c"
}

static GeeIterator*
synapse_result_set_real_iterator (GeeIterable* base)
{
	SynapseResultSet * self;
	GeeMap* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result = NULL;
#line 46 "../lib/synapse-core/result-set.vala"
	self = (SynapseResultSet*) base;
#line 46 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 46 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 46 "../lib/synapse-core/result-set.vala"
	result = _tmp1_;
#line 46 "../lib/synapse-core/result-set.vala"
	return result;
#line 223 "result-set.c"
}

static gboolean
synapse_result_set_real_foreach (GeeTraversable* base,
                                 GeeForallFunc func,
                                 gpointer func_target)
{
	SynapseResultSet * self;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gboolean _tmp4_;
	gboolean result = FALSE;
#line 48 "../lib/synapse-core/result-set.vala"
	self = (SynapseResultSet*) base;
#line 48 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 48 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_map_get_keys (_tmp0_);
#line 48 "../lib/synapse-core/result-set.vala"
	_tmp2_ = _tmp1_;
#line 48 "../lib/synapse-core/result-set.vala"
	_tmp3_ = _tmp2_;
#line 48 "../lib/synapse-core/result-set.vala"
	_tmp4_ = gee_traversable_foreach ((GeeTraversable*) _tmp3_, func, func_target);
#line 48 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (_tmp3_);
#line 48 "../lib/synapse-core/result-set.vala"
	result = _tmp4_;
#line 48 "../lib/synapse-core/result-set.vala"
	return result;
#line 256 "result-set.c"
}

void
synapse_result_set_add (SynapseResultSet* self,
                        SynapseMatch* match,
                        gint relevancy)
{
	GeeMap* _tmp0_;
#line 50 "../lib/synapse-core/result-set.vala"
	g_return_if_fail (self != NULL);
#line 50 "../lib/synapse-core/result-set.vala"
	g_return_if_fail (match != NULL);
#line 51 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 51 "../lib/synapse-core/result-set.vala"
	gee_map_set (_tmp0_, match, (gpointer) ((gintptr) relevancy));
#line 53 "../lib/synapse-core/result-set.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 275 "result-set.c"
		const gchar* uri = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
#line 54 "../lib/synapse-core/result-set.vala"
		_tmp1_ = synapse_uri_match_get_uri (SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL);
#line 54 "../lib/synapse-core/result-set.vala"
		_tmp2_ = _tmp1_;
#line 54 "../lib/synapse-core/result-set.vala"
		uri = _tmp2_;
#line 55 "../lib/synapse-core/result-set.vala"
		_tmp4_ = uri;
#line 55 "../lib/synapse-core/result-set.vala"
		if (_tmp4_ != NULL) {
#line 291 "result-set.c"
			const gchar* _tmp5_;
#line 55 "../lib/synapse-core/result-set.vala"
			_tmp5_ = uri;
#line 55 "../lib/synapse-core/result-set.vala"
			_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 297 "result-set.c"
		} else {
#line 55 "../lib/synapse-core/result-set.vala"
			_tmp3_ = FALSE;
#line 301 "result-set.c"
		}
#line 55 "../lib/synapse-core/result-set.vala"
		if (_tmp3_) {
#line 305 "result-set.c"
			GeeSet* _tmp6_;
			const gchar* _tmp7_;
#line 56 "../lib/synapse-core/result-set.vala"
			_tmp6_ = self->uris;
#line 56 "../lib/synapse-core/result-set.vala"
			_tmp7_ = uri;
#line 56 "../lib/synapse-core/result-set.vala"
			gee_collection_add ((GeeCollection*) _tmp6_, _tmp7_);
#line 314 "result-set.c"
		}
	}
}

void
synapse_result_set_add_all (SynapseResultSet* self,
                            SynapseResultSet* rs)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
#line 61 "../lib/synapse-core/result-set.vala"
	g_return_if_fail (self != NULL);
#line 62 "../lib/synapse-core/result-set.vala"
	if (rs == NULL) {
#line 63 "../lib/synapse-core/result-set.vala"
		return;
#line 333 "result-set.c"
	}
#line 65 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 65 "../lib/synapse-core/result-set.vala"
	_tmp1_ = rs->matches;
#line 65 "../lib/synapse-core/result-set.vala"
	gee_map_set_all (_tmp0_, _tmp1_);
#line 66 "../lib/synapse-core/result-set.vala"
	_tmp2_ = self->uris;
#line 66 "../lib/synapse-core/result-set.vala"
	_tmp3_ = rs->uris;
#line 66 "../lib/synapse-core/result-set.vala"
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp3_);
#line 347 "result-set.c"
}

gboolean
synapse_result_set_contains_uri (SynapseResultSet* self,
                                 const gchar* uri)
{
	GeeSet* _tmp0_;
	gboolean result = FALSE;
#line 69 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 69 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 70 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->uris;
#line 70 "../lib/synapse-core/result-set.vala"
	result = gee_collection_contains ((GeeCollection*) _tmp0_, uri);
#line 70 "../lib/synapse-core/result-set.vala"
	return result;
#line 366 "result-set.c"
}

static gint
__lambda4_ (SynapseResultSet* self,
            GeeMapEntry* a,
            GeeMapEntry* b)
{
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gint relevancy_delta = 0;
	GeeMapEntry* _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	GeeMapEntry* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	gint result = 0;
#line 77 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 77 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 78 "../lib/synapse-core/result-set.vala"
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 79 "../lib/synapse-core/result-set.vala"
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 80 "../lib/synapse-core/result-set.vala"
	_tmp0_ = e2;
#line 80 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_map_entry_get_value (_tmp0_);
#line 80 "../lib/synapse-core/result-set.vala"
	_tmp2_ = _tmp1_;
#line 80 "../lib/synapse-core/result-set.vala"
	_tmp3_ = e1;
#line 80 "../lib/synapse-core/result-set.vala"
	_tmp4_ = gee_map_entry_get_value (_tmp3_);
#line 80 "../lib/synapse-core/result-set.vala"
	_tmp5_ = _tmp4_;
#line 80 "../lib/synapse-core/result-set.vala"
	relevancy_delta = ((gint) ((gintptr) _tmp2_)) - ((gint) ((gintptr) _tmp5_));
#line 81 "../lib/synapse-core/result-set.vala"
	if (relevancy_delta != 0) {
#line 82 "../lib/synapse-core/result-set.vala"
		result = relevancy_delta;
#line 82 "../lib/synapse-core/result-set.vala"
		return result;
#line 412 "result-set.c"
	} else {
		GeeMapEntry* _tmp6_;
		gconstpointer _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GeeMapEntry* _tmp11_;
		gconstpointer _tmp12_;
		gconstpointer _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp6_ = e1;
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp7_ = gee_map_entry_get_key (_tmp6_);
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp8_ = _tmp7_;
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp9_ = synapse_match_get_title ((SynapseMatch*) _tmp8_);
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp10_ = _tmp9_;
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp11_ = e2;
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp12_ = gee_map_entry_get_key (_tmp11_);
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp13_ = _tmp12_;
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp14_ = synapse_match_get_title ((SynapseMatch*) _tmp13_);
#line 85 "../lib/synapse-core/result-set.vala"
		_tmp15_ = _tmp14_;
#line 85 "../lib/synapse-core/result-set.vala"
		result = g_ascii_strcasecmp (_tmp10_, _tmp15_);
#line 85 "../lib/synapse-core/result-set.vala"
		return result;
#line 448 "result-set.c"
	}
}

static gint
___lambda4__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda4_ ((SynapseResultSet*) self, (GeeMapEntry*) a, (GeeMapEntry*) b);
#line 77 "../lib/synapse-core/result-set.vala"
	return result;
#line 461 "result-set.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 89 "../lib/synapse-core/result-set.vala"
	return self ? g_object_ref (self) : NULL;
#line 469 "result-set.c"
}

GeeList*
synapse_result_set_get_sorted_list (SynapseResultSet* self)
{
	GeeArrayList* l = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* sorted_list = NULL;
	GeeArrayList* _tmp7_;
	GeeList* result = NULL;
#line 73 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 74 "../lib/synapse-core/result-set.vala"
	_tmp0_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 74 "../lib/synapse-core/result-set.vala"
	l = _tmp0_;
#line 75 "../lib/synapse-core/result-set.vala"
	_tmp1_ = l;
#line 75 "../lib/synapse-core/result-set.vala"
	_tmp2_ = self->matches;
#line 75 "../lib/synapse-core/result-set.vala"
	_tmp3_ = gee_map_get_entries (_tmp2_);
#line 75 "../lib/synapse-core/result-set.vala"
	_tmp4_ = _tmp3_;
#line 75 "../lib/synapse-core/result-set.vala"
	_tmp5_ = _tmp4_;
#line 75 "../lib/synapse-core/result-set.vala"
	gee_array_list_add_all (_tmp1_, (GeeCollection*) _tmp5_);
#line 75 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (_tmp5_);
#line 77 "../lib/synapse-core/result-set.vala"
	_tmp6_ = l;
#line 77 "../lib/synapse-core/result-set.vala"
	gee_list_sort ((GeeList*) _tmp6_, ___lambda4__gcompare_data_func, g_object_ref (self), g_object_unref);
#line 88 "../lib/synapse-core/result-set.vala"
	_tmp7_ = gee_array_list_new (SYNAPSE_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 88 "../lib/synapse-core/result-set.vala"
	sorted_list = _tmp7_;
#line 514 "result-set.c"
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _m_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _m_index = 0;
#line 89 "../lib/synapse-core/result-set.vala"
		_tmp8_ = l;
#line 89 "../lib/synapse-core/result-set.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 89 "../lib/synapse-core/result-set.vala"
		_m_list = _tmp9_;
#line 89 "../lib/synapse-core/result-set.vala"
		_tmp10_ = _m_list;
#line 89 "../lib/synapse-core/result-set.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
#line 89 "../lib/synapse-core/result-set.vala"
		_tmp12_ = _tmp11_;
#line 89 "../lib/synapse-core/result-set.vala"
		_m_size = _tmp12_;
#line 89 "../lib/synapse-core/result-set.vala"
		_m_index = -1;
#line 89 "../lib/synapse-core/result-set.vala"
		while (TRUE) {
#line 542 "result-set.c"
			gint _tmp13_;
			gint _tmp14_;
			GeeMapEntry* m = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			GeeArrayList* _tmp17_;
			GeeMapEntry* _tmp18_;
			gconstpointer _tmp19_;
			gconstpointer _tmp20_;
#line 89 "../lib/synapse-core/result-set.vala"
			_m_index = _m_index + 1;
#line 89 "../lib/synapse-core/result-set.vala"
			_tmp13_ = _m_index;
#line 89 "../lib/synapse-core/result-set.vala"
			_tmp14_ = _m_size;
#line 89 "../lib/synapse-core/result-set.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 89 "../lib/synapse-core/result-set.vala"
				break;
#line 562 "result-set.c"
			}
#line 89 "../lib/synapse-core/result-set.vala"
			_tmp15_ = _m_list;
#line 89 "../lib/synapse-core/result-set.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _m_index);
#line 89 "../lib/synapse-core/result-set.vala"
			m = (GeeMapEntry*) _tmp16_;
#line 90 "../lib/synapse-core/result-set.vala"
			_tmp17_ = sorted_list;
#line 90 "../lib/synapse-core/result-set.vala"
			_tmp18_ = m;
#line 90 "../lib/synapse-core/result-set.vala"
			_tmp19_ = gee_map_entry_get_key (_tmp18_);
#line 90 "../lib/synapse-core/result-set.vala"
			_tmp20_ = _tmp19_;
#line 90 "../lib/synapse-core/result-set.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, (SynapseMatch*) _tmp20_);
#line 89 "../lib/synapse-core/result-set.vala"
			_g_object_unref0 (m);
#line 582 "result-set.c"
		}
#line 89 "../lib/synapse-core/result-set.vala"
		_g_object_unref0 (_m_list);
#line 586 "result-set.c"
	}
#line 93 "../lib/synapse-core/result-set.vala"
	result = (GeeList*) sorted_list;
#line 93 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (l);
#line 93 "../lib/synapse-core/result-set.vala"
	return result;
#line 594 "result-set.c"
}

static GType
synapse_result_set_real_get_element_type (GeeTraversable* base)
{
	GType result;
	SynapseResultSet* self;
	GeeMap* _tmp0_;
	GType _tmp1_;
	GType _tmp2_;
#line 38 "../lib/synapse-core/result-set.vala"
	self = (SynapseResultSet*) base;
#line 38 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 38 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp0_);
#line 38 "../lib/synapse-core/result-set.vala"
	_tmp2_ = _tmp1_;
#line 38 "../lib/synapse-core/result-set.vala"
	result = _tmp2_;
#line 38 "../lib/synapse-core/result-set.vala"
	return result;
#line 617 "result-set.c"
}

gint
synapse_result_set_get_size (SynapseResultSet* self)
{
	gint result;
	GeeMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 40 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 40 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_map_get_size (_tmp0_);
#line 40 "../lib/synapse-core/result-set.vala"
	_tmp2_ = _tmp1_;
#line 40 "../lib/synapse-core/result-set.vala"
	result = _tmp2_;
#line 40 "../lib/synapse-core/result-set.vala"
	return result;
#line 639 "result-set.c"
}

GeeSet*
synapse_result_set_get_keys (SynapseResultSet* self)
{
	GeeSet* result;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
#line 42 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 42 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_map_get_keys (_tmp0_);
#line 42 "../lib/synapse-core/result-set.vala"
	_tmp2_ = _tmp1_;
#line 42 "../lib/synapse-core/result-set.vala"
	result = _tmp2_;
#line 42 "../lib/synapse-core/result-set.vala"
	return result;
#line 661 "result-set.c"
}

GeeSet*
synapse_result_set_get_entries (SynapseResultSet* self)
{
	GeeSet* result;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
#line 44 "../lib/synapse-core/result-set.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../lib/synapse-core/result-set.vala"
	_tmp0_ = self->matches;
#line 44 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_map_get_entries (_tmp0_);
#line 44 "../lib/synapse-core/result-set.vala"
	_tmp2_ = _tmp1_;
#line 44 "../lib/synapse-core/result-set.vala"
	result = _tmp2_;
#line 44 "../lib/synapse-core/result-set.vala"
	return result;
#line 683 "result-set.c"
}

static GObject *
synapse_result_set_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseResultSet * self;
	GeeHashMap* _tmp0_;
	GeeHashSet* _tmp1_;
#line 32 "../lib/synapse-core/result-set.vala"
	parent_class = G_OBJECT_CLASS (synapse_result_set_parent_class);
#line 32 "../lib/synapse-core/result-set.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 32 "../lib/synapse-core/result-set.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RESULT_SET, SynapseResultSet);
#line 33 "../lib/synapse-core/result-set.vala"
	_tmp0_ = gee_hash_map_new (SYNAPSE_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 33 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (self->matches);
#line 33 "../lib/synapse-core/result-set.vala"
	self->matches = (GeeMap*) _tmp0_;
#line 35 "../lib/synapse-core/result-set.vala"
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 35 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (self->uris);
#line 35 "../lib/synapse-core/result-set.vala"
	self->uris = (GeeSet*) _tmp1_;
#line 32 "../lib/synapse-core/result-set.vala"
	return obj;
#line 716 "result-set.c"
}

static void
synapse_result_set_class_init (SynapseResultSetClass * klass,
                               gpointer klass_data)
{
#line 24 "../lib/synapse-core/result-set.vala"
	synapse_result_set_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-core/result-set.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_result_set_get_property;
#line 24 "../lib/synapse-core/result-set.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_result_set_constructor;
#line 24 "../lib/synapse-core/result-set.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_result_set_finalize;
#line 24 "../lib/synapse-core/result-set.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_RESULT_SET_ELEMENT_TYPE_PROPERTY, synapse_result_set_properties[SYNAPSE_RESULT_SET_ELEMENT_TYPE_PROPERTY] = g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 24 "../lib/synapse-core/result-set.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_RESULT_SET_SIZE_PROPERTY, synapse_result_set_properties[SYNAPSE_RESULT_SET_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 24 "../lib/synapse-core/result-set.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_RESULT_SET_KEYS_PROPERTY, synapse_result_set_properties[SYNAPSE_RESULT_SET_KEYS_PROPERTY] = g_param_spec_object ("keys", "keys", "keys", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 24 "../lib/synapse-core/result-set.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_RESULT_SET_ENTRIES_PROPERTY, synapse_result_set_properties[SYNAPSE_RESULT_SET_ENTRIES_PROPERTY] = g_param_spec_object ("entries", "entries", "entries", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 739 "result-set.c"
}

static GType
synapse_result_set_gee_traversable_get_g_type (SynapseResultSet* self)
{
#line 24 "../lib/synapse-core/result-set.vala"
	return SYNAPSE_TYPE_MATCH;
#line 747 "result-set.c"
}

static GBoxedCopyFunc
synapse_result_set_gee_traversable_get_g_dup_func (SynapseResultSet* self)
{
#line 24 "../lib/synapse-core/result-set.vala"
	return g_object_ref;
#line 755 "result-set.c"
}

static GDestroyNotify
synapse_result_set_gee_traversable_get_g_destroy_func (SynapseResultSet* self)
{
#line 24 "../lib/synapse-core/result-set.vala"
	return g_object_unref;
#line 763 "result-set.c"
}

static void
synapse_result_set_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                   gpointer iface_data)
{
#line 24 "../lib/synapse-core/result-set.vala"
	synapse_result_set_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-core/result-set.vala"
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) synapse_result_set_real_foreach;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_g_type = (GType (*) (GeeTraversable *)) synapse_result_set_gee_traversable_get_g_type;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) synapse_result_set_gee_traversable_get_g_dup_func;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) synapse_result_set_gee_traversable_get_g_destroy_func;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_element_type = synapse_result_set_real_get_element_type;
#line 782 "result-set.c"
}

static GType
synapse_result_set_gee_iterable_get_g_type (SynapseResultSet* self)
{
#line 24 "../lib/synapse-core/result-set.vala"
	return GEE_MAP_TYPE_ENTRY;
#line 790 "result-set.c"
}

static GBoxedCopyFunc
synapse_result_set_gee_iterable_get_g_dup_func (SynapseResultSet* self)
{
#line 24 "../lib/synapse-core/result-set.vala"
	return g_object_ref;
#line 798 "result-set.c"
}

static GDestroyNotify
synapse_result_set_gee_iterable_get_g_destroy_func (SynapseResultSet* self)
{
#line 24 "../lib/synapse-core/result-set.vala"
	return g_object_unref;
#line 806 "result-set.c"
}

static void
synapse_result_set_gee_iterable_interface_init (GeeIterableIface * iface,
                                                gpointer iface_data)
{
#line 24 "../lib/synapse-core/result-set.vala"
	synapse_result_set_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-core/result-set.vala"
	iface->iterator = (GeeIterator* (*) (GeeIterable*)) synapse_result_set_real_iterator;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_g_type = (GType (*) (GeeIterable *)) synapse_result_set_gee_iterable_get_g_type;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeIterable *)) synapse_result_set_gee_iterable_get_g_dup_func;
#line 24 "../lib/synapse-core/result-set.vala"
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeIterable *)) synapse_result_set_gee_iterable_get_g_destroy_func;
#line 823 "result-set.c"
}

static void
synapse_result_set_instance_init (SynapseResultSet * self,
                                  gpointer klass)
{
}

static void
synapse_result_set_finalize (GObject * obj)
{
	SynapseResultSet * self;
#line 24 "../lib/synapse-core/result-set.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RESULT_SET, SynapseResultSet);
#line 25 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (self->matches);
#line 26 "../lib/synapse-core/result-set.vala"
	_g_object_unref0 (self->uris);
#line 24 "../lib/synapse-core/result-set.vala"
	G_OBJECT_CLASS (synapse_result_set_parent_class)->finalize (obj);
#line 844 "result-set.c"
}

static GType
synapse_result_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseResultSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_result_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseResultSet), 0, (GInstanceInitFunc) synapse_result_set_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) synapse_result_set_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) synapse_result_set_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_result_set_type_id;
	synapse_result_set_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseResultSet", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_result_set_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (synapse_result_set_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
	return synapse_result_set_type_id;
}

GType
synapse_result_set_get_type (void)
{
	static volatile gsize synapse_result_set_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_result_set_type_id__volatile)) {
		GType synapse_result_set_type_id;
		synapse_result_set_type_id = synapse_result_set_get_type_once ();
		g_once_init_leave (&synapse_result_set_type_id__volatile, synapse_result_set_type_id);
	}
	return synapse_result_set_type_id__volatile;
}

static void
_vala_synapse_result_set_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SynapseResultSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_RESULT_SET, SynapseResultSet);
#line 24 "../lib/synapse-core/result-set.vala"
	switch (property_id) {
#line 24 "../lib/synapse-core/result-set.vala"
		case SYNAPSE_RESULT_SET_ELEMENT_TYPE_PROPERTY:
#line 24 "../lib/synapse-core/result-set.vala"
		g_value_set_gtype (value, gee_traversable_get_element_type ((GeeTraversable*) self));
#line 24 "../lib/synapse-core/result-set.vala"
		break;
#line 24 "../lib/synapse-core/result-set.vala"
		case SYNAPSE_RESULT_SET_SIZE_PROPERTY:
#line 24 "../lib/synapse-core/result-set.vala"
		g_value_set_int (value, synapse_result_set_get_size (self));
#line 24 "../lib/synapse-core/result-set.vala"
		break;
#line 24 "../lib/synapse-core/result-set.vala"
		case SYNAPSE_RESULT_SET_KEYS_PROPERTY:
#line 24 "../lib/synapse-core/result-set.vala"
		g_value_take_object (value, synapse_result_set_get_keys (self));
#line 24 "../lib/synapse-core/result-set.vala"
		break;
#line 24 "../lib/synapse-core/result-set.vala"
		case SYNAPSE_RESULT_SET_ENTRIES_PROPERTY:
#line 24 "../lib/synapse-core/result-set.vala"
		g_value_take_object (value, synapse_result_set_get_entries (self));
#line 24 "../lib/synapse-core/result-set.vala"
		break;
#line 906 "result-set.c"
		default:
#line 24 "../lib/synapse-core/result-set.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-core/result-set.vala"
		break;
#line 912 "result-set.c"
	}
}

