/* utils.c generated by valac 0.48.13, the Vala compiler
 * generated from utils.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdarg.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseUtilsQueryExistsAsyncData SynapseUtilsQueryExistsAsyncData;

#define SYNAPSE_UTILS_TYPE_LOGGER (synapse_utils_logger_get_type ())
#define SYNAPSE_UTILS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger))
#define SYNAPSE_UTILS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))
#define SYNAPSE_UTILS_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))

typedef struct _SynapseUtilsLogger SynapseUtilsLogger;
typedef struct _SynapseUtilsLoggerClass SynapseUtilsLoggerClass;
typedef struct _SynapseUtilsLoggerPrivate SynapseUtilsLoggerPrivate;
typedef struct _SynapseUtilsParamSpecLogger SynapseUtilsParamSpecLogger;
typedef struct _SynapseUtilsDelegateWrapper SynapseUtilsDelegateWrapper;

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
typedef struct _SynapseUtilsAsyncOncePrivate SynapseUtilsAsyncOncePrivate;
typedef enum  {
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED,
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS,
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE
} SynapseUtilsAsyncOnceOperationState;

#define SYNAPSE_UTILS_ASYNC_ONCE_TYPE_OPERATION_STATE (synapse_utils_async_once_operation_state_get_type ())
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseUtilsAsyncOnceEnterData SynapseUtilsAsyncOnceEnterData;
typedef struct _SynapseUtilsAsyncOnceWaitAsyncData SynapseUtilsAsyncOnceWaitAsyncData;
typedef struct _SynapseUtilsParamSpecAsyncOnce SynapseUtilsParamSpecAsyncOnce;

#define SYNAPSE_UTILS_TYPE_FILE_INFO (synapse_utils_file_info_get_type ())
#define SYNAPSE_UTILS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo))
#define SYNAPSE_UTILS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))
#define SYNAPSE_UTILS_IS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_IS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))

typedef struct _SynapseUtilsFileInfo SynapseUtilsFileInfo;
typedef struct _SynapseUtilsFileInfoClass SynapseUtilsFileInfoClass;
typedef struct _SynapseUtilsFileInfoPrivate SynapseUtilsFileInfoPrivate;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT,
	SYNAPSE_MATCH_TYPE_INTERNET
} SynapseMatchType;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseUtilsFileInfoInitializeData SynapseUtilsFileInfoInitializeData;
typedef struct _SynapseUtilsFileInfoExistsData SynapseUtilsFileInfoExistsData;
typedef struct _SynapseUtilsParamSpecFileInfo SynapseUtilsParamSpecFileInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SynapseUtilsQueryExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* f;
	gboolean result;
	gboolean exists;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _SynapseUtilsLogger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsLoggerPrivate * priv;
};

struct _SynapseUtilsLoggerClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsLogger *self);
};

struct _SynapseUtilsParamSpecLogger {
	GParamSpec parent_instance;
};

struct _SynapseUtilsDelegateWrapper {
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _SynapseUtilsAsyncOnce {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsAsyncOncePrivate * priv;
};

struct _SynapseUtilsAsyncOnceClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsAsyncOnce *self);
};

struct _SynapseUtilsAsyncOncePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer inner;
	SynapseUtilsAsyncOnceOperationState state;
	SynapseUtilsDelegateWrapper** callbacks;
	gint callbacks_length1;
	gint _callbacks_size_;
};

struct _SynapseUtilsAsyncOnceEnterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsAsyncOnce* self;
	gboolean result;
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	SynapseUtilsAsyncOnceOperationState _tmp1_;
};

struct _SynapseUtilsAsyncOnceWaitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsAsyncOnce* self;
	SynapseUtilsDelegateWrapper* _tmp0_;
};

struct _SynapseUtilsParamSpecAsyncOnce {
	GParamSpec parent_instance;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseUtilsFileInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsFileInfoPrivate * priv;
	gchar* uri;
	gchar* parse_name;
	SynapseQueryFlags file_type;
	SynapseUriMatch* match_obj;
};

struct _SynapseUtilsFileInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsFileInfo *self);
};

struct _SynapseUtilsFileInfoPrivate {
	gboolean initialized;
	GType match_obj_type;
};

struct _SynapseUtilsFileInfoInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsFileInfo* self;
	GFile* f;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* fi;
	const gchar* _tmp2_;
	GFileInfo* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	GIcon* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GObject* _tmp14_;
	GObject* _tmp15_;
	const gchar* mime_type;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	SynapseUriMatch* _tmp23_;
	SynapseQueryFlags _tmp24_;
	SynapseUriMatch* _tmp25_;
	const gchar* _tmp26_;
	GError* err;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _inner_error0_;
};

struct _SynapseUtilsFileInfoExistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsFileInfo* self;
	gboolean result;
	GFile* f;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _result_;
};

struct _SynapseUtilsParamSpecFileInfo {
	GParamSpec parent_instance;
};

static gpointer synapse_utils_logger_parent_class = NULL;
static gboolean synapse_utils_logger_initialized;
static gboolean synapse_utils_logger_initialized = FALSE;
static gboolean synapse_utils_logger_show_debug;
static gboolean synapse_utils_logger_show_debug = FALSE;
static gint SynapseUtilsAsyncOnce_private_offset;
static gpointer synapse_utils_async_once_parent_class = NULL;
static gint SynapseUtilsFileInfo_private_offset;
static gpointer synapse_utils_file_info_parent_class = NULL;
static gchar* synapse_utils_file_info_interesting_attributes;
static gchar* synapse_utils_file_info_interesting_attributes = NULL;

gchar* synapse_utils_remove_accents (const gchar* input);
gchar* synapse_utils_remove_last_unichar (const gchar* input);
static void synapse_utils_query_exists_async_data_free (gpointer _data);
void synapse_utils_query_exists_async (GFile* f,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* _data_);
static void synapse_utils_query_exists_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
gchar* synapse_utils_extract_type_name (GType obj_type);
gpointer synapse_utils_logger_ref (gpointer instance);
void synapse_utils_logger_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_logger (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void synapse_utils_value_set_logger (GValue* value,
                                     gpointer v_object);
void synapse_utils_value_take_logger (GValue* value,
                                      gpointer v_object);
gpointer synapse_utils_value_get_logger (const GValue* value);
GType synapse_utils_logger_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsLogger, synapse_utils_logger_unref)
#define SYNAPSE_UTILS_LOGGER_RED "\x1b[31m"
#define SYNAPSE_UTILS_LOGGER_GREEN "\x1b[32m"
#define SYNAPSE_UTILS_LOGGER_YELLOW "\x1b[33m"
#define SYNAPSE_UTILS_LOGGER_BLUE "\x1b[34m"
#define SYNAPSE_UTILS_LOGGER_MAGENTA "\x1b[35m"
#define SYNAPSE_UTILS_LOGGER_CYAN "\x1b[36m"
#define SYNAPSE_UTILS_LOGGER_RESET "\x1b[0m"
static void synapse_utils_logger_log_internal (GObject* obj,
                                        GLogLevelFlags level,
                                        const gchar* format,
                                        va_list args);
static void synapse_utils_logger_initialize (void);
void synapse_utils_logger_handler (const gchar* domain,
                                   GLogLevelFlags level,
                                   const gchar* msg);
static void _synapse_utils_logger_handler_glog_func (const gchar* log_domain,
                                              GLogLevelFlags log_levels,
                                              const gchar* message,
                                              gpointer self);
gboolean synapse_utils_logger_debug_enabled (void);
void synapse_utils_logger_log (GObject* obj,
                               const gchar* format,
                               ...);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
void synapse_utils_logger_warning (GObject* obj,
                                   const gchar* format,
                                   ...);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
SynapseUtilsLogger* synapse_utils_logger_new (void);
SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type);
static void synapse_utils_logger_finalize (SynapseUtilsLogger * obj);
static GType synapse_utils_logger_get_type_once (void);
void synapse_utils_delegate_wrapper_free (SynapseUtilsDelegateWrapper * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsDelegateWrapper, synapse_utils_delegate_wrapper_free)
static void synapse_utils_delegate_wrapper_instance_init (SynapseUtilsDelegateWrapper * self);
SynapseUtilsDelegateWrapper* synapse_utils_delegate_wrapper_new (GSourceFunc cb,
                                                                 gpointer cb_target,
                                                                 GDestroyNotify cb_target_destroy_notify);
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsAsyncOnce, synapse_utils_async_once_unref)
static GType synapse_utils_async_once_operation_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
gconstpointer synapse_utils_async_once_get_data (SynapseUtilsAsyncOnce* self);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
static void synapse_utils_async_once_enter_data_free (gpointer _data);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
static gboolean synapse_utils_async_once_enter_co (SynapseUtilsAsyncOnceEnterData* _data_);
static void synapse_utils_async_once_wait_async (SynapseUtilsAsyncOnce* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_utils_async_once_wait_finish (SynapseUtilsAsyncOnce* self,
                                           GAsyncResult* _res_);
static void synapse_utils_async_once_enter_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
static void synapse_utils_async_once_notify_all (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_reset (SynapseUtilsAsyncOnce* self);
static void synapse_utils_async_once_wait_async_data_free (gpointer _data);
static gboolean synapse_utils_async_once_wait_async_co (SynapseUtilsAsyncOnceWaitAsyncData* _data_);
static gboolean _synapse_utils_async_once_wait_async_co_gsource_func (gpointer self);
static void _vala_array_add8 (SynapseUtilsDelegateWrapper** * array,
                       gint* length,
                       gint* size,
                       SynapseUtilsDelegateWrapper* value);
static void synapse_utils_async_once_finalize (SynapseUtilsAsyncOnce * obj);
static GType synapse_utils_async_once_get_type_once (void);
gpointer synapse_utils_file_info_ref (gpointer instance);
void synapse_utils_file_info_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_file_info (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void synapse_utils_value_set_file_info (GValue* value,
                                        gpointer v_object);
void synapse_utils_value_take_file_info (GValue* value,
                                         gpointer v_object);
gpointer synapse_utils_value_get_file_info (const GValue* value);
GType synapse_utils_file_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsFileInfo, synapse_utils_file_info_unref)
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
SynapseUtilsFileInfo* synapse_utils_file_info_new (const gchar* uri,
                                                   GType obj_type);
SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type,
                                                         const gchar* uri,
                                                         GType obj_type);
gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self);
static void synapse_utils_file_info_initialize_data_free (gpointer _data);
void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self,
                                                GAsyncResult* _res_);
static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* _data_);
static void synapse_utils_file_info_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static void synapse_utils_file_info_exists_data_free (gpointer _data);
void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self,
                                                GAsyncResult* _res_);
static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* _data_);
static void synapse_utils_file_info_exists_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo * obj);
static GType synapse_utils_file_info_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

gchar*
synapse_utils_remove_accents (const gchar* input)
{
	gchar* _result_ = NULL;
	const gchar* charset = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 29 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 32 "../lib/synapse-core/utils.vala"
	g_get_charset (&_tmp0_);
#line 32 "../lib/synapse-core/utils.vala"
	charset = _tmp0_;
#line 534 "utils.c"
	{
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		gint _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
#line 35 "../lib/synapse-core/utils.vala"
		_tmp2_ = strlen (input);
#line 35 "../lib/synapse-core/utils.vala"
		_tmp3_ = _tmp2_;
#line 35 "../lib/synapse-core/utils.vala"
		_tmp4_ = charset;
#line 35 "../lib/synapse-core/utils.vala"
		_tmp5_ = g_convert (input, (gssize) _tmp3_, "US-ASCII//TRANSLIT", _tmp4_, NULL, NULL, &_inner_error0_);
#line 35 "../lib/synapse-core/utils.vala"
		_tmp1_ = _tmp5_;
#line 35 "../lib/synapse-core/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 35 "../lib/synapse-core/utils.vala"
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 557 "utils.c"
				goto __catch0_g_convert_error;
			}
#line 35 "../lib/synapse-core/utils.vala"
			_g_free0 (_result_);
#line 35 "../lib/synapse-core/utils.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 35 "../lib/synapse-core/utils.vala"
			g_clear_error (&_inner_error0_);
#line 35 "../lib/synapse-core/utils.vala"
			return NULL;
#line 568 "utils.c"
		}
#line 35 "../lib/synapse-core/utils.vala"
		_tmp6_ = _tmp1_;
#line 35 "../lib/synapse-core/utils.vala"
		_tmp1_ = NULL;
#line 35 "../lib/synapse-core/utils.vala"
		_g_free0 (_result_);
#line 35 "../lib/synapse-core/utils.vala"
		_result_ = _tmp6_;
#line 38 "../lib/synapse-core/utils.vala"
		_tmp7_ = _result_;
#line 38 "../lib/synapse-core/utils.vala"
		if (g_strcmp0 (input, _tmp7_) == 0) {
#line 39 "../lib/synapse-core/utils.vala"
			result = NULL;
#line 39 "../lib/synapse-core/utils.vala"
			_g_free0 (_tmp1_);
#line 39 "../lib/synapse-core/utils.vala"
			_g_free0 (_result_);
#line 39 "../lib/synapse-core/utils.vala"
			return result;
#line 590 "utils.c"
		}
#line 34 "../lib/synapse-core/utils.vala"
		_g_free0 (_tmp1_);
#line 594 "utils.c"
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
#line 34 "../lib/synapse-core/utils.vala"
		g_clear_error (&_inner_error0_);
#line 42 "../lib/synapse-core/utils.vala"
		_g_free0 (_result_);
#line 42 "../lib/synapse-core/utils.vala"
		_result_ = NULL;
#line 605 "utils.c"
	}
	__finally0:
#line 34 "../lib/synapse-core/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 34 "../lib/synapse-core/utils.vala"
		_g_free0 (_result_);
#line 34 "../lib/synapse-core/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 34 "../lib/synapse-core/utils.vala"
		g_clear_error (&_inner_error0_);
#line 34 "../lib/synapse-core/utils.vala"
		return NULL;
#line 618 "utils.c"
	}
#line 45 "../lib/synapse-core/utils.vala"
	result = _result_;
#line 45 "../lib/synapse-core/utils.vala"
	return result;
#line 624 "utils.c"
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result = 0;
#line 1282 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1283 "glib-2.0.vapi"
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
#line 1283 "glib-2.0.vapi"
	result = (gint) (_tmp0_ - ((gchar*) self));
#line 1283 "glib-2.0.vapi"
	return result;
#line 641 "utils.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 664 "utils.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 673 "utils.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 692 "utils.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 696 "utils.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 702 "utils.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 712 "utils.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 720 "utils.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 724 "utils.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 730 "utils.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 740 "utils.c"
}

gchar*
synapse_utils_remove_last_unichar (const gchar* input)
{
	glong char_count = 0L;
	gint len = 0;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 48 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 49 "../lib/synapse-core/utils.vala"
	char_count = (glong) g_utf8_strlen (input, (gssize) -1);
#line 50 "../lib/synapse-core/utils.vala"
	len = string_index_of_nth_char (input, char_count - 1);
#line 52 "../lib/synapse-core/utils.vala"
	_tmp0_ = string_substring (input, (glong) 0, (glong) len);
#line 52 "../lib/synapse-core/utils.vala"
	result = _tmp0_;
#line 52 "../lib/synapse-core/utils.vala"
	return result;
#line 762 "utils.c"
}

static void
synapse_utils_query_exists_async_data_free (gpointer _data)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = _data;
#line 284 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->f);
#line 284 "../lib/synapse-core/data-sink.vala"
	g_slice_free (SynapseUtilsQueryExistsAsyncData, _data_);
#line 774 "utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	return self ? g_object_ref (self) : NULL;
#line 782 "utils.c"
}

void
synapse_utils_query_exists_async (GFile* f,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	GFile* _tmp0_;
#line 284 "../lib/synapse-core/data-sink.vala"
	_data_ = g_slice_new0 (SynapseUtilsQueryExistsAsyncData);
#line 284 "../lib/synapse-core/data-sink.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 284 "../lib/synapse-core/data-sink.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_query_exists_async_data_free);
#line 284 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _g_object_ref0 (f);
#line 284 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->f);
#line 284 "../lib/synapse-core/data-sink.vala"
	_data_->f = _tmp0_;
#line 284 "../lib/synapse-core/data-sink.vala"
	synapse_utils_query_exists_async_co (_data_);
#line 806 "utils.c"
}

gboolean
synapse_utils_query_exists_finish (GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsQueryExistsAsyncData* _data_;
#line 284 "../lib/synapse-core/data-sink.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 284 "../lib/synapse-core/data-sink.vala"
	result = _data_->result;
#line 284 "../lib/synapse-core/data-sink.vala"
	return result;
#line 820 "utils.c"
}

static void
synapse_utils_query_exists_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
#line 59 "../lib/synapse-core/utils.vala"
	_data_ = _user_data_;
#line 59 "../lib/synapse-core/utils.vala"
	_data_->_source_object_ = source_object;
#line 59 "../lib/synapse-core/utils.vala"
	_data_->_res_ = _res_;
#line 59 "../lib/synapse-core/utils.vala"
	synapse_utils_query_exists_async_co (_data_);
#line 837 "utils.c"
}

static gboolean
synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* _data_)
{
#line 55 "../lib/synapse-core/utils.vala"
	switch (_data_->_state_) {
#line 55 "../lib/synapse-core/utils.vala"
		case 0:
#line 847 "utils.c"
		goto _state_0;
#line 55 "../lib/synapse-core/utils.vala"
		case 1:
#line 851 "utils.c"
		goto _state_1;
		default:
#line 55 "../lib/synapse-core/utils.vala"
		g_assert_not_reached ();
#line 856 "utils.c"
	}
	_state_0:
	{
#line 59 "../lib/synapse-core/utils.vala"
		_data_->_state_ = 1;
#line 59 "../lib/synapse-core/utils.vala"
		g_file_query_info_async (_data_->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_utils_query_exists_async_ready, _data_);
#line 59 "../lib/synapse-core/utils.vala"
		return FALSE;
#line 866 "utils.c"
		_state_1:
#line 59 "../lib/synapse-core/utils.vala"
		_data_->_tmp0_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error0_);
#line 59 "../lib/synapse-core/utils.vala"
		_data_->_tmp1_ = _data_->_tmp0_;
#line 59 "../lib/synapse-core/utils.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 59 "../lib/synapse-core/utils.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 876 "utils.c"
			goto __catch0_g_error;
		}
#line 60 "../lib/synapse-core/utils.vala"
		_data_->exists = TRUE;
#line 881 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 58 "../lib/synapse-core/utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 62 "../lib/synapse-core/utils.vala"
		_data_->exists = FALSE;
#line 890 "utils.c"
	}
	__finally0:
#line 58 "../lib/synapse-core/utils.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 58 "../lib/synapse-core/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 58 "../lib/synapse-core/utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 58 "../lib/synapse-core/utils.vala"
		g_object_unref (_data_->_async_result);
#line 58 "../lib/synapse-core/utils.vala"
		return FALSE;
#line 903 "utils.c"
	}
#line 65 "../lib/synapse-core/utils.vala"
	_data_->result = _data_->exists;
#line 65 "../lib/synapse-core/utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 65 "../lib/synapse-core/utils.vala"
	if (_data_->_state_ != 0) {
#line 65 "../lib/synapse-core/utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 65 "../lib/synapse-core/utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 915 "utils.c"
		}
	}
#line 65 "../lib/synapse-core/utils.vala"
	g_object_unref (_data_->_async_result);
#line 65 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 922 "utils.c"
}

gchar*
synapse_utils_extract_type_name (GType obj_type)
{
	gchar* obj_class = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result = NULL;
#line 69 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_type_name (obj_type);
#line 69 "../lib/synapse-core/utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 69 "../lib/synapse-core/utils.vala"
	obj_class = _tmp1_;
#line 70 "../lib/synapse-core/utils.vala"
	_tmp2_ = obj_class;
#line 70 "../lib/synapse-core/utils.vala"
	if (g_str_has_prefix (_tmp2_, "Synapse")) {
#line 943 "utils.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 71 "../lib/synapse-core/utils.vala"
		_tmp3_ = obj_class;
#line 71 "../lib/synapse-core/utils.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 7, (glong) -1);
#line 71 "../lib/synapse-core/utils.vala"
		result = _tmp4_;
#line 71 "../lib/synapse-core/utils.vala"
		_g_free0 (obj_class);
#line 71 "../lib/synapse-core/utils.vala"
		return result;
#line 956 "utils.c"
	}
#line 74 "../lib/synapse-core/utils.vala"
	result = obj_class;
#line 74 "../lib/synapse-core/utils.vala"
	return result;
#line 962 "utils.c"
}

static void
synapse_utils_logger_log_internal (GObject* obj,
                                   GLogLevelFlags level,
                                   const gchar* format,
                                   va_list args)
{
	gchar* desc = NULL;
	gchar* _tmp0_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 89 "../lib/synapse-core/utils.vala"
	g_return_if_fail (format != NULL);
#line 90 "../lib/synapse-core/utils.vala"
	if (!synapse_utils_logger_initialized) {
#line 91 "../lib/synapse-core/utils.vala"
		synapse_utils_logger_initialize ();
#line 982 "utils.c"
	}
#line 93 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_strdup ("");
#line 93 "../lib/synapse-core/utils.vala"
	desc = _tmp0_;
#line 94 "../lib/synapse-core/utils.vala"
	if (obj != NULL) {
#line 990 "utils.c"
		gchar* obj_class = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 95 "../lib/synapse-core/utils.vala"
		_tmp1_ = synapse_utils_extract_type_name (G_TYPE_FROM_INSTANCE (obj));
#line 95 "../lib/synapse-core/utils.vala"
		obj_class = _tmp1_;
#line 96 "../lib/synapse-core/utils.vala"
		_tmp2_ = obj_class;
#line 96 "../lib/synapse-core/utils.vala"
		_tmp3_ = g_strdup_printf ("%s[%s]%s ", SYNAPSE_UTILS_LOGGER_MAGENTA, _tmp2_, SYNAPSE_UTILS_LOGGER_RESET);
#line 96 "../lib/synapse-core/utils.vala"
		_g_free0 (desc);
#line 96 "../lib/synapse-core/utils.vala"
		desc = _tmp3_;
#line 94 "../lib/synapse-core/utils.vala"
		_g_free0 (obj_class);
#line 1009 "utils.c"
	}
#line 98 "../lib/synapse-core/utils.vala"
	_tmp4_ = desc;
#line 98 "../lib/synapse-core/utils.vala"
	_tmp5_ = g_strconcat (_tmp4_, format, NULL);
#line 98 "../lib/synapse-core/utils.vala"
	_tmp6_ = _tmp5_;
#line 98 "../lib/synapse-core/utils.vala"
	g_logv ("Synapse", level, _tmp6_, args);
#line 98 "../lib/synapse-core/utils.vala"
	_g_free0 (_tmp6_);
#line 89 "../lib/synapse-core/utils.vala"
	_g_free0 (desc);
#line 1023 "utils.c"
}

static void
_synapse_utils_logger_handler_glog_func (const gchar* log_domain,
                                         GLogLevelFlags log_levels,
                                         const gchar* message,
                                         gpointer self)
{
#line 116 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_handler (log_domain, log_levels, message);
#line 1034 "utils.c"
}

static void
synapse_utils_logger_initialize (void)
{
	GLogLevelFlags levels = 0U;
	gchar** domains = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint domains_length1;
	gint _domains_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GLogLevelFlags _tmp13_;
	const gchar* _tmp14_;
#line 102 "../lib/synapse-core/utils.vala"
	levels = (((G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_WARNING) | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_strdup ("Synapse");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp1_ = g_strdup ("Gtk");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp2_ = g_strdup ("Gdk");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp3_ = g_strdup ("GLib");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp4_ = g_strdup ("GLib-GObject");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp5_ = g_strdup ("Pango");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp6_ = g_strdup ("GdkPixbuf");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp7_ = g_strdup ("GLib-GIO");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp8_ = g_strdup ("GtkHotkey");
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_ = g_new0 (gchar*, 9 + 1);
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[0] = _tmp0_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[1] = _tmp1_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[2] = _tmp2_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[3] = _tmp3_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[4] = _tmp4_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[5] = _tmp5_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[6] = _tmp6_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[7] = _tmp7_;
#line 103 "../lib/synapse-core/utils.vala"
	_tmp9_[8] = _tmp8_;
#line 103 "../lib/synapse-core/utils.vala"
	domains = _tmp9_;
#line 103 "../lib/synapse-core/utils.vala"
	domains_length1 = 9;
#line 103 "../lib/synapse-core/utils.vala"
	_domains_size_ = domains_length1;
#line 115 "../lib/synapse-core/utils.vala"
	_tmp10_ = domains;
#line 115 "../lib/synapse-core/utils.vala"
	_tmp10__length1 = domains_length1;
#line 1108 "utils.c"
	{
		gchar** domain_collection = NULL;
		gint domain_collection_length1 = 0;
		gint _domain_collection_size_ = 0;
		gint domain_it = 0;
#line 115 "../lib/synapse-core/utils.vala"
		domain_collection = _tmp10_;
#line 115 "../lib/synapse-core/utils.vala"
		domain_collection_length1 = _tmp10__length1;
#line 115 "../lib/synapse-core/utils.vala"
		for (domain_it = 0; domain_it < domain_collection_length1; domain_it = domain_it + 1) {
#line 1120 "utils.c"
			const gchar* domain = NULL;
#line 115 "../lib/synapse-core/utils.vala"
			domain = domain_collection[domain_it];
#line 1124 "utils.c"
			{
				const gchar* _tmp11_;
				GLogLevelFlags _tmp12_;
#line 116 "../lib/synapse-core/utils.vala"
				_tmp11_ = domain;
#line 116 "../lib/synapse-core/utils.vala"
				_tmp12_ = levels;
#line 116 "../lib/synapse-core/utils.vala"
				g_log_set_handler (_tmp11_, _tmp12_, _synapse_utils_logger_handler_glog_func, NULL);
#line 1134 "utils.c"
			}
		}
	}
#line 118 "../lib/synapse-core/utils.vala"
	_tmp13_ = levels;
#line 118 "../lib/synapse-core/utils.vala"
	g_log_set_handler (NULL, _tmp13_, _synapse_utils_logger_handler_glog_func, NULL);
#line 120 "../lib/synapse-core/utils.vala"
	_tmp14_ = g_getenv ("SYNAPSE_DEBUG");
#line 120 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_show_debug = _tmp14_ != NULL;
#line 121 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_initialized = TRUE;
#line 101 "../lib/synapse-core/utils.vala"
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
#line 1150 "utils.c"
}

gboolean
synapse_utils_logger_debug_enabled (void)
{
	gboolean result = FALSE;
#line 125 "../lib/synapse-core/utils.vala"
	if (!synapse_utils_logger_initialized) {
#line 125 "../lib/synapse-core/utils.vala"
		synapse_utils_logger_initialize ();
#line 1161 "utils.c"
	}
#line 126 "../lib/synapse-core/utils.vala"
	result = synapse_utils_logger_show_debug;
#line 126 "../lib/synapse-core/utils.vala"
	return result;
#line 1167 "utils.c"
}

void
synapse_utils_logger_log (GObject* obj,
                          const gchar* format,
                          ...)
{
	va_list args = {0};
#line 129 "../lib/synapse-core/utils.vala"
	g_return_if_fail (format != NULL);
#line 130 "../lib/synapse-core/utils.vala"
	va_start (args, format);
#line 131 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_INFO, format, args);
#line 129 "../lib/synapse-core/utils.vala"
	va_end (args);
#line 1184 "utils.c"
}

void
synapse_utils_logger_debug (GObject* obj,
                            const gchar* format,
                            ...)
{
	va_list args = {0};
#line 135 "../lib/synapse-core/utils.vala"
	g_return_if_fail (format != NULL);
#line 136 "../lib/synapse-core/utils.vala"
	va_start (args, format);
#line 137 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_DEBUG, format, args);
#line 135 "../lib/synapse-core/utils.vala"
	va_end (args);
#line 1201 "utils.c"
}

void
synapse_utils_logger_warning (GObject* obj,
                              const gchar* format,
                              ...)
{
	va_list args = {0};
#line 140 "../lib/synapse-core/utils.vala"
	g_return_if_fail (format != NULL);
#line 141 "../lib/synapse-core/utils.vala"
	va_start (args, format);
#line 142 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_WARNING, format, args);
#line 140 "../lib/synapse-core/utils.vala"
	va_end (args);
#line 1218 "utils.c"
}

void
synapse_utils_logger_error (GObject* obj,
                            const gchar* format,
                            ...)
{
	va_list args = {0};
#line 145 "../lib/synapse-core/utils.vala"
	g_return_if_fail (format != NULL);
#line 146 "../lib/synapse-core/utils.vala"
	va_start (args, format);
#line 147 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_ERROR, format, args);
#line 145 "../lib/synapse-core/utils.vala"
	va_end (args);
#line 1235 "utils.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 1248 "utils.c"
}

void
synapse_utils_logger_handler (const gchar* domain,
                              GLogLevelFlags level,
                              const gchar* msg)
{
	gchar* header = NULL;
	gchar* domain_str = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GTimeVal time_val = {0};
	gint _tmp3_ = 0;
	GTimeVal _tmp4_;
	glong time_str_len = 0L;
	gchar* cur_time = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	FILE* _tmp45_;
	const gchar* _tmp46_;
#line 150 "../lib/synapse-core/utils.vala"
	g_return_if_fail (msg != NULL);
#line 152 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_strdup ("");
#line 152 "../lib/synapse-core/utils.vala"
	domain_str = _tmp0_;
#line 153 "../lib/synapse-core/utils.vala"
	if (domain != NULL) {
#line 153 "../lib/synapse-core/utils.vala"
		_tmp1_ = g_strcmp0 (domain, "Synapse") != 0;
#line 1281 "utils.c"
	} else {
#line 153 "../lib/synapse-core/utils.vala"
		_tmp1_ = FALSE;
#line 1285 "utils.c"
	}
#line 153 "../lib/synapse-core/utils.vala"
	if (_tmp1_) {
#line 1289 "utils.c"
		gchar* _tmp2_;
#line 154 "../lib/synapse-core/utils.vala"
		_tmp2_ = g_strconcat (domain, "-", NULL);
#line 154 "../lib/synapse-core/utils.vala"
		_g_free0 (domain_str);
#line 154 "../lib/synapse-core/utils.vala"
		domain_str = _tmp2_;
#line 1297 "utils.c"
	}
#line 157 "../lib/synapse-core/utils.vala"
	g_get_current_time (&time_val);
#line 158 "../lib/synapse-core/utils.vala"
	_tmp4_ = time_val;
#line 158 "../lib/synapse-core/utils.vala"
	if (_tmp4_.tv_usec != ((glong) 0)) {
#line 158 "../lib/synapse-core/utils.vala"
		_tmp3_ = 15;
#line 1307 "utils.c"
	} else {
#line 158 "../lib/synapse-core/utils.vala"
		_tmp3_ = 8;
#line 1311 "utils.c"
	}
#line 158 "../lib/synapse-core/utils.vala"
	time_str_len = (glong) _tmp3_;
#line 159 "../lib/synapse-core/utils.vala"
	_tmp5_ = g_time_val_to_iso8601 (&time_val);
#line 159 "../lib/synapse-core/utils.vala"
	_tmp6_ = _tmp5_;
#line 159 "../lib/synapse-core/utils.vala"
	_tmp7_ = string_substring (_tmp6_, (glong) 11, time_str_len);
#line 159 "../lib/synapse-core/utils.vala"
	_tmp8_ = _tmp7_;
#line 159 "../lib/synapse-core/utils.vala"
	_g_free0 (_tmp6_);
#line 159 "../lib/synapse-core/utils.vala"
	cur_time = _tmp8_;
#line 161 "../lib/synapse-core/utils.vala"
	if (level == G_LOG_LEVEL_DEBUG) {
#line 1329 "utils.c"
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 162 "../lib/synapse-core/utils.vala"
		if (!synapse_utils_logger_show_debug) {
#line 1340 "utils.c"
			const gchar* _tmp10_;
#line 162 "../lib/synapse-core/utils.vala"
			_tmp10_ = domain_str;
#line 162 "../lib/synapse-core/utils.vala"
			_tmp9_ = g_strcmp0 (_tmp10_, "") == 0;
#line 1346 "utils.c"
		} else {
#line 162 "../lib/synapse-core/utils.vala"
			_tmp9_ = FALSE;
#line 1350 "utils.c"
		}
#line 162 "../lib/synapse-core/utils.vala"
		if (_tmp9_) {
#line 163 "../lib/synapse-core/utils.vala"
			_g_free0 (cur_time);
#line 163 "../lib/synapse-core/utils.vala"
			_g_free0 (domain_str);
#line 163 "../lib/synapse-core/utils.vala"
			_g_free0 (header);
#line 163 "../lib/synapse-core/utils.vala"
			return;
#line 1362 "utils.c"
		}
#line 165 "../lib/synapse-core/utils.vala"
		_tmp11_ = string_to_string (SYNAPSE_UTILS_LOGGER_GREEN);
#line 165 "../lib/synapse-core/utils.vala"
		_tmp12_ = cur_time;
#line 165 "../lib/synapse-core/utils.vala"
		_tmp13_ = string_to_string (_tmp12_);
#line 165 "../lib/synapse-core/utils.vala"
		_tmp14_ = domain_str;
#line 165 "../lib/synapse-core/utils.vala"
		_tmp15_ = string_to_string (_tmp14_);
#line 165 "../lib/synapse-core/utils.vala"
		_tmp16_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
#line 165 "../lib/synapse-core/utils.vala"
		_tmp17_ = g_strconcat (_tmp11_, "[", _tmp13_, " ", _tmp15_, "Debug]", _tmp16_, NULL);
#line 165 "../lib/synapse-core/utils.vala"
		_g_free0 (header);
#line 165 "../lib/synapse-core/utils.vala"
		header = _tmp17_;
#line 1382 "utils.c"
	} else {
#line 166 "../lib/synapse-core/utils.vala"
		if (level == G_LOG_LEVEL_INFO) {
#line 1386 "utils.c"
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
#line 167 "../lib/synapse-core/utils.vala"
			_tmp18_ = string_to_string (SYNAPSE_UTILS_LOGGER_BLUE);
#line 167 "../lib/synapse-core/utils.vala"
			_tmp19_ = cur_time;
#line 167 "../lib/synapse-core/utils.vala"
			_tmp20_ = string_to_string (_tmp19_);
#line 167 "../lib/synapse-core/utils.vala"
			_tmp21_ = domain_str;
#line 167 "../lib/synapse-core/utils.vala"
			_tmp22_ = string_to_string (_tmp21_);
#line 167 "../lib/synapse-core/utils.vala"
			_tmp23_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
#line 167 "../lib/synapse-core/utils.vala"
			_tmp24_ = g_strconcat (_tmp18_, "[", _tmp20_, " ", _tmp22_, "Info]", _tmp23_, NULL);
#line 167 "../lib/synapse-core/utils.vala"
			_g_free0 (header);
#line 167 "../lib/synapse-core/utils.vala"
			header = _tmp24_;
#line 1412 "utils.c"
		} else {
#line 168 "../lib/synapse-core/utils.vala"
			if (level == G_LOG_LEVEL_WARNING) {
#line 1416 "utils.c"
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
#line 169 "../lib/synapse-core/utils.vala"
				_tmp25_ = string_to_string (SYNAPSE_UTILS_LOGGER_RED);
#line 169 "../lib/synapse-core/utils.vala"
				_tmp26_ = cur_time;
#line 169 "../lib/synapse-core/utils.vala"
				_tmp27_ = string_to_string (_tmp26_);
#line 169 "../lib/synapse-core/utils.vala"
				_tmp28_ = domain_str;
#line 169 "../lib/synapse-core/utils.vala"
				_tmp29_ = string_to_string (_tmp28_);
#line 169 "../lib/synapse-core/utils.vala"
				_tmp30_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
#line 169 "../lib/synapse-core/utils.vala"
				_tmp31_ = g_strconcat (_tmp25_, "[", _tmp27_, " ", _tmp29_, "Warning]", _tmp30_, NULL);
#line 169 "../lib/synapse-core/utils.vala"
				_g_free0 (header);
#line 169 "../lib/synapse-core/utils.vala"
				header = _tmp31_;
#line 1442 "utils.c"
			} else {
				gboolean _tmp32_ = FALSE;
#line 170 "../lib/synapse-core/utils.vala"
				if (level == G_LOG_LEVEL_CRITICAL) {
#line 170 "../lib/synapse-core/utils.vala"
					_tmp32_ = TRUE;
#line 1449 "utils.c"
				} else {
#line 170 "../lib/synapse-core/utils.vala"
					_tmp32_ = level == G_LOG_LEVEL_ERROR;
#line 1453 "utils.c"
				}
#line 170 "../lib/synapse-core/utils.vala"
				if (_tmp32_) {
#line 1457 "utils.c"
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
#line 171 "../lib/synapse-core/utils.vala"
					_tmp33_ = string_to_string (SYNAPSE_UTILS_LOGGER_RED);
#line 171 "../lib/synapse-core/utils.vala"
					_tmp34_ = cur_time;
#line 171 "../lib/synapse-core/utils.vala"
					_tmp35_ = string_to_string (_tmp34_);
#line 171 "../lib/synapse-core/utils.vala"
					_tmp36_ = domain_str;
#line 171 "../lib/synapse-core/utils.vala"
					_tmp37_ = string_to_string (_tmp36_);
#line 171 "../lib/synapse-core/utils.vala"
					_tmp38_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
#line 171 "../lib/synapse-core/utils.vala"
					_tmp39_ = g_strconcat (_tmp33_, "[", _tmp35_, " ", _tmp37_, "Critical]", _tmp38_, NULL);
#line 171 "../lib/synapse-core/utils.vala"
					_g_free0 (header);
#line 171 "../lib/synapse-core/utils.vala"
					header = _tmp39_;
#line 1483 "utils.c"
				} else {
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
#line 173 "../lib/synapse-core/utils.vala"
					_tmp40_ = string_to_string (SYNAPSE_UTILS_LOGGER_YELLOW);
#line 173 "../lib/synapse-core/utils.vala"
					_tmp41_ = cur_time;
#line 173 "../lib/synapse-core/utils.vala"
					_tmp42_ = string_to_string (_tmp41_);
#line 173 "../lib/synapse-core/utils.vala"
					_tmp43_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
#line 173 "../lib/synapse-core/utils.vala"
					_tmp44_ = g_strconcat (_tmp40_, "[", _tmp42_, "]", _tmp43_, NULL);
#line 173 "../lib/synapse-core/utils.vala"
					_g_free0 (header);
#line 173 "../lib/synapse-core/utils.vala"
					header = _tmp44_;
#line 1504 "utils.c"
				}
			}
		}
	}
#line 176 "../lib/synapse-core/utils.vala"
	_tmp45_ = stdout;
#line 176 "../lib/synapse-core/utils.vala"
	_tmp46_ = header;
#line 176 "../lib/synapse-core/utils.vala"
	fprintf (_tmp45_, "%s %s\n", _tmp46_, msg);
#line 150 "../lib/synapse-core/utils.vala"
	_g_free0 (cur_time);
#line 150 "../lib/synapse-core/utils.vala"
	_g_free0 (domain_str);
#line 150 "../lib/synapse-core/utils.vala"
	_g_free0 (header);
#line 1521 "utils.c"
}

SynapseUtilsLogger*
synapse_utils_logger_construct (GType object_type)
{
	SynapseUtilsLogger* self = NULL;
#line 77 "../lib/synapse-core/utils.vala"
	self = (SynapseUtilsLogger*) g_type_create_instance (object_type);
#line 77 "../lib/synapse-core/utils.vala"
	return self;
#line 1532 "utils.c"
}

SynapseUtilsLogger*
synapse_utils_logger_new (void)
{
#line 77 "../lib/synapse-core/utils.vala"
	return synapse_utils_logger_construct (SYNAPSE_UTILS_TYPE_LOGGER);
#line 1540 "utils.c"
}

static void
synapse_utils_value_logger_init (GValue* value)
{
#line 77 "../lib/synapse-core/utils.vala"
	value->data[0].v_pointer = NULL;
#line 1548 "utils.c"
}

static void
synapse_utils_value_logger_free_value (GValue* value)
{
#line 77 "../lib/synapse-core/utils.vala"
	if (value->data[0].v_pointer) {
#line 77 "../lib/synapse-core/utils.vala"
		synapse_utils_logger_unref (value->data[0].v_pointer);
#line 1558 "utils.c"
	}
}

static void
synapse_utils_value_logger_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
#line 77 "../lib/synapse-core/utils.vala"
	if (src_value->data[0].v_pointer) {
#line 77 "../lib/synapse-core/utils.vala"
		dest_value->data[0].v_pointer = synapse_utils_logger_ref (src_value->data[0].v_pointer);
#line 1570 "utils.c"
	} else {
#line 77 "../lib/synapse-core/utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1574 "utils.c"
	}
}

static gpointer
synapse_utils_value_logger_peek_pointer (const GValue* value)
{
#line 77 "../lib/synapse-core/utils.vala"
	return value->data[0].v_pointer;
#line 1583 "utils.c"
}

static gchar*
synapse_utils_value_logger_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
#line 77 "../lib/synapse-core/utils.vala"
	if (collect_values[0].v_pointer) {
#line 1594 "utils.c"
		SynapseUtilsLogger * object;
		object = collect_values[0].v_pointer;
#line 77 "../lib/synapse-core/utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 77 "../lib/synapse-core/utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1601 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 77 "../lib/synapse-core/utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1605 "utils.c"
		}
#line 77 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = synapse_utils_logger_ref (object);
#line 1609 "utils.c"
	} else {
#line 77 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 1613 "utils.c"
	}
#line 77 "../lib/synapse-core/utils.vala"
	return NULL;
#line 1617 "utils.c"
}

static gchar*
synapse_utils_value_logger_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	SynapseUtilsLogger ** object_p;
	object_p = collect_values[0].v_pointer;
#line 77 "../lib/synapse-core/utils.vala"
	if (!object_p) {
#line 77 "../lib/synapse-core/utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1632 "utils.c"
	}
#line 77 "../lib/synapse-core/utils.vala"
	if (!value->data[0].v_pointer) {
#line 77 "../lib/synapse-core/utils.vala"
		*object_p = NULL;
#line 1638 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 77 "../lib/synapse-core/utils.vala"
		*object_p = value->data[0].v_pointer;
#line 1642 "utils.c"
	} else {
#line 77 "../lib/synapse-core/utils.vala"
		*object_p = synapse_utils_logger_ref (value->data[0].v_pointer);
#line 1646 "utils.c"
	}
#line 77 "../lib/synapse-core/utils.vala"
	return NULL;
#line 1650 "utils.c"
}

GParamSpec*
synapse_utils_param_spec_logger (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	SynapseUtilsParamSpecLogger* spec;
#line 77 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
#line 77 "../lib/synapse-core/utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 77 "../lib/synapse-core/utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 77 "../lib/synapse-core/utils.vala"
	return G_PARAM_SPEC (spec);
#line 1669 "utils.c"
}

gpointer
synapse_utils_value_get_logger (const GValue* value)
{
#line 77 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
#line 77 "../lib/synapse-core/utils.vala"
	return value->data[0].v_pointer;
#line 1679 "utils.c"
}

void
synapse_utils_value_set_logger (GValue* value,
                                gpointer v_object)
{
	SynapseUtilsLogger * old;
#line 77 "../lib/synapse-core/utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
#line 77 "../lib/synapse-core/utils.vala"
	old = value->data[0].v_pointer;
#line 77 "../lib/synapse-core/utils.vala"
	if (v_object) {
#line 77 "../lib/synapse-core/utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
#line 77 "../lib/synapse-core/utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 77 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = v_object;
#line 77 "../lib/synapse-core/utils.vala"
		synapse_utils_logger_ref (value->data[0].v_pointer);
#line 1701 "utils.c"
	} else {
#line 77 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 1705 "utils.c"
	}
#line 77 "../lib/synapse-core/utils.vala"
	if (old) {
#line 77 "../lib/synapse-core/utils.vala"
		synapse_utils_logger_unref (old);
#line 1711 "utils.c"
	}
}

void
synapse_utils_value_take_logger (GValue* value,
                                 gpointer v_object)
{
	SynapseUtilsLogger * old;
#line 77 "../lib/synapse-core/utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
#line 77 "../lib/synapse-core/utils.vala"
	old = value->data[0].v_pointer;
#line 77 "../lib/synapse-core/utils.vala"
	if (v_object) {
#line 77 "../lib/synapse-core/utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
#line 77 "../lib/synapse-core/utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 77 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = v_object;
#line 1732 "utils.c"
	} else {
#line 77 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 1736 "utils.c"
	}
#line 77 "../lib/synapse-core/utils.vala"
	if (old) {
#line 77 "../lib/synapse-core/utils.vala"
		synapse_utils_logger_unref (old);
#line 1742 "utils.c"
	}
}

static void
synapse_utils_logger_class_init (SynapseUtilsLoggerClass * klass,
                                 gpointer klass_data)
{
#line 77 "../lib/synapse-core/utils.vala"
	synapse_utils_logger_parent_class = g_type_class_peek_parent (klass);
#line 77 "../lib/synapse-core/utils.vala"
	((SynapseUtilsLoggerClass *) klass)->finalize = synapse_utils_logger_finalize;
#line 1754 "utils.c"
}

static void
synapse_utils_logger_instance_init (SynapseUtilsLogger * self,
                                    gpointer klass)
{
#line 77 "../lib/synapse-core/utils.vala"
	self->ref_count = 1;
#line 1763 "utils.c"
}

static void
synapse_utils_logger_finalize (SynapseUtilsLogger * obj)
{
	SynapseUtilsLogger * self;
#line 77 "../lib/synapse-core/utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger);
#line 77 "../lib/synapse-core/utils.vala"
	g_signal_handlers_destroy (self);
#line 1774 "utils.c"
}

static GType
synapse_utils_logger_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_logger_init, synapse_utils_value_logger_free_value, synapse_utils_value_logger_copy_value, synapse_utils_value_logger_peek_pointer, "p", synapse_utils_value_logger_collect_value, "p", synapse_utils_value_logger_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsLogger), 0, (GInstanceInitFunc) synapse_utils_logger_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_utils_logger_type_id;
	synapse_utils_logger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsLogger", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_utils_logger_type_id;
}

GType
synapse_utils_logger_get_type (void)
{
	static volatile gsize synapse_utils_logger_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_logger_type_id__volatile)) {
		GType synapse_utils_logger_type_id;
		synapse_utils_logger_type_id = synapse_utils_logger_get_type_once ();
		g_once_init_leave (&synapse_utils_logger_type_id__volatile, synapse_utils_logger_type_id);
	}
	return synapse_utils_logger_type_id__volatile;
}

gpointer
synapse_utils_logger_ref (gpointer instance)
{
	SynapseUtilsLogger * self;
	self = instance;
#line 77 "../lib/synapse-core/utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 77 "../lib/synapse-core/utils.vala"
	return instance;
#line 1809 "utils.c"
}

void
synapse_utils_logger_unref (gpointer instance)
{
	SynapseUtilsLogger * self;
	self = instance;
#line 77 "../lib/synapse-core/utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 77 "../lib/synapse-core/utils.vala"
		SYNAPSE_UTILS_LOGGER_GET_CLASS (self)->finalize (self);
#line 77 "../lib/synapse-core/utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1823 "utils.c"
	}
}

SynapseUtilsDelegateWrapper*
synapse_utils_delegate_wrapper_new (GSourceFunc cb,
                                    gpointer cb_target,
                                    GDestroyNotify cb_target_destroy_notify)
{
	SynapseUtilsDelegateWrapper* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
#line 193 "../lib/synapse-core/utils.vala"
	self = g_slice_new0 (SynapseUtilsDelegateWrapper);
#line 193 "../lib/synapse-core/utils.vala"
	synapse_utils_delegate_wrapper_instance_init (self);
#line 194 "../lib/synapse-core/utils.vala"
	_tmp0_ = cb;
#line 194 "../lib/synapse-core/utils.vala"
	_tmp0__target = cb_target;
#line 194 "../lib/synapse-core/utils.vala"
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
#line 194 "../lib/synapse-core/utils.vala"
	cb = NULL;
#line 194 "../lib/synapse-core/utils.vala"
	cb_target = NULL;
#line 194 "../lib/synapse-core/utils.vala"
	cb_target_destroy_notify = NULL;
#line 194 "../lib/synapse-core/utils.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 194 "../lib/synapse-core/utils.vala"
	self->callback = NULL;
#line 194 "../lib/synapse-core/utils.vala"
	self->callback_target = NULL;
#line 194 "../lib/synapse-core/utils.vala"
	self->callback_target_destroy_notify = NULL;
#line 194 "../lib/synapse-core/utils.vala"
	self->callback = _tmp0_;
#line 194 "../lib/synapse-core/utils.vala"
	self->callback_target = _tmp0__target;
#line 194 "../lib/synapse-core/utils.vala"
	self->callback_target_destroy_notify = _tmp0__target_destroy_notify;
#line 193 "../lib/synapse-core/utils.vala"
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
#line 193 "../lib/synapse-core/utils.vala"
	cb = NULL;
#line 193 "../lib/synapse-core/utils.vala"
	cb_target = NULL;
#line 193 "../lib/synapse-core/utils.vala"
	cb_target_destroy_notify = NULL;
#line 193 "../lib/synapse-core/utils.vala"
	return self;
#line 1876 "utils.c"
}

static void
synapse_utils_delegate_wrapper_instance_init (SynapseUtilsDelegateWrapper * self)
{
}

void
synapse_utils_delegate_wrapper_free (SynapseUtilsDelegateWrapper * self)
{
#line 191 "../lib/synapse-core/utils.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 191 "../lib/synapse-core/utils.vala"
	self->callback = NULL;
#line 191 "../lib/synapse-core/utils.vala"
	self->callback_target = NULL;
#line 191 "../lib/synapse-core/utils.vala"
	self->callback_target_destroy_notify = NULL;
#line 190 "../lib/synapse-core/utils.vala"
	g_slice_free (SynapseUtilsDelegateWrapper, self);
#line 1897 "utils.c"
}

static inline gpointer
synapse_utils_async_once_get_instance_private (SynapseUtilsAsyncOnce* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsAsyncOnce_private_offset);
}

static GType
synapse_utils_async_once_operation_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED", "not-started"}, {SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS", "in-progress"}, {SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE", "done"}, {0, NULL, NULL}};
	GType synapse_utils_async_once_operation_state_type_id;
	synapse_utils_async_once_operation_state_type_id = g_enum_register_static ("SynapseUtilsAsyncOnceOperationState", values);
	return synapse_utils_async_once_operation_state_type_id;
}

static GType
synapse_utils_async_once_operation_state_get_type (void)
{
	static volatile gsize synapse_utils_async_once_operation_state_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_async_once_operation_state_type_id__volatile)) {
		GType synapse_utils_async_once_operation_state_type_id;
		synapse_utils_async_once_operation_state_type_id = synapse_utils_async_once_operation_state_get_type_once ();
		g_once_init_leave (&synapse_utils_async_once_operation_state_type_id__volatile, synapse_utils_async_once_operation_state_type_id);
	}
	return synapse_utils_async_once_operation_state_type_id__volatile;
}

SynapseUtilsAsyncOnce*
synapse_utils_async_once_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func)
{
	SynapseUtilsAsyncOnce* self = NULL;
#line 233 "../lib/synapse-core/utils.vala"
	self = (SynapseUtilsAsyncOnce*) g_type_create_instance (object_type);
#line 233 "../lib/synapse-core/utils.vala"
	self->priv->g_type = g_type;
#line 233 "../lib/synapse-core/utils.vala"
	self->priv->g_dup_func = g_dup_func;
#line 233 "../lib/synapse-core/utils.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 234 "../lib/synapse-core/utils.vala"
	self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED;
#line 233 "../lib/synapse-core/utils.vala"
	return self;
#line 1946 "utils.c"
}

SynapseUtilsAsyncOnce*
synapse_utils_async_once_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func)
{
#line 233 "../lib/synapse-core/utils.vala"
	return synapse_utils_async_once_construct (SYNAPSE_UTILS_TYPE_ASYNC_ONCE, g_type, g_dup_func, g_destroy_func);
#line 1956 "utils.c"
}

gconstpointer
synapse_utils_async_once_get_data (SynapseUtilsAsyncOnce* self)
{
	gconstpointer _tmp0_;
	gconstpointer result = NULL;
#line 237 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 238 "../lib/synapse-core/utils.vala"
	_tmp0_ = self->priv->inner;
#line 238 "../lib/synapse-core/utils.vala"
	result = _tmp0_;
#line 238 "../lib/synapse-core/utils.vala"
	return result;
#line 1972 "utils.c"
}

gboolean
synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self)
{
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	gboolean result = FALSE;
#line 241 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 242 "../lib/synapse-core/utils.vala"
	_tmp0_ = self->priv->state;
#line 242 "../lib/synapse-core/utils.vala"
	result = _tmp0_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE;
#line 242 "../lib/synapse-core/utils.vala"
	return result;
#line 1988 "utils.c"
}

static void
synapse_utils_async_once_enter_data_free (gpointer _data)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	_data_ = _data;
#line 221 "../lib/synapse-core/utils.vala"
	_synapse_utils_async_once_unref0 (_data_->self);
#line 221 "../lib/synapse-core/utils.vala"
	g_slice_free (SynapseUtilsAsyncOnceEnterData, _data_);
#line 2000 "utils.c"
}

static gpointer
_synapse_utils_async_once_ref0 (gpointer self)
{
#line 221 "../lib/synapse-core/utils.vala"
	return self ? synapse_utils_async_once_ref (self) : NULL;
#line 2008 "utils.c"
}

void
synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	SynapseUtilsAsyncOnce* _tmp0_;
#line 221 "../lib/synapse-core/utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsAsyncOnceEnterData);
#line 221 "../lib/synapse-core/utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 221 "../lib/synapse-core/utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_async_once_enter_data_free);
#line 221 "../lib/synapse-core/utils.vala"
	_tmp0_ = _synapse_utils_async_once_ref0 (self);
#line 221 "../lib/synapse-core/utils.vala"
	_data_->self = _tmp0_;
#line 221 "../lib/synapse-core/utils.vala"
	synapse_utils_async_once_enter_co (_data_);
#line 2030 "utils.c"
}

gboolean
synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsAsyncOnceEnterData* _data_;
#line 221 "../lib/synapse-core/utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 221 "../lib/synapse-core/utils.vala"
	result = _data_->result;
#line 221 "../lib/synapse-core/utils.vala"
	return result;
#line 2045 "utils.c"
}

static void
synapse_utils_async_once_enter_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
#line 250 "../lib/synapse-core/utils.vala"
	_data_ = _user_data_;
#line 250 "../lib/synapse-core/utils.vala"
	_data_->_source_object_ = source_object;
#line 250 "../lib/synapse-core/utils.vala"
	_data_->_res_ = _res_;
#line 250 "../lib/synapse-core/utils.vala"
	synapse_utils_async_once_enter_co (_data_);
#line 2062 "utils.c"
}

static gboolean
synapse_utils_async_once_enter_co (SynapseUtilsAsyncOnceEnterData* _data_)
{
#line 245 "../lib/synapse-core/utils.vala"
	switch (_data_->_state_) {
#line 245 "../lib/synapse-core/utils.vala"
		case 0:
#line 2072 "utils.c"
		goto _state_0;
#line 245 "../lib/synapse-core/utils.vala"
		case 1:
#line 2076 "utils.c"
		goto _state_1;
		default:
#line 245 "../lib/synapse-core/utils.vala"
		g_assert_not_reached ();
#line 2081 "utils.c"
	}
	_state_0:
#line 246 "../lib/synapse-core/utils.vala"
	_data_->_tmp0_ = _data_->self->priv->state;
#line 246 "../lib/synapse-core/utils.vala"
	if (_data_->_tmp0_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED) {
#line 247 "../lib/synapse-core/utils.vala"
		_data_->self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS;
#line 248 "../lib/synapse-core/utils.vala"
		_data_->result = TRUE;
#line 248 "../lib/synapse-core/utils.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 248 "../lib/synapse-core/utils.vala"
		if (_data_->_state_ != 0) {
#line 248 "../lib/synapse-core/utils.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 248 "../lib/synapse-core/utils.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2100 "utils.c"
			}
		}
#line 248 "../lib/synapse-core/utils.vala"
		g_object_unref (_data_->_async_result);
#line 248 "../lib/synapse-core/utils.vala"
		return FALSE;
#line 2107 "utils.c"
	} else {
#line 249 "../lib/synapse-core/utils.vala"
		_data_->_tmp1_ = _data_->self->priv->state;
#line 249 "../lib/synapse-core/utils.vala"
		if (_data_->_tmp1_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
#line 250 "../lib/synapse-core/utils.vala"
			_data_->_state_ = 1;
#line 250 "../lib/synapse-core/utils.vala"
			synapse_utils_async_once_wait_async (_data_->self, synapse_utils_async_once_enter_ready, _data_);
#line 250 "../lib/synapse-core/utils.vala"
			return FALSE;
#line 2119 "utils.c"
			_state_1:
#line 250 "../lib/synapse-core/utils.vala"
			synapse_utils_async_once_wait_finish (_data_->self, _data_->_res_);
#line 2123 "utils.c"
		}
	}
#line 253 "../lib/synapse-core/utils.vala"
	_data_->result = FALSE;
#line 253 "../lib/synapse-core/utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 253 "../lib/synapse-core/utils.vala"
	if (_data_->_state_ != 0) {
#line 253 "../lib/synapse-core/utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 253 "../lib/synapse-core/utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2136 "utils.c"
		}
	}
#line 253 "../lib/synapse-core/utils.vala"
	g_object_unref (_data_->_async_result);
#line 253 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 2143 "utils.c"
}

void
synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                gconstpointer _result_)
{
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	gpointer _tmp1_;
#line 256 "../lib/synapse-core/utils.vala"
	g_return_if_fail (self != NULL);
#line 257 "../lib/synapse-core/utils.vala"
	_tmp0_ = self->priv->state;
#line 257 "../lib/synapse-core/utils.vala"
	if (_tmp0_ != SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
#line 258 "../lib/synapse-core/utils.vala"
		g_warning ("utils.vala:258: Incorrect usage of AsyncOnce");
#line 259 "../lib/synapse-core/utils.vala"
		return;
#line 2162 "utils.c"
	}
#line 262 "../lib/synapse-core/utils.vala"
	self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE;
#line 263 "../lib/synapse-core/utils.vala"
	_tmp1_ = ((_result_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _result_) : ((gpointer) _result_);
#line 263 "../lib/synapse-core/utils.vala"
	((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
#line 263 "../lib/synapse-core/utils.vala"
	self->priv->inner = _tmp1_;
#line 264 "../lib/synapse-core/utils.vala"
	synapse_utils_async_once_notify_all (self);
#line 2174 "utils.c"
}

void
synapse_utils_async_once_reset (SynapseUtilsAsyncOnce* self)
{
	SynapseUtilsAsyncOnceOperationState _tmp0_;
#line 268 "../lib/synapse-core/utils.vala"
	g_return_if_fail (self != NULL);
#line 269 "../lib/synapse-core/utils.vala"
	_tmp0_ = self->priv->state;
#line 269 "../lib/synapse-core/utils.vala"
	if (_tmp0_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
#line 270 "../lib/synapse-core/utils.vala"
		g_warning ("utils.vala:270: AsyncOnce.reset() cannot be called in the middle of in" \
"itialization.");
#line 2189 "utils.c"
	} else {
#line 272 "../lib/synapse-core/utils.vala"
		self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED;
#line 273 "../lib/synapse-core/utils.vala"
		((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
#line 273 "../lib/synapse-core/utils.vala"
		self->priv->inner = NULL;
#line 2197 "utils.c"
	}
}

static void
synapse_utils_async_once_notify_all (SynapseUtilsAsyncOnce* self)
{
	SynapseUtilsDelegateWrapper** _tmp0_;
	gint _tmp0__length1;
	SynapseUtilsDelegateWrapper** _tmp3_;
#line 277 "../lib/synapse-core/utils.vala"
	g_return_if_fail (self != NULL);
#line 278 "../lib/synapse-core/utils.vala"
	_tmp0_ = self->priv->callbacks;
#line 278 "../lib/synapse-core/utils.vala"
	_tmp0__length1 = self->priv->callbacks_length1;
#line 2213 "utils.c"
	{
		SynapseUtilsDelegateWrapper** wrapper_collection = NULL;
		gint wrapper_collection_length1 = 0;
		gint _wrapper_collection_size_ = 0;
		gint wrapper_it = 0;
#line 278 "../lib/synapse-core/utils.vala"
		wrapper_collection = _tmp0_;
#line 278 "../lib/synapse-core/utils.vala"
		wrapper_collection_length1 = _tmp0__length1;
#line 278 "../lib/synapse-core/utils.vala"
		for (wrapper_it = 0; wrapper_it < wrapper_collection_length1; wrapper_it = wrapper_it + 1) {
#line 2225 "utils.c"
			SynapseUtilsDelegateWrapper* wrapper = NULL;
#line 278 "../lib/synapse-core/utils.vala"
			wrapper = wrapper_collection[wrapper_it];
#line 2229 "utils.c"
			{
				SynapseUtilsDelegateWrapper* _tmp1_;
				GSourceFunc _tmp2_;
				gpointer _tmp2__target;
#line 279 "../lib/synapse-core/utils.vala"
				_tmp1_ = wrapper;
#line 279 "../lib/synapse-core/utils.vala"
				_tmp2_ = _tmp1_->callback;
#line 279 "../lib/synapse-core/utils.vala"
				_tmp2__target = _tmp1_->callback_target;
#line 279 "../lib/synapse-core/utils.vala"
				_tmp2_ (_tmp2__target);
#line 2242 "utils.c"
			}
		}
	}
#line 281 "../lib/synapse-core/utils.vala"
	_tmp3_ = g_new0 (SynapseUtilsDelegateWrapper*, 0 + 1);
#line 281 "../lib/synapse-core/utils.vala"
	self->priv->callbacks = (_vala_array_free (self->priv->callbacks, self->priv->callbacks_length1, (GDestroyNotify) synapse_utils_delegate_wrapper_free), NULL);
#line 281 "../lib/synapse-core/utils.vala"
	self->priv->callbacks = _tmp3_;
#line 281 "../lib/synapse-core/utils.vala"
	self->priv->callbacks_length1 = 0;
#line 281 "../lib/synapse-core/utils.vala"
	self->priv->_callbacks_size_ = self->priv->callbacks_length1;
#line 2256 "utils.c"
}

static void
synapse_utils_async_once_wait_async_data_free (gpointer _data)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	_data_ = _data;
#line 221 "../lib/synapse-core/utils.vala"
	_synapse_utils_async_once_unref0 (_data_->self);
#line 221 "../lib/synapse-core/utils.vala"
	g_slice_free (SynapseUtilsAsyncOnceWaitAsyncData, _data_);
#line 2268 "utils.c"
}

static void
synapse_utils_async_once_wait_async (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	SynapseUtilsAsyncOnce* _tmp0_;
#line 221 "../lib/synapse-core/utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsAsyncOnceWaitAsyncData);
#line 221 "../lib/synapse-core/utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 221 "../lib/synapse-core/utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_async_once_wait_async_data_free);
#line 221 "../lib/synapse-core/utils.vala"
	_tmp0_ = _synapse_utils_async_once_ref0 (self);
#line 221 "../lib/synapse-core/utils.vala"
	_data_->self = _tmp0_;
#line 221 "../lib/synapse-core/utils.vala"
	synapse_utils_async_once_wait_async_co (_data_);
#line 2290 "utils.c"
}

static void
synapse_utils_async_once_wait_finish (SynapseUtilsAsyncOnce* self,
                                      GAsyncResult* _res_)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
#line 221 "../lib/synapse-core/utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2300 "utils.c"
}

static gboolean
_synapse_utils_async_once_wait_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_utils_async_once_wait_async_co (self);
#line 285 "../lib/synapse-core/utils.vala"
	return result;
#line 2310 "utils.c"
}

static void
_vala_array_add8 (SynapseUtilsDelegateWrapper** * array,
                  gint* length,
                  gint* size,
                  SynapseUtilsDelegateWrapper* value)
{
#line 285 "../lib/synapse-core/utils.vala"
	if ((*length) == (*size)) {
#line 285 "../lib/synapse-core/utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 285 "../lib/synapse-core/utils.vala"
		*array = g_renew (SynapseUtilsDelegateWrapper*, *array, (*size) + 1);
#line 2325 "utils.c"
	}
#line 285 "../lib/synapse-core/utils.vala"
	(*array)[(*length)++] = value;
#line 285 "../lib/synapse-core/utils.vala"
	(*array)[*length] = NULL;
#line 2331 "utils.c"
}

static gboolean
synapse_utils_async_once_wait_async_co (SynapseUtilsAsyncOnceWaitAsyncData* _data_)
{
#line 284 "../lib/synapse-core/utils.vala"
	switch (_data_->_state_) {
#line 284 "../lib/synapse-core/utils.vala"
		case 0:
#line 2341 "utils.c"
		goto _state_0;
#line 284 "../lib/synapse-core/utils.vala"
		case 1:
#line 2345 "utils.c"
		goto _state_1;
		default:
#line 284 "../lib/synapse-core/utils.vala"
		g_assert_not_reached ();
#line 2350 "utils.c"
	}
	_state_0:
#line 285 "../lib/synapse-core/utils.vala"
	_data_->_tmp0_ = synapse_utils_delegate_wrapper_new (_synapse_utils_async_once_wait_async_co_gsource_func, _data_, NULL);
#line 285 "../lib/synapse-core/utils.vala"
	_vala_array_add8 (&_data_->self->priv->callbacks, &_data_->self->priv->callbacks_length1, &_data_->self->priv->_callbacks_size_, _data_->_tmp0_);
#line 286 "../lib/synapse-core/utils.vala"
	_data_->_state_ = 1;
#line 286 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 2361 "utils.c"
	_state_1:
	;
#line 284 "../lib/synapse-core/utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 284 "../lib/synapse-core/utils.vala"
	if (_data_->_state_ != 0) {
#line 284 "../lib/synapse-core/utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 284 "../lib/synapse-core/utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2372 "utils.c"
		}
	}
#line 284 "../lib/synapse-core/utils.vala"
	g_object_unref (_data_->_async_result);
#line 284 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 2379 "utils.c"
}

static void
synapse_utils_value_async_once_init (GValue* value)
{
#line 221 "../lib/synapse-core/utils.vala"
	value->data[0].v_pointer = NULL;
#line 2387 "utils.c"
}

static void
synapse_utils_value_async_once_free_value (GValue* value)
{
#line 221 "../lib/synapse-core/utils.vala"
	if (value->data[0].v_pointer) {
#line 221 "../lib/synapse-core/utils.vala"
		synapse_utils_async_once_unref (value->data[0].v_pointer);
#line 2397 "utils.c"
	}
}

static void
synapse_utils_value_async_once_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
#line 221 "../lib/synapse-core/utils.vala"
	if (src_value->data[0].v_pointer) {
#line 221 "../lib/synapse-core/utils.vala"
		dest_value->data[0].v_pointer = synapse_utils_async_once_ref (src_value->data[0].v_pointer);
#line 2409 "utils.c"
	} else {
#line 221 "../lib/synapse-core/utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2413 "utils.c"
	}
}

static gpointer
synapse_utils_value_async_once_peek_pointer (const GValue* value)
{
#line 221 "../lib/synapse-core/utils.vala"
	return value->data[0].v_pointer;
#line 2422 "utils.c"
}

static gchar*
synapse_utils_value_async_once_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
#line 221 "../lib/synapse-core/utils.vala"
	if (collect_values[0].v_pointer) {
#line 2433 "utils.c"
		SynapseUtilsAsyncOnce * object;
		object = collect_values[0].v_pointer;
#line 221 "../lib/synapse-core/utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 221 "../lib/synapse-core/utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2440 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 221 "../lib/synapse-core/utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2444 "utils.c"
		}
#line 221 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = synapse_utils_async_once_ref (object);
#line 2448 "utils.c"
	} else {
#line 221 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 2452 "utils.c"
	}
#line 221 "../lib/synapse-core/utils.vala"
	return NULL;
#line 2456 "utils.c"
}

static gchar*
synapse_utils_value_async_once_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	SynapseUtilsAsyncOnce ** object_p;
	object_p = collect_values[0].v_pointer;
#line 221 "../lib/synapse-core/utils.vala"
	if (!object_p) {
#line 221 "../lib/synapse-core/utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2471 "utils.c"
	}
#line 221 "../lib/synapse-core/utils.vala"
	if (!value->data[0].v_pointer) {
#line 221 "../lib/synapse-core/utils.vala"
		*object_p = NULL;
#line 2477 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 221 "../lib/synapse-core/utils.vala"
		*object_p = value->data[0].v_pointer;
#line 2481 "utils.c"
	} else {
#line 221 "../lib/synapse-core/utils.vala"
		*object_p = synapse_utils_async_once_ref (value->data[0].v_pointer);
#line 2485 "utils.c"
	}
#line 221 "../lib/synapse-core/utils.vala"
	return NULL;
#line 2489 "utils.c"
}

GParamSpec*
synapse_utils_param_spec_async_once (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	SynapseUtilsParamSpecAsyncOnce* spec;
#line 221 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_ASYNC_ONCE), NULL);
#line 221 "../lib/synapse-core/utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 221 "../lib/synapse-core/utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 221 "../lib/synapse-core/utils.vala"
	return G_PARAM_SPEC (spec);
#line 2508 "utils.c"
}

gpointer
synapse_utils_value_get_async_once (const GValue* value)
{
#line 221 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE), NULL);
#line 221 "../lib/synapse-core/utils.vala"
	return value->data[0].v_pointer;
#line 2518 "utils.c"
}

void
synapse_utils_value_set_async_once (GValue* value,
                                    gpointer v_object)
{
	SynapseUtilsAsyncOnce * old;
#line 221 "../lib/synapse-core/utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 221 "../lib/synapse-core/utils.vala"
	old = value->data[0].v_pointer;
#line 221 "../lib/synapse-core/utils.vala"
	if (v_object) {
#line 221 "../lib/synapse-core/utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 221 "../lib/synapse-core/utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 221 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = v_object;
#line 221 "../lib/synapse-core/utils.vala"
		synapse_utils_async_once_ref (value->data[0].v_pointer);
#line 2540 "utils.c"
	} else {
#line 221 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 2544 "utils.c"
	}
#line 221 "../lib/synapse-core/utils.vala"
	if (old) {
#line 221 "../lib/synapse-core/utils.vala"
		synapse_utils_async_once_unref (old);
#line 2550 "utils.c"
	}
}

void
synapse_utils_value_take_async_once (GValue* value,
                                     gpointer v_object)
{
	SynapseUtilsAsyncOnce * old;
#line 221 "../lib/synapse-core/utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 221 "../lib/synapse-core/utils.vala"
	old = value->data[0].v_pointer;
#line 221 "../lib/synapse-core/utils.vala"
	if (v_object) {
#line 221 "../lib/synapse-core/utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 221 "../lib/synapse-core/utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 221 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = v_object;
#line 2571 "utils.c"
	} else {
#line 221 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 2575 "utils.c"
	}
#line 221 "../lib/synapse-core/utils.vala"
	if (old) {
#line 221 "../lib/synapse-core/utils.vala"
		synapse_utils_async_once_unref (old);
#line 2581 "utils.c"
	}
}

static void
synapse_utils_async_once_class_init (SynapseUtilsAsyncOnceClass * klass,
                                     gpointer klass_data)
{
#line 221 "../lib/synapse-core/utils.vala"
	synapse_utils_async_once_parent_class = g_type_class_peek_parent (klass);
#line 221 "../lib/synapse-core/utils.vala"
	((SynapseUtilsAsyncOnceClass *) klass)->finalize = synapse_utils_async_once_finalize;
#line 221 "../lib/synapse-core/utils.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUtilsAsyncOnce_private_offset);
#line 2595 "utils.c"
}

static void
synapse_utils_async_once_instance_init (SynapseUtilsAsyncOnce * self,
                                        gpointer klass)
{
	SynapseUtilsDelegateWrapper** _tmp0_;
#line 221 "../lib/synapse-core/utils.vala"
	self->priv = synapse_utils_async_once_get_instance_private (self);
#line 231 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_new0 (SynapseUtilsDelegateWrapper*, 0 + 1);
#line 231 "../lib/synapse-core/utils.vala"
	self->priv->callbacks = _tmp0_;
#line 231 "../lib/synapse-core/utils.vala"
	self->priv->callbacks_length1 = 0;
#line 231 "../lib/synapse-core/utils.vala"
	self->priv->_callbacks_size_ = self->priv->callbacks_length1;
#line 221 "../lib/synapse-core/utils.vala"
	self->ref_count = 1;
#line 2615 "utils.c"
}

static void
synapse_utils_async_once_finalize (SynapseUtilsAsyncOnce * obj)
{
	SynapseUtilsAsyncOnce * self;
#line 221 "../lib/synapse-core/utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce);
#line 221 "../lib/synapse-core/utils.vala"
	g_signal_handlers_destroy (self);
#line 228 "../lib/synapse-core/utils.vala"
	((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
#line 231 "../lib/synapse-core/utils.vala"
	self->priv->callbacks = (_vala_array_free (self->priv->callbacks, self->priv->callbacks_length1, (GDestroyNotify) synapse_utils_delegate_wrapper_free), NULL);
#line 2630 "utils.c"
}

static GType
synapse_utils_async_once_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_async_once_init, synapse_utils_value_async_once_free_value, synapse_utils_value_async_once_copy_value, synapse_utils_value_async_once_peek_pointer, "p", synapse_utils_value_async_once_collect_value, "p", synapse_utils_value_async_once_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsAsyncOnceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_async_once_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsAsyncOnce), 0, (GInstanceInitFunc) synapse_utils_async_once_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_utils_async_once_type_id;
	synapse_utils_async_once_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsAsyncOnce", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SynapseUtilsAsyncOnce_private_offset = g_type_add_instance_private (synapse_utils_async_once_type_id, sizeof (SynapseUtilsAsyncOncePrivate));
	return synapse_utils_async_once_type_id;
}

GType
synapse_utils_async_once_get_type (void)
{
	static volatile gsize synapse_utils_async_once_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_async_once_type_id__volatile)) {
		GType synapse_utils_async_once_type_id;
		synapse_utils_async_once_type_id = synapse_utils_async_once_get_type_once ();
		g_once_init_leave (&synapse_utils_async_once_type_id__volatile, synapse_utils_async_once_type_id);
	}
	return synapse_utils_async_once_type_id__volatile;
}

gpointer
synapse_utils_async_once_ref (gpointer instance)
{
	SynapseUtilsAsyncOnce * self;
	self = instance;
#line 221 "../lib/synapse-core/utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 221 "../lib/synapse-core/utils.vala"
	return instance;
#line 2666 "utils.c"
}

void
synapse_utils_async_once_unref (gpointer instance)
{
	SynapseUtilsAsyncOnce * self;
	self = instance;
#line 221 "../lib/synapse-core/utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 221 "../lib/synapse-core/utils.vala"
		SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS (self)->finalize (self);
#line 221 "../lib/synapse-core/utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2680 "utils.c"
	}
}

static inline gpointer
synapse_utils_file_info_get_instance_private (SynapseUtilsFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsFileInfo_private_offset);
}

SynapseUtilsFileInfo*
synapse_utils_file_info_construct (GType object_type,
                                   const gchar* uri,
                                   GType obj_type)
{
	SynapseUtilsFileInfo* self = NULL;
	gchar* _tmp0_;
	GFile* f = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 311 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 311 "../lib/synapse-core/utils.vala"
	self = (SynapseUtilsFileInfo*) g_type_create_instance (object_type);
#line 312 "../lib/synapse-core/utils.vala"
	_vala_assert (g_type_is_a (obj_type, SYNAPSE_TYPE_URI_MATCH), "obj_type.is_a (typeof (UriMatch))");
#line 313 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_strdup (uri);
#line 313 "../lib/synapse-core/utils.vala"
	_g_free0 (self->uri);
#line 313 "../lib/synapse-core/utils.vala"
	self->uri = _tmp0_;
#line 314 "../lib/synapse-core/utils.vala"
	_g_object_unref0 (self->match_obj);
#line 314 "../lib/synapse-core/utils.vala"
	self->match_obj = NULL;
#line 315 "../lib/synapse-core/utils.vala"
	self->priv->match_obj_type = obj_type;
#line 316 "../lib/synapse-core/utils.vala"
	self->priv->initialized = FALSE;
#line 317 "../lib/synapse-core/utils.vala"
	self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
#line 319 "../lib/synapse-core/utils.vala"
	_tmp1_ = g_file_new_for_uri (uri);
#line 319 "../lib/synapse-core/utils.vala"
	f = _tmp1_;
#line 320 "../lib/synapse-core/utils.vala"
	_tmp2_ = g_file_get_parse_name (f);
#line 320 "../lib/synapse-core/utils.vala"
	_g_free0 (self->parse_name);
#line 320 "../lib/synapse-core/utils.vala"
	self->parse_name = _tmp2_;
#line 311 "../lib/synapse-core/utils.vala"
	_g_object_unref0 (f);
#line 311 "../lib/synapse-core/utils.vala"
	return self;
#line 2736 "utils.c"
}

SynapseUtilsFileInfo*
synapse_utils_file_info_new (const gchar* uri,
                             GType obj_type)
{
#line 311 "../lib/synapse-core/utils.vala"
	return synapse_utils_file_info_construct (SYNAPSE_UTILS_TYPE_FILE_INFO, uri, obj_type);
#line 2745 "utils.c"
}

gboolean
synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self)
{
	gboolean result = FALSE;
#line 323 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 324 "../lib/synapse-core/utils.vala"
	result = self->priv->initialized;
#line 324 "../lib/synapse-core/utils.vala"
	return result;
#line 2758 "utils.c"
}

static void
synapse_utils_file_info_initialize_data_free (gpointer _data)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = _data;
#line 290 "../lib/synapse-core/utils.vala"
	_synapse_utils_file_info_unref0 (_data_->self);
#line 290 "../lib/synapse-core/utils.vala"
	g_slice_free (SynapseUtilsFileInfoInitializeData, _data_);
#line 2770 "utils.c"
}

static gpointer
_synapse_utils_file_info_ref0 (gpointer self)
{
#line 290 "../lib/synapse-core/utils.vala"
	return self ? synapse_utils_file_info_ref (self) : NULL;
#line 2778 "utils.c"
}

void
synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	SynapseUtilsFileInfo* _tmp0_;
#line 290 "../lib/synapse-core/utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsFileInfoInitializeData);
#line 290 "../lib/synapse-core/utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 290 "../lib/synapse-core/utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_file_info_initialize_data_free);
#line 290 "../lib/synapse-core/utils.vala"
	_tmp0_ = _synapse_utils_file_info_ref0 (self);
#line 290 "../lib/synapse-core/utils.vala"
	_data_->self = _tmp0_;
#line 290 "../lib/synapse-core/utils.vala"
	synapse_utils_file_info_initialize_co (_data_);
#line 2800 "utils.c"
}

void
synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self,
                                           GAsyncResult* _res_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
#line 290 "../lib/synapse-core/utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2810 "utils.c"
}

static void
synapse_utils_file_info_initialize_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
#line 332 "../lib/synapse-core/utils.vala"
	_data_ = _user_data_;
#line 332 "../lib/synapse-core/utils.vala"
	_data_->_source_object_ = source_object;
#line 332 "../lib/synapse-core/utils.vala"
	_data_->_res_ = _res_;
#line 332 "../lib/synapse-core/utils.vala"
	synapse_utils_file_info_initialize_co (_data_);
#line 2827 "utils.c"
}

static gboolean
synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* _data_)
{
#line 327 "../lib/synapse-core/utils.vala"
	switch (_data_->_state_) {
#line 327 "../lib/synapse-core/utils.vala"
		case 0:
#line 2837 "utils.c"
		goto _state_0;
#line 331 "../lib/synapse-core/utils.vala"
		case 1:
#line 2841 "utils.c"
		goto _state_1;
		default:
#line 331 "../lib/synapse-core/utils.vala"
		g_assert_not_reached ();
#line 2846 "utils.c"
	}
	_state_0:
#line 328 "../lib/synapse-core/utils.vala"
	_data_->self->priv->initialized = TRUE;
#line 329 "../lib/synapse-core/utils.vala"
	_data_->_tmp0_ = _data_->self->uri;
#line 329 "../lib/synapse-core/utils.vala"
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
#line 329 "../lib/synapse-core/utils.vala"
	_data_->f = _data_->_tmp1_;
#line 2857 "utils.c"
	{
#line 332 "../lib/synapse-core/utils.vala"
		_data_->_tmp2_ = synapse_utils_file_info_interesting_attributes;
#line 332 "../lib/synapse-core/utils.vala"
		_data_->_state_ = 1;
#line 332 "../lib/synapse-core/utils.vala"
		g_file_query_info_async (_data_->f, _data_->_tmp2_, 0, 0, NULL, synapse_utils_file_info_initialize_ready, _data_);
#line 332 "../lib/synapse-core/utils.vala"
		return FALSE;
#line 2867 "utils.c"
		_state_1:
#line 332 "../lib/synapse-core/utils.vala"
		_data_->_tmp3_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error0_);
#line 332 "../lib/synapse-core/utils.vala"
		_data_->fi = _data_->_tmp3_;
#line 332 "../lib/synapse-core/utils.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2875 "utils.c"
			goto __catch0_g_error;
		}
#line 333 "../lib/synapse-core/utils.vala"
		if (g_file_info_get_file_type (_data_->fi) == G_FILE_TYPE_REGULAR) {
#line 333 "../lib/synapse-core/utils.vala"
			_data_->_tmp5_ = !g_file_info_get_is_hidden (_data_->fi);
#line 2882 "utils.c"
		} else {
#line 333 "../lib/synapse-core/utils.vala"
			_data_->_tmp5_ = FALSE;
#line 2886 "utils.c"
		}
#line 333 "../lib/synapse-core/utils.vala"
		if (_data_->_tmp5_) {
#line 333 "../lib/synapse-core/utils.vala"
			_data_->_tmp4_ = !g_file_info_get_is_backup (_data_->fi);
#line 2892 "utils.c"
		} else {
#line 333 "../lib/synapse-core/utils.vala"
			_data_->_tmp4_ = FALSE;
#line 2896 "utils.c"
		}
#line 333 "../lib/synapse-core/utils.vala"
		if (_data_->_tmp4_) {
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp6_ = g_file_info_get_attribute_byte_string (_data_->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp7_ = g_file_info_get_icon (_data_->fi);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp8_ = g_icon_to_string (_data_->_tmp7_);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp10_ = _data_->self->uri;
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp11_ = g_file_info_get_display_name (_data_->fi);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp12_ = g_file_get_parse_name (_data_->f);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp14_ = g_object_new (_data_->self->priv->match_obj_type, "thumbnail-path", _data_->_tmp6_, "icon-name", _data_->_tmp9_, "uri", _data_->_tmp10_, "title", _data_->_tmp11_, "description", _data_->_tmp13_, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, NULL, NULL);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->_tmp15_ = G_IS_INITIALLY_UNOWNED (_data_->_tmp14_) ? g_object_ref_sink (_data_->_tmp14_) : _data_->_tmp14_;
#line 334 "../lib/synapse-core/utils.vala"
			_g_object_unref0 (_data_->self->match_obj);
#line 334 "../lib/synapse-core/utils.vala"
			_data_->self->match_obj = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 334 "../lib/synapse-core/utils.vala"
			_g_free0 (_data_->_tmp13_);
#line 334 "../lib/synapse-core/utils.vala"
			_g_free0 (_data_->_tmp9_);
#line 344 "../lib/synapse-core/utils.vala"
			_data_->_tmp16_ = g_file_info_get_attribute_string (_data_->fi, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
#line 344 "../lib/synapse-core/utils.vala"
			_data_->mime_type = _data_->_tmp16_;
#line 345 "../lib/synapse-core/utils.vala"
			_data_->_tmp17_ = _data_->mime_type;
#line 345 "../lib/synapse-core/utils.vala"
			if (g_content_type_is_unknown (_data_->_tmp17_)) {
#line 346 "../lib/synapse-core/utils.vala"
				_data_->self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
#line 2938 "utils.c"
			} else {
#line 347 "../lib/synapse-core/utils.vala"
				_data_->_tmp18_ = _data_->mime_type;
#line 347 "../lib/synapse-core/utils.vala"
				if (g_content_type_is_a (_data_->_tmp18_, "audio/*")) {
#line 348 "../lib/synapse-core/utils.vala"
					_data_->self->file_type = SYNAPSE_QUERY_FLAGS_AUDIO;
#line 2946 "utils.c"
				} else {
#line 349 "../lib/synapse-core/utils.vala"
					_data_->_tmp19_ = _data_->mime_type;
#line 349 "../lib/synapse-core/utils.vala"
					if (g_content_type_is_a (_data_->_tmp19_, "video/*")) {
#line 350 "../lib/synapse-core/utils.vala"
						_data_->self->file_type = SYNAPSE_QUERY_FLAGS_VIDEO;
#line 2954 "utils.c"
					} else {
#line 351 "../lib/synapse-core/utils.vala"
						_data_->_tmp20_ = _data_->mime_type;
#line 351 "../lib/synapse-core/utils.vala"
						if (g_content_type_is_a (_data_->_tmp20_, "image/*")) {
#line 352 "../lib/synapse-core/utils.vala"
							_data_->self->file_type = SYNAPSE_QUERY_FLAGS_IMAGES;
#line 2962 "utils.c"
						} else {
#line 353 "../lib/synapse-core/utils.vala"
							_data_->_tmp21_ = _data_->mime_type;
#line 353 "../lib/synapse-core/utils.vala"
							if (g_content_type_is_a (_data_->_tmp21_, "text/*")) {
#line 354 "../lib/synapse-core/utils.vala"
								_data_->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
#line 2970 "utils.c"
							} else {
#line 355 "../lib/synapse-core/utils.vala"
								_data_->_tmp22_ = _data_->mime_type;
#line 355 "../lib/synapse-core/utils.vala"
								if (g_content_type_is_a (_data_->_tmp22_, "application/*")) {
#line 356 "../lib/synapse-core/utils.vala"
									_data_->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
#line 2978 "utils.c"
								}
							}
						}
					}
				}
			}
#line 359 "../lib/synapse-core/utils.vala"
			_data_->_tmp23_ = _data_->self->match_obj;
#line 359 "../lib/synapse-core/utils.vala"
			_data_->_tmp24_ = _data_->self->file_type;
#line 359 "../lib/synapse-core/utils.vala"
			synapse_uri_match_set_file_type (_data_->_tmp23_, _data_->_tmp24_);
#line 360 "../lib/synapse-core/utils.vala"
			_data_->_tmp25_ = _data_->self->match_obj;
#line 360 "../lib/synapse-core/utils.vala"
			_data_->_tmp26_ = _data_->mime_type;
#line 360 "../lib/synapse-core/utils.vala"
			synapse_uri_match_set_mime_type (_data_->_tmp25_, _data_->_tmp26_);
#line 2997 "utils.c"
		}
#line 333 "../lib/synapse-core/utils.vala"
		_g_object_unref0 (_data_->fi);
#line 3001 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 333 "../lib/synapse-core/utils.vala"
		_data_->err = _data_->_inner_error0_;
#line 333 "../lib/synapse-core/utils.vala"
		_data_->_inner_error0_ = NULL;
#line 363 "../lib/synapse-core/utils.vala"
		_data_->_tmp27_ = _data_->err;
#line 363 "../lib/synapse-core/utils.vala"
		_data_->_tmp28_ = _data_->_tmp27_->message;
#line 363 "../lib/synapse-core/utils.vala"
		g_warning ("utils.vala:363: %s", _data_->_tmp28_);
#line 333 "../lib/synapse-core/utils.vala"
		_g_error_free0 (_data_->err);
#line 3018 "utils.c"
	}
	__finally0:
#line 333 "../lib/synapse-core/utils.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 333 "../lib/synapse-core/utils.vala"
		_g_object_unref0 (_data_->f);
#line 333 "../lib/synapse-core/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 333 "../lib/synapse-core/utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 333 "../lib/synapse-core/utils.vala"
		g_object_unref (_data_->_async_result);
#line 333 "../lib/synapse-core/utils.vala"
		return FALSE;
#line 3033 "utils.c"
	}
#line 331 "../lib/synapse-core/utils.vala"
	_g_object_unref0 (_data_->f);
#line 331 "../lib/synapse-core/utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 331 "../lib/synapse-core/utils.vala"
	if (_data_->_state_ != 0) {
#line 331 "../lib/synapse-core/utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 331 "../lib/synapse-core/utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3045 "utils.c"
		}
	}
#line 331 "../lib/synapse-core/utils.vala"
	g_object_unref (_data_->_async_result);
#line 331 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 3052 "utils.c"
}

static void
synapse_utils_file_info_exists_data_free (gpointer _data)
{
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = _data;
#line 327 "../lib/synapse-core/utils.vala"
	_synapse_utils_file_info_unref0 (_data_->self);
#line 327 "../lib/synapse-core/utils.vala"
	g_slice_free (SynapseUtilsFileInfoExistsData, _data_);
#line 3064 "utils.c"
}

void
synapse_utils_file_info_exists (SynapseUtilsFileInfo* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseUtilsFileInfoExistsData* _data_;
	SynapseUtilsFileInfo* _tmp0_;
#line 327 "../lib/synapse-core/utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsFileInfoExistsData);
#line 327 "../lib/synapse-core/utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 327 "../lib/synapse-core/utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_file_info_exists_data_free);
#line 327 "../lib/synapse-core/utils.vala"
	_tmp0_ = _synapse_utils_file_info_ref0 (self);
#line 327 "../lib/synapse-core/utils.vala"
	_data_->self = _tmp0_;
#line 327 "../lib/synapse-core/utils.vala"
	synapse_utils_file_info_exists_co (_data_);
#line 3086 "utils.c"
}

gboolean
synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsFileInfoExistsData* _data_;
#line 327 "../lib/synapse-core/utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 327 "../lib/synapse-core/utils.vala"
	result = _data_->result;
#line 327 "../lib/synapse-core/utils.vala"
	return result;
#line 3101 "utils.c"
}

static void
synapse_utils_file_info_exists_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseUtilsFileInfoExistsData* _data_;
#line 369 "../lib/synapse-core/utils.vala"
	_data_ = _user_data_;
#line 369 "../lib/synapse-core/utils.vala"
	_data_->_source_object_ = source_object;
#line 369 "../lib/synapse-core/utils.vala"
	_data_->_res_ = _res_;
#line 369 "../lib/synapse-core/utils.vala"
	synapse_utils_file_info_exists_co (_data_);
#line 3118 "utils.c"
}

static gboolean
synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* _data_)
{
#line 367 "../lib/synapse-core/utils.vala"
	switch (_data_->_state_) {
#line 367 "../lib/synapse-core/utils.vala"
		case 0:
#line 3128 "utils.c"
		goto _state_0;
#line 367 "../lib/synapse-core/utils.vala"
		case 1:
#line 3132 "utils.c"
		goto _state_1;
		default:
#line 367 "../lib/synapse-core/utils.vala"
		g_assert_not_reached ();
#line 3137 "utils.c"
	}
	_state_0:
#line 368 "../lib/synapse-core/utils.vala"
	_data_->_tmp0_ = _data_->self->uri;
#line 368 "../lib/synapse-core/utils.vala"
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
#line 368 "../lib/synapse-core/utils.vala"
	_data_->f = _data_->_tmp1_;
#line 369 "../lib/synapse-core/utils.vala"
	_data_->_state_ = 1;
#line 369 "../lib/synapse-core/utils.vala"
	synapse_utils_query_exists_async (_data_->f, synapse_utils_file_info_exists_ready, _data_);
#line 369 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 3152 "utils.c"
	_state_1:
#line 369 "../lib/synapse-core/utils.vala"
	_data_->_result_ = synapse_utils_query_exists_finish (_data_->_res_);
#line 371 "../lib/synapse-core/utils.vala"
	_data_->result = _data_->_result_;
#line 371 "../lib/synapse-core/utils.vala"
	_g_object_unref0 (_data_->f);
#line 371 "../lib/synapse-core/utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 371 "../lib/synapse-core/utils.vala"
	if (_data_->_state_ != 0) {
#line 371 "../lib/synapse-core/utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 371 "../lib/synapse-core/utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3168 "utils.c"
		}
	}
#line 371 "../lib/synapse-core/utils.vala"
	g_object_unref (_data_->_async_result);
#line 371 "../lib/synapse-core/utils.vala"
	return FALSE;
#line 3175 "utils.c"
}

static void
synapse_utils_value_file_info_init (GValue* value)
{
#line 327 "../lib/synapse-core/utils.vala"
	value->data[0].v_pointer = NULL;
#line 3183 "utils.c"
}

static void
synapse_utils_value_file_info_free_value (GValue* value)
{
#line 327 "../lib/synapse-core/utils.vala"
	if (value->data[0].v_pointer) {
#line 327 "../lib/synapse-core/utils.vala"
		synapse_utils_file_info_unref (value->data[0].v_pointer);
#line 3193 "utils.c"
	}
}

static void
synapse_utils_value_file_info_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 327 "../lib/synapse-core/utils.vala"
	if (src_value->data[0].v_pointer) {
#line 327 "../lib/synapse-core/utils.vala"
		dest_value->data[0].v_pointer = synapse_utils_file_info_ref (src_value->data[0].v_pointer);
#line 3205 "utils.c"
	} else {
#line 327 "../lib/synapse-core/utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3209 "utils.c"
	}
}

static gpointer
synapse_utils_value_file_info_peek_pointer (const GValue* value)
{
#line 327 "../lib/synapse-core/utils.vala"
	return value->data[0].v_pointer;
#line 3218 "utils.c"
}

static gchar*
synapse_utils_value_file_info_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 327 "../lib/synapse-core/utils.vala"
	if (collect_values[0].v_pointer) {
#line 3229 "utils.c"
		SynapseUtilsFileInfo * object;
		object = collect_values[0].v_pointer;
#line 327 "../lib/synapse-core/utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 327 "../lib/synapse-core/utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3236 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 327 "../lib/synapse-core/utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3240 "utils.c"
		}
#line 327 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = synapse_utils_file_info_ref (object);
#line 3244 "utils.c"
	} else {
#line 327 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 3248 "utils.c"
	}
#line 327 "../lib/synapse-core/utils.vala"
	return NULL;
#line 3252 "utils.c"
}

static gchar*
synapse_utils_value_file_info_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	SynapseUtilsFileInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 327 "../lib/synapse-core/utils.vala"
	if (!object_p) {
#line 327 "../lib/synapse-core/utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3267 "utils.c"
	}
#line 327 "../lib/synapse-core/utils.vala"
	if (!value->data[0].v_pointer) {
#line 327 "../lib/synapse-core/utils.vala"
		*object_p = NULL;
#line 3273 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 327 "../lib/synapse-core/utils.vala"
		*object_p = value->data[0].v_pointer;
#line 3277 "utils.c"
	} else {
#line 327 "../lib/synapse-core/utils.vala"
		*object_p = synapse_utils_file_info_ref (value->data[0].v_pointer);
#line 3281 "utils.c"
	}
#line 327 "../lib/synapse-core/utils.vala"
	return NULL;
#line 3285 "utils.c"
}

GParamSpec*
synapse_utils_param_spec_file_info (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	SynapseUtilsParamSpecFileInfo* spec;
#line 327 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
#line 327 "../lib/synapse-core/utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 327 "../lib/synapse-core/utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 327 "../lib/synapse-core/utils.vala"
	return G_PARAM_SPEC (spec);
#line 3304 "utils.c"
}

gpointer
synapse_utils_value_get_file_info (const GValue* value)
{
#line 327 "../lib/synapse-core/utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
#line 327 "../lib/synapse-core/utils.vala"
	return value->data[0].v_pointer;
#line 3314 "utils.c"
}

void
synapse_utils_value_set_file_info (GValue* value,
                                   gpointer v_object)
{
	SynapseUtilsFileInfo * old;
#line 327 "../lib/synapse-core/utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 327 "../lib/synapse-core/utils.vala"
	old = value->data[0].v_pointer;
#line 327 "../lib/synapse-core/utils.vala"
	if (v_object) {
#line 327 "../lib/synapse-core/utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 327 "../lib/synapse-core/utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 327 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = v_object;
#line 327 "../lib/synapse-core/utils.vala"
		synapse_utils_file_info_ref (value->data[0].v_pointer);
#line 3336 "utils.c"
	} else {
#line 327 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 3340 "utils.c"
	}
#line 327 "../lib/synapse-core/utils.vala"
	if (old) {
#line 327 "../lib/synapse-core/utils.vala"
		synapse_utils_file_info_unref (old);
#line 3346 "utils.c"
	}
}

void
synapse_utils_value_take_file_info (GValue* value,
                                    gpointer v_object)
{
	SynapseUtilsFileInfo * old;
#line 327 "../lib/synapse-core/utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 327 "../lib/synapse-core/utils.vala"
	old = value->data[0].v_pointer;
#line 327 "../lib/synapse-core/utils.vala"
	if (v_object) {
#line 327 "../lib/synapse-core/utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 327 "../lib/synapse-core/utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 327 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = v_object;
#line 3367 "utils.c"
	} else {
#line 327 "../lib/synapse-core/utils.vala"
		value->data[0].v_pointer = NULL;
#line 3371 "utils.c"
	}
#line 327 "../lib/synapse-core/utils.vala"
	if (old) {
#line 327 "../lib/synapse-core/utils.vala"
		synapse_utils_file_info_unref (old);
#line 3377 "utils.c"
	}
}

static void
synapse_utils_file_info_class_init (SynapseUtilsFileInfoClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
#line 290 "../lib/synapse-core/utils.vala"
	synapse_utils_file_info_parent_class = g_type_class_peek_parent (klass);
#line 290 "../lib/synapse-core/utils.vala"
	((SynapseUtilsFileInfoClass *) klass)->finalize = synapse_utils_file_info_finalize;
#line 290 "../lib/synapse-core/utils.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUtilsFileInfo_private_offset);
#line 293 "../lib/synapse-core/utils.vala"
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, NULL, NULL);
#line 293 "../lib/synapse-core/utils.vala"
	_g_free0 (synapse_utils_file_info_interesting_attributes);
#line 293 "../lib/synapse-core/utils.vala"
	synapse_utils_file_info_interesting_attributes = _tmp0_;
#line 3398 "utils.c"
}

static void
synapse_utils_file_info_instance_init (SynapseUtilsFileInfo * self,
                                       gpointer klass)
{
#line 290 "../lib/synapse-core/utils.vala"
	self->priv = synapse_utils_file_info_get_instance_private (self);
#line 327 "../lib/synapse-core/utils.vala"
	self->ref_count = 1;
#line 3409 "utils.c"
}

static void
synapse_utils_file_info_finalize (SynapseUtilsFileInfo * obj)
{
	SynapseUtilsFileInfo * self;
#line 290 "../lib/synapse-core/utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo);
#line 290 "../lib/synapse-core/utils.vala"
	g_signal_handlers_destroy (self);
#line 304 "../lib/synapse-core/utils.vala"
	_g_free0 (self->uri);
#line 305 "../lib/synapse-core/utils.vala"
	_g_free0 (self->parse_name);
#line 307 "../lib/synapse-core/utils.vala"
	_g_object_unref0 (self->match_obj);
#line 3426 "utils.c"
}

static GType
synapse_utils_file_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_file_info_init, synapse_utils_value_file_info_free_value, synapse_utils_value_file_info_copy_value, synapse_utils_value_file_info_peek_pointer, "p", synapse_utils_value_file_info_collect_value, "p", synapse_utils_value_file_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsFileInfo), 0, (GInstanceInitFunc) synapse_utils_file_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_utils_file_info_type_id;
	synapse_utils_file_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsFileInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SynapseUtilsFileInfo_private_offset = g_type_add_instance_private (synapse_utils_file_info_type_id, sizeof (SynapseUtilsFileInfoPrivate));
	return synapse_utils_file_info_type_id;
}

GType
synapse_utils_file_info_get_type (void)
{
	static volatile gsize synapse_utils_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_file_info_type_id__volatile)) {
		GType synapse_utils_file_info_type_id;
		synapse_utils_file_info_type_id = synapse_utils_file_info_get_type_once ();
		g_once_init_leave (&synapse_utils_file_info_type_id__volatile, synapse_utils_file_info_type_id);
	}
	return synapse_utils_file_info_type_id__volatile;
}

gpointer
synapse_utils_file_info_ref (gpointer instance)
{
	SynapseUtilsFileInfo * self;
	self = instance;
#line 327 "../lib/synapse-core/utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 327 "../lib/synapse-core/utils.vala"
	return instance;
#line 3462 "utils.c"
}

void
synapse_utils_file_info_unref (gpointer instance)
{
	SynapseUtilsFileInfo * self;
	self = instance;
#line 327 "../lib/synapse-core/utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 327 "../lib/synapse-core/utils.vala"
		SYNAPSE_UTILS_FILE_INFO_GET_CLASS (self)->finalize (self);
#line 327 "../lib/synapse-core/utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3476 "utils.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 290 "../lib/synapse-core/utils.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3487 "utils.c"
		gint i;
#line 290 "../lib/synapse-core/utils.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 290 "../lib/synapse-core/utils.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 290 "../lib/synapse-core/utils.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3495 "utils.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 290 "../lib/synapse-core/utils.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 290 "../lib/synapse-core/utils.vala"
	g_free (array);
#line 3510 "utils.c"
}

