/* link-plugin.c generated by valac 0.48.13, the Vala compiler
 * generated from link-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Magnus Kulke <mkulke@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Magnus Kulke <mkulke@gmail.com>
*/

#include <glib-object.h>
#include "synapse-core.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define SYNAPSE_TYPE_LINK_PLUGIN (synapse_link_plugin_get_type ())
#define SYNAPSE_LINK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin))
#define SYNAPSE_LINK_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPluginClass))
#define SYNAPSE_IS_LINK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LINK_PLUGIN))
#define SYNAPSE_IS_LINK_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LINK_PLUGIN))
#define SYNAPSE_LINK_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPluginClass))

typedef struct _SynapseLinkPlugin SynapseLinkPlugin;
typedef struct _SynapseLinkPluginClass SynapseLinkPluginClass;
typedef struct _SynapseLinkPluginPrivate SynapseLinkPluginPrivate;
enum  {
	SYNAPSE_LINK_PLUGIN_0_PROPERTY,
	SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_LINK_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_link_plugin_properties[SYNAPSE_LINK_PLUGIN_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_LINK_PLUGIN_TYPE_RESULT (synapse_link_plugin_result_get_type ())
#define SYNAPSE_LINK_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult))
#define SYNAPSE_LINK_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResultClass))
#define SYNAPSE_LINK_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LINK_PLUGIN_TYPE_RESULT))
#define SYNAPSE_LINK_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LINK_PLUGIN_TYPE_RESULT))
#define SYNAPSE_LINK_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResultClass))

typedef struct _SynapseLinkPluginResult SynapseLinkPluginResult;
typedef struct _SynapseLinkPluginResultClass SynapseLinkPluginResultClass;
typedef struct _SynapseLinkPluginSearchData SynapseLinkPluginSearchData;
typedef struct _SynapseLinkPluginResultPrivate SynapseLinkPluginResultPrivate;
enum  {
	SYNAPSE_LINK_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_TITLE_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_DESCRIPTION_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_ICON_NAME_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_MATCH_TYPE_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseLinkPlugin {
	GObject parent_instance;
	SynapseLinkPluginPrivate * priv;
};

struct _SynapseLinkPluginClass {
	GObjectClass parent_class;
};

struct _SynapseLinkPluginPrivate {
	gboolean _enabled;
	GRegex* regex;
};

struct _SynapseLinkPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseLinkPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	gboolean matched;
	GRegex* _tmp0_;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	SynapseLinkPluginResult* _result_;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	SynapseLinkPluginResult* _tmp5_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseLinkPluginResult* _tmp8_;
	GError* _inner_error0_;
};

struct _SynapseLinkPluginResult {
	GObject parent_instance;
	SynapseLinkPluginResultPrivate * priv;
};

struct _SynapseLinkPluginResultClass {
	GObjectClass parent_class;
};

struct _SynapseLinkPluginResultPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	gchar* uri;
	GAppInfo* appinfo;
};

static gint SynapseLinkPlugin_private_offset;
static gpointer synapse_link_plugin_parent_class = NULL;
static gint SynapseLinkPluginResult_private_offset;
static gpointer synapse_link_plugin_result_parent_class = NULL;
static SynapseMatchIface * synapse_link_plugin_result_synapse_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_link_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_link_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_link_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseLinkPlugin, g_object_unref)
static void synapse_link_plugin_real_activate (SynapseActivatable* base);
static void synapse_link_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_link_plugin_register_plugin (void);
static void _synapse_link_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_link_plugin_real_handles_query (SynapseItemProvider* base,
                                                 SynapseQuery* query);
static void synapse_link_plugin_real_search_data_free (gpointer _data);
static void synapse_link_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* query,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean synapse_link_plugin_real_search_co (SynapseLinkPluginSearchData* _data_);
GType synapse_link_plugin_result_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseLinkPluginResult, g_object_unref)
SynapseLinkPluginResult* synapse_link_plugin_result_new (const gchar* link);
SynapseLinkPluginResult* synapse_link_plugin_result_construct (GType object_type,
                                                               const gchar* link);
SynapseLinkPlugin* synapse_link_plugin_new (void);
SynapseLinkPlugin* synapse_link_plugin_construct (GType object_type);
static void synapse_link_plugin_result_real_execute (SynapseMatch* base,
                                              SynapseMatch* match);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
gint synapse_link_plugin_result_get_default_relevancy (SynapseLinkPluginResult* self);
void synapse_link_plugin_result_set_default_relevancy (SynapseLinkPluginResult* self,
                                                       gint value);
static void synapse_link_plugin_result_finalize (GObject * obj);
static GType synapse_link_plugin_result_get_type_once (void);
static void _vala_synapse_link_plugin_result_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_synapse_link_plugin_result_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static GObject * synapse_link_plugin_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void synapse_link_plugin_finalize (GObject * obj);
static GType synapse_link_plugin_get_type_once (void);
static void _vala_synapse_link_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_synapse_link_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
synapse_link_plugin_get_instance_private (SynapseLinkPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLinkPlugin_private_offset);
}

static void
synapse_link_plugin_real_activate (SynapseActivatable* base)
{
	SynapseLinkPlugin * self;
#line 27 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) base;
#line 210 "link-plugin.c"
}

static void
synapse_link_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseLinkPlugin * self;
#line 29 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) base;
#line 219 "link-plugin.c"
}

static void
_synapse_link_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 79 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_register_plugin ();
#line 227 "link-plugin.c"
}

static void
synapse_link_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
#line 79 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
#line 79 "../lib/synapse-plugins/link-plugin.vala"
	_tmp1_ = _tmp0_;
#line 79 "../lib/synapse-plugins/link-plugin.vala"
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LINK_PLUGIN, _ ("Link"), _ ("Open link in default browser"), "web-browser", _synapse_link_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 79 "../lib/synapse-plugins/link-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 243 "link-plugin.c"
}

static gboolean
synapse_link_plugin_real_handles_query (SynapseItemProvider* base,
                                        SynapseQuery* query)
{
	SynapseLinkPlugin * self;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	gboolean result = FALSE;
#line 101 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) base;
#line 101 "../lib/synapse-plugins/link-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 102 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = *query;
#line 102 "../lib/synapse-plugins/link-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 102 "../lib/synapse-plugins/link-plugin.vala"
	result = (_tmp1_ & SYNAPSE_QUERY_FLAGS_TEXT) == SYNAPSE_QUERY_FLAGS_TEXT;
#line 102 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 266 "link-plugin.c"
}

static void
synapse_link_plugin_real_search_data_free (gpointer _data)
{
	SynapseLinkPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	g_slice_free (SynapseLinkPluginSearchData, _data_);
#line 282 "link-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 290 "link-plugin.c"
}

static void
synapse_link_plugin_real_search (SynapseItemProvider* base,
                                 SynapseQuery* query,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapseLinkPlugin * self;
	SynapseLinkPluginSearchData* _data_;
	SynapseLinkPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) base;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_data_ = g_slice_new0 (SynapseLinkPluginSearchData);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_link_plugin_real_search_data_free);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_tmp1_ = *query;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_data_->query = _tmp3_;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_real_search_co (_data_);
#line 329 "link-plugin.c"
}

static SynapseResultSet*
synapse_link_plugin_search_finish (SynapseItemProvider* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SynapseResultSet* result;
	SynapseLinkPluginSearchData* _data_;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	if (NULL == _data_) {
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		return NULL;
#line 345 "link-plugin.c"
	}
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	result = _data_->result;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	_data_->result = NULL;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 353 "link-plugin.c"
}

static gboolean
synapse_link_plugin_real_search_co (SynapseLinkPluginSearchData* _data_)
{
#line 105 "../lib/synapse-plugins/link-plugin.vala"
	switch (_data_->_state_) {
#line 105 "../lib/synapse-plugins/link-plugin.vala"
		case 0:
#line 363 "link-plugin.c"
		goto _state_0;
		default:
#line 105 "../lib/synapse-plugins/link-plugin.vala"
		g_assert_not_reached ();
#line 368 "link-plugin.c"
	}
	_state_0:
#line 106 "../lib/synapse-plugins/link-plugin.vala"
	_data_->_tmp0_ = _data_->self->priv->regex;
#line 106 "../lib/synapse-plugins/link-plugin.vala"
	_data_->_tmp1_ = _data_->query;
#line 106 "../lib/synapse-plugins/link-plugin.vala"
	_data_->_tmp2_ = _data_->_tmp1_.query_string;
#line 106 "../lib/synapse-plugins/link-plugin.vala"
	_data_->matched = g_regex_match (_data_->_tmp0_, _data_->_tmp2_, 0, NULL);
#line 107 "../lib/synapse-plugins/link-plugin.vala"
	if (_data_->matched) {
#line 108 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_tmp3_ = _data_->query;
#line 108 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_tmp4_ = _data_->_tmp3_.query_string;
#line 108 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_tmp5_ = synapse_link_plugin_result_new (_data_->_tmp4_);
#line 108 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_result_ = _data_->_tmp5_;
#line 109 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_tmp6_ = synapse_result_set_new ();
#line 109 "../lib/synapse-plugins/link-plugin.vala"
		_data_->results = _data_->_tmp6_;
#line 110 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_tmp7_ = _data_->results;
#line 110 "../lib/synapse-plugins/link-plugin.vala"
		_data_->_tmp8_ = _data_->_result_;
#line 110 "../lib/synapse-plugins/link-plugin.vala"
		synapse_result_set_add (_data_->_tmp7_, (SynapseMatch*) _data_->_tmp8_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
		synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 111 "../lib/synapse-plugins/link-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				_g_object_unref0 (_data_->results);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				return FALSE;
#line 415 "link-plugin.c"
			} else {
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				_g_object_unref0 (_data_->results);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 111 "../lib/synapse-plugins/link-plugin.vala"
				return FALSE;
#line 429 "link-plugin.c"
			}
		}
#line 113 "../lib/synapse-plugins/link-plugin.vala"
		_data_->result = _data_->results;
#line 113 "../lib/synapse-plugins/link-plugin.vala"
		_g_object_unref0 (_data_->_result_);
#line 113 "../lib/synapse-plugins/link-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 113 "../lib/synapse-plugins/link-plugin.vala"
		if (_data_->_state_ != 0) {
#line 113 "../lib/synapse-plugins/link-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 113 "../lib/synapse-plugins/link-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 444 "link-plugin.c"
			}
		}
#line 113 "../lib/synapse-plugins/link-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 113 "../lib/synapse-plugins/link-plugin.vala"
		return FALSE;
#line 451 "link-plugin.c"
	}
#line 116 "../lib/synapse-plugins/link-plugin.vala"
	_data_->result = NULL;
#line 116 "../lib/synapse-plugins/link-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 116 "../lib/synapse-plugins/link-plugin.vala"
	if (_data_->_state_ != 0) {
#line 116 "../lib/synapse-plugins/link-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 116 "../lib/synapse-plugins/link-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 463 "link-plugin.c"
		}
	}
#line 116 "../lib/synapse-plugins/link-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 116 "../lib/synapse-plugins/link-plugin.vala"
	return FALSE;
#line 470 "link-plugin.c"
}

SynapseLinkPlugin*
synapse_link_plugin_construct (GType object_type)
{
	SynapseLinkPlugin * self = NULL;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) g_object_new (object_type, NULL);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	return self;
#line 481 "link-plugin.c"
}

SynapseLinkPlugin*
synapse_link_plugin_new (void)
{
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	return synapse_link_plugin_construct (SYNAPSE_TYPE_LINK_PLUGIN);
#line 489 "link-plugin.c"
}

static gboolean
synapse_link_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseLinkPlugin* self;
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) base;
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	result = self->priv->_enabled;
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 503 "link-plugin.c"
}

static void
synapse_link_plugin_real_set_enabled (SynapseActivatable* base,
                                      gboolean value)
{
	SynapseLinkPlugin* self;
	gboolean old_value;
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPlugin*) base;
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_real_get_enabled (base);
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	if (old_value != value) {
#line 25 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_enabled = value;
#line 25 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_properties[SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY]);
#line 522 "link-plugin.c"
	}
}

static inline gpointer
synapse_link_plugin_result_get_instance_private (SynapseLinkPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLinkPluginResult_private_offset);
}

SynapseLinkPluginResult*
synapse_link_plugin_result_construct (GType object_type,
                                      const gchar* link)
{
	SynapseLinkPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _title = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _icon_name = NULL;
	gchar* _tmp6_;
	GAppInfo* _tmp7_;
	GAppInfo* _tmp8_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
#line 45 "../lib/synapse-plugins/link-plugin.vala"
	g_return_val_if_fail (link != NULL, NULL);
#line 45 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) g_object_new (object_type, NULL);
#line 46 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = g_strdup (link);
#line 46 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (self->priv->uri);
#line 46 "../lib/synapse-plugins/link-plugin.vala"
	self->priv->uri = _tmp0_;
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_tmp1_ = self->priv->uri;
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_tmp2_ = g_strdup_printf ("Open %s in default web browser", _tmp1_);
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_tmp3_ = _tmp2_;
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_tmp4_ = g_strdup (_ (_tmp3_));
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_tmp5_ = _tmp4_;
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (_tmp3_);
#line 47 "../lib/synapse-plugins/link-plugin.vala"
	_title = _tmp5_;
#line 48 "../lib/synapse-plugins/link-plugin.vala"
	_tmp6_ = g_strdup ("web-browser");
#line 48 "../lib/synapse-plugins/link-plugin.vala"
	_icon_name = _tmp6_;
#line 50 "../lib/synapse-plugins/link-plugin.vala"
	_tmp7_ = g_app_info_get_default_for_type ("x-scheme-handler/http", FALSE);
#line 50 "../lib/synapse-plugins/link-plugin.vala"
	_g_object_unref0 (self->priv->appinfo);
#line 50 "../lib/synapse-plugins/link-plugin.vala"
	self->priv->appinfo = _tmp7_;
#line 51 "../lib/synapse-plugins/link-plugin.vala"
	_tmp8_ = self->priv->appinfo;
#line 51 "../lib/synapse-plugins/link-plugin.vala"
	if (_tmp8_ != NULL) {
#line 588 "link-plugin.c"
		const gchar* _tmp9_;
		GAppInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GAppInfo* _tmp13_;
		GIcon* _tmp14_;
		gchar* _tmp15_;
#line 52 "../lib/synapse-plugins/link-plugin.vala"
		_tmp9_ = self->priv->uri;
#line 52 "../lib/synapse-plugins/link-plugin.vala"
		_tmp10_ = self->priv->appinfo;
#line 52 "../lib/synapse-plugins/link-plugin.vala"
		_tmp11_ = g_app_info_get_display_name (_tmp10_);
#line 52 "../lib/synapse-plugins/link-plugin.vala"
		_tmp12_ = g_strdup_printf (_ ("Open %s in %s"), _tmp9_, _tmp11_);
#line 52 "../lib/synapse-plugins/link-plugin.vala"
		_g_free0 (_title);
#line 52 "../lib/synapse-plugins/link-plugin.vala"
		_title = _tmp12_;
#line 53 "../lib/synapse-plugins/link-plugin.vala"
		_tmp13_ = self->priv->appinfo;
#line 53 "../lib/synapse-plugins/link-plugin.vala"
		_tmp14_ = g_app_info_get_icon (_tmp13_);
#line 53 "../lib/synapse-plugins/link-plugin.vala"
		_tmp15_ = g_icon_to_string (_tmp14_);
#line 53 "../lib/synapse-plugins/link-plugin.vala"
		_g_free0 (_icon_name);
#line 53 "../lib/synapse-plugins/link-plugin.vala"
		_icon_name = _tmp15_;
#line 618 "link-plugin.c"
	}
#line 56 "../lib/synapse-plugins/link-plugin.vala"
	_tmp16_ = _title;
#line 56 "../lib/synapse-plugins/link-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp16_);
#line 57 "../lib/synapse-plugins/link-plugin.vala"
	_tmp17_ = _icon_name;
#line 57 "../lib/synapse-plugins/link-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp17_);
#line 58 "../lib/synapse-plugins/link-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _ ("Open this link in default browser"));
#line 59 "../lib/synapse-plugins/link-plugin.vala"
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
#line 60 "../lib/synapse-plugins/link-plugin.vala"
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_ACTION);
#line 45 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (_icon_name);
#line 45 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (_title);
#line 45 "../lib/synapse-plugins/link-plugin.vala"
	return self;
#line 640 "link-plugin.c"
}

SynapseLinkPluginResult*
synapse_link_plugin_result_new (const gchar* link)
{
#line 45 "../lib/synapse-plugins/link-plugin.vala"
	return synapse_link_plugin_result_construct (SYNAPSE_LINK_PLUGIN_TYPE_RESULT, link);
#line 648 "link-plugin.c"
}

static void
_g_free0_ (gpointer var)
{
#line 70 "../lib/synapse-plugins/link-plugin.vala"
	var = (g_free (var), NULL);
#line 656 "link-plugin.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 70 "../lib/synapse-plugins/link-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 664 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_execute (SynapseMatch* base,
                                         SynapseMatch* match)
{
	SynapseLinkPluginResult * self;
	GAppInfo* _tmp0_;
	GList* list = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 63 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 64 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = self->priv->appinfo;
#line 64 "../lib/synapse-plugins/link-plugin.vala"
	if (_tmp0_ == NULL) {
#line 65 "../lib/synapse-plugins/link-plugin.vala"
		return;
#line 685 "link-plugin.c"
	}
#line 68 "../lib/synapse-plugins/link-plugin.vala"
	list = NULL;
#line 69 "../lib/synapse-plugins/link-plugin.vala"
	_tmp1_ = self->priv->uri;
#line 69 "../lib/synapse-plugins/link-plugin.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 69 "../lib/synapse-plugins/link-plugin.vala"
	list = g_list_append (list, _tmp2_);
#line 695 "link-plugin.c"
	{
		GAppInfo* _tmp3_;
		GList* _tmp4_;
#line 71 "../lib/synapse-plugins/link-plugin.vala"
		_tmp3_ = self->priv->appinfo;
#line 71 "../lib/synapse-plugins/link-plugin.vala"
		_tmp4_ = list;
#line 71 "../lib/synapse-plugins/link-plugin.vala"
		g_app_info_launch_uris (_tmp3_, _tmp4_, NULL, &_inner_error0_);
#line 71 "../lib/synapse-plugins/link-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 707 "link-plugin.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		e = _inner_error0_;
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		_inner_error0_ = NULL;
#line 73 "../lib/synapse-plugins/link-plugin.vala"
		_tmp5_ = e;
#line 73 "../lib/synapse-plugins/link-plugin.vala"
		_tmp6_ = _tmp5_->message;
#line 73 "../lib/synapse-plugins/link-plugin.vala"
		g_warning ("link-plugin.vala:73: %s\n", _tmp6_);
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		_g_error_free0 (e);
#line 729 "link-plugin.c"
	}
	__finally0:
#line 70 "../lib/synapse-plugins/link-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		(list == NULL) ? NULL : (list = (_g_list_free__g_free0_ (list), NULL));
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 70 "../lib/synapse-plugins/link-plugin.vala"
		return;
#line 742 "link-plugin.c"
	}
#line 63 "../lib/synapse-plugins/link-plugin.vala"
	(list == NULL) ? NULL : (list = (_g_list_free__g_free0_ (list), NULL));
#line 746 "link-plugin.c"
}

static const gchar*
synapse_link_plugin_result_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseLinkPluginResult* self;
	const gchar* _tmp0_;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	result = _tmp0_;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 763 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_set_title (SynapseMatch* base,
                                           const gchar* value)
{
	SynapseLinkPluginResult* self;
	gchar* old_value;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_real_get_title (base);
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 778 "link-plugin.c"
		gchar* _tmp0_;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 33 "../lib/synapse-plugins/link-plugin.vala"
		_g_free0 (self->priv->_title);
#line 33 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_title = _tmp0_;
#line 33 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_TITLE_PROPERTY]);
#line 788 "link-plugin.c"
	}
}

static const gchar*
synapse_link_plugin_result_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseLinkPluginResult* self;
	const gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = self->priv->_description;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	result = _tmp0_;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 806 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_set_description (SynapseMatch* base,
                                                 const gchar* value)
{
	SynapseLinkPluginResult* self;
	gchar* old_value;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_real_get_description (base);
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 821 "link-plugin.c"
		gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../lib/synapse-plugins/link-plugin.vala"
		_g_free0 (self->priv->_description);
#line 34 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_description = _tmp0_;
#line 34 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_DESCRIPTION_PROPERTY]);
#line 831 "link-plugin.c"
	}
}

static const gchar*
synapse_link_plugin_result_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseLinkPluginResult* self;
	const gchar* _tmp0_;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = self->priv->_icon_name;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	result = _tmp0_;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 849 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_set_icon_name (SynapseMatch* base,
                                               const gchar* value)
{
	SynapseLinkPluginResult* self;
	gchar* old_value;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_real_get_icon_name (base);
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 864 "link-plugin.c"
		gchar* _tmp0_;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 35 "../lib/synapse-plugins/link-plugin.vala"
		_g_free0 (self->priv->_icon_name);
#line 35 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_icon_name = _tmp0_;
#line 35 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_ICON_NAME_PROPERTY]);
#line 874 "link-plugin.c"
	}
}

static gboolean
synapse_link_plugin_result_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseLinkPluginResult* self;
#line 36 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 36 "../lib/synapse-plugins/link-plugin.vala"
	result = self->priv->_has_thumbnail;
#line 36 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 889 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_set_has_thumbnail (SynapseMatch* base,
                                                   gboolean value)
{
	SynapseLinkPluginResult* self;
	gboolean old_value;
#line 36 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 36 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_real_get_has_thumbnail (base);
#line 36 "../lib/synapse-plugins/link-plugin.vala"
	if (old_value != value) {
#line 36 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_has_thumbnail = value;
#line 36 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY]);
#line 908 "link-plugin.c"
	}
}

static const gchar*
synapse_link_plugin_result_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseLinkPluginResult* self;
	const gchar* _tmp0_;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	result = _tmp0_;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 926 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_set_thumbnail_path (SynapseMatch* base,
                                                    const gchar* value)
{
	SynapseLinkPluginResult* self;
	gchar* old_value;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_real_get_thumbnail_path (base);
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 941 "link-plugin.c"
		gchar* _tmp0_;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 37 "../lib/synapse-plugins/link-plugin.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 37 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 37 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY]);
#line 951 "link-plugin.c"
	}
}

static SynapseMatchType
synapse_link_plugin_result_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseLinkPluginResult* self;
	SynapseMatchType _tmp0_;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	_tmp0_ = self->priv->_match_type;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	result = _tmp0_;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 969 "link-plugin.c"
}

static void
synapse_link_plugin_result_real_set_match_type (SynapseMatch* base,
                                                SynapseMatchType value)
{
	SynapseLinkPluginResult* self;
	SynapseMatchType old_value;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	self = (SynapseLinkPluginResult*) base;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_real_get_match_type (base);
#line 38 "../lib/synapse-plugins/link-plugin.vala"
	if (old_value != value) {
#line 38 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_match_type = value;
#line 38 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_MATCH_TYPE_PROPERTY]);
#line 988 "link-plugin.c"
	}
}

gint
synapse_link_plugin_result_get_default_relevancy (SynapseLinkPluginResult* self)
{
	gint result;
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	result = self->priv->_default_relevancy;
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	return result;
#line 1002 "link-plugin.c"
}

void
synapse_link_plugin_result_set_default_relevancy (SynapseLinkPluginResult* self,
                                                  gint value)
{
	gint old_value;
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	old_value = synapse_link_plugin_result_get_default_relevancy (self);
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	if (old_value != value) {
#line 40 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->_default_relevancy = value;
#line 40 "../lib/synapse-plugins/link-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
#line 1020 "link-plugin.c"
	}
}

static void
synapse_link_plugin_result_class_init (SynapseLinkPluginResultClass * klass,
                                       gpointer klass_data)
{
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_result_parent_class = g_type_class_peek_parent (klass);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseLinkPluginResult_private_offset);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_link_plugin_result_get_property;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_link_plugin_result_set_property;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_link_plugin_result_finalize;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_TITLE_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_DESCRIPTION_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_ICON_NAME_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_MATCH_TYPE_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1052 "link-plugin.c"
}

static void
synapse_link_plugin_result_synapse_match_interface_init (SynapseMatchIface * iface,
                                                         gpointer iface_data)
{
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_result_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_link_plugin_result_real_execute;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_title = synapse_link_plugin_result_real_get_title;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_title = synapse_link_plugin_result_real_set_title;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_description = synapse_link_plugin_result_real_get_description;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_description = synapse_link_plugin_result_real_set_description;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_icon_name = synapse_link_plugin_result_real_get_icon_name;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_icon_name = synapse_link_plugin_result_real_set_icon_name;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_has_thumbnail = synapse_link_plugin_result_real_get_has_thumbnail;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_has_thumbnail = synapse_link_plugin_result_real_set_has_thumbnail;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_thumbnail_path = synapse_link_plugin_result_real_get_thumbnail_path;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_thumbnail_path = synapse_link_plugin_result_real_set_thumbnail_path;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_match_type = synapse_link_plugin_result_real_get_match_type;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_match_type = synapse_link_plugin_result_real_set_match_type;
#line 1087 "link-plugin.c"
}

static void
synapse_link_plugin_result_instance_init (SynapseLinkPluginResult * self,
                                          gpointer klass)
{
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	self->priv = synapse_link_plugin_result_get_instance_private (self);
#line 40 "../lib/synapse-plugins/link-plugin.vala"
	self->priv->_default_relevancy = 0;
#line 1098 "link-plugin.c"
}

static void
synapse_link_plugin_result_finalize (GObject * obj)
{
	SynapseLinkPluginResult * self;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult);
#line 33 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (self->priv->_title);
#line 34 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (self->priv->_description);
#line 35 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (self->priv->_icon_name);
#line 37 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 42 "../lib/synapse-plugins/link-plugin.vala"
	_g_free0 (self->priv->uri);
#line 43 "../lib/synapse-plugins/link-plugin.vala"
	_g_object_unref0 (self->priv->appinfo);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (synapse_link_plugin_result_parent_class)->finalize (obj);
#line 1121 "link-plugin.c"
}

static GType
synapse_link_plugin_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLinkPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_link_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLinkPluginResult), 0, (GInstanceInitFunc) synapse_link_plugin_result_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_link_plugin_result_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_link_plugin_result_type_id;
	synapse_link_plugin_result_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLinkPluginResult", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_link_plugin_result_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	SynapseLinkPluginResult_private_offset = g_type_add_instance_private (synapse_link_plugin_result_type_id, sizeof (SynapseLinkPluginResultPrivate));
	return synapse_link_plugin_result_type_id;
}

GType
synapse_link_plugin_result_get_type (void)
{
	static volatile gsize synapse_link_plugin_result_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_link_plugin_result_type_id__volatile)) {
		GType synapse_link_plugin_result_type_id;
		synapse_link_plugin_result_type_id = synapse_link_plugin_result_get_type_once ();
		g_once_init_leave (&synapse_link_plugin_result_type_id__volatile, synapse_link_plugin_result_type_id);
	}
	return synapse_link_plugin_result_type_id__volatile;
}

static void
_vala_synapse_link_plugin_result_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SynapseLinkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	switch (property_id) {
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_TITLE_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_DESCRIPTION_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_ICON_NAME_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_MATCH_TYPE_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_int (value, synapse_link_plugin_result_get_default_relevancy (self));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1200 "link-plugin.c"
		default:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1206 "link-plugin.c"
	}
}

static void
_vala_synapse_link_plugin_result_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SynapseLinkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
	switch (property_id) {
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_TITLE_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_DESCRIPTION_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_ICON_NAME_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_MATCH_TYPE_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		synapse_link_plugin_result_set_default_relevancy (self, g_value_get_int (value));
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1262 "link-plugin.c"
		default:
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1268 "link-plugin.c"
	}
}

static GObject *
synapse_link_plugin_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLinkPlugin * self;
	GError* _inner_error0_ = NULL;
#line 92 "../lib/synapse-plugins/link-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_link_plugin_parent_class);
#line 92 "../lib/synapse-plugins/link-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 92 "../lib/synapse-plugins/link-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
#line 1287 "link-plugin.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		_tmp1_ = g_regex_new ("[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,4}\\b([-a-zA-Z0-9@:%_\\+.~#?&" \
"//=]*)", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		_tmp0_ = _tmp1_;
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1298 "link-plugin.c"
			goto __catch0_g_error;
		}
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		_tmp2_ = _tmp0_;
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		_tmp0_ = NULL;
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		_g_regex_unref0 (self->priv->regex);
#line 94 "../lib/synapse-plugins/link-plugin.vala"
		self->priv->regex = _tmp2_;
#line 93 "../lib/synapse-plugins/link-plugin.vala"
		_g_regex_unref0 (_tmp0_);
#line 1311 "link-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 93 "../lib/synapse-plugins/link-plugin.vala"
		e = _inner_error0_;
#line 93 "../lib/synapse-plugins/link-plugin.vala"
		_inner_error0_ = NULL;
#line 97 "../lib/synapse-plugins/link-plugin.vala"
		_tmp3_ = e;
#line 97 "../lib/synapse-plugins/link-plugin.vala"
		_tmp4_ = _tmp3_->message;
#line 97 "../lib/synapse-plugins/link-plugin.vala"
		g_critical ("link-plugin.vala:97: Error creating regexp: %s", _tmp4_);
#line 93 "../lib/synapse-plugins/link-plugin.vala"
		_g_error_free0 (e);
#line 1331 "link-plugin.c"
	}
	__finally0:
#line 93 "../lib/synapse-plugins/link-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 93 "../lib/synapse-plugins/link-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 93 "../lib/synapse-plugins/link-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 1340 "link-plugin.c"
	}
#line 92 "../lib/synapse-plugins/link-plugin.vala"
	return obj;
#line 1344 "link-plugin.c"
}

static void
synapse_link_plugin_class_init (SynapseLinkPluginClass * klass,
                                gpointer klass_data)
{
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseLinkPlugin_private_offset);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_link_plugin_get_property;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_link_plugin_set_property;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_link_plugin_constructor;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_link_plugin_finalize;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY, synapse_link_plugin_properties[SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 87 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_register_plugin ();
#line 1367 "link-plugin.c"
}

static void
synapse_link_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                        gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_link_plugin_real_activate;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_link_plugin_real_deactivate;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->get_enabled = synapse_link_plugin_real_get_enabled;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->set_enabled = synapse_link_plugin_real_set_enabled;
#line 1384 "link-plugin.c"
}

static void
synapse_link_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                          gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	synapse_link_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_link_plugin_real_handles_query;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_link_plugin_real_search;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_link_plugin_search_finish;
#line 1399 "link-plugin.c"
}

static void
synapse_link_plugin_instance_init (SynapseLinkPlugin * self,
                                   gpointer klass)
{
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	self->priv = synapse_link_plugin_get_instance_private (self);
#line 25 "../lib/synapse-plugins/link-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1410 "link-plugin.c"
}

static void
synapse_link_plugin_finalize (GObject * obj)
{
	SynapseLinkPlugin * self;
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
#line 90 "../lib/synapse-plugins/link-plugin.vala"
	_g_regex_unref0 (self->priv->regex);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	G_OBJECT_CLASS (synapse_link_plugin_parent_class)->finalize (obj);
#line 1423 "link-plugin.c"
}

static GType
synapse_link_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLinkPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_link_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLinkPlugin), 0, (GInstanceInitFunc) synapse_link_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_link_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_link_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_link_plugin_type_id;
	synapse_link_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLinkPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_link_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_link_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseLinkPlugin_private_offset = g_type_add_instance_private (synapse_link_plugin_type_id, sizeof (SynapseLinkPluginPrivate));
	return synapse_link_plugin_type_id;
}

GType
synapse_link_plugin_get_type (void)
{
	static volatile gsize synapse_link_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_link_plugin_type_id__volatile)) {
		GType synapse_link_plugin_type_id;
		synapse_link_plugin_type_id = synapse_link_plugin_get_type_once ();
		g_once_init_leave (&synapse_link_plugin_type_id__volatile, synapse_link_plugin_type_id);
	}
	return synapse_link_plugin_type_id__volatile;
}

static void
_vala_synapse_link_plugin_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapseLinkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1468 "link-plugin.c"
		default:
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1474 "link-plugin.c"
	}
}

static void
_vala_synapse_link_plugin_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapseLinkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		case SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1494 "link-plugin.c"
		default:
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/link-plugin.vala"
		break;
#line 1500 "link-plugin.c"
	}
}

