/* Grid.c generated by valac 0.48.13, the Vala compiler
 * generated from Grid.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>

#define LAUNCHER_WIDGETS_TYPE_PAGE (launcher_widgets_page_get_type ())
typedef struct _LauncherWidgetsPage LauncherWidgetsPage;

#define LAUNCHER_WIDGETS_TYPE_GRID (launcher_widgets_grid_get_type ())
#define LAUNCHER_WIDGETS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_WIDGETS_TYPE_GRID, LauncherWidgetsGrid))
#define LAUNCHER_WIDGETS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_WIDGETS_TYPE_GRID, LauncherWidgetsGridClass))
#define LAUNCHER_WIDGETS_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_WIDGETS_TYPE_GRID))
#define LAUNCHER_WIDGETS_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_WIDGETS_TYPE_GRID))
#define LAUNCHER_WIDGETS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_WIDGETS_TYPE_GRID, LauncherWidgetsGridClass))

typedef struct _LauncherWidgetsGrid LauncherWidgetsGrid;
typedef struct _LauncherWidgetsGridClass LauncherWidgetsGridClass;
typedef struct _LauncherWidgetsGridPrivate LauncherWidgetsGridPrivate;

#define LAUNCHER_WIDGETS_TYPE_SWITCHER (launcher_widgets_switcher_get_type ())
#define LAUNCHER_WIDGETS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_WIDGETS_TYPE_SWITCHER, LauncherWidgetsSwitcher))
#define LAUNCHER_WIDGETS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_WIDGETS_TYPE_SWITCHER, LauncherWidgetsSwitcherClass))
#define LAUNCHER_WIDGETS_IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_WIDGETS_TYPE_SWITCHER))
#define LAUNCHER_WIDGETS_IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_WIDGETS_TYPE_SWITCHER))
#define LAUNCHER_WIDGETS_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_WIDGETS_TYPE_SWITCHER, LauncherWidgetsSwitcherClass))

typedef struct _LauncherWidgetsSwitcher LauncherWidgetsSwitcher;
typedef struct _LauncherWidgetsSwitcherClass LauncherWidgetsSwitcherClass;
enum  {
	LAUNCHER_WIDGETS_GRID_0_PROPERTY,
	LAUNCHER_WIDGETS_GRID_NUM_PROPERTIES
};
static GParamSpec* launcher_widgets_grid_properties[LAUNCHER_WIDGETS_GRID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define LAUNCHER_WIDGETS_TYPE_APP_ENTRY (launcher_widgets_app_entry_get_type ())
#define LAUNCHER_WIDGETS_APP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_WIDGETS_TYPE_APP_ENTRY, LauncherWidgetsAppEntry))
#define LAUNCHER_WIDGETS_APP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_WIDGETS_TYPE_APP_ENTRY, LauncherWidgetsAppEntryClass))
#define LAUNCHER_WIDGETS_IS_APP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_WIDGETS_TYPE_APP_ENTRY))
#define LAUNCHER_WIDGETS_IS_APP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_WIDGETS_TYPE_APP_ENTRY))
#define LAUNCHER_WIDGETS_APP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_WIDGETS_TYPE_APP_ENTRY, LauncherWidgetsAppEntryClass))

typedef struct _LauncherWidgetsAppEntry LauncherWidgetsAppEntry;
typedef struct _LauncherWidgetsAppEntryClass LauncherWidgetsAppEntryClass;

struct _LauncherWidgetsPage {
	guint rows;
	guint columns;
	gint number;
};

struct _LauncherWidgetsGrid {
	GtkBox parent_instance;
	LauncherWidgetsGridPrivate * priv;
	LauncherWidgetsSwitcher* page_switcher;
};

struct _LauncherWidgetsGridClass {
	GtkBoxClass parent_class;
};

struct _LauncherWidgetsGridPrivate {
	GtkStack* stack;
	GtkGrid* current_grid;
	GeeHashMap* grids;
	guint current_row;
	guint current_col;
	LauncherWidgetsPage page;
};

static gint LauncherWidgetsGrid_private_offset;
static gpointer launcher_widgets_grid_parent_class = NULL;

GType launcher_widgets_page_get_type (void) G_GNUC_CONST;
LauncherWidgetsPage* launcher_widgets_page_dup (const LauncherWidgetsPage* self);
void launcher_widgets_page_free (LauncherWidgetsPage* self);
GType launcher_widgets_grid_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherWidgetsGrid, g_object_unref)
GType launcher_widgets_switcher_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherWidgetsSwitcher, g_object_unref)
LauncherWidgetsGrid* launcher_widgets_grid_new (gint rows,
                                                gint columns);
LauncherWidgetsGrid* launcher_widgets_grid_construct (GType object_type,
                                                      gint rows,
                                                      gint columns);
LauncherWidgetsSwitcher* launcher_widgets_switcher_new (void);
LauncherWidgetsSwitcher* launcher_widgets_switcher_construct (GType object_type);
void launcher_widgets_switcher_set_stack (LauncherWidgetsSwitcher* self,
                                          GtkStack* stack);
static void launcher_widgets_grid_create_new_grid (LauncherWidgetsGrid* self);
void launcher_widgets_grid_go_to_number (LauncherWidgetsGrid* self,
                                         gint number);
#define LAUNCHER_PIXELS_ROW_SPACING 10
void launcher_widgets_grid_append (LauncherWidgetsGrid* self,
                                   GtkWidget* widget);
static void launcher_widgets_grid_update_position (LauncherWidgetsGrid* self);
void launcher_widgets_grid_clear (LauncherWidgetsGrid* self);
GtkWidget* launcher_widgets_grid_get_child_at (LauncherWidgetsGrid* self,
                                               gint column,
                                               gint row);
GType launcher_widgets_app_entry_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherWidgetsAppEntry, g_object_unref)
gint launcher_widgets_grid_get_page_columns (LauncherWidgetsGrid* self);
gint launcher_widgets_grid_get_page_rows (LauncherWidgetsGrid* self);
gint launcher_widgets_grid_get_n_pages (LauncherWidgetsGrid* self);
gint launcher_widgets_grid_get_current_page (LauncherWidgetsGrid* self);
void launcher_widgets_grid_go_to_next (LauncherWidgetsGrid* self);
void launcher_widgets_switcher_update_selected (LauncherWidgetsSwitcher* self);
void launcher_widgets_grid_go_to_previous (LauncherWidgetsGrid* self);
void launcher_widgets_grid_go_to_last (LauncherWidgetsGrid* self);
void launcher_widgets_grid_resize (LauncherWidgetsGrid* self,
                                   gint rows,
                                   gint columns);
static void launcher_widgets_grid_finalize (GObject * obj);
static GType launcher_widgets_grid_get_type_once (void);

LauncherWidgetsPage*
launcher_widgets_page_dup (const LauncherWidgetsPage* self)
{
	LauncherWidgetsPage* dup;
#line 23 "../src/Widgets/Grid.vala"
	dup = g_new0 (LauncherWidgetsPage, 1);
#line 23 "../src/Widgets/Grid.vala"
	memcpy (dup, self, sizeof (LauncherWidgetsPage));
#line 23 "../src/Widgets/Grid.vala"
	return dup;
#line 152 "Grid.c"
}

void
launcher_widgets_page_free (LauncherWidgetsPage* self)
{
#line 23 "../src/Widgets/Grid.vala"
	g_free (self);
#line 160 "Grid.c"
}

static GType
launcher_widgets_page_get_type_once (void)
{
	GType launcher_widgets_page_type_id;
	launcher_widgets_page_type_id = g_boxed_type_register_static ("LauncherWidgetsPage", (GBoxedCopyFunc) launcher_widgets_page_dup, (GBoxedFreeFunc) launcher_widgets_page_free);
	return launcher_widgets_page_type_id;
}

GType
launcher_widgets_page_get_type (void)
{
	static volatile gsize launcher_widgets_page_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_widgets_page_type_id__volatile)) {
		GType launcher_widgets_page_type_id;
		launcher_widgets_page_type_id = launcher_widgets_page_get_type_once ();
		g_once_init_leave (&launcher_widgets_page_type_id__volatile, launcher_widgets_page_type_id);
	}
	return launcher_widgets_page_type_id__volatile;
}

static inline gpointer
launcher_widgets_grid_get_instance_private (LauncherWidgetsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, LauncherWidgetsGrid_private_offset);
}

LauncherWidgetsGrid*
launcher_widgets_grid_construct (GType object_type,
                                 gint rows,
                                 gint columns)
{
	LauncherWidgetsGrid * self = NULL;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp0_;
	GtkStack* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	LauncherWidgetsSwitcher* _tmp4_;
	LauncherWidgetsSwitcher* _tmp5_;
	GtkStack* _tmp6_;
	GtkGrid* fake_grid = NULL;
	GtkGrid* _tmp7_;
	GtkStack* _tmp8_;
	LauncherWidgetsSwitcher* _tmp9_;
	GeeHashMap* _tmp10_;
#line 42 "../src/Widgets/Grid.vala"
	self = (LauncherWidgetsGrid*) g_object_new (object_type, NULL);
#line 43 "../src/Widgets/Grid.vala"
	self->priv->page.rows = (guint) rows;
#line 44 "../src/Widgets/Grid.vala"
	self->priv->page.columns = (guint) columns;
#line 45 "../src/Widgets/Grid.vala"
	self->priv->page.number = 1;
#line 46 "../src/Widgets/Grid.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 46 "../src/Widgets/Grid.vala"
	g_object_ref_sink (_tmp0_);
#line 46 "../src/Widgets/Grid.vala"
	main_grid = _tmp0_;
#line 47 "../src/Widgets/Grid.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) main_grid, GTK_ORIENTATION_VERTICAL);
#line 48 "../src/Widgets/Grid.vala"
	gtk_grid_set_row_spacing (main_grid, 6);
#line 49 "../src/Widgets/Grid.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) main_grid, 12);
#line 50 "../src/Widgets/Grid.vala"
	_tmp1_ = (GtkStack*) gtk_stack_new ();
#line 50 "../src/Widgets/Grid.vala"
	g_object_ref_sink (_tmp1_);
#line 50 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->priv->stack);
#line 50 "../src/Widgets/Grid.vala"
	self->priv->stack = _tmp1_;
#line 51 "../src/Widgets/Grid.vala"
	_tmp2_ = self->priv->stack;
#line 51 "../src/Widgets/Grid.vala"
	g_object_set ((GtkWidget*) _tmp2_, "expand", TRUE, NULL);
#line 52 "../src/Widgets/Grid.vala"
	_tmp3_ = self->priv->stack;
#line 52 "../src/Widgets/Grid.vala"
	gtk_stack_set_transition_type (_tmp3_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
#line 53 "../src/Widgets/Grid.vala"
	_tmp4_ = launcher_widgets_switcher_new ();
#line 53 "../src/Widgets/Grid.vala"
	g_object_ref_sink (_tmp4_);
#line 53 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->page_switcher);
#line 53 "../src/Widgets/Grid.vala"
	self->page_switcher = _tmp4_;
#line 54 "../src/Widgets/Grid.vala"
	_tmp5_ = self->page_switcher;
#line 54 "../src/Widgets/Grid.vala"
	_tmp6_ = self->priv->stack;
#line 54 "../src/Widgets/Grid.vala"
	launcher_widgets_switcher_set_stack (_tmp5_, _tmp6_);
#line 55 "../src/Widgets/Grid.vala"
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
#line 55 "../src/Widgets/Grid.vala"
	g_object_ref_sink (_tmp7_);
#line 55 "../src/Widgets/Grid.vala"
	fake_grid = _tmp7_;
#line 56 "../src/Widgets/Grid.vala"
	g_object_set ((GtkWidget*) fake_grid, "expand", TRUE, NULL);
#line 58 "../src/Widgets/Grid.vala"
	_tmp8_ = self->priv->stack;
#line 58 "../src/Widgets/Grid.vala"
	gtk_container_add ((GtkContainer*) main_grid, (GtkWidget*) _tmp8_);
#line 59 "../src/Widgets/Grid.vala"
	gtk_container_add ((GtkContainer*) main_grid, (GtkWidget*) fake_grid);
#line 60 "../src/Widgets/Grid.vala"
	_tmp9_ = self->page_switcher;
#line 60 "../src/Widgets/Grid.vala"
	gtk_container_add ((GtkContainer*) main_grid, (GtkWidget*) _tmp9_);
#line 61 "../src/Widgets/Grid.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_grid);
#line 63 "../src/Widgets/Grid.vala"
	_tmp10_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, gtk_grid_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 63 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->priv->grids);
#line 63 "../src/Widgets/Grid.vala"
	self->priv->grids = _tmp10_;
#line 64 "../src/Widgets/Grid.vala"
	launcher_widgets_grid_create_new_grid (self);
#line 65 "../src/Widgets/Grid.vala"
	launcher_widgets_grid_go_to_number (self, 1);
#line 42 "../src/Widgets/Grid.vala"
	_g_object_unref0 (fake_grid);
#line 42 "../src/Widgets/Grid.vala"
	_g_object_unref0 (main_grid);
#line 42 "../src/Widgets/Grid.vala"
	return self;
#line 294 "Grid.c"
}

LauncherWidgetsGrid*
launcher_widgets_grid_new (gint rows,
                           gint columns)
{
#line 42 "../src/Widgets/Grid.vala"
	return launcher_widgets_grid_construct (LAUNCHER_WIDGETS_TYPE_GRID, rows, columns);
#line 303 "Grid.c"
}

static void
launcher_widgets_grid_create_new_grid (LauncherWidgetsGrid* self)
{
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GeeHashMap* _tmp10_;
	LauncherWidgetsPage _tmp11_;
	GtkGrid* _tmp12_;
	GtkStack* _tmp13_;
	GtkGrid* _tmp14_;
	LauncherWidgetsPage _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	LauncherWidgetsPage _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
#line 68 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 70 "../src/Widgets/Grid.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 70 "../src/Widgets/Grid.vala"
	g_object_ref_sink (_tmp0_);
#line 70 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->priv->current_grid);
#line 70 "../src/Widgets/Grid.vala"
	self->priv->current_grid = _tmp0_;
#line 71 "../src/Widgets/Grid.vala"
	_tmp1_ = self->priv->current_grid;
#line 71 "../src/Widgets/Grid.vala"
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
#line 72 "../src/Widgets/Grid.vala"
	_tmp2_ = self->priv->current_grid;
#line 72 "../src/Widgets/Grid.vala"
	gtk_grid_set_row_homogeneous (_tmp2_, TRUE);
#line 73 "../src/Widgets/Grid.vala"
	_tmp3_ = self->priv->current_grid;
#line 73 "../src/Widgets/Grid.vala"
	gtk_grid_set_column_homogeneous (_tmp3_, TRUE);
#line 74 "../src/Widgets/Grid.vala"
	_tmp4_ = self->priv->current_grid;
#line 74 "../src/Widgets/Grid.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 25);
#line 75 "../src/Widgets/Grid.vala"
	_tmp5_ = self->priv->current_grid;
#line 75 "../src/Widgets/Grid.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 25);
#line 76 "../src/Widgets/Grid.vala"
	_tmp6_ = self->priv->current_grid;
#line 76 "../src/Widgets/Grid.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 25);
#line 77 "../src/Widgets/Grid.vala"
	_tmp7_ = self->priv->current_grid;
#line 77 "../src/Widgets/Grid.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp7_, 25);
#line 79 "../src/Widgets/Grid.vala"
	_tmp8_ = self->priv->current_grid;
#line 79 "../src/Widgets/Grid.vala"
	gtk_grid_set_row_spacing (_tmp8_, LAUNCHER_PIXELS_ROW_SPACING);
#line 80 "../src/Widgets/Grid.vala"
	_tmp9_ = self->priv->current_grid;
#line 80 "../src/Widgets/Grid.vala"
	gtk_grid_set_column_spacing (_tmp9_, 0);
#line 81 "../src/Widgets/Grid.vala"
	_tmp10_ = self->priv->grids;
#line 81 "../src/Widgets/Grid.vala"
	_tmp11_ = self->priv->page;
#line 81 "../src/Widgets/Grid.vala"
	_tmp12_ = self->priv->current_grid;
#line 81 "../src/Widgets/Grid.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) _tmp11_.number), _tmp12_);
#line 82 "../src/Widgets/Grid.vala"
	_tmp13_ = self->priv->stack;
#line 82 "../src/Widgets/Grid.vala"
	_tmp14_ = self->priv->current_grid;
#line 82 "../src/Widgets/Grid.vala"
	_tmp15_ = self->priv->page;
#line 82 "../src/Widgets/Grid.vala"
	_tmp16_ = g_strdup_printf ("%i", _tmp15_.number);
#line 82 "../src/Widgets/Grid.vala"
	_tmp17_ = _tmp16_;
#line 82 "../src/Widgets/Grid.vala"
	_tmp18_ = self->priv->page;
#line 82 "../src/Widgets/Grid.vala"
	_tmp19_ = g_strdup_printf ("%i", _tmp18_.number);
#line 82 "../src/Widgets/Grid.vala"
	_tmp20_ = _tmp19_;
#line 82 "../src/Widgets/Grid.vala"
	gtk_stack_add_titled (_tmp13_, (GtkWidget*) _tmp14_, _tmp17_, _tmp20_);
#line 82 "../src/Widgets/Grid.vala"
	_g_free0 (_tmp20_);
#line 82 "../src/Widgets/Grid.vala"
	_g_free0 (_tmp17_);
#line 406 "Grid.c"
	{
		gint row = 0;
#line 85 "../src/Widgets/Grid.vala"
		row = 0;
#line 411 "Grid.c"
		{
			gboolean _tmp21_ = FALSE;
#line 85 "../src/Widgets/Grid.vala"
			_tmp21_ = TRUE;
#line 85 "../src/Widgets/Grid.vala"
			while (TRUE) {
#line 418 "Grid.c"
				LauncherWidgetsPage _tmp23_;
#line 85 "../src/Widgets/Grid.vala"
				if (!_tmp21_) {
#line 422 "Grid.c"
					gint _tmp22_;
#line 85 "../src/Widgets/Grid.vala"
					_tmp22_ = row;
#line 85 "../src/Widgets/Grid.vala"
					row = _tmp22_ + 1;
#line 428 "Grid.c"
				}
#line 85 "../src/Widgets/Grid.vala"
				_tmp21_ = FALSE;
#line 85 "../src/Widgets/Grid.vala"
				_tmp23_ = self->priv->page;
#line 85 "../src/Widgets/Grid.vala"
				if (!(((guint) row) < _tmp23_.rows)) {
#line 85 "../src/Widgets/Grid.vala"
					break;
#line 438 "Grid.c"
				}
				{
					gint column = 0;
#line 86 "../src/Widgets/Grid.vala"
					column = 0;
#line 444 "Grid.c"
					{
						gboolean _tmp24_ = FALSE;
#line 86 "../src/Widgets/Grid.vala"
						_tmp24_ = TRUE;
#line 86 "../src/Widgets/Grid.vala"
						while (TRUE) {
#line 451 "Grid.c"
							LauncherWidgetsPage _tmp26_;
							GtkGrid* _tmp27_;
							GtkGrid* _tmp28_;
							GtkGrid* _tmp29_;
#line 86 "../src/Widgets/Grid.vala"
							if (!_tmp24_) {
#line 458 "Grid.c"
								gint _tmp25_;
#line 86 "../src/Widgets/Grid.vala"
								_tmp25_ = column;
#line 86 "../src/Widgets/Grid.vala"
								column = _tmp25_ + 1;
#line 464 "Grid.c"
							}
#line 86 "../src/Widgets/Grid.vala"
							_tmp24_ = FALSE;
#line 86 "../src/Widgets/Grid.vala"
							_tmp26_ = self->priv->page;
#line 86 "../src/Widgets/Grid.vala"
							if (!(((guint) column) < _tmp26_.columns)) {
#line 86 "../src/Widgets/Grid.vala"
								break;
#line 474 "Grid.c"
							}
#line 87 "../src/Widgets/Grid.vala"
							_tmp27_ = self->priv->current_grid;
#line 87 "../src/Widgets/Grid.vala"
							_tmp28_ = (GtkGrid*) gtk_grid_new ();
#line 87 "../src/Widgets/Grid.vala"
							g_object_ref_sink (_tmp28_);
#line 87 "../src/Widgets/Grid.vala"
							_tmp29_ = _tmp28_;
#line 87 "../src/Widgets/Grid.vala"
							gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp29_, column, row, 1, 1);
#line 87 "../src/Widgets/Grid.vala"
							_g_object_unref0 (_tmp29_);
#line 488 "Grid.c"
						}
					}
				}
			}
		}
	}
}

void
launcher_widgets_grid_append (LauncherWidgetsGrid* self,
                              GtkWidget* widget)
{
	GtkGrid* _tmp0_;
	guint _tmp1_;
	GtkGrid* _tmp2_;
#line 90 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 90 "../src/Widgets/Grid.vala"
	g_return_if_fail (widget != NULL);
#line 91 "../src/Widgets/Grid.vala"
	launcher_widgets_grid_update_position (self);
#line 93 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->current_grid;
#line 93 "../src/Widgets/Grid.vala"
	gtk_grid_attach (_tmp0_, widget, (gint) self->priv->current_col, (gint) self->priv->current_row, 1, 1);
#line 94 "../src/Widgets/Grid.vala"
	_tmp1_ = self->priv->current_col;
#line 94 "../src/Widgets/Grid.vala"
	self->priv->current_col = _tmp1_ + 1;
#line 95 "../src/Widgets/Grid.vala"
	_tmp2_ = self->priv->current_grid;
#line 95 "../src/Widgets/Grid.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 522 "Grid.c"
}

static void
launcher_widgets_grid_update_position (LauncherWidgetsGrid* self)
{
	LauncherWidgetsPage _tmp0_;
	LauncherWidgetsPage _tmp2_;
#line 98 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 99 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->page;
#line 99 "../src/Widgets/Grid.vala"
	if (self->priv->current_col == _tmp0_.columns) {
#line 536 "Grid.c"
		guint _tmp1_;
#line 100 "../src/Widgets/Grid.vala"
		self->priv->current_col = (guint) 0;
#line 101 "../src/Widgets/Grid.vala"
		_tmp1_ = self->priv->current_row;
#line 101 "../src/Widgets/Grid.vala"
		self->priv->current_row = _tmp1_ + 1;
#line 544 "Grid.c"
	}
#line 104 "../src/Widgets/Grid.vala"
	_tmp2_ = self->priv->page;
#line 104 "../src/Widgets/Grid.vala"
	if (self->priv->current_row == _tmp2_.rows) {
#line 550 "Grid.c"
		gint _tmp3_;
#line 105 "../src/Widgets/Grid.vala"
		_tmp3_ = self->priv->page.number;
#line 105 "../src/Widgets/Grid.vala"
		self->priv->page.number = _tmp3_ + 1;
#line 106 "../src/Widgets/Grid.vala"
		launcher_widgets_grid_create_new_grid (self);
#line 107 "../src/Widgets/Grid.vala"
		self->priv->current_row = (guint) 0;
#line 560 "Grid.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 113 "../src/Widgets/Grid.vala"
	return self ? g_object_ref (self) : NULL;
#line 569 "Grid.c"
}

void
launcher_widgets_grid_clear (LauncherWidgetsGrid* self)
{
	GeeHashMap* _tmp14_;
	GtkStack* _tmp15_;
	GtkGrid* _tmp16_;
#line 111 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 580 "Grid.c"
	{
		GeeIterator* _grid_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 112 "../src/Widgets/Grid.vala"
		_tmp0_ = self->priv->grids;
#line 112 "../src/Widgets/Grid.vala"
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
#line 112 "../src/Widgets/Grid.vala"
		_tmp2_ = _tmp1_;
#line 112 "../src/Widgets/Grid.vala"
		_tmp3_ = _tmp2_;
#line 112 "../src/Widgets/Grid.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 112 "../src/Widgets/Grid.vala"
		_tmp5_ = _tmp4_;
#line 112 "../src/Widgets/Grid.vala"
		_g_object_unref0 (_tmp3_);
#line 112 "../src/Widgets/Grid.vala"
		_grid_it = _tmp5_;
#line 112 "../src/Widgets/Grid.vala"
		while (TRUE) {
#line 607 "Grid.c"
			GeeIterator* _tmp6_;
			GtkGrid* grid = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GtkGrid* _tmp9_;
			GList* _tmp10_;
			GtkGrid* _tmp13_;
#line 112 "../src/Widgets/Grid.vala"
			_tmp6_ = _grid_it;
#line 112 "../src/Widgets/Grid.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 112 "../src/Widgets/Grid.vala"
				break;
#line 621 "Grid.c"
			}
#line 112 "../src/Widgets/Grid.vala"
			_tmp7_ = _grid_it;
#line 112 "../src/Widgets/Grid.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 112 "../src/Widgets/Grid.vala"
			grid = (GtkGrid*) _tmp8_;
#line 113 "../src/Widgets/Grid.vala"
			_tmp9_ = grid;
#line 113 "../src/Widgets/Grid.vala"
			_tmp10_ = gtk_container_get_children ((GtkContainer*) _tmp9_);
#line 633 "Grid.c"
			{
				GList* widget_collection = NULL;
				GList* widget_it = NULL;
#line 113 "../src/Widgets/Grid.vala"
				widget_collection = _tmp10_;
#line 113 "../src/Widgets/Grid.vala"
				for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
#line 641 "Grid.c"
					GtkWidget* _tmp11_;
					GtkWidget* widget = NULL;
#line 113 "../src/Widgets/Grid.vala"
					_tmp11_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
#line 113 "../src/Widgets/Grid.vala"
					widget = _tmp11_;
#line 648 "Grid.c"
					{
						GtkWidget* _tmp12_;
#line 114 "../src/Widgets/Grid.vala"
						_tmp12_ = widget;
#line 114 "../src/Widgets/Grid.vala"
						gtk_widget_destroy (_tmp12_);
#line 113 "../src/Widgets/Grid.vala"
						_g_object_unref0 (widget);
#line 657 "Grid.c"
					}
				}
#line 113 "../src/Widgets/Grid.vala"
				(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
#line 662 "Grid.c"
			}
#line 117 "../src/Widgets/Grid.vala"
			_tmp13_ = grid;
#line 117 "../src/Widgets/Grid.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 112 "../src/Widgets/Grid.vala"
			_g_object_unref0 (grid);
#line 670 "Grid.c"
		}
#line 112 "../src/Widgets/Grid.vala"
		_g_object_unref0 (_grid_it);
#line 674 "Grid.c"
	}
#line 120 "../src/Widgets/Grid.vala"
	_tmp14_ = self->priv->grids;
#line 120 "../src/Widgets/Grid.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp14_);
#line 121 "../src/Widgets/Grid.vala"
	self->priv->current_row = (guint) 0;
#line 122 "../src/Widgets/Grid.vala"
	self->priv->current_col = (guint) 0;
#line 123 "../src/Widgets/Grid.vala"
	self->priv->page.number = 1;
#line 124 "../src/Widgets/Grid.vala"
	launcher_widgets_grid_create_new_grid (self);
#line 125 "../src/Widgets/Grid.vala"
	_tmp15_ = self->priv->stack;
#line 125 "../src/Widgets/Grid.vala"
	_tmp16_ = self->priv->current_grid;
#line 125 "../src/Widgets/Grid.vala"
	gtk_stack_set_visible_child (_tmp15_, (GtkWidget*) _tmp16_);
#line 694 "Grid.c"
}

GtkWidget*
launcher_widgets_grid_get_child_at (LauncherWidgetsGrid* self,
                                    gint column,
                                    gint row)
{
	gint col = 0;
	LauncherWidgetsPage _tmp0_;
	GtkGrid* grid = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GtkGrid* _tmp3_;
	GtkWidget* result = NULL;
#line 128 "../src/Widgets/Grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 129 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->page;
#line 129 "../src/Widgets/Grid.vala"
	col = ((gint) (column / _tmp0_.columns)) + 1;
#line 131 "../src/Widgets/Grid.vala"
	_tmp1_ = self->priv->grids;
#line 131 "../src/Widgets/Grid.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) col));
#line 131 "../src/Widgets/Grid.vala"
	grid = (GtkGrid*) _tmp2_;
#line 132 "../src/Widgets/Grid.vala"
	_tmp3_ = grid;
#line 132 "../src/Widgets/Grid.vala"
	if (_tmp3_ != NULL) {
#line 725 "Grid.c"
		GtkGrid* _tmp4_;
		LauncherWidgetsPage _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
#line 133 "../src/Widgets/Grid.vala"
		_tmp4_ = grid;
#line 133 "../src/Widgets/Grid.vala"
		_tmp5_ = self->priv->page;
#line 133 "../src/Widgets/Grid.vala"
		_tmp6_ = gtk_grid_get_child_at (_tmp4_, column - (((gint) _tmp5_.columns) * (col - 1)), row);
#line 133 "../src/Widgets/Grid.vala"
		_tmp7_ = _g_object_ref0 ((GtkWidget*) (LAUNCHER_WIDGETS_IS_APP_ENTRY (_tmp6_) ? ((LauncherWidgetsAppEntry*) _tmp6_) : NULL));
#line 133 "../src/Widgets/Grid.vala"
		result = _tmp7_;
#line 133 "../src/Widgets/Grid.vala"
		_g_object_unref0 (grid);
#line 133 "../src/Widgets/Grid.vala"
		return result;
#line 744 "Grid.c"
	} else {
#line 135 "../src/Widgets/Grid.vala"
		result = NULL;
#line 135 "../src/Widgets/Grid.vala"
		_g_object_unref0 (grid);
#line 135 "../src/Widgets/Grid.vala"
		return result;
#line 752 "Grid.c"
	}
#line 128 "../src/Widgets/Grid.vala"
	_g_object_unref0 (grid);
#line 756 "Grid.c"
}

gint
launcher_widgets_grid_get_page_columns (LauncherWidgetsGrid* self)
{
	LauncherWidgetsPage _tmp0_;
	gint result = 0;
#line 139 "../src/Widgets/Grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 140 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->page;
#line 140 "../src/Widgets/Grid.vala"
	result = (gint) _tmp0_.columns;
#line 140 "../src/Widgets/Grid.vala"
	return result;
#line 772 "Grid.c"
}

gint
launcher_widgets_grid_get_page_rows (LauncherWidgetsGrid* self)
{
	LauncherWidgetsPage _tmp0_;
	gint result = 0;
#line 143 "../src/Widgets/Grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 144 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->page;
#line 144 "../src/Widgets/Grid.vala"
	result = (gint) _tmp0_.rows;
#line 144 "../src/Widgets/Grid.vala"
	return result;
#line 788 "Grid.c"
}

gint
launcher_widgets_grid_get_n_pages (LauncherWidgetsGrid* self)
{
	LauncherWidgetsPage _tmp0_;
	gint result = 0;
#line 147 "../src/Widgets/Grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 148 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->page;
#line 148 "../src/Widgets/Grid.vala"
	result = (gint) _tmp0_.number;
#line 148 "../src/Widgets/Grid.vala"
	return result;
#line 804 "Grid.c"
}

gint
launcher_widgets_grid_get_current_page (LauncherWidgetsGrid* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gint result = 0;
#line 151 "../src/Widgets/Grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 152 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->stack;
#line 152 "../src/Widgets/Grid.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 152 "../src/Widgets/Grid.vala"
	result = atoi (_tmp1_);
#line 152 "../src/Widgets/Grid.vala"
	return result;
#line 823 "Grid.c"
}

void
launcher_widgets_grid_go_to_next (LauncherWidgetsGrid* self)
{
	gint page_number = 0;
	LauncherWidgetsSwitcher* _tmp3_;
#line 155 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 156 "../src/Widgets/Grid.vala"
	page_number = launcher_widgets_grid_get_current_page (self) + 1;
#line 157 "../src/Widgets/Grid.vala"
	if (page_number <= launcher_widgets_grid_get_n_pages (self)) {
#line 837 "Grid.c"
		GtkStack* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 158 "../src/Widgets/Grid.vala"
		_tmp0_ = self->priv->stack;
#line 158 "../src/Widgets/Grid.vala"
		_tmp1_ = g_strdup_printf ("%i", page_number);
#line 158 "../src/Widgets/Grid.vala"
		_tmp2_ = _tmp1_;
#line 158 "../src/Widgets/Grid.vala"
		gtk_stack_set_visible_child_name (_tmp0_, _tmp2_);
#line 158 "../src/Widgets/Grid.vala"
		_g_free0 (_tmp2_);
#line 851 "Grid.c"
	}
#line 160 "../src/Widgets/Grid.vala"
	_tmp3_ = self->page_switcher;
#line 160 "../src/Widgets/Grid.vala"
	launcher_widgets_switcher_update_selected (_tmp3_);
#line 857 "Grid.c"
}

void
launcher_widgets_grid_go_to_previous (LauncherWidgetsGrid* self)
{
	gint page_number = 0;
	LauncherWidgetsSwitcher* _tmp3_;
#line 163 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 164 "../src/Widgets/Grid.vala"
	page_number = launcher_widgets_grid_get_current_page (self) - 1;
#line 165 "../src/Widgets/Grid.vala"
	if (page_number > 0) {
#line 871 "Grid.c"
		GtkStack* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 166 "../src/Widgets/Grid.vala"
		_tmp0_ = self->priv->stack;
#line 166 "../src/Widgets/Grid.vala"
		_tmp1_ = g_strdup_printf ("%i", page_number);
#line 166 "../src/Widgets/Grid.vala"
		_tmp2_ = _tmp1_;
#line 166 "../src/Widgets/Grid.vala"
		gtk_stack_set_visible_child_name (_tmp0_, _tmp2_);
#line 166 "../src/Widgets/Grid.vala"
		_g_free0 (_tmp2_);
#line 885 "Grid.c"
	}
#line 168 "../src/Widgets/Grid.vala"
	_tmp3_ = self->page_switcher;
#line 168 "../src/Widgets/Grid.vala"
	launcher_widgets_switcher_update_selected (_tmp3_);
#line 891 "Grid.c"
}

void
launcher_widgets_grid_go_to_last (LauncherWidgetsGrid* self)
{
	GtkStack* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	LauncherWidgetsSwitcher* _tmp3_;
#line 171 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 172 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->stack;
#line 172 "../src/Widgets/Grid.vala"
	_tmp1_ = g_strdup_printf ("%i", launcher_widgets_grid_get_n_pages (self));
#line 172 "../src/Widgets/Grid.vala"
	_tmp2_ = _tmp1_;
#line 172 "../src/Widgets/Grid.vala"
	gtk_stack_set_visible_child_name (_tmp0_, _tmp2_);
#line 172 "../src/Widgets/Grid.vala"
	_g_free0 (_tmp2_);
#line 173 "../src/Widgets/Grid.vala"
	_tmp3_ = self->page_switcher;
#line 173 "../src/Widgets/Grid.vala"
	launcher_widgets_switcher_update_selected (_tmp3_);
#line 917 "Grid.c"
}

void
launcher_widgets_grid_go_to_number (LauncherWidgetsGrid* self,
                                    gint number)
{
	GtkStack* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	LauncherWidgetsSwitcher* _tmp3_;
#line 176 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 177 "../src/Widgets/Grid.vala"
	_tmp0_ = self->priv->stack;
#line 177 "../src/Widgets/Grid.vala"
	_tmp1_ = g_strdup_printf ("%i", number);
#line 177 "../src/Widgets/Grid.vala"
	_tmp2_ = _tmp1_;
#line 177 "../src/Widgets/Grid.vala"
	gtk_stack_set_visible_child_name (_tmp0_, _tmp2_);
#line 177 "../src/Widgets/Grid.vala"
	_g_free0 (_tmp2_);
#line 178 "../src/Widgets/Grid.vala"
	_tmp3_ = self->page_switcher;
#line 178 "../src/Widgets/Grid.vala"
	launcher_widgets_switcher_update_selected (_tmp3_);
#line 944 "Grid.c"
}

void
launcher_widgets_grid_resize (LauncherWidgetsGrid* self,
                              gint rows,
                              gint columns)
{
#line 181 "../src/Widgets/Grid.vala"
	g_return_if_fail (self != NULL);
#line 182 "../src/Widgets/Grid.vala"
	launcher_widgets_grid_clear (self);
#line 183 "../src/Widgets/Grid.vala"
	self->priv->page.rows = (guint) rows;
#line 184 "../src/Widgets/Grid.vala"
	self->priv->page.columns = (guint) columns;
#line 185 "../src/Widgets/Grid.vala"
	self->priv->page.number = 1;
#line 962 "Grid.c"
}

static void
launcher_widgets_grid_class_init (LauncherWidgetsGridClass * klass,
                                  gpointer klass_data)
{
#line 29 "../src/Widgets/Grid.vala"
	launcher_widgets_grid_parent_class = g_type_class_peek_parent (klass);
#line 29 "../src/Widgets/Grid.vala"
	g_type_class_adjust_private_offset (klass, &LauncherWidgetsGrid_private_offset);
#line 29 "../src/Widgets/Grid.vala"
	G_OBJECT_CLASS (klass)->finalize = launcher_widgets_grid_finalize;
#line 975 "Grid.c"
}

static void
launcher_widgets_grid_instance_init (LauncherWidgetsGrid * self,
                                     gpointer klass)
{
#line 29 "../src/Widgets/Grid.vala"
	self->priv = launcher_widgets_grid_get_instance_private (self);
#line 37 "../src/Widgets/Grid.vala"
	self->priv->current_row = (guint) 0;
#line 38 "../src/Widgets/Grid.vala"
	self->priv->current_col = (guint) 0;
#line 988 "Grid.c"
}

static void
launcher_widgets_grid_finalize (GObject * obj)
{
	LauncherWidgetsGrid * self;
#line 29 "../src/Widgets/Grid.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_WIDGETS_TYPE_GRID, LauncherWidgetsGrid);
#line 31 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->page_switcher);
#line 33 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->priv->stack);
#line 34 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->priv->current_grid);
#line 35 "../src/Widgets/Grid.vala"
	_g_object_unref0 (self->priv->grids);
#line 29 "../src/Widgets/Grid.vala"
	G_OBJECT_CLASS (launcher_widgets_grid_parent_class)->finalize (obj);
#line 1007 "Grid.c"
}

static GType
launcher_widgets_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LauncherWidgetsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_widgets_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherWidgetsGrid), 0, (GInstanceInitFunc) launcher_widgets_grid_instance_init, NULL };
	GType launcher_widgets_grid_type_id;
	launcher_widgets_grid_type_id = g_type_register_static (gtk_box_get_type (), "LauncherWidgetsGrid", &g_define_type_info, 0);
	LauncherWidgetsGrid_private_offset = g_type_add_instance_private (launcher_widgets_grid_type_id, sizeof (LauncherWidgetsGridPrivate));
	return launcher_widgets_grid_type_id;
}

GType
launcher_widgets_grid_get_type (void)
{
	static volatile gsize launcher_widgets_grid_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_widgets_grid_type_id__volatile)) {
		GType launcher_widgets_grid_type_id;
		launcher_widgets_grid_type_id = launcher_widgets_grid_get_type_once ();
		g_once_init_leave (&launcher_widgets_grid_type_id__volatile, launcher_widgets_grid_type_id);
	}
	return launcher_widgets_grid_type_id__volatile;
}

