#!/bin/sh

ans=$(zenity  --list  --width=460 --height=340 --window-icon="/usr/share/mcm/mcm.svg" --text  "What would you like to do?" \
--radiolist  --column "Pick" --column "Output Type" TRUE "View the Help Page" FALSE "Turn Motion Off" FALSE "Reload Motion" FALSE "Start Motion" FALSE "Adjust local Camera with GUI" FALSE "Set Local Camera to Daytime Settings" FALSE "Set Local Camera to Nighttime Settings" FALSE "Delete crontab" FALSE "Install crontab" FALSE "Edit Motion Conf" FALSE "Edit IP Address on 1up Viewer" FALSE "Edit IP Address on 2up Viewer" FALSE "Edit IP Address on 3up Viewer" FALSE "Edit IP Address on 4up Viewer");

 
if [ "$ans" = "View the Help Page" ]
then
xdg-open 'file:///var/www/html/motion/help/motion-monitor-help.html'
elif [ "$ans" = "Turn Motion Off" ]
then
/usr/local/bin/motion/stop.sh
elif [ "$ans" = "Reload Motion" ]
then
systemctl reload motion
elif [ "$ans" = "Start Motion" ]
then
/usr/local/bin/motion/start.sh
elif [ "$ans" = "Adjust local Camera with GUI" ]
then
/usr/local/bin/motion/camerasettings.sh
elif [ "$ans" = "Set Local Camera to Daytime Settings" ]
then
/usr/local/bin/motion/daytime.sh
elif [ "$ans" = "Set Local Camera to Nighttime Settings" ]
then
/usr/local/bin/motion/nighttime.sh
elif [ "$ans" = "Delete crontab" ]
then
crontab -r
elif [ "$ans" = "Install crontab" ]
then
/usr/local/bin/motion/motion-cron.sh
elif [ "$ans" = "Edit Motion Conf" ]
then
xfce4-terminal -e="/usr/local/bin/motion/edit-conf.sh"
elif [ "$ans" = "Edit IP Address on 1up Viewer" ]
then
xfce4-terminal -e="/usr/local/bin/motion/edit-mcm1.sh"
elif [ "$ans" = "Edit IP Address on 2up Viewer" ]
then
xfce4-terminal -e="/usr/local/bin/motion/edit-mcm2.sh"
elif [ "$ans" = "Edit IP Address on 3up Viewer" ]
then
xfce4-terminal -e="/usr/local/bin/motion/edit-mcm3.sh"
elif [ "$ans" = "Edit IP Address on 4up Viewer" ]
then
xfce4-terminal -e="/usr/local/bin/motion/edit-mcm4.sh"
fi


