/* App.c generated by valac 0.42.5, the Vala compiler
 * generated from App.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/*                2013-2014 Akshay Shekher*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gmenu-tree.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define PANTHER_BACKEND_TYPE_APP (panther_backend_app_get_type ())
#define PANTHER_BACKEND_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_BACKEND_TYPE_APP, PantherBackendApp))
#define PANTHER_BACKEND_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_BACKEND_TYPE_APP, PantherBackendAppClass))
#define PANTHER_BACKEND_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_BACKEND_TYPE_APP))
#define PANTHER_BACKEND_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_BACKEND_TYPE_APP))
#define PANTHER_BACKEND_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_BACKEND_TYPE_APP, PantherBackendAppClass))

typedef struct _PantherBackendApp PantherBackendApp;
typedef struct _PantherBackendAppClass PantherBackendAppClass;
typedef struct _PantherBackendAppPrivate PantherBackendAppPrivate;
typedef enum  {
	PANTHER_BACKEND_APP_APP_TYPE_APP,
	PANTHER_BACKEND_APP_APP_TYPE_COMMAND,
	PANTHER_BACKEND_APP_APP_TYPE_SYNAPSE
} PantherBackendAppAppType;


#define PANTHER_BACKEND_APP_TYPE_APP_TYPE (panther_backend_app_app_type_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
enum  {
	PANTHER_BACKEND_APP_0_PROPERTY,
	PANTHER_BACKEND_APP_NAME_PROPERTY,
	PANTHER_BACKEND_APP_DESCRIPTION_PROPERTY,
	PANTHER_BACKEND_APP_DESKTOP_ID_PROPERTY,
	PANTHER_BACKEND_APP_EXEC_PROPERTY,
	PANTHER_BACKEND_APP_ICON_NAME_PROPERTY,
	PANTHER_BACKEND_APP_KEYWORDS_PROPERTY,
	PANTHER_BACKEND_APP_ICON_PROPERTY,
	PANTHER_BACKEND_APP_POPULARITY_PROPERTY,
	PANTHER_BACKEND_APP_RELEVANCY_PROPERTY,
	PANTHER_BACKEND_APP_DESKTOP_PATH_PROPERTY,
	PANTHER_BACKEND_APP_CATEGORIES_PROPERTY,
	PANTHER_BACKEND_APP_GENERIC_NAME_PROPERTY,
	PANTHER_BACKEND_APP_APP_TYPE_PROPERTY,
	PANTHER_BACKEND_APP_MATCH_PROPERTY,
	PANTHER_BACKEND_APP_TARGET_PROPERTY,
	PANTHER_BACKEND_APP_ACTIONS_PROPERTY,
	PANTHER_BACKEND_APP_ACTIONS_MAP_PROPERTY,
	PANTHER_BACKEND_APP_NUM_PROPERTIES
};
static GParamSpec* panther_backend_app_properties[PANTHER_BACKEND_APP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PANTHER_TYPE_SETTINGS (panther_settings_get_type ())
#define PANTHER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_TYPE_SETTINGS, PantherSettings))
#define PANTHER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_TYPE_SETTINGS, PantherSettingsClass))
#define PANTHER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_TYPE_SETTINGS))
#define PANTHER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_TYPE_SETTINGS))
#define PANTHER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_TYPE_SETTINGS, PantherSettingsClass))

typedef struct _PantherSettings PantherSettings;
typedef struct _PantherSettingsClass PantherSettingsClass;
typedef struct _Block1Data Block1Data;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD (panther_backend_app_icon_load_fallback_method_get_type ())
#define PANTHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, PantherBackendAppIconLoadFallbackMethod))
#define PANTHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, PantherBackendAppIconLoadFallbackMethodClass))
#define PANTHER_BACKEND_APP_IS_ICON_LOAD_FALLBACK_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD))
#define PANTHER_BACKEND_APP_IS_ICON_LOAD_FALLBACK_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD))
#define PANTHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, PantherBackendAppIconLoadFallbackMethodClass))

typedef struct _PantherBackendAppIconLoadFallbackMethod PantherBackendAppIconLoadFallbackMethod;
typedef struct _PantherBackendAppIconLoadFallbackMethodClass PantherBackendAppIconLoadFallbackMethodClass;
typedef void (*PantherBackendAppIconLoadFallback) (gpointer user_data);
typedef struct _PantherBackendAppIconLoadFallbackMethodPrivate PantherBackendAppIconLoadFallbackMethodPrivate;
#define _panther_backend_app_icon_load_fallback_method_unref0(var) ((var == NULL) ? NULL : (var = (panther_backend_app_icon_load_fallback_method_unref (var), NULL)))

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchIface))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchIface SynapseSearchMatchIface;

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _PantherBackendAppParamSpecIconLoadFallbackMethod PantherBackendAppParamSpecIconLoadFallbackMethod;
enum  {
	PANTHER_BACKEND_APP_START_SEARCH_SIGNAL,
	PANTHER_BACKEND_APP_ICON_CHANGED_SIGNAL,
	PANTHER_BACKEND_APP_LAUNCHED_SIGNAL,
	PANTHER_BACKEND_APP_NUM_SIGNALS
};
static guint panther_backend_app_signals[PANTHER_BACKEND_APP_NUM_SIGNALS] = {0};

typedef enum  {
	ICON_ERROR_NOT_FOUND
} IconError;
#define ICON_ERROR icon_error_quark ()
struct _PantherBackendApp {
	GObject parent_instance;
	PantherBackendAppPrivate * priv;
};

struct _PantherBackendAppClass {
	GObjectClass parent_class;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _PantherBackendAppPrivate {
	gchar* _name;
	gchar* _description;
	gchar* _desktop_id;
	gchar* _exec;
	gchar* _icon_name;
	gchar** _keywords;
	gint _keywords_length1;
	gint __keywords_size_;
	GdkPixbuf* _icon;
	gdouble _popularity;
	gdouble _relevancy;
	gchar* _desktop_path;
	gchar* _categories;
	gchar* _generic_name;
	PantherBackendAppAppType _app_type;
	SynapseMatch* _match;
	SynapseMatch* _target;
	GeeArrayList* _actions;
	GeeHashMap* _actions_map;
	gboolean check_icon_again;
	GLoadableIcon* loadable_icon;
};

struct _Block1Data {
	int _ref_count_;
	PantherBackendApp* self;
	GdkPixbuf* icon;
	GtkIconLookupFlags flags;
	gint size;
};

struct _PantherBackendAppIconLoadFallbackMethod {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PantherBackendAppIconLoadFallbackMethodPrivate * priv;
	PantherBackendAppIconLoadFallback load_icon;
	gpointer load_icon_target;
};

struct _PantherBackendAppIconLoadFallbackMethodClass {
	GTypeClass parent_class;
	void (*finalize) (PantherBackendAppIconLoadFallbackMethod *self);
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatchIface {
	GTypeInterface parent_iface;
	SynapseMatch* (*get_search_source) (SynapseSearchMatch* self);
	void (*set_search_source) (SynapseSearchMatch* self, SynapseMatch* value);
};

struct _PantherBackendAppParamSpecIconLoadFallbackMethod {
	GParamSpec parent_instance;
};


static gint PantherBackendApp_private_offset;
static gpointer panther_backend_app_parent_class = NULL;
static gpointer panther_backend_app_icon_load_fallback_method_parent_class = NULL;

GQuark icon_error_quark (void);
GType panther_backend_app_get_type (void) G_GNUC_CONST;
GType panther_backend_app_app_type_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GtkIconTheme* panther_panther_get_icon_theme (void);
void panther_backend_app_update_icon (PantherBackendApp* self);
static void _panther_backend_app_update_icon_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                              gpointer self);
#define PANTHER_BACKEND_APP_RECHECK_TIMEOUT 2
#define PANTHER_BACKEND_APP_DESKTOP_ACTION_KEY "Actions"
#define PANTHER_BACKEND_APP_DESKTOP_ACTION_GROUP_NAME "Desktop Action %s"
PantherBackendApp* panther_backend_app_new (GMenuTreeEntry* entry);
PantherBackendApp* panther_backend_app_construct (GType object_type,
                                                  GMenuTreeEntry* entry);
static void panther_backend_app_set_app_type (PantherBackendApp* self,
                                       PantherBackendAppAppType value);
void panther_backend_app_set_name (PantherBackendApp* self,
                                   const gchar* value);
const gchar* panther_backend_app_get_name (PantherBackendApp* self);
static void panther_backend_app_set_description (PantherBackendApp* self,
                                          const gchar* value);
static void panther_backend_app_set_exec (PantherBackendApp* self,
                                   const gchar* value);
void panther_backend_app_set_desktop_id (PantherBackendApp* self,
                                         const gchar* value);
static void panther_backend_app_set_desktop_path (PantherBackendApp* self,
                                           const gchar* value);
static void panther_backend_app_set_categories (PantherBackendApp* self,
                                         const gchar* value);
static void panther_backend_app_set_generic_name (PantherBackendApp* self,
                                           const gchar* value);
static void panther_backend_app_set_icon_name (PantherBackendApp* self,
                                        const gchar* value);
GdkPixbuf* panther_backend_app_get_loadable_icon (PantherBackendApp* self);
static void panther_backend_app_set_icon (PantherBackendApp* self,
                                   GdkPixbuf* value);
GdkPixbuf* panther_backend_app_get_icon (PantherBackendApp* self);
PantherBackendApp* panther_backend_app_new_from_command (const gchar* command);
PantherBackendApp* panther_backend_app_construct_from_command (GType object_type,
                                                               const gchar* command);
PantherBackendApp* panther_backend_app_new_from_synapse_match (SynapseMatch* match,
                                                               SynapseMatch* target);
PantherBackendApp* panther_backend_app_construct_from_synapse_match (GType object_type,
                                                                     SynapseMatch* match,
                                                                     SynapseMatch* target);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_description (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
static void panther_backend_app_set_match (PantherBackendApp* self,
                                    SynapseMatch* value);
static void panther_backend_app_set_target (PantherBackendApp* self,
                                     SynapseMatch* value);
GdkPixbuf* panther_backend_app_load_icon (PantherBackendApp* self,
                                          gint size);
GType panther_settings_get_type (void) G_GNUC_CONST;
PantherSettings* panther_panther_get_settings (void);
gint panther_settings_get_icon_size (PantherSettings* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
PantherBackendAppAppType panther_backend_app_get_app_type (PantherBackendApp* self);
SynapseMatch* panther_backend_app_get_match (PantherBackendApp* self);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
const gchar* panther_backend_app_get_icon_name (PantherBackendApp* self);
static gpointer panther_backend_app_icon_load_fallback_method_ref (gpointer instance);
static void panther_backend_app_icon_load_fallback_method_unref (gpointer instance);
static GParamSpec* panther_backend_app_param_spec_icon_load_fallback_method (const gchar* name,
                                                                      const gchar* nick,
                                                                      const gchar* blurb,
                                                                      GType object_type,
                                                                      GParamFlags flags) G_GNUC_UNUSED;
static void panther_backend_app_value_set_icon_load_fallback_method (GValue* value,
                                                              gpointer v_object) G_GNUC_UNUSED;
static void panther_backend_app_value_take_icon_load_fallback_method (GValue* value,
                                                               gpointer v_object) G_GNUC_UNUSED;
static gpointer panther_backend_app_value_get_icon_load_fallback_method (const GValue* value) G_GNUC_UNUSED;
static GType panther_backend_app_icon_load_fallback_method_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void __lambda31_ (Block1Data* _data1_);
static void ___lambda31__panther_backend_app_icon_load_fallback (gpointer self);
static PantherBackendAppIconLoadFallbackMethod* panther_backend_app_icon_load_fallback_method_new (PantherBackendAppIconLoadFallback fallback,
                                                                                            gpointer fallback_target);
static PantherBackendAppIconLoadFallbackMethod* panther_backend_app_icon_load_fallback_method_construct (GType object_type,
                                                                                                  PantherBackendAppIconLoadFallback fallback,
                                                                                                  gpointer fallback_target);
static void __lambda32_ (PantherBackendApp* self);
static gboolean ___lambda33_ (PantherBackendApp* self);
static gboolean ____lambda33__gsource_func (gpointer self);
static void ___lambda32__panther_backend_app_icon_load_fallback (gpointer self);
static void __lambda34_ (Block1Data* _data1_);
static void ___lambda34__panther_backend_app_icon_load_fallback (gpointer self);
static void __lambda35_ (Block1Data* _data1_);
static void ___lambda35__panther_backend_app_icon_load_fallback (gpointer self);
static void __lambda36_ (Block1Data* _data1_);
static void ___lambda36__panther_backend_app_icon_load_fallback (gpointer self);
static void __lambda37_ (Block1Data* _data1_);
static void ___lambda37__panther_backend_app_icon_load_fallback (gpointer self);
gboolean panther_backend_app_launch (PantherBackendApp* self);
const gchar* panther_backend_app_get_exec (PantherBackendApp* self);
const gchar* panther_backend_app_get_desktop_id (PantherBackendApp* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
GType synapse_search_match_get_type (void) G_GNUC_CONST;
SynapseMatch* panther_backend_app_get_target (PantherBackendApp* self);
GeeList* panther_backend_synapse_search_find_actions_for_match (SynapseMatch* match);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
void panther_backend_app_init_actions (PantherBackendApp* self,
                                       GError** error);
static void panther_backend_app_set_actions (PantherBackendApp* self,
                                      GeeArrayList* value);
static void panther_backend_app_set_actions_map (PantherBackendApp* self,
                                          GeeHashMap* value);
const gchar* panther_backend_app_get_desktop_path (PantherBackendApp* self);
GeeArrayList* panther_backend_app_get_actions (PantherBackendApp* self);
GeeHashMap* panther_backend_app_get_actions_map (PantherBackendApp* self);
const gchar* panther_backend_app_get_description (PantherBackendApp* self);
gchar** panther_backend_app_get_keywords (PantherBackendApp* self,
                                          int* result_length1);
static void panther_backend_app_set_keywords (PantherBackendApp* self,
                                       gchar** value,
                                       int value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
gdouble panther_backend_app_get_popularity (PantherBackendApp* self);
void panther_backend_app_set_popularity (PantherBackendApp* self,
                                         gdouble value);
gdouble panther_backend_app_get_relevancy (PantherBackendApp* self);
void panther_backend_app_set_relevancy (PantherBackendApp* self,
                                        gdouble value);
const gchar* panther_backend_app_get_categories (PantherBackendApp* self);
const gchar* panther_backend_app_get_generic_name (PantherBackendApp* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void panther_backend_app_icon_load_fallback_method_finalize (PantherBackendAppIconLoadFallbackMethod * obj);
static void panther_backend_app_finalize (GObject * obj);
static void _vala_panther_backend_app_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_panther_backend_app_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* PANTHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

GQuark
icon_error_quark (void)
{
	return g_quark_from_static_string ("icon-error-quark");
}


static inline gpointer
panther_backend_app_get_instance_private (PantherBackendApp* self)
{
	return G_STRUCT_MEMBER_P (self, PantherBackendApp_private_offset);
}


static void
_panther_backend_app_update_icon_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                         gpointer self)
{
	panther_backend_app_update_icon ((PantherBackendApp*) self);
}


GType
panther_backend_app_app_type_get_type (void)
{
	static volatile gsize panther_backend_app_app_type_type_id__volatile = 0;
	if (g_once_init_enter (&panther_backend_app_app_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PANTHER_BACKEND_APP_APP_TYPE_APP, "PANTHER_BACKEND_APP_APP_TYPE_APP", "app"}, {PANTHER_BACKEND_APP_APP_TYPE_COMMAND, "PANTHER_BACKEND_APP_APP_TYPE_COMMAND", "command"}, {PANTHER_BACKEND_APP_APP_TYPE_SYNAPSE, "PANTHER_BACKEND_APP_APP_TYPE_SYNAPSE", "synapse"}, {0, NULL, NULL}};
		GType panther_backend_app_app_type_type_id;
		panther_backend_app_app_type_type_id = g_enum_register_static ("PantherBackendAppAppType", values);
		g_once_init_leave (&panther_backend_app_app_type_type_id__volatile, panther_backend_app_app_type_type_id);
	}
	return panther_backend_app_app_type_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


PantherBackendApp*
panther_backend_app_construct (GType object_type,
                               GMenuTreeEntry* entry)
{
	PantherBackendApp * self = NULL;
	GDesktopAppInfo* info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	GDesktopAppInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GDesktopAppInfo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GDesktopAppInfo* _tmp17_;
	const gchar* _tmp18_;
	GDesktopAppInfo* _tmp19_;
	const gchar* _tmp20_;
	GDesktopAppInfo* _tmp21_;
	GIcon* _tmp22_;
	GdkPixbuf* _tmp37_;
	g_return_val_if_fail (entry != NULL, NULL);
	self = (PantherBackendApp*) g_object_new (object_type, NULL);
	panther_backend_app_set_app_type (self, PANTHER_BACKEND_APP_APP_TYPE_APP);
	_tmp0_ = gmenu_tree_entry_get_app_info (entry);
	info = _tmp0_;
	_tmp1_ = info;
	_tmp2_ = g_app_info_get_display_name ((GAppInfo*) _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	panther_backend_app_set_name (self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp6_ = info;
	_tmp7_ = g_app_info_get_description ((GAppInfo*) _tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_tmp5_ = _tmp8_;
	if (_tmp5_ == NULL) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = self->priv->_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp10_;
	}
	panther_backend_app_set_description (self, _tmp5_);
	_tmp11_ = info;
	_tmp12_ = g_app_info_get_commandline ((GAppInfo*) _tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _tmp13_;
	panther_backend_app_set_exec (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = gmenu_tree_entry_get_desktop_file_id (entry);
	panther_backend_app_set_desktop_id (self, _tmp15_);
	_tmp16_ = gmenu_tree_entry_get_desktop_file_path (entry);
	panther_backend_app_set_desktop_path (self, _tmp16_);
	_tmp17_ = info;
	_tmp18_ = g_desktop_app_info_get_categories (_tmp17_);
	panther_backend_app_set_categories (self, _tmp18_);
	_tmp19_ = info;
	_tmp20_ = g_desktop_app_info_get_generic_name (_tmp19_);
	panther_backend_app_set_generic_name (self, _tmp20_);
	_tmp21_ = info;
	_tmp22_ = g_app_info_get_icon ((GAppInfo*) _tmp21_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, g_themed_icon_get_type ())) {
		GDesktopAppInfo* _tmp23_;
		GIcon* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp23_ = info;
		_tmp24_ = g_app_info_get_icon ((GAppInfo*) _tmp23_);
		_tmp26_ = _tmp25_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, g_themed_icon_get_type ()) ? ((GThemedIcon*) _tmp24_) : NULL);
		_tmp27_ = _tmp26_[0];
		_tmp28_ = g_strdup (_tmp27_);
		_tmp29_ = _tmp28_;
		panther_backend_app_set_icon_name (self, _tmp29_);
		_g_free0 (_tmp29_);
	} else {
		GDesktopAppInfo* _tmp30_;
		GIcon* _tmp31_;
		_tmp30_ = info;
		_tmp31_ = g_app_info_get_icon ((GAppInfo*) _tmp30_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, g_loadable_icon_get_type ())) {
			GDesktopAppInfo* _tmp32_;
			GIcon* _tmp33_;
			GLoadableIcon* _tmp34_;
			GdkPixbuf* _tmp35_;
			GdkPixbuf* _tmp36_;
			_tmp32_ = info;
			_tmp33_ = g_app_info_get_icon ((GAppInfo*) _tmp32_);
			_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, g_loadable_icon_get_type ()) ? ((GLoadableIcon*) _tmp33_) : NULL);
			_g_object_unref0 (self->priv->loadable_icon);
			self->priv->loadable_icon = _tmp34_;
			_tmp35_ = panther_backend_app_get_loadable_icon (self);
			_tmp36_ = _tmp35_;
			panther_backend_app_set_icon (self, _tmp36_);
			_g_object_unref0 (_tmp36_);
		} else {
			panther_backend_app_set_icon_name (self, "application-default-icon");
		}
	}
	_tmp37_ = self->priv->_icon;
	if (_tmp37_ == NULL) {
		GtkIconTheme* _tmp38_;
		GtkIconTheme* _tmp39_;
		panther_backend_app_update_icon (self);
		_tmp38_ = panther_panther_get_icon_theme ();
		_tmp39_ = _tmp38_;
		g_signal_connect_object (_tmp39_, "changed", (GCallback) _panther_backend_app_update_icon_gtk_icon_theme_changed, self, 0);
	}
	_g_free0 (_tmp5_);
	return self;
}


PantherBackendApp*
panther_backend_app_new (GMenuTreeEntry* entry)
{
	return panther_backend_app_construct (PANTHER_BACKEND_TYPE_APP, entry);
}


PantherBackendApp*
panther_backend_app_construct_from_command (GType object_type,
                                            const gchar* command)
{
	PantherBackendApp * self = NULL;
	g_return_val_if_fail (command != NULL, NULL);
	self = (PantherBackendApp*) g_object_new (object_type, NULL);
	panther_backend_app_set_app_type (self, PANTHER_BACKEND_APP_APP_TYPE_COMMAND);
	panther_backend_app_set_name (self, command);
	panther_backend_app_set_description (self, _ ("Run this command…"));
	panther_backend_app_set_exec (self, command);
	panther_backend_app_set_desktop_id (self, command);
	panther_backend_app_set_icon_name (self, "system-run");
	panther_backend_app_update_icon (self);
	return self;
}


PantherBackendApp*
panther_backend_app_new_from_command (const gchar* command)
{
	return panther_backend_app_construct_from_command (PANTHER_BACKEND_TYPE_APP, command);
}


PantherBackendApp*
panther_backend_app_construct_from_synapse_match (GType object_type,
                                                  SynapseMatch* match,
                                                  SynapseMatch* target)
{
	PantherBackendApp * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (match != NULL, NULL);
	self = (PantherBackendApp*) g_object_new (object_type, NULL);
	panther_backend_app_set_app_type (self, PANTHER_BACKEND_APP_APP_TYPE_SYNAPSE);
	_tmp0_ = synapse_match_get_title (match);
	_tmp1_ = _tmp0_;
	panther_backend_app_set_name (self, _tmp1_);
	_tmp2_ = synapse_match_get_description (match);
	_tmp3_ = _tmp2_;
	panther_backend_app_set_description (self, _tmp3_);
	_tmp4_ = synapse_match_get_icon_name (match);
	_tmp5_ = _tmp4_;
	panther_backend_app_set_icon_name (self, _tmp5_);
	panther_backend_app_set_match (self, match);
	panther_backend_app_set_target (self, target);
	panther_backend_app_update_icon (self);
	return self;
}


PantherBackendApp*
panther_backend_app_new_from_synapse_match (SynapseMatch* match,
                                            SynapseMatch* target)
{
	return panther_backend_app_construct_from_synapse_match (PANTHER_BACKEND_TYPE_APP, match, target);
}


void
panther_backend_app_update_icon (PantherBackendApp* self)
{
	PantherSettings* _tmp0_;
	PantherSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = panther_panther_get_settings ();
	_tmp1_ = _tmp0_;
	_tmp2_ = panther_settings_get_icon_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = panther_backend_app_load_icon (self, _tmp3_);
	_tmp5_ = _tmp4_;
	panther_backend_app_set_icon (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_signal_emit (self, panther_backend_app_signals[PANTHER_BACKEND_APP_ICON_CHANGED_SIGNAL], 0);
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PantherBackendApp* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->icon);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
__lambda31_ (Block1Data* _data1_)
{
	PantherBackendApp* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		const gchar* _tmp3_;
		GtkIconLookupFlags _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp1_ = panther_panther_get_icon_theme ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_icon_name;
		_tmp4_ = _data1_->flags;
		_tmp5_ = gtk_icon_theme_load_icon (_tmp2_, _tmp3_, _data1_->size, _tmp4_, &_inner_error_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp6_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data1_->icon);
		_data1_->icon = _tmp6_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("App.vala:188: Could not load icon. Falling back to method 2");
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda31__panther_backend_app_icon_load_fallback (gpointer self)
{
	__lambda31_ (self);
}


static gboolean
___lambda33_ (PantherBackendApp* self)
{
	gboolean result = FALSE;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	_tmp0_ = panther_panther_get_icon_theme ();
	_tmp1_ = _tmp0_;
	gtk_icon_theme_rescan_if_needed (_tmp1_);
	panther_backend_app_update_icon (self);
	result = FALSE;
	return result;
}


static gboolean
____lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda33_ ((PantherBackendApp*) self);
	return result;
}


static void
__lambda32_ (PantherBackendApp* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->check_icon_again;
	if (_tmp0_) {
		self->priv->check_icon_again = FALSE;
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) PANTHER_BACKEND_APP_RECHECK_TIMEOUT, ____lambda33__gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void
___lambda32__panther_backend_app_icon_load_fallback (gpointer self)
{
	__lambda32_ ((PantherBackendApp*) self);
}


static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static void
__lambda34_ (Block1Data* _data1_)
{
	PantherBackendApp* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		const gchar* _tmp0_;
		_tmp0_ = self->priv->_icon_name;
		if (string_last_index_of (_tmp0_, ".", 0) > 0) {
			gchar* name = NULL;
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			GdkPixbuf* _tmp4_ = NULL;
			GtkIconTheme* _tmp5_;
			GtkIconTheme* _tmp6_;
			const gchar* _tmp7_;
			GtkIconLookupFlags _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp1_ = self->priv->_icon_name;
			_tmp2_ = self->priv->_icon_name;
			_tmp3_ = string_slice (_tmp1_, (glong) 0, (glong) string_last_index_of (_tmp2_, ".", 0));
			name = _tmp3_;
			_tmp5_ = panther_panther_get_icon_theme ();
			_tmp6_ = _tmp5_;
			_tmp7_ = name;
			_tmp8_ = _data1_->flags;
			_tmp9_ = gtk_icon_theme_load_icon (_tmp6_, _tmp7_, _data1_->size, _tmp8_, &_inner_error_);
			_tmp4_ = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (name);
				goto __catch3_g_error;
			}
			_tmp10_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (_data1_->icon);
			_data1_->icon = _tmp10_;
			_g_object_unref0 (_tmp4_);
			_g_free0 (name);
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("App.vala:213: Could not load icon. Falling back to method 3");
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda34__panther_backend_app_icon_load_fallback (gpointer self)
{
	__lambda34_ (self);
}


static void
__lambda35_ (Block1Data* _data1_)
{
	PantherBackendApp* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		GdkPixbuf* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp1_ = self->priv->_icon_name;
		_tmp2_ = gdk_pixbuf_new_from_file_at_scale (_tmp1_, _data1_->size, _data1_->size, FALSE, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data1_->icon);
		_data1_->icon = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("App.vala:221: Could not load icon. Falling back to method 4");
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda35__panther_backend_app_icon_load_fallback (gpointer self)
{
	__lambda35_ (self);
}


static void
__lambda36_ (Block1Data* _data1_)
{
	PantherBackendApp* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkIconLookupFlags _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp1_ = panther_panther_get_icon_theme ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _data1_->flags;
		_tmp4_ = gtk_icon_theme_load_icon (_tmp2_, "application-default-icon", _data1_->size, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data1_->icon);
		_data1_->icon = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("App.vala:229: Could not load icon. Falling back to method 5");
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda36__panther_backend_app_icon_load_fallback (gpointer self)
{
	__lambda36_ (self);
}


static void
__lambda37_ (Block1Data* _data1_)
{
	PantherBackendApp* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkIconLookupFlags _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp1_ = panther_panther_get_icon_theme ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _data1_->flags;
		_tmp4_ = gtk_icon_theme_load_icon (_tmp2_, "image-missing", _data1_->size, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data1_->icon);
		_data1_->icon = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("App.vala:237: Could not find a fallback icon to load");
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda37__panther_backend_app_icon_load_fallback (gpointer self)
{
	__lambda37_ (self);
}


static gpointer
_panther_backend_app_icon_load_fallback_method_ref0 (gpointer self)
{
	return self ? panther_backend_app_icon_load_fallback_method_ref (self) : NULL;
}


GdkPixbuf*
panther_backend_app_load_icon (PantherBackendApp* self,
                               gint size)
{
	GdkPixbuf* result = NULL;
	Block1Data* _data1_;
	PantherBackendAppAppType _tmp0_;
	GLoadableIcon* _tmp34_;
	PantherBackendAppIconLoadFallbackMethod** fallbacks = NULL;
	PantherBackendAppIconLoadFallbackMethod* _tmp36_;
	PantherBackendAppIconLoadFallbackMethod* _tmp37_;
	PantherBackendAppIconLoadFallbackMethod* _tmp38_;
	PantherBackendAppIconLoadFallbackMethod* _tmp39_;
	PantherBackendAppIconLoadFallbackMethod* _tmp40_;
	PantherBackendAppIconLoadFallbackMethod* _tmp41_;
	PantherBackendAppIconLoadFallbackMethod** _tmp42_;
	gint fallbacks_length1;
	gint _fallbacks_size_;
	PantherBackendAppIconLoadFallbackMethod** _tmp43_;
	gint _tmp43__length1;
	GdkPixbuf* _tmp48_;
	GdkPixbuf* _tmp49_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->size = size;
	_tmp0_ = self->priv->_app_type;
	if (_tmp0_ == PANTHER_BACKEND_APP_APP_TYPE_SYNAPSE) {
		{
			gboolean _tmp1_ = FALSE;
			SynapseMatch* _tmp2_;
			SynapseMatchType _tmp3_;
			SynapseMatchType _tmp4_;
			GIcon* icon = NULL;
			const gchar* _tmp14_;
			GIcon* _tmp15_;
			GtkIconInfo* info = NULL;
			GtkIconTheme* _tmp16_;
			GIcon* _tmp17_;
			GtkIconInfo* _tmp18_;
			GtkIconInfo* _tmp19_;
			GdkPixbuf* _tmp21_ = NULL;
			GtkIconInfo* _tmp22_;
			GdkPixbuf* _tmp23_;
			GdkPixbuf* _tmp24_;
			_tmp2_ = self->priv->_match;
			_tmp3_ = synapse_match_get_match_type (_tmp2_);
			_tmp4_ = _tmp3_;
			if (_tmp4_ == SYNAPSE_MATCH_TYPE_CONTACT) {
				SynapseMatch* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = self->priv->_match;
				_tmp6_ = synapse_match_get_has_thumbnail (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp1_ = _tmp7_;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				GdkPixbuf* _tmp8_ = NULL;
				SynapseMatch* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				GdkPixbuf* _tmp12_;
				GdkPixbuf* _tmp13_;
				_tmp9_ = self->priv->_match;
				_tmp10_ = synapse_match_get_thumbnail_path (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = gdk_pixbuf_new_from_file_at_scale (_tmp11_, _data1_->size, _data1_->size, TRUE, &_inner_error_);
				_tmp8_ = _tmp12_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = _tmp8_;
				_tmp8_ = NULL;
				result = _tmp13_;
				_g_object_unref0 (_tmp8_);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				return result;
			}
			_tmp14_ = self->priv->_icon_name;
			_tmp15_ = g_icon_new_for_string (_tmp14_, &_inner_error_);
			icon = _tmp15_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp16_ = gtk_icon_theme_get_default ();
			_tmp17_ = icon;
			_tmp18_ = gtk_icon_theme_lookup_by_gicon (_tmp16_, _tmp17_, _data1_->size, GTK_ICON_LOOKUP_FORCE_SIZE);
			info = _tmp18_;
			_tmp19_ = info;
			if (_tmp19_ == NULL) {
				GError* _tmp20_;
				_tmp20_ = g_error_new_literal (ICON_ERROR, ICON_ERROR_NOT_FOUND, "Not found");
				_inner_error_ = _tmp20_;
				_gtk_icon_info_free0 (info);
				_g_object_unref0 (icon);
				goto __catch0_g_error;
			}
			_tmp22_ = info;
			_tmp23_ = gtk_icon_info_load_icon (_tmp22_, &_inner_error_);
			_tmp21_ = _tmp23_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_gtk_icon_info_free0 (info);
				_g_object_unref0 (icon);
				goto __catch0_g_error;
			}
			_tmp24_ = _tmp21_;
			_tmp21_ = NULL;
			result = _tmp24_;
			_g_object_unref0 (_tmp21_);
			_gtk_icon_info_free0 (info);
			_g_object_unref0 (icon);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			g_warning ("App.vala:166: Failed to load icon: %s\n", _tmp26_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		{
			GdkPixbuf* _tmp27_ = NULL;
			GtkIconTheme* _tmp28_;
			GtkIconTheme* _tmp29_;
			GdkPixbuf* _tmp30_;
			GdkPixbuf* _tmp31_;
			_tmp28_ = panther_panther_get_icon_theme ();
			_tmp29_ = _tmp28_;
			_tmp30_ = gtk_icon_theme_load_icon (_tmp29_, "application-default-icon", _data1_->size, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
			_tmp27_ = _tmp30_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp31_ = _tmp27_;
			_tmp27_ = NULL;
			result = _tmp31_;
			_g_object_unref0 (_tmp27_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			g_critical ("App.vala:173: %s", _tmp33_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_data1_->icon = NULL;
	_data1_->flags = GTK_ICON_LOOKUP_FORCE_SIZE;
	_tmp34_ = self->priv->loadable_icon;
	if (_tmp34_ != NULL) {
		GdkPixbuf* _tmp35_;
		_tmp35_ = panther_backend_app_get_loadable_icon (self);
		result = _tmp35_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp36_ = panther_backend_app_icon_load_fallback_method_new (___lambda31__panther_backend_app_icon_load_fallback, _data1_);
	_tmp37_ = panther_backend_app_icon_load_fallback_method_new (___lambda32__panther_backend_app_icon_load_fallback, self);
	_tmp38_ = panther_backend_app_icon_load_fallback_method_new (___lambda34__panther_backend_app_icon_load_fallback, _data1_);
	_tmp39_ = panther_backend_app_icon_load_fallback_method_new (___lambda35__panther_backend_app_icon_load_fallback, _data1_);
	_tmp40_ = panther_backend_app_icon_load_fallback_method_new (___lambda36__panther_backend_app_icon_load_fallback, _data1_);
	_tmp41_ = panther_backend_app_icon_load_fallback_method_new (___lambda37__panther_backend_app_icon_load_fallback, _data1_);
	_tmp42_ = g_new0 (PantherBackendAppIconLoadFallbackMethod*, 6 + 1);
	_tmp42_[0] = _tmp36_;
	_tmp42_[1] = _tmp37_;
	_tmp42_[2] = _tmp38_;
	_tmp42_[3] = _tmp39_;
	_tmp42_[4] = _tmp40_;
	_tmp42_[5] = _tmp41_;
	fallbacks = _tmp42_;
	fallbacks_length1 = 6;
	_fallbacks_size_ = fallbacks_length1;
	_tmp43_ = fallbacks;
	_tmp43__length1 = fallbacks_length1;
	{
		PantherBackendAppIconLoadFallbackMethod** fallback_collection = NULL;
		gint fallback_collection_length1 = 0;
		gint _fallback_collection_size_ = 0;
		gint fallback_it = 0;
		fallback_collection = _tmp43_;
		fallback_collection_length1 = _tmp43__length1;
		for (fallback_it = 0; fallback_it < _tmp43__length1; fallback_it = fallback_it + 1) {
			PantherBackendAppIconLoadFallbackMethod* _tmp44_;
			PantherBackendAppIconLoadFallbackMethod* fallback = NULL;
			_tmp44_ = _panther_backend_app_icon_load_fallback_method_ref0 (fallback_collection[fallback_it]);
			fallback = _tmp44_;
			{
				PantherBackendAppIconLoadFallbackMethod* _tmp45_;
				PantherBackendAppIconLoadFallback _tmp46_;
				void* _tmp46__target;
				GdkPixbuf* _tmp47_;
				_tmp45_ = fallback;
				_tmp46_ = _tmp45_->load_icon;
				_tmp46__target = _tmp45_->load_icon_target;
				_tmp46_ (_tmp46__target);
				_tmp47_ = _data1_->icon;
				if (_tmp47_ != NULL) {
					_panther_backend_app_icon_load_fallback_method_unref0 (fallback);
					break;
				}
				_panther_backend_app_icon_load_fallback_method_unref0 (fallback);
			}
		}
	}
	_tmp48_ = _data1_->icon;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	result = _tmp49_;
	fallbacks = (_vala_array_free (fallbacks, fallbacks_length1, (GDestroyNotify) panther_backend_app_icon_load_fallback_method_unref), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


GdkPixbuf*
panther_backend_app_get_loadable_icon (PantherBackendApp* self)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* tmp_loadable_icon = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GInputStream* icon_stream = NULL;
		GLoadableIcon* _tmp0_;
		GInputStream* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GInputStream* _tmp3_;
		PantherSettings* _tmp4_;
		PantherSettings* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		PantherSettings* _tmp8_;
		PantherSettings* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		_tmp0_ = self->priv->loadable_icon;
		_tmp1_ = g_loadable_icon_load (_tmp0_, 0, NULL, NULL, &_inner_error_);
		icon_stream = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp3_ = icon_stream;
		_tmp4_ = panther_panther_get_settings ();
		_tmp5_ = _tmp4_;
		_tmp6_ = panther_settings_get_icon_size (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = panther_panther_get_settings ();
		_tmp9_ = _tmp8_;
		_tmp10_ = panther_settings_get_icon_size (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gdk_pixbuf_new_from_stream_at_scale (_tmp3_, _tmp7_, _tmp11_, TRUE, NULL, &_inner_error_);
		_tmp2_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (icon_stream);
			goto __catch7_g_error;
		}
		_tmp13_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (tmp_loadable_icon);
		tmp_loadable_icon = _tmp13_;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (icon_stream);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (tmp_loadable_icon);
		tmp_loadable_icon = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (tmp_loadable_icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = tmp_loadable_icon;
	return result;
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gboolean
panther_backend_app_launch (PantherBackendApp* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PantherBackendAppAppType _tmp0_;
		_tmp0_ = self->priv->_app_type;
		switch (_tmp0_) {
			case PANTHER_BACKEND_APP_APP_TYPE_COMMAND:
			{
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp1_ = self->priv->_name;
				_tmp2_ = string_to_string (_tmp1_);
				_tmp3_ = g_strconcat ("Launching command: ", _tmp2_, NULL);
				_tmp4_ = _tmp3_;
				g_debug ("App.vala:266: %s", _tmp4_);
				_g_free0 (_tmp4_);
				_tmp5_ = self->priv->_exec;
				g_spawn_command_line_async (_tmp5_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch8_g_error;
				}
				break;
			}
			case PANTHER_BACKEND_APP_APP_TYPE_APP:
			{
				const gchar* _tmp6_;
				GDesktopAppInfo* _tmp7_;
				GDesktopAppInfo* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				g_signal_emit (self, panther_backend_app_signals[PANTHER_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
				_tmp6_ = self->priv->_desktop_id;
				_tmp7_ = g_desktop_app_info_new (_tmp6_);
				_tmp8_ = _tmp7_;
				g_app_info_launch ((GAppInfo*) _tmp8_, NULL, NULL, &_inner_error_);
				_g_object_unref0 (_tmp8_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch8_g_error;
				}
				_tmp9_ = self->priv->_name;
				_tmp10_ = string_to_string (_tmp9_);
				_tmp11_ = g_strconcat ("Launching application: ", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				g_debug ("App.vala:272: %s", _tmp12_);
				_g_free0 (_tmp12_);
				break;
			}
			case PANTHER_BACKEND_APP_APP_TYPE_SYNAPSE:
			{
				SynapseMatch* _tmp13_;
				SynapseMatchType _tmp14_;
				SynapseMatchType _tmp15_;
				_tmp13_ = self->priv->_match;
				_tmp14_ = synapse_match_get_match_type (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == SYNAPSE_MATCH_TYPE_SEARCH) {
					SynapseMatch* _tmp16_;
					SynapseMatch* _tmp17_;
					_tmp16_ = self->priv->_match;
					_tmp17_ = self->priv->_target;
					g_signal_emit (self, panther_backend_app_signals[PANTHER_BACKEND_APP_START_SEARCH_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, SYNAPSE_TYPE_SEARCH_MATCH) ? ((SynapseSearchMatch*) _tmp16_) : NULL, _tmp17_);
					result = FALSE;
					return result;
				} else {
					SynapseMatch* _tmp18_;
					_tmp18_ = self->priv->_target;
					if (_tmp18_ == NULL) {
						SynapseMatch* _tmp19_;
						GeeList* _tmp20_;
						GeeList* _tmp21_;
						gpointer _tmp22_;
						SynapseMatch* _tmp23_;
						SynapseMatch* _tmp24_;
						_tmp19_ = self->priv->_match;
						_tmp20_ = panther_backend_synapse_search_find_actions_for_match (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = gee_list_get (_tmp21_, 0);
						_tmp23_ = (SynapseMatch*) _tmp22_;
						_tmp24_ = self->priv->_match;
						synapse_match_execute_with_target (_tmp23_, _tmp24_, NULL);
						_g_object_unref0 (_tmp23_);
						_g_object_unref0 (_tmp21_);
					} else {
						SynapseMatch* _tmp25_;
						SynapseMatch* _tmp26_;
						_tmp25_ = self->priv->_match;
						_tmp26_ = self->priv->_target;
						synapse_match_execute_with_target (_tmp25_, _tmp26_, NULL);
					}
				}
				break;
			}
			default:
			break;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = self->priv->_name;
		_tmp28_ = self->priv->_exec;
		g_warning ("App.vala:287: Failed to launch %s: %s", _tmp27_, _tmp28_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp29_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp29_;
	}
	result = TRUE;
	return result;
}


void
panther_backend_app_init_actions (PantherBackendApp* self,
                                  GError** error)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GKeyFile* file = NULL;
	gchar* textdomain = NULL;
	gboolean _tmp18_ = FALSE;
	GeeArrayList* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	panther_backend_app_set_actions (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	panther_backend_app_set_actions_map (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		GKeyFile* _tmp4_;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = g_key_file_new ();
		_g_key_file_unref0 (file);
		file = _tmp4_;
		_tmp5_ = file;
		_tmp6_ = self->priv->_desktop_path;
		g_key_file_load_from_file (_tmp5_, _tmp6_, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = self->priv->_desktop_path;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("App.vala:305: %s: %s", _tmp7_, _tmp9_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_unref0 (file);
			return;
		} else {
			_g_key_file_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	textdomain = NULL;
	{
		const gchar** domain_key_collection = NULL;
		gint domain_key_collection_length1 = 0;
		gint _domain_key_collection_size_ = 0;
		gint domain_key_it = 0;
		domain_key_collection = PANTHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS;
		domain_key_collection_length1 = G_N_ELEMENTS (PANTHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS);
		for (domain_key_it = 0; domain_key_it < G_N_ELEMENTS (PANTHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS); domain_key_it = domain_key_it + 1) {
			const gchar* domain_key = NULL;
			domain_key = domain_key_collection[domain_key_it];
			{
				gboolean _tmp10_ = FALSE;
				GKeyFile* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = file;
				_tmp12_ = domain_key;
				_tmp10_ = g_key_file_has_key (_tmp11_, G_KEY_FILE_DESKTOP_GROUP, _tmp12_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (textdomain);
						_g_key_file_unref0 (file);
						return;
					} else {
						_g_free0 (textdomain);
						_g_key_file_unref0 (file);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (_tmp10_) {
					gchar* _tmp13_ = NULL;
					GKeyFile* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp14_ = file;
					_tmp15_ = domain_key;
					_tmp16_ = g_key_file_get_string (_tmp14_, G_KEY_FILE_DESKTOP_GROUP, _tmp15_, &_inner_error_);
					_tmp13_ = _tmp16_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (textdomain);
							_g_key_file_unref0 (file);
							return;
						} else {
							_g_free0 (textdomain);
							_g_key_file_unref0 (file);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp17_ = _tmp13_;
					_tmp13_ = NULL;
					_g_free0 (textdomain);
					textdomain = _tmp17_;
					_g_free0 (_tmp13_);
					break;
				}
			}
		}
	}
	_tmp19_ = self->priv->_actions;
	if (_tmp19_ != NULL) {
		GeeHashMap* _tmp20_;
		_tmp20_ = self->priv->_actions_map;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GeeArrayList* _tmp21_;
		GeeHashMap* _tmp22_;
		gchar** keys = NULL;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint keys_length1;
		gint _keys_size_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp21_ = self->priv->_actions;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp21_);
		_tmp22_ = self->priv->_actions_map;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp22_);
		_tmp23_ = g_strdup (PANTHER_BACKEND_APP_DESKTOP_ACTION_KEY);
		_tmp24_ = g_new0 (gchar*, 1 + 1);
		_tmp24_[0] = _tmp23_;
		keys = _tmp24_;
		keys_length1 = 1;
		_keys_size_ = keys_length1;
		_tmp25_ = keys;
		_tmp25__length1 = keys_length1;
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp25_;
			key_collection_length1 = _tmp25__length1;
			for (key_it = 0; key_it < _tmp25__length1; key_it = key_it + 1) {
				gchar* _tmp26_;
				gchar* key = NULL;
				_tmp26_ = g_strdup (key_collection[key_it]);
				key = _tmp26_;
				{
					gboolean _tmp27_ = FALSE;
					GKeyFile* _tmp28_;
					const gchar* _tmp29_;
					gchar** _tmp30_ = NULL;
					GKeyFile* _tmp31_;
					const gchar* _tmp32_;
					gsize _tmp33_ = 0;
					gchar** _tmp34_;
					gint _tmp30__length1;
					gint __tmp30__size_;
					_tmp28_ = file;
					_tmp29_ = key;
					_tmp27_ = g_key_file_has_key (_tmp28_, G_KEY_FILE_DESKTOP_GROUP, _tmp29_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (key);
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (textdomain);
							_g_key_file_unref0 (file);
							return;
						} else {
							_g_free0 (key);
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (textdomain);
							_g_key_file_unref0 (file);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					if (!_tmp27_) {
						_g_free0 (key);
						continue;
					}
					_tmp31_ = file;
					_tmp32_ = key;
					_tmp34_ = g_key_file_get_string_list (_tmp31_, G_KEY_FILE_DESKTOP_GROUP, _tmp32_, &_tmp33_, &_inner_error_);
					_tmp30_ = _tmp34_;
					_tmp30__length1 = _tmp33_;
					__tmp30__size_ = _tmp30__length1;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (key);
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (textdomain);
							_g_key_file_unref0 (file);
							return;
						} else {
							_g_free0 (key);
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (textdomain);
							_g_key_file_unref0 (file);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					{
						gchar** action_collection = NULL;
						gint action_collection_length1 = 0;
						gint _action_collection_size_ = 0;
						gint action_it = 0;
						action_collection = _tmp30_;
						action_collection_length1 = _tmp30__length1;
						for (action_it = 0; action_it < _tmp30__length1; action_it = action_it + 1) {
							gchar* _tmp35_;
							gchar* action = NULL;
							_tmp35_ = g_strdup (action_collection[action_it]);
							action = _tmp35_;
							{
								gchar* group = NULL;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								GKeyFile* _tmp38_;
								const gchar* _tmp39_;
								gboolean _tmp40_ = FALSE;
								GKeyFile* _tmp41_;
								const gchar* _tmp42_;
								gchar* action_name = NULL;
								GKeyFile* _tmp43_;
								const gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* action_icon = NULL;
								gchar* _tmp46_;
								gboolean _tmp47_ = FALSE;
								GKeyFile* _tmp48_;
								const gchar* _tmp49_;
								gchar* action_exec = NULL;
								gchar* _tmp55_;
								gboolean _tmp56_ = FALSE;
								GKeyFile* _tmp57_;
								const gchar* _tmp58_;
								const gchar* _tmp64_;
								GeeArrayList* _tmp68_;
								const gchar* _tmp69_;
								GeeHashMap* _tmp70_;
								const gchar* _tmp71_;
								const gchar* _tmp72_;
								const gchar* _tmp73_;
								gchar* _tmp74_;
								gchar* _tmp75_;
								_tmp36_ = action;
								_tmp37_ = g_strdup_printf (PANTHER_BACKEND_APP_DESKTOP_ACTION_GROUP_NAME, _tmp36_);
								group = _tmp37_;
								_tmp38_ = file;
								_tmp39_ = group;
								if (!g_key_file_has_group (_tmp38_, _tmp39_)) {
									_g_free0 (group);
									_g_free0 (action);
									continue;
								}
								_tmp41_ = file;
								_tmp42_ = group;
								_tmp40_ = g_key_file_has_key (_tmp41_, _tmp42_, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										return;
									} else {
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								if (_tmp40_) {
									_g_free0 (group);
									_g_free0 (action);
									continue;
								}
								_tmp43_ = file;
								_tmp44_ = group;
								_tmp45_ = g_key_file_get_locale_string (_tmp43_, _tmp44_, G_KEY_FILE_DESKTOP_KEY_NAME, NULL, &_inner_error_);
								action_name = _tmp45_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										return;
									} else {
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								_tmp46_ = g_strdup ("");
								action_icon = _tmp46_;
								_tmp48_ = file;
								_tmp49_ = group;
								_tmp47_ = g_key_file_has_key (_tmp48_, _tmp49_, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (action_icon);
										_g_free0 (action_name);
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										return;
									} else {
										_g_free0 (action_icon);
										_g_free0 (action_name);
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								if (_tmp47_) {
									gchar* _tmp50_ = NULL;
									GKeyFile* _tmp51_;
									const gchar* _tmp52_;
									gchar* _tmp53_;
									gchar* _tmp54_;
									_tmp51_ = file;
									_tmp52_ = group;
									_tmp53_ = g_key_file_get_locale_string (_tmp51_, _tmp52_, G_KEY_FILE_DESKTOP_KEY_ICON, NULL, &_inner_error_);
									_tmp50_ = _tmp53_;
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == G_KEY_FILE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (action_icon);
											_g_free0 (action_name);
											_g_free0 (group);
											_g_free0 (action);
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											_g_key_file_unref0 (file);
											return;
										} else {
											_g_free0 (action_icon);
											_g_free0 (action_name);
											_g_free0 (group);
											_g_free0 (action);
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											_g_key_file_unref0 (file);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_tmp54_ = _tmp50_;
									_tmp50_ = NULL;
									_g_free0 (action_icon);
									action_icon = _tmp54_;
									_g_free0 (_tmp50_);
								}
								_tmp55_ = g_strdup ("");
								action_exec = _tmp55_;
								_tmp57_ = file;
								_tmp58_ = group;
								_tmp56_ = g_key_file_has_key (_tmp57_, _tmp58_, G_KEY_FILE_DESKTOP_KEY_EXEC, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (action_exec);
										_g_free0 (action_icon);
										_g_free0 (action_name);
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										return;
									} else {
										_g_free0 (action_exec);
										_g_free0 (action_icon);
										_g_free0 (action_name);
										_g_free0 (group);
										_g_free0 (action);
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (key);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										_g_key_file_unref0 (file);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								if (_tmp56_) {
									gchar* _tmp59_ = NULL;
									GKeyFile* _tmp60_;
									const gchar* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
									_tmp60_ = file;
									_tmp61_ = group;
									_tmp62_ = g_key_file_get_string (_tmp60_, _tmp61_, G_KEY_FILE_DESKTOP_KEY_EXEC, &_inner_error_);
									_tmp59_ = _tmp62_;
									if (G_UNLIKELY (_inner_error_ != NULL)) {
										if (_inner_error_->domain == G_KEY_FILE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (action_exec);
											_g_free0 (action_icon);
											_g_free0 (action_name);
											_g_free0 (group);
											_g_free0 (action);
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											_g_key_file_unref0 (file);
											return;
										} else {
											_g_free0 (action_exec);
											_g_free0 (action_icon);
											_g_free0 (action_name);
											_g_free0 (group);
											_g_free0 (action);
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											_g_key_file_unref0 (file);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_tmp63_ = _tmp59_;
									_tmp59_ = NULL;
									_g_free0 (action_exec);
									action_exec = _tmp63_;
									_g_free0 (_tmp59_);
								}
								_tmp64_ = textdomain;
								if (_tmp64_ != NULL) {
									const gchar* _tmp65_;
									const gchar* _tmp66_;
									gchar* _tmp67_;
									_tmp65_ = textdomain;
									_tmp66_ = action_name;
									_tmp67_ = g_strdup (g_dgettext (_tmp65_, _tmp66_));
									_g_free0 (action_name);
									action_name = _tmp67_;
								}
								_tmp68_ = self->priv->_actions;
								_tmp69_ = action_name;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp69_);
								_tmp70_ = self->priv->_actions_map;
								_tmp71_ = action_name;
								_tmp72_ = action_exec;
								_tmp73_ = action_icon;
								_tmp74_ = g_strdup_printf ("%s;;%s", _tmp72_, _tmp73_);
								_tmp75_ = _tmp74_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp70_, _tmp71_, _tmp75_);
								_g_free0 (_tmp75_);
								_g_free0 (action_exec);
								_g_free0 (action_icon);
								_g_free0 (action_name);
								_g_free0 (group);
								_g_free0 (action);
							}
						}
					}
					_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (key);
				}
			}
		}
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (textdomain);
	_g_key_file_unref0 (file);
}


const gchar*
panther_backend_app_get_name (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void
panther_backend_app_set_name (PantherBackendApp* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_NAME_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_description (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_description (PantherBackendApp* self,
                                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_description (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_DESCRIPTION_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_desktop_id (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}


void
panther_backend_app_set_desktop_id (PantherBackendApp* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_desktop_id (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_DESKTOP_ID_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_exec (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_exec (PantherBackendApp* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_exec (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_EXEC_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_icon_name (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_icon_name (PantherBackendApp* self,
                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_icon_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_ICON_NAME_PROPERTY]);
	}
}


gchar**
panther_backend_app_get_keywords (PantherBackendApp* self,
                                  int* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keywords;
	_tmp0__length1 = self->priv->_keywords_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void
panther_backend_app_set_keywords (PantherBackendApp* self,
                                  gchar** value,
                                  int value_length1)
{
	int old_value_length;
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_keywords (self, &old_value_length) != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : ((gpointer) value);
		_tmp0__length1 = value_length1;
		self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_keywords = _tmp0_;
		self->priv->_keywords_length1 = _tmp0__length1;
		self->priv->__keywords_size_ = self->priv->_keywords_length1;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_KEYWORDS_PROPERTY]);
	}
}


GdkPixbuf*
panther_backend_app_get_icon (PantherBackendApp* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_icon (PantherBackendApp* self,
                              GdkPixbuf* value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_icon (self) != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_ICON_PROPERTY]);
	}
}


gdouble
panther_backend_app_get_popularity (PantherBackendApp* self)
{
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_popularity;
	result = _tmp0_;
	return result;
}


void
panther_backend_app_set_popularity (PantherBackendApp* self,
                                    gdouble value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_popularity (self) != value) {
		self->priv->_popularity = value;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_POPULARITY_PROPERTY]);
	}
}


gdouble
panther_backend_app_get_relevancy (PantherBackendApp* self)
{
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_relevancy;
	result = _tmp0_;
	return result;
}


void
panther_backend_app_set_relevancy (PantherBackendApp* self,
                                   gdouble value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_relevancy (self) != value) {
		self->priv->_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_RELEVANCY_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_desktop_path (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_desktop_path (PantherBackendApp* self,
                                      const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_desktop_path (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_DESKTOP_PATH_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_categories (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_categories;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_categories (PantherBackendApp* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_categories (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_categories);
		self->priv->_categories = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_CATEGORIES_PROPERTY]);
	}
}


const gchar*
panther_backend_app_get_generic_name (PantherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_generic_name (PantherBackendApp* self,
                                      const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, panther_backend_app_get_generic_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_GENERIC_NAME_PROPERTY]);
	}
}


PantherBackendAppAppType
panther_backend_app_get_app_type (PantherBackendApp* self)
{
	PantherBackendAppAppType result;
	PantherBackendAppAppType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_app_type;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_app_type (PantherBackendApp* self,
                                  PantherBackendAppAppType value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_app_type (self) != value) {
		self->priv->_app_type = value;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_APP_TYPE_PROPERTY]);
	}
}


SynapseMatch*
panther_backend_app_get_match (PantherBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_match;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_match (PantherBackendApp* self,
                               SynapseMatch* value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_match (self) != value) {
		SynapseMatch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_match);
		self->priv->_match = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_MATCH_PROPERTY]);
	}
}


SynapseMatch*
panther_backend_app_get_target (PantherBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_target (PantherBackendApp* self,
                                SynapseMatch* value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_target (self) != value) {
		SynapseMatch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_target);
		self->priv->_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_TARGET_PROPERTY]);
	}
}


GeeArrayList*
panther_backend_app_get_actions (PantherBackendApp* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_actions (PantherBackendApp* self,
                                 GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_actions (self) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_ACTIONS_PROPERTY]);
	}
}


GeeHashMap*
panther_backend_app_get_actions_map (PantherBackendApp* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions_map;
	result = _tmp0_;
	return result;
}


static void
panther_backend_app_set_actions_map (PantherBackendApp* self,
                                     GeeHashMap* value)
{
	g_return_if_fail (self != NULL);
	if (panther_backend_app_get_actions_map (self) != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions_map);
		self->priv->_actions_map = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, panther_backend_app_properties[PANTHER_BACKEND_APP_ACTIONS_MAP_PROPERTY]);
	}
}


static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static PantherBackendAppIconLoadFallbackMethod*
panther_backend_app_icon_load_fallback_method_construct (GType object_type,
                                                         PantherBackendAppIconLoadFallback fallback,
                                                         gpointer fallback_target)
{
	PantherBackendAppIconLoadFallbackMethod* self = NULL;
	self = (PantherBackendAppIconLoadFallbackMethod*) g_type_create_instance (object_type);
	self->load_icon = fallback;
	self->load_icon_target = fallback_target;
	return self;
}


static PantherBackendAppIconLoadFallbackMethod*
panther_backend_app_icon_load_fallback_method_new (PantherBackendAppIconLoadFallback fallback,
                                                   gpointer fallback_target)
{
	return panther_backend_app_icon_load_fallback_method_construct (PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, fallback, fallback_target);
}


static void
panther_backend_app_value_icon_load_fallback_method_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
panther_backend_app_value_icon_load_fallback_method_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		panther_backend_app_icon_load_fallback_method_unref (value->data[0].v_pointer);
	}
}


static void
panther_backend_app_value_icon_load_fallback_method_copy_value (const GValue* src_value,
                                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = panther_backend_app_icon_load_fallback_method_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
panther_backend_app_value_icon_load_fallback_method_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
panther_backend_app_value_icon_load_fallback_method_collect_value (GValue* value,
                                                                   guint n_collect_values,
                                                                   GTypeCValue* collect_values,
                                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PantherBackendAppIconLoadFallbackMethod * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = panther_backend_app_icon_load_fallback_method_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
panther_backend_app_value_icon_load_fallback_method_lcopy_value (const GValue* value,
                                                                 guint n_collect_values,
                                                                 GTypeCValue* collect_values,
                                                                 guint collect_flags)
{
	PantherBackendAppIconLoadFallbackMethod ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = panther_backend_app_icon_load_fallback_method_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
panther_backend_app_param_spec_icon_load_fallback_method (const gchar* name,
                                                          const gchar* nick,
                                                          const gchar* blurb,
                                                          GType object_type,
                                                          GParamFlags flags)
{
	PantherBackendAppParamSpecIconLoadFallbackMethod* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
panther_backend_app_value_get_icon_load_fallback_method (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD), NULL);
	return value->data[0].v_pointer;
}


static void
panther_backend_app_value_set_icon_load_fallback_method (GValue* value,
                                                         gpointer v_object)
{
	PantherBackendAppIconLoadFallbackMethod * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		panther_backend_app_icon_load_fallback_method_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panther_backend_app_icon_load_fallback_method_unref (old);
	}
}


static void
panther_backend_app_value_take_icon_load_fallback_method (GValue* value,
                                                          gpointer v_object)
{
	PantherBackendAppIconLoadFallbackMethod * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panther_backend_app_icon_load_fallback_method_unref (old);
	}
}


static void
panther_backend_app_icon_load_fallback_method_class_init (PantherBackendAppIconLoadFallbackMethodClass * klass)
{
	panther_backend_app_icon_load_fallback_method_parent_class = g_type_class_peek_parent (klass);
	((PantherBackendAppIconLoadFallbackMethodClass *) klass)->finalize = panther_backend_app_icon_load_fallback_method_finalize;
}


static void
panther_backend_app_icon_load_fallback_method_instance_init (PantherBackendAppIconLoadFallbackMethod * self)
{
	self->ref_count = 1;
}


static void
panther_backend_app_icon_load_fallback_method_finalize (PantherBackendAppIconLoadFallbackMethod * obj)
{
	PantherBackendAppIconLoadFallbackMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, PantherBackendAppIconLoadFallbackMethod);
	g_signal_handlers_destroy (self);
}


static GType
panther_backend_app_icon_load_fallback_method_get_type (void)
{
	static volatile gsize panther_backend_app_icon_load_fallback_method_type_id__volatile = 0;
	if (g_once_init_enter (&panther_backend_app_icon_load_fallback_method_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { panther_backend_app_value_icon_load_fallback_method_init, panther_backend_app_value_icon_load_fallback_method_free_value, panther_backend_app_value_icon_load_fallback_method_copy_value, panther_backend_app_value_icon_load_fallback_method_peek_pointer, "p", panther_backend_app_value_icon_load_fallback_method_collect_value, "p", panther_backend_app_value_icon_load_fallback_method_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PantherBackendAppIconLoadFallbackMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panther_backend_app_icon_load_fallback_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantherBackendAppIconLoadFallbackMethod), 0, (GInstanceInitFunc) panther_backend_app_icon_load_fallback_method_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType panther_backend_app_icon_load_fallback_method_type_id;
		panther_backend_app_icon_load_fallback_method_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PantherBackendAppIconLoadFallbackMethod", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&panther_backend_app_icon_load_fallback_method_type_id__volatile, panther_backend_app_icon_load_fallback_method_type_id);
	}
	return panther_backend_app_icon_load_fallback_method_type_id__volatile;
}


static gpointer
panther_backend_app_icon_load_fallback_method_ref (gpointer instance)
{
	PantherBackendAppIconLoadFallbackMethod * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
panther_backend_app_icon_load_fallback_method_unref (gpointer instance)
{
	PantherBackendAppIconLoadFallbackMethod * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PANTHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
panther_backend_app_class_init (PantherBackendAppClass * klass)
{
	panther_backend_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantherBackendApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_panther_backend_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_panther_backend_app_set_property;
	G_OBJECT_CLASS (klass)->finalize = panther_backend_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_NAME_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_DESCRIPTION_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_DESKTOP_ID_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_EXEC_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_ICON_NAME_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_KEYWORDS_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_KEYWORDS_PROPERTY] = g_param_spec_boxed ("keywords", "keywords", "keywords", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_ICON_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_POPULARITY_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_POPULARITY_PROPERTY] = g_param_spec_double ("popularity", "popularity", "popularity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_RELEVANCY_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_RELEVANCY_PROPERTY] = g_param_spec_double ("relevancy", "relevancy", "relevancy", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_DESKTOP_PATH_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_CATEGORIES_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_CATEGORIES_PROPERTY] = g_param_spec_string ("categories", "categories", "categories", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_GENERIC_NAME_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_APP_TYPE_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_APP_TYPE_PROPERTY] = g_param_spec_enum ("app-type", "app-type", "app-type", PANTHER_BACKEND_APP_TYPE_APP_TYPE, PANTHER_BACKEND_APP_APP_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_MATCH_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_MATCH_PROPERTY] = g_param_spec_object ("match", "match", "match", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_TARGET_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_ACTIONS_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_BACKEND_APP_ACTIONS_MAP_PROPERTY, panther_backend_app_properties[PANTHER_BACKEND_APP_ACTIONS_MAP_PROPERTY] = g_param_spec_object ("actions-map", "actions-map", "actions-map", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	panther_backend_app_signals[PANTHER_BACKEND_APP_START_SEARCH_SIGNAL] = g_signal_new ("start-search", PANTHER_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, SYNAPSE_TYPE_SEARCH_MATCH, SYNAPSE_TYPE_MATCH);
	panther_backend_app_signals[PANTHER_BACKEND_APP_ICON_CHANGED_SIGNAL] = g_signal_new ("icon-changed", PANTHER_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	panther_backend_app_signals[PANTHER_BACKEND_APP_LAUNCHED_SIGNAL] = g_signal_new ("launched", PANTHER_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PANTHER_BACKEND_TYPE_APP);
}


static void
panther_backend_app_instance_init (PantherBackendApp * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = panther_backend_app_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_icon = NULL;
	_tmp2_ = g_strdup ("");
	self->priv->_generic_name = _tmp2_;
	self->priv->_app_type = PANTHER_BACKEND_APP_APP_TYPE_APP;
	self->priv->_match = NULL;
	self->priv->_target = NULL;
	self->priv->_actions = NULL;
	self->priv->_actions_map = NULL;
	self->priv->check_icon_again = TRUE;
	self->priv->loadable_icon = NULL;
}


static void
panther_backend_app_finalize (GObject * obj)
{
	PantherBackendApp * self;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	guint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHER_BACKEND_TYPE_APP, PantherBackendApp);
	_tmp0_ = panther_panther_get_icon_theme ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("changed", gtk_icon_theme_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _panther_backend_app_update_icon_gtk_icon_theme_changed, self);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	_g_free0 (self->priv->_icon_name);
	self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_desktop_path);
	_g_free0 (self->priv->_categories);
	_g_free0 (self->priv->_generic_name);
	_g_object_unref0 (self->priv->_match);
	_g_object_unref0 (self->priv->_target);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_actions_map);
	_g_object_unref0 (self->priv->loadable_icon);
	G_OBJECT_CLASS (panther_backend_app_parent_class)->finalize (obj);
}


GType
panther_backend_app_get_type (void)
{
	static volatile gsize panther_backend_app_type_id__volatile = 0;
	if (g_once_init_enter (&panther_backend_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PantherBackendAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panther_backend_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantherBackendApp), 0, (GInstanceInitFunc) panther_backend_app_instance_init, NULL };
		GType panther_backend_app_type_id;
		panther_backend_app_type_id = g_type_register_static (G_TYPE_OBJECT, "PantherBackendApp", &g_define_type_info, 0);
		PantherBackendApp_private_offset = g_type_add_instance_private (panther_backend_app_type_id, sizeof (PantherBackendAppPrivate));
		g_once_init_leave (&panther_backend_app_type_id__volatile, panther_backend_app_type_id);
	}
	return panther_backend_app_type_id__volatile;
}


static void
_vala_panther_backend_app_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PantherBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHER_BACKEND_TYPE_APP, PantherBackendApp);
	switch (property_id) {
		case PANTHER_BACKEND_APP_NAME_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_name (self));
		break;
		case PANTHER_BACKEND_APP_DESCRIPTION_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_description (self));
		break;
		case PANTHER_BACKEND_APP_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_desktop_id (self));
		break;
		case PANTHER_BACKEND_APP_EXEC_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_exec (self));
		break;
		case PANTHER_BACKEND_APP_ICON_NAME_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_icon_name (self));
		break;
		case PANTHER_BACKEND_APP_KEYWORDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, panther_backend_app_get_keywords (self, &length));
		}
		break;
		case PANTHER_BACKEND_APP_ICON_PROPERTY:
		g_value_set_object (value, panther_backend_app_get_icon (self));
		break;
		case PANTHER_BACKEND_APP_POPULARITY_PROPERTY:
		g_value_set_double (value, panther_backend_app_get_popularity (self));
		break;
		case PANTHER_BACKEND_APP_RELEVANCY_PROPERTY:
		g_value_set_double (value, panther_backend_app_get_relevancy (self));
		break;
		case PANTHER_BACKEND_APP_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_desktop_path (self));
		break;
		case PANTHER_BACKEND_APP_CATEGORIES_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_categories (self));
		break;
		case PANTHER_BACKEND_APP_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, panther_backend_app_get_generic_name (self));
		break;
		case PANTHER_BACKEND_APP_APP_TYPE_PROPERTY:
		g_value_set_enum (value, panther_backend_app_get_app_type (self));
		break;
		case PANTHER_BACKEND_APP_MATCH_PROPERTY:
		g_value_set_object (value, panther_backend_app_get_match (self));
		break;
		case PANTHER_BACKEND_APP_TARGET_PROPERTY:
		g_value_set_object (value, panther_backend_app_get_target (self));
		break;
		case PANTHER_BACKEND_APP_ACTIONS_PROPERTY:
		g_value_set_object (value, panther_backend_app_get_actions (self));
		break;
		case PANTHER_BACKEND_APP_ACTIONS_MAP_PROPERTY:
		g_value_set_object (value, panther_backend_app_get_actions_map (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_panther_backend_app_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PantherBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHER_BACKEND_TYPE_APP, PantherBackendApp);
	switch (property_id) {
		case PANTHER_BACKEND_APP_NAME_PROPERTY:
		panther_backend_app_set_name (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_DESCRIPTION_PROPERTY:
		panther_backend_app_set_description (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_DESKTOP_ID_PROPERTY:
		panther_backend_app_set_desktop_id (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_EXEC_PROPERTY:
		panther_backend_app_set_exec (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_ICON_NAME_PROPERTY:
		panther_backend_app_set_icon_name (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_KEYWORDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			panther_backend_app_set_keywords (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PANTHER_BACKEND_APP_ICON_PROPERTY:
		panther_backend_app_set_icon (self, g_value_get_object (value));
		break;
		case PANTHER_BACKEND_APP_POPULARITY_PROPERTY:
		panther_backend_app_set_popularity (self, g_value_get_double (value));
		break;
		case PANTHER_BACKEND_APP_RELEVANCY_PROPERTY:
		panther_backend_app_set_relevancy (self, g_value_get_double (value));
		break;
		case PANTHER_BACKEND_APP_DESKTOP_PATH_PROPERTY:
		panther_backend_app_set_desktop_path (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_CATEGORIES_PROPERTY:
		panther_backend_app_set_categories (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_GENERIC_NAME_PROPERTY:
		panther_backend_app_set_generic_name (self, g_value_get_string (value));
		break;
		case PANTHER_BACKEND_APP_APP_TYPE_PROPERTY:
		panther_backend_app_set_app_type (self, g_value_get_enum (value));
		break;
		case PANTHER_BACKEND_APP_MATCH_PROPERTY:
		panther_backend_app_set_match (self, g_value_get_object (value));
		break;
		case PANTHER_BACKEND_APP_TARGET_PROPERTY:
		panther_backend_app_set_target (self, g_value_get_object (value));
		break;
		case PANTHER_BACKEND_APP_ACTIONS_PROPERTY:
		panther_backend_app_set_actions (self, g_value_get_object (value));
		break;
		case PANTHER_BACKEND_APP_ACTIONS_MAP_PROPERTY:
		panther_backend_app_set_actions_map (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



