/* config-service.c generated by valac 0.42.5, the Vala compiler
 * generated from config-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define SYNAPSE_TYPE_CONFIG_OBJECT (synapse_config_object_get_type ())
#define SYNAPSE_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObject))
#define SYNAPSE_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))
#define SYNAPSE_IS_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_IS_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_CONFIG_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))

typedef struct _SynapseConfigObject SynapseConfigObject;
typedef struct _SynapseConfigObjectClass SynapseConfigObjectClass;
typedef struct _SynapseConfigObjectPrivate SynapseConfigObjectPrivate;
enum  {
	SYNAPSE_CONFIG_OBJECT_0_PROPERTY,
	SYNAPSE_CONFIG_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_config_object_properties[SYNAPSE_CONFIG_OBJECT_NUM_PROPERTIES];

#define SYNAPSE_TYPE_CONFIG_SERVICE (synapse_config_service_get_type ())
#define SYNAPSE_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService))
#define SYNAPSE_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))
#define SYNAPSE_IS_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_IS_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_CONFIG_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))

typedef struct _SynapseConfigService SynapseConfigService;
typedef struct _SynapseConfigServiceClass SynapseConfigServiceClass;
typedef struct _SynapseConfigServicePrivate SynapseConfigServicePrivate;
enum  {
	SYNAPSE_CONFIG_SERVICE_0_PROPERTY,
	SYNAPSE_CONFIG_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_config_service_properties[SYNAPSE_CONFIG_SERVICE_NUM_PROPERTIES];
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseConfigObject {
	GObject parent_instance;
	SynapseConfigObjectPrivate * priv;
};

struct _SynapseConfigObjectClass {
	GObjectClass parent_class;
};

struct _SynapseConfigService {
	GObject parent_instance;
	SynapseConfigServicePrivate * priv;
};

struct _SynapseConfigServiceClass {
	GObjectClass parent_class;
};

struct _SynapseConfigServicePrivate {
	JsonNode* root_node;
	gchar* config_file_name;
	guint save_timer_id;
};

struct _Block11Data {
	int _ref_count_;
	SynapseConfigService* self;
	SynapseConfigObject* co;
	gchar* group;
	gchar* key;
};


static gpointer synapse_config_object_parent_class = NULL;
static gint SynapseConfigService_private_offset;
static gpointer synapse_config_service_parent_class = NULL;
static SynapseConfigService* synapse_config_service_instance;
static SynapseConfigService* synapse_config_service_instance = NULL;

GType synapse_config_object_get_type (void) G_GNUC_CONST;
SynapseConfigObject* synapse_config_object_construct (GType object_type);
GType synapse_config_service_get_type (void) G_GNUC_CONST;
void synapse_config_service_save (SynapseConfigService* self);
static void _vala_JsonNode_free (JsonNode* self);
SynapseConfigService* synapse_config_service_get_default (void);
static SynapseConfigService* synapse_config_service_new (void);
static SynapseConfigService* synapse_config_service_construct (GType object_type);
SynapseConfigObject* synapse_config_service_get_config (SynapseConfigService* self,
                                                        const gchar* group,
                                                        const gchar* key,
                                                        GType config_type);
SynapseConfigObject* synapse_config_service_bind_config (SynapseConfigService* self,
                                                         const gchar* group,
                                                         const gchar* key,
                                                         GType config_type);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda17_ (Block11Data* _data11_);
void synapse_config_service_set_config (SynapseConfigService* self,
                                        const gchar* group,
                                        const gchar* key,
                                        SynapseConfigObject* cfg_obj);
static void ___lambda17__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean synapse_config_service_save_timeout (SynapseConfigService* self);
static gboolean _synapse_config_service_save_timeout_gsource_func (gpointer self);
static GObject * synapse_config_service_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_config_service_finalize (GObject * obj);


SynapseConfigObject*
synapse_config_object_construct (GType object_type)
{
	SynapseConfigObject * self = NULL;
	self = (SynapseConfigObject*) g_object_new (object_type, NULL);
	return self;
}


static void
synapse_config_object_class_init (SynapseConfigObjectClass * klass)
{
	synapse_config_object_parent_class = g_type_class_peek_parent (klass);
}


static void
synapse_config_object_instance_init (SynapseConfigObject * self)
{
}


GType
synapse_config_object_get_type (void)
{
	static volatile gsize synapse_config_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_config_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_config_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConfigObject), 0, (GInstanceInitFunc) synapse_config_object_instance_init, NULL };
		GType synapse_config_object_type_id;
		synapse_config_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseConfigObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&synapse_config_object_type_id__volatile, synapse_config_object_type_id);
	}
	return synapse_config_object_type_id__volatile;
}


static inline gpointer
synapse_config_service_get_instance_private (SynapseConfigService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseConfigService_private_offset);
}


static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


SynapseConfigService*
synapse_config_service_get_default (void)
{
	SynapseConfigService* result = NULL;
	SynapseConfigService* _tmp0_ = NULL;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseConfigService* _tmp4_;
	_tmp1_ = synapse_config_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseConfigService* _tmp3_;
		_tmp3_ = synapse_config_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static SynapseConfigService*
synapse_config_service_construct (GType object_type)
{
	SynapseConfigService * self = NULL;
	self = (SynapseConfigService*) g_object_new (object_type, NULL);
	return self;
}


static SynapseConfigService*
synapse_config_service_new (void)
{
	return synapse_config_service_construct (SYNAPSE_TYPE_CONFIG_SERVICE);
}


/**
     * Creates an instance of an object derived from ConfigObject class, which
     * will have its public properties set to values stored in config file, or
     * to the default values if this object wasn't yet stored.
     *
     * @param group A group name.
     * @param key A key name.
     * @param config_type Type of the object (must be subclass of ConfigObject)
     * @return An instance of config_type.
     */
SynapseConfigObject*
synapse_config_service_get_config (SynapseConfigService* self,
                                   const gchar* group,
                                   const gchar* key,
                                   GType config_type)
{
	SynapseConfigObject* result = NULL;
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonNode* group_node = NULL;
	JsonObject* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	GObject* _tmp17_;
	GObject* _tmp18_;
	SynapseConfigObject* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	obj = _tmp1_;
	_tmp2_ = obj;
	_tmp3_ = json_object_get_member (_tmp2_, group);
	group_node = _tmp3_;
	_tmp4_ = group_node;
	if (_tmp4_ != NULL) {
		JsonNode* _tmp5_;
		_tmp5_ = group_node;
		if (json_node_get_node_type (_tmp5_) == JSON_NODE_OBJECT) {
			JsonObject* group_obj = NULL;
			JsonNode* _tmp6_;
			JsonObject* _tmp7_;
			JsonNode* key_node = NULL;
			JsonObject* _tmp8_;
			JsonNode* _tmp9_;
			gboolean _tmp10_ = FALSE;
			JsonNode* _tmp11_;
			_tmp6_ = group_node;
			_tmp7_ = json_node_get_object (_tmp6_);
			group_obj = _tmp7_;
			_tmp8_ = group_obj;
			_tmp9_ = json_object_get_member (_tmp8_, key);
			key_node = _tmp9_;
			_tmp11_ = key_node;
			if (_tmp11_ != NULL) {
				JsonNode* _tmp12_;
				_tmp12_ = key_node;
				_tmp10_ = json_node_get_node_type (_tmp12_) == JSON_NODE_OBJECT;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				GObject* _result_ = NULL;
				JsonNode* _tmp13_;
				GObject* _tmp14_;
				GObject* _tmp15_;
				SynapseConfigObject* _tmp16_;
				_tmp13_ = key_node;
				_tmp14_ = json_gobject_deserialize (config_type, _tmp13_);
				_result_ = _tmp14_;
				_tmp15_ = _result_;
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, SYNAPSE_TYPE_CONFIG_OBJECT) ? ((SynapseConfigObject*) _tmp15_) : NULL);
				result = _tmp16_;
				_g_object_unref0 (_result_);
				return result;
			}
		}
	}
	_tmp17_ = g_object_new (config_type, NULL);
	_tmp18_ = G_IS_INITIALLY_UNOWNED (_tmp17_) ? g_object_ref_sink (_tmp17_) : _tmp17_;
	_tmp19_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, SYNAPSE_TYPE_CONFIG_OBJECT) ? ((SynapseConfigObject*) _tmp18_) : NULL;
	if (_tmp19_ == NULL) {
		_g_object_unref0 (_tmp18_);
	}
	result = _tmp19_;
	return result;
}


/**
     * Behaves in a similar way to get_config, but it also watches for changes
     * in the returned config object and saves them back to the config file
     * (without the need of calling set_config).
     *
     * @param group A group name.
     * @param key A key name.
     * @param config_type Type of the object (must be subclass of ConfigObject)
     */
static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SynapseConfigService* self;
		self = _data11_->self;
		_g_free0 (_data11_->group);
		_g_free0 (_data11_->key);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}


static void
__lambda17_ (Block11Data* _data11_)
{
	SynapseConfigService* self;
	self = _data11_->self;
	synapse_config_service_set_config (self, _data11_->group, _data11_->key, _data11_->co);
}


static void
___lambda17__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda17_ (self);
}


SynapseConfigObject*
synapse_config_service_bind_config (SynapseConfigService* self,
                                    const gchar* group,
                                    const gchar* key,
                                    GType config_type)
{
	SynapseConfigObject* result = NULL;
	Block11Data* _data11_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SynapseConfigObject* config_object = NULL;
	SynapseConfigObject* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = g_strdup (group);
	_g_free0 (_data11_->group);
	_data11_->group = _tmp0_;
	_tmp1_ = g_strdup (key);
	_g_free0 (_data11_->key);
	_data11_->key = _tmp1_;
	_tmp2_ = synapse_config_service_get_config (self, _data11_->group, _data11_->key, config_type);
	config_object = _tmp2_;
	_data11_->co = config_object;
	g_signal_connect_data ((GObject*) _data11_->co, "notify", (GCallback) ___lambda17__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	result = config_object;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


/**
     * Stores all public properties of the object to the config file under
     * specified group and key names.
     *
     * @param group A group name.
     * @param key A key name.
     * @param cfg_obj ConfigObject instance.
     */
static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}


static gboolean
_synapse_config_service_save_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_config_service_save_timeout ((SynapseConfigService*) self);
	return result;
}


void
synapse_config_service_set_config (SynapseConfigService* self,
                                   const gchar* group,
                                   const gchar* key,
                                   SynapseConfigObject* cfg_obj)
{
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_;
	JsonObject* group_obj = NULL;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	JsonObject* _tmp10_;
	JsonNode* node = NULL;
	JsonNode* _tmp12_;
	JsonObject* _tmp13_;
	JsonNode* _tmp14_;
	JsonObject* _tmp15_;
	JsonObject* _tmp16_;
	guint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (cfg_obj != NULL);
	_tmp0_ = self->priv->root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	obj = _tmp1_;
	_tmp3_ = obj;
	if (!json_object_has_member (_tmp3_, group)) {
		_tmp2_ = TRUE;
	} else {
		JsonObject* _tmp4_;
		JsonNode* _tmp5_;
		_tmp4_ = obj;
		_tmp5_ = json_object_get_member (_tmp4_, group);
		_tmp2_ = json_node_get_node_type (_tmp5_) != JSON_NODE_OBJECT;
	}
	if (_tmp2_) {
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		_tmp6_ = obj;
		_tmp7_ = json_object_new ();
		json_object_set_object_member (_tmp6_, group, _tmp7_);
	}
	_tmp8_ = obj;
	_tmp9_ = json_object_get_object_member (_tmp8_, group);
	group_obj = _tmp9_;
	_tmp10_ = group_obj;
	if (json_object_has_member (_tmp10_, key)) {
		JsonObject* _tmp11_;
		_tmp11_ = group_obj;
		json_object_remove_member (_tmp11_, key);
	}
	_tmp12_ = json_gobject_serialize ((GObject*) cfg_obj);
	node = _tmp12_;
	_tmp13_ = group_obj;
	_tmp14_ = node;
	_tmp15_ = json_node_get_object (_tmp14_);
	_tmp16_ = _json_object_ref0 (_tmp15_);
	json_object_set_object_member (_tmp13_, key, _tmp16_);
	_tmp17_ = self->priv->save_timer_id;
	if (_tmp17_ != ((guint) 0)) {
		guint _tmp18_;
		_tmp18_ = self->priv->save_timer_id;
		g_source_remove (_tmp18_);
	}
	self->priv->save_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 30000, _synapse_config_service_save_timeout_gsource_func, g_object_ref (self), g_object_unref);
	__vala_JsonNode_free0 (node);
}


static gboolean
synapse_config_service_save_timeout (SynapseConfigService* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->save_timer_id = (guint) 0;
	synapse_config_service_save (self);
	result = FALSE;
	return result;
}


/**
     * Forces immediate saving of the configuration file to the filesystem.
     */
void
synapse_config_service_save (SynapseConfigService* self)
{
	guint _tmp0_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp2_;
	JsonNode* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_timer_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->save_timer_id;
		g_source_remove (_tmp1_);
		self->priv->save_timer_id = (guint) 0;
	}
	_tmp2_ = json_generator_new ();
	generator = _tmp2_;
	json_generator_set_pretty (generator, TRUE);
	_tmp3_ = self->priv->root_node;
	json_generator_set_root (generator, _tmp3_);
	_tmp4_ = self->priv->config_file_name;
	_tmp5_ = g_path_get_dirname (_tmp4_);
	_tmp6_ = _tmp5_;
	g_mkdir_with_parents (_tmp6_, 0755);
	_g_free0 (_tmp6_);
	{
		const gchar* _tmp7_;
		_tmp7_ = self->priv->config_file_name;
		json_generator_to_file (generator, _tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("config-service.vala:187: %s", _tmp9_);
		_g_error_free0 (err);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (generator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (generator);
}


static GObject *
synapse_config_service_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseConfigService * self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_config_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService);
	synapse_config_service_instance = self;
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "synapse", "config.json", NULL);
	_g_free0 (self->priv->config_file_name);
	self->priv->config_file_name = _tmp2_;
	{
		JsonParser* _tmp3_;
		const gchar* _tmp4_;
		JsonParser* _tmp5_;
		JsonNode* _tmp6_;
		JsonNode* _tmp7_;
		JsonNode* _tmp8_;
		_tmp3_ = parser;
		_tmp4_ = self->priv->config_file_name;
		json_parser_load_from_file (_tmp3_, _tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
		_tmp5_ = parser;
		_tmp6_ = json_parser_get_root (_tmp5_);
		_tmp7_ = json_node_copy (_tmp6_);
		__vala_JsonNode_free0 (self->priv->root_node);
		self->priv->root_node = _tmp7_;
		_tmp8_ = self->priv->root_node;
		if (json_node_get_node_type (_tmp8_) != JSON_NODE_OBJECT) {
			JsonNode* _tmp9_;
			JsonNode* _tmp10_;
			JsonObject* _tmp11_;
			_tmp9_ = json_node_new (JSON_NODE_OBJECT);
			__vala_JsonNode_free0 (self->priv->root_node);
			self->priv->root_node = _tmp9_;
			_tmp10_ = self->priv->root_node;
			_tmp11_ = json_object_new ();
			json_node_take_object (_tmp10_, _tmp11_);
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* err = NULL;
		JsonNode* _tmp12_;
		JsonNode* _tmp13_;
		JsonObject* _tmp14_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = json_node_new (JSON_NODE_OBJECT);
		__vala_JsonNode_free0 (self->priv->root_node);
		self->priv->root_node = _tmp12_;
		_tmp13_ = self->priv->root_node;
		_tmp14_ = json_object_new ();
		json_node_take_object (_tmp13_, _tmp14_);
		_g_error_free0 (err);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_object_unref0 (parser);
	return obj;
}


static void
synapse_config_service_class_init (SynapseConfigServiceClass * klass)
{
	synapse_config_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseConfigService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_config_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_config_service_finalize;
}


static void
synapse_config_service_instance_init (SynapseConfigService * self)
{
	self->priv = synapse_config_service_get_instance_private (self);
	self->priv->save_timer_id = (guint) 0;
}


static void
synapse_config_service_finalize (GObject * obj)
{
	SynapseConfigService * self;
	guint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService);
	_tmp0_ = self->priv->save_timer_id;
	if (_tmp0_ != ((guint) 0)) {
		synapse_config_service_save (self);
	}
	synapse_config_service_instance = NULL;
	__vala_JsonNode_free0 (self->priv->root_node);
	_g_free0 (self->priv->config_file_name);
	G_OBJECT_CLASS (synapse_config_service_parent_class)->finalize (obj);
}


GType
synapse_config_service_get_type (void)
{
	static volatile gsize synapse_config_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_config_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_config_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConfigService), 0, (GInstanceInitFunc) synapse_config_service_instance_init, NULL };
		GType synapse_config_service_type_id;
		synapse_config_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseConfigService", &g_define_type_info, 0);
		SynapseConfigService_private_offset = g_type_add_instance_private (synapse_config_service_type_id, sizeof (SynapseConfigServicePrivate));
		g_once_init_leave (&synapse_config_service_type_id__volatile, synapse_config_service_type_id);
	}
	return synapse_config_service_type_id__volatile;
}



