/* query.c generated by valac 0.42.5, the Vala compiler
 * generated from query.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;


#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;


#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()


GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
void synapse_query_init (SynapseQuery *self,
                         guint query_id,
                         const gchar* query,
                         SynapseQueryFlags flags,
                         guint num_results);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
GQuark synapse_search_error_quark (void);
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static gint __lambda9_ (GeeMapEntry* a,
                 GeeMapEntry* b);
static gint ___lambda9__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType
synapse_query_flags_get_type (void)
{
	static volatile gsize synapse_query_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE, "SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE", "include-remote"}, {SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "SYNAPSE_QUERY_FLAGS_UNCATEGORIZED", "uncategorized"}, {SYNAPSE_QUERY_FLAGS_APPLICATIONS, "SYNAPSE_QUERY_FLAGS_APPLICATIONS", "applications"}, {SYNAPSE_QUERY_FLAGS_ACTIONS, "SYNAPSE_QUERY_FLAGS_ACTIONS", "actions"}, {SYNAPSE_QUERY_FLAGS_AUDIO, "SYNAPSE_QUERY_FLAGS_AUDIO", "audio"}, {SYNAPSE_QUERY_FLAGS_VIDEO, "SYNAPSE_QUERY_FLAGS_VIDEO", "video"}, {SYNAPSE_QUERY_FLAGS_DOCUMENTS, "SYNAPSE_QUERY_FLAGS_DOCUMENTS", "documents"}, {SYNAPSE_QUERY_FLAGS_IMAGES, "SYNAPSE_QUERY_FLAGS_IMAGES", "images"}, {SYNAPSE_QUERY_FLAGS_FILES, "SYNAPSE_QUERY_FLAGS_FILES", "files"}, {SYNAPSE_QUERY_FLAGS_PLACES, "SYNAPSE_QUERY_FLAGS_PLACES", "places"}, {SYNAPSE_QUERY_FLAGS_INTERNET, "SYNAPSE_QUERY_FLAGS_INTERNET", "internet"}, {SYNAPSE_QUERY_FLAGS_TEXT, "SYNAPSE_QUERY_FLAGS_TEXT", "text"}, {SYNAPSE_QUERY_FLAGS_CONTACTS, "SYNAPSE_QUERY_FLAGS_CONTACTS", "contacts"}, {SYNAPSE_QUERY_FLAGS_ALL, "SYNAPSE_QUERY_FLAGS_ALL", "all"}, {SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT, "SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT", "local-content"}, {0, NULL, NULL}};
		GType synapse_query_flags_type_id;
		synapse_query_flags_type_id = g_flags_register_static ("SynapseQueryFlags", values);
		g_once_init_leave (&synapse_query_flags_type_id__volatile, synapse_query_flags_type_id);
	}
	return synapse_query_flags_type_id__volatile;
}


GType
synapse_matcher_flags_get_type (void)
{
	static volatile gsize synapse_matcher_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_matcher_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_MATCHER_FLAGS_NO_REVERSED, "SYNAPSE_MATCHER_FLAGS_NO_REVERSED", "no-reversed"}, {SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING, "SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING", "no-substring"}, {SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, "SYNAPSE_MATCHER_FLAGS_NO_PARTIAL", "no-partial"}, {SYNAPSE_MATCHER_FLAGS_NO_FUZZY, "SYNAPSE_MATCHER_FLAGS_NO_FUZZY", "no-fuzzy"}, {0, NULL, NULL}};
		GType synapse_matcher_flags_type_id;
		synapse_matcher_flags_type_id = g_flags_register_static ("SynapseMatcherFlags", values);
		g_once_init_leave (&synapse_matcher_flags_type_id__volatile, synapse_matcher_flags_type_id);
	}
	return synapse_matcher_flags_type_id__volatile;
}


void
synapse_query_init (SynapseQuery *self,
                    guint query_id,
                    const gchar* query,
                    SynapseQueryFlags flags,
                    guint num_results)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (query != NULL);
	memset (self, 0, sizeof (SynapseQuery));
	(*self).query_id = query_id;
	_tmp0_ = g_strdup (query);
	_g_free0 ((*self).query_string);
	(*self).query_string = _tmp0_;
	_tmp1_ = g_utf8_casefold (query, (gssize) -1);
	_g_free0 ((*self).query_string_folded);
	(*self).query_string_folded = _tmp1_;
	(*self).query_type = flags;
	(*self).max_results = num_results;
}


gboolean
synapse_query_is_cancelled (SynapseQuery *self)
{
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	_tmp0_ = (*self).cancellable;
	result = g_cancellable_is_cancelled (_tmp0_);
	return result;
}


void
synapse_query_check_cancellable (SynapseQuery *self,
                                 GError** error)
{
	GCancellable* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = (*self).cancellable;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gint
__lambda9_ (GeeMapEntry* a,
            GeeMapEntry* b)
{
	gint result = 0;
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gconstpointer _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
	_tmp0_ = gee_map_entry_get_value (e2);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_map_entry_get_value (e1);
	_tmp3_ = _tmp2_;
	result = ((gint) ((gintptr) _tmp1_)) - ((gint) ((gintptr) _tmp3_));
	return result;
}


static gint
___lambda9__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda9_ ((GeeMapEntry*) a, (GeeMapEntry*) b);
	return result;
}


GeeList*
synapse_query_get_matchers_for_query (const gchar* query,
                                      SynapseMatcherFlags match_flags,
                                      GRegexCompileFlags flags)
{
	GeeList* result = NULL;
	GeeHashMap* results = NULL;
	GeeHashMap* _tmp0_;
	GRegex* re = NULL;
	gchar** individual_words = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint individual_words_length1;
	gint _individual_words_size_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar** individual_chars = NULL;
	gchar** _tmp95_;
	gchar** _tmp96_;
	gint individual_chars_length1;
	gint _individual_chars_size_;
	gchar** escaped_chars = NULL;
	gchar** _tmp97_;
	gint escaped_chars_length1;
	gint _escaped_chars_size_;
	gchar** _tmp98_;
	gint _tmp98__length1;
	gboolean _tmp102_ = FALSE;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp116_ = FALSE;
	GeeArrayList* sorted_results = NULL;
	GeeArrayList* _tmp128_;
	GeeSet* entries = NULL;
	GeeSet* _tmp129_;
	GeeSet* _tmp130_;
	GeeSet* _tmp131_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, (GDestroyNotify) g_regex_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	results = _tmp0_;
	{
		GRegex* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		_tmp2_ = g_regex_escape_string (query, -1);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("^(%s)$", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_regex_new (_tmp5_, flags, 0, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch37_g_regex_error;
			}
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp8_;
		_tmp9_ = re;
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp9_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_HIGHEST)));
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally37;
	__catch37_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_;
		_tmp11_ = g_regex_escape_string (query, -1);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("^(%s)", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_regex_new (_tmp14_, flags, 0, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp10_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp17_;
		_tmp18_ = re;
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp18_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_EXCELLENT)));
		_g_regex_unref0 (_tmp10_);
	}
	goto __finally38;
	__catch38_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GRegex* _tmp24_;
		GRegex* _tmp25_;
		GRegex* _tmp26_;
		GRegex* _tmp27_;
		_tmp20_ = g_regex_escape_string (query, -1);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("\\b(%s)", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_regex_new (_tmp23_, flags, 0, &_inner_error_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp19_ = _tmp25_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch39_g_regex_error;
			}
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp26_ = _tmp19_;
		_tmp19_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp26_;
		_tmp27_ = re;
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp27_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_VERY_GOOD)));
		_g_regex_unref0 (_tmp19_);
	}
	goto __finally39;
	__catch39_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp28_ = string_strip (query);
	_tmp29_ = _tmp28_;
	_tmp31_ = _tmp30_ = g_regex_split_simple ("\\s+", _tmp29_, 0, 0);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _vala_array_length (_tmp30_);
	_g_free0 (_tmp29_);
	individual_words = _tmp32_;
	individual_words_length1 = _tmp32__length1;
	_individual_words_size_ = individual_words_length1;
	_tmp33_ = individual_words;
	_tmp33__length1 = individual_words_length1;
	if (_tmp33__length1 >= 2) {
		gchar** escaped_words = NULL;
		gchar** _tmp34_;
		gint escaped_words_length1;
		gint _escaped_words_size_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* pattern = NULL;
		gchar** _tmp39_;
		gint _tmp39__length1;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp34_ = g_new0 (gchar*, 0 + 1);
		escaped_words = _tmp34_;
		escaped_words_length1 = 0;
		_escaped_words_size_ = escaped_words_length1;
		_tmp35_ = individual_words;
		_tmp35__length1 = individual_words_length1;
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp35_;
			word_collection_length1 = _tmp35__length1;
			for (word_it = 0; word_it < _tmp35__length1; word_it = word_it + 1) {
				const gchar* word = NULL;
				word = word_collection[word_it];
				{
					gchar** _tmp36_;
					gint _tmp36__length1;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp36_ = escaped_words;
					_tmp36__length1 = escaped_words_length1;
					_tmp37_ = word;
					_tmp38_ = g_regex_escape_string (_tmp37_, -1);
					_vala_array_add7 (&escaped_words, &escaped_words_length1, &_escaped_words_size_, _tmp38_);
				}
			}
		}
		_tmp39_ = escaped_words;
		_tmp39__length1 = escaped_words_length1;
		_tmp40_ = _vala_g_strjoinv (").+\\b(", _tmp39_, _tmp39__length1);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("\\b(%s)", _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		pattern = _tmp43_;
		{
			GRegex* _tmp44_ = NULL;
			const gchar* _tmp45_;
			GRegex* _tmp46_;
			GRegex* _tmp47_;
			GRegex* _tmp48_;
			_tmp45_ = pattern;
			_tmp46_ = g_regex_new (_tmp45_, flags, 0, &_inner_error_);
			_tmp44_ = _tmp46_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch40_g_regex_error;
				}
				_g_free0 (pattern);
				escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp47_ = _tmp44_;
			_tmp44_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp47_;
			_tmp48_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp48_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_GOOD)));
			_g_regex_unref0 (_tmp44_);
		}
		goto __finally40;
		__catch40_g_regex_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally40:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (pattern);
			escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_REVERSED) == SYNAPSE_MATCHER_FLAGS_NO_REVERSED)) {
			gchar** _tmp49_;
			gint _tmp49__length1;
			_tmp49_ = escaped_words;
			_tmp49__length1 = escaped_words_length1;
			if (_tmp49__length1 == 2) {
				gchar* reversed = NULL;
				gchar** _tmp50_;
				gint _tmp50__length1;
				const gchar* _tmp51_;
				gchar** _tmp52_;
				gint _tmp52__length1;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				_tmp50_ = escaped_words;
				_tmp50__length1 = escaped_words_length1;
				_tmp51_ = _tmp50_[1];
				_tmp52_ = escaped_words;
				_tmp52__length1 = escaped_words_length1;
				_tmp53_ = _tmp52_[0];
				_tmp54_ = g_strjoin (").+\\b(", _tmp51_, _tmp53_, NULL, NULL);
				_tmp55_ = _tmp54_;
				_tmp56_ = g_strdup_printf ("\\b(%s)", _tmp55_);
				_tmp57_ = _tmp56_;
				_g_free0 (_tmp55_);
				reversed = _tmp57_;
				{
					GRegex* _tmp58_ = NULL;
					const gchar* _tmp59_;
					GRegex* _tmp60_;
					GRegex* _tmp61_;
					GRegex* _tmp62_;
					_tmp59_ = reversed;
					_tmp60_ = g_regex_new (_tmp59_, flags, 0, &_inner_error_);
					_tmp58_ = _tmp60_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch41_g_regex_error;
						}
						_g_free0 (reversed);
						_g_free0 (pattern);
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
						_g_regex_unref0 (re);
						_g_object_unref0 (results);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp61_ = _tmp58_;
					_tmp58_ = NULL;
					_g_regex_unref0 (re);
					re = _tmp61_;
					_tmp62_ = re;
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp62_, (gpointer) ((gintptr) ((gint) (SYNAPSE_MATCH_SCORE_GOOD - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR))));
					_g_regex_unref0 (_tmp58_);
				}
				goto __finally41;
				__catch41_g_regex_error:
				{
					GError* err = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally41:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (reversed);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (reversed);
			} else {
				gchar* orred = NULL;
				gchar** _tmp63_;
				gint _tmp63__length1;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* any_order = NULL;
				gchar* _tmp68_;
				_tmp63_ = escaped_words;
				_tmp63__length1 = escaped_words_length1;
				_tmp64_ = _vala_g_strjoinv (")|(?:", _tmp63_, _tmp63__length1);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strdup_printf ("\\b((?:%s))", _tmp65_);
				_tmp67_ = _tmp66_;
				_g_free0 (_tmp65_);
				orred = _tmp67_;
				_tmp68_ = g_strdup ("");
				any_order = _tmp68_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp69_ = FALSE;
						_tmp69_ = TRUE;
						while (TRUE) {
							gint _tmp71_;
							gchar** _tmp72_;
							gint _tmp72__length1;
							gboolean is_last = FALSE;
							gint _tmp73_;
							gchar** _tmp74_;
							gint _tmp74__length1;
							const gchar* _tmp75_;
							const gchar* _tmp76_;
							gchar* _tmp77_;
							gboolean _tmp78_;
							if (!_tmp69_) {
								gint _tmp70_;
								_tmp70_ = i;
								i = _tmp70_ + 1;
							}
							_tmp69_ = FALSE;
							_tmp71_ = i;
							_tmp72_ = escaped_words;
							_tmp72__length1 = escaped_words_length1;
							if (!(_tmp71_ < _tmp72__length1)) {
								break;
							}
							_tmp73_ = i;
							_tmp74_ = escaped_words;
							_tmp74__length1 = escaped_words_length1;
							is_last = _tmp73_ == (_tmp74__length1 - 1);
							_tmp75_ = any_order;
							_tmp76_ = orred;
							_tmp77_ = g_strconcat (_tmp75_, _tmp76_, NULL);
							_g_free0 (any_order);
							any_order = _tmp77_;
							_tmp78_ = is_last;
							if (!_tmp78_) {
								const gchar* _tmp79_;
								gchar* _tmp80_;
								_tmp79_ = any_order;
								_tmp80_ = g_strconcat (_tmp79_, ".+", NULL);
								_g_free0 (any_order);
								any_order = _tmp80_;
							}
						}
					}
				}
				{
					GRegex* _tmp81_ = NULL;
					const gchar* _tmp82_;
					GRegex* _tmp83_;
					GRegex* _tmp84_;
					GRegex* _tmp85_;
					_tmp82_ = any_order;
					_tmp83_ = g_regex_new (_tmp82_, flags, 0, &_inner_error_);
					_tmp81_ = _tmp83_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch42_g_regex_error;
						}
						_g_free0 (any_order);
						_g_free0 (orred);
						_g_free0 (pattern);
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
						_g_regex_unref0 (re);
						_g_object_unref0 (results);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp84_ = _tmp81_;
					_tmp81_ = NULL;
					_g_regex_unref0 (re);
					re = _tmp84_;
					_tmp85_ = re;
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp85_, (gpointer) ((gintptr) ((gint) (SYNAPSE_MATCH_SCORE_AVERAGE + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR))));
					_g_regex_unref0 (_tmp81_);
				}
				goto __finally42;
				__catch42_g_regex_error:
				{
					GError* err = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally42:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (any_order);
					_g_free0 (orred);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (any_order);
				_g_free0 (orred);
			}
		}
		_g_free0 (pattern);
		escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING) == SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING)) {
		{
			GRegex* _tmp86_ = NULL;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			GRegex* _tmp91_;
			GRegex* _tmp92_;
			GRegex* _tmp93_;
			GRegex* _tmp94_;
			_tmp87_ = g_regex_escape_string (query, -1);
			_tmp88_ = _tmp87_;
			_tmp89_ = g_strdup_printf ("(%s)", _tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_regex_new (_tmp90_, flags, 0, &_inner_error_);
			_tmp92_ = _tmp91_;
			_g_free0 (_tmp90_);
			_g_free0 (_tmp88_);
			_tmp86_ = _tmp92_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch43_g_regex_error;
				}
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp93_ = _tmp86_;
			_tmp86_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp93_;
			_tmp94_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp94_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_BELOW_AVERAGE)));
			_g_regex_unref0 (_tmp86_);
		}
		goto __finally43;
		__catch43_g_regex_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally43:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp96_ = _tmp95_ = g_regex_split_simple ("\\s*", query, 0, 0);
	individual_chars = _tmp96_;
	individual_chars_length1 = _vala_array_length (_tmp95_);
	_individual_chars_size_ = individual_chars_length1;
	_tmp97_ = g_new0 (gchar*, 0 + 1);
	escaped_chars = _tmp97_;
	escaped_chars_length1 = 0;
	_escaped_chars_size_ = escaped_chars_length1;
	_tmp98_ = individual_chars;
	_tmp98__length1 = individual_chars_length1;
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp98_;
		word_collection_length1 = _tmp98__length1;
		for (word_it = 0; word_it < _tmp98__length1; word_it = word_it + 1) {
			const gchar* word = NULL;
			word = word_collection[word_it];
			{
				gchar** _tmp99_;
				gint _tmp99__length1;
				const gchar* _tmp100_;
				gchar* _tmp101_;
				_tmp99_ = escaped_chars;
				_tmp99__length1 = escaped_chars_length1;
				_tmp100_ = word;
				_tmp101_ = g_regex_escape_string (_tmp100_, -1);
				_vala_array_add8 (&escaped_chars, &escaped_chars_length1, &_escaped_chars_size_, _tmp101_);
			}
		}
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) == SYNAPSE_MATCHER_FLAGS_NO_PARTIAL)) {
		gchar** _tmp104_;
		gint _tmp104__length1;
		_tmp104_ = individual_words;
		_tmp104__length1 = individual_words_length1;
		_tmp103_ = _tmp104__length1 == 1;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		gchar** _tmp105_;
		gint _tmp105__length1;
		_tmp105_ = individual_chars;
		_tmp105__length1 = individual_chars_length1;
		_tmp102_ = _tmp105__length1 <= 5;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		gchar* pattern = NULL;
		gchar** _tmp106_;
		gint _tmp106__length1;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		_tmp106_ = escaped_chars;
		_tmp106__length1 = escaped_chars_length1;
		_tmp107_ = _vala_g_strjoinv (").+\\b(", _tmp106_, _tmp106__length1);
		_tmp108_ = _tmp107_;
		_tmp109_ = g_strdup_printf ("\\b(%s)", _tmp108_);
		_tmp110_ = _tmp109_;
		_g_free0 (_tmp108_);
		pattern = _tmp110_;
		{
			GRegex* _tmp111_ = NULL;
			const gchar* _tmp112_;
			GRegex* _tmp113_;
			GRegex* _tmp114_;
			GRegex* _tmp115_;
			_tmp112_ = pattern;
			_tmp113_ = g_regex_new (_tmp112_, flags, 0, &_inner_error_);
			_tmp111_ = _tmp113_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch44_g_regex_error;
				}
				_g_free0 (pattern);
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp114_ = _tmp111_;
			_tmp111_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp114_;
			_tmp115_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp115_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE)));
			_g_regex_unref0 (_tmp111_);
		}
		goto __finally44;
		__catch44_g_regex_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally44:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (pattern);
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_FUZZY) == SYNAPSE_MATCHER_FLAGS_NO_FUZZY)) {
		gchar** _tmp117_;
		gint _tmp117__length1;
		_tmp117_ = escaped_chars;
		_tmp117__length1 = escaped_chars_length1;
		_tmp116_ = _tmp117__length1 > 0;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		gchar* pattern = NULL;
		gchar** _tmp118_;
		gint _tmp118__length1;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		_tmp118_ = escaped_chars;
		_tmp118__length1 = escaped_chars_length1;
		_tmp119_ = _vala_g_strjoinv (").*(", _tmp118_, _tmp118__length1);
		_tmp120_ = _tmp119_;
		_tmp121_ = g_strdup_printf ("\\b(%s)", _tmp120_);
		_tmp122_ = _tmp121_;
		_g_free0 (_tmp120_);
		pattern = _tmp122_;
		{
			GRegex* _tmp123_ = NULL;
			const gchar* _tmp124_;
			GRegex* _tmp125_;
			GRegex* _tmp126_;
			GRegex* _tmp127_;
			_tmp124_ = pattern;
			_tmp125_ = g_regex_new (_tmp124_, flags, 0, &_inner_error_);
			_tmp123_ = _tmp125_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch45_g_regex_error;
				}
				_g_free0 (pattern);
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp126_ = _tmp123_;
			_tmp123_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp126_;
			_tmp127_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp127_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_POOR)));
			_g_regex_unref0 (_tmp123_);
		}
		goto __finally45;
		__catch45_g_regex_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally45:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (pattern);
	}
	_tmp128_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	sorted_results = _tmp128_;
	_tmp129_ = gee_abstract_map_get_entries ((GeeAbstractMap*) results);
	_tmp130_ = _tmp129_;
	entries = _tmp130_;
	_tmp131_ = _g_object_ref0 (entries);
	g_object_set_data_full ((GObject*) sorted_results, "entries-ref", _tmp131_, g_object_unref);
	gee_array_list_add_all (sorted_results, (GeeCollection*) entries);
	gee_list_sort ((GeeList*) sorted_results, ___lambda9__gcompare_data_func, NULL, NULL);
	result = (GeeList*) sorted_results;
	_g_object_unref0 (entries);
	escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
	individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
	individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (re);
	_g_object_unref0 (results);
	return result;
}


void
synapse_query_copy (const SynapseQuery* self,
                    SynapseQuery* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	SynapseQueryFlags _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	_tmp0_ = (*self).query_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).query_string);
	(*dest).query_string = _tmp1_;
	_tmp2_ = (*self).query_string_folded;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).query_string_folded);
	(*dest).query_string_folded = _tmp3_;
	_tmp4_ = (*self).cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).cancellable);
	(*dest).cancellable = _tmp5_;
	_tmp6_ = (*self).query_type;
	(*dest).query_type = _tmp6_;
	_tmp7_ = (*self).max_results;
	(*dest).max_results = _tmp7_;
	_tmp8_ = (*self).query_id;
	(*dest).query_id = _tmp8_;
}


void
synapse_query_destroy (SynapseQuery* self)
{
	_g_free0 ((*self).query_string);
	_g_free0 ((*self).query_string_folded);
	_g_object_unref0 ((*self).cancellable);
}


SynapseQuery*
synapse_query_dup (const SynapseQuery* self)
{
	SynapseQuery* dup;
	dup = g_new0 (SynapseQuery, 1);
	synapse_query_copy (self, dup);
	return dup;
}


void
synapse_query_free (SynapseQuery* self)
{
	synapse_query_destroy (self);
	g_free (self);
}


GType
synapse_query_get_type (void)
{
	static volatile gsize synapse_query_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_type_id__volatile)) {
		GType synapse_query_type_id;
		synapse_query_type_id = g_boxed_type_register_static ("SynapseQuery", (GBoxedCopyFunc) synapse_query_dup, (GBoxedFreeFunc) synapse_query_free);
		g_once_init_leave (&synapse_query_type_id__volatile, synapse_query_type_id);
	}
	return synapse_query_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



